/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.lang.overlog.MaterializationChecker;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.Type;
import xtc.util.SymbolTable;

public final class Normalizer
extends Visitor {
    private static int tempNameCount = 0;
    private Map<String, List<Node>> currentScope;
    private Node currentTuple;
    private Node currentEvent;
    private int currentTupleIndex;
    private SymbolTable table;
    private SymbolTable typesTable;
    private SymbolTable normalizedTypes;
    private boolean inRuleHead = false;
    private boolean inAssignment = false;
    private Set<String> materialized;

    public Node analyze(Node node, SymbolTable symbolTable, SymbolTable symbolTable2, SymbolTable symbolTable3) {
        this.table = symbolTable;
        this.typesTable = symbolTable2;
        this.normalizedTypes = symbolTable3;
        this.materialized = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        new MaterializationChecker().analyze(node, hashSet, this.materialized);
        this.dispatch(node);
        return node;
    }

    public void visit(GNode gNode) {
        for (Object object : gNode) {
            if (object instanceof Node) {
                this.dispatch((Node)object);
                continue;
            }
            if (!Node.isList(object)) continue;
            this.iterate(Node.toList(object));
        }
    }

    public void visitRule(GNode gNode) {
        String string = "unknown";
        if ("RuleIdentifier".equals(gNode.getNode(0).getName())) {
            string = gNode.getNode(0).getString(0);
            this.table.enter(string);
            this.typesTable.enter(string);
            this.normalizedTypes.enter(string);
        } else {
            Iterator<List<Node>> iterator = this.table.freshName();
            this.table.enter((String)((Object)iterator));
            this.typesTable.enter((String)((Object)iterator));
            this.normalizedTypes.enter((String)((Object)iterator));
        }
        this.currentEvent = null;
        this.currentScope = new HashMap<String, List<Node>>();
        for (Node iterable : gNode.getList(3)) {
            this.dispatch(iterable);
        }
        for (List<Node> list : this.currentScope.values()) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : list) {
                if (node.equals(list.get(0))) continue;
                arrayList.add(node);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                gNode.getList(3).add(GNode.create("EqualityExpression", list.get(0), "==", arrayList.get(i)));
            }
        }
        this.inRuleHead = true;
        this.dispatch(gNode.getNode(2));
        this.inRuleHead = false;
        this.currentScope = null;
        this.table.exit();
        this.typesTable.exit();
        this.normalizedTypes.exit();
        this.currentEvent = null;
    }

    public void visitTuple(GNode gNode) {
        this.currentTuple = gNode;
        this.currentTupleIndex = 0;
        if (!this.materialized.contains(gNode.getNode(0).getString(0))) {
            this.currentEvent = gNode;
        }
        for (Node node : gNode.getList(1)) {
            this.dispatch(node);
            ++this.currentTupleIndex;
        }
        this.currentTuple = null;
        this.currentTupleIndex = 0;
    }

    public void visitExpression(GNode gNode) {
        this.inAssignment = true;
        this.dispatch(gNode.getNode(0));
        this.inAssignment = false;
        this.dispatch(gNode.getNode(2));
    }

    public void visitVariableIdentifier(GNode gNode) {
        Object object;
        String string = "V" + tempNameCount;
        ++tempNameCount;
        GNode gNode2 = GNode.create("VariableIdentifier", string);
        GNode gNode3 = gNode;
        if (!this.inAssignment) {
            gNode3 = gNode2;
        }
        if (this.currentScope.containsKey(gNode.getString(0))) {
            this.currentScope.get(gNode.getString(0)).add(gNode3);
        } else {
            object = new ArrayList<GNode>();
            object.add(gNode3);
            this.currentScope.put(gNode.getString(0), (List<Node>)object);
        }
        object = "Unknown";
        Type type2 = (Type)this.typesTable.current().lookup(gNode.getString(0));
        if (type2 != null) {
            if (type2.isInteger()) {
                object = "Integer";
            } else if (type2.isBoolean()) {
                object = "Boolean";
            } else if (type2.isFloat()) {
                object = "Float";
            } else if (type2.isInternal()) {
                if ("string constant".equals(type2.getName())) {
                    object = "String";
                } else if ("location".equals(type2.getName())) {
                    object = "NetAddr";
                }
            }
        }
        this.normalizedTypes.current().define(string, type2);
        if (this.currentTuple != null && !this.inRuleHead) {
            Node node = this.tupleAccess(GNode.create("QualifiedIdentifier", object), GNode.create("PrimaryIdentifier", this.currentTuple.getNode(0).getString(0)), GNode.create("IntegerLiteral", Integer.toString(this.currentTupleIndex)));
            this.table.current().define(string, node);
            if (this.table.current().isDefined(gNode.getString(0))) {
                String string2;
                if (this.currentEvent != null && (string2 = this.currentEvent.getNode(0).getString(0)).equals(this.currentTuple.getNode(0).getString(0))) {
                    this.table.current().define(gNode.getString(0), node);
                }
            } else {
                this.table.current().define(gNode.getString(0), node);
            }
        } else if (this.inAssignment) {
            this.table.current().define(gNode.getString(0), GNode.create("VariableIdentifier", gNode.getString(0)));
        } else if (!this.inRuleHead) {
            this.table.current().define(string, GNode.create("VariableIdentifier", gNode.getString(0)));
            gNode.set(0, string);
        }
    }

    private Node tupleAccess(Node node, Node node2, Node node3) {
        GNode gNode = GNode.create("Type", node, null);
        GNode gNode2 = GNode.create("Arguments", node3);
        GNode gNode3 = GNode.create("CallExpression", node2, null, "getTerm", gNode2);
        GNode gNode4 = GNode.create("CastExpression", gNode, gNode3);
        return gNode4;
    }
}

