/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.util.Pair;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrencyAnalyzer
extends Visitor {
    private final Runtime runtime;
    private Set<String> materialized;
    private Set<Node> fixpointInitiaters;
    private Map<Node, List<Node>> closureMap;
    private Map<Node, Set<Node>> readSets;
    private Map<Node, Set<Node>> writeSets;

    public ConcurrencyAnalyzer(Runtime runtime) {
        this.runtime = runtime;
        this.materialized = new HashSet<String>();
        this.fixpointInitiaters = new HashSet<Node>();
        this.closureMap = new HashMap<Node, List<Node>>();
        this.readSets = new HashMap<Node, Set<Node>>();
        this.writeSets = new HashMap<Node, Set<Node>>();
    }

    public Node analyze(Node node) {
        this.dispatch(node);
        new MaterializationChecker().analyze(node);
        node = this.computeFixpoints(node);
        return node;
    }

    private Node getExternal(Node node) {
        String string = ((Node)node.getNode(1).getList(1).get(0)).getNode(0).getString(0);
        for (Node node2 : node.getList(2)) {
            String string2;
            if (!"Tuple".equals(node2.getName()) || string.equals(string2 = ((Node)node2.getList(1).get(0)).getNode(0).getString(0))) continue;
            return node.getNode(1);
        }
        return null;
    }

    private Node getMaterialized(Node node) {
        String string = node.getNode(1).getNode(0).getString(0);
        if (!this.materialized.contains(string)) {
            return null;
        }
        return (Node)node.getNode(1).getList(1).get(0);
    }

    private Node computeFixpoints(Node node) {
        for (Node node2 : this.fixpointInitiaters) {
            HashSet<Node> hashSet = new HashSet<Node>();
            this.computeFixpoint(node2, node2, hashSet);
            node = this.addReadSet(node, node2);
            node = this.addWriteSet(node, node2);
        }
        return node;
    }

    private Node addReadSet(Node node, Node node2) {
        if (!this.readSets.containsKey(node2)) {
            return node;
        }
        Set<Node> set = this.readSets.get(node2);
        for (Node node3 : set) {
            node = this.addReadWriteFact(node, node2.getNode(0).getString(0), node3.getNode(0).getString(0), "R");
        }
        return node;
    }

    private Node addWriteSet(Node node, Node node2) {
        if (!this.writeSets.containsKey(node2)) {
            return node;
        }
        Set<Node> set = this.writeSets.get(node2);
        for (Node node3 : set) {
            node = this.addReadWriteFact(node, node2.getNode(0).getString(0), node3.getNode(0).getString(0), "W");
        }
        return node;
    }

    private Node addReadWriteFact(Node node, String string, String string2, String string3) {
        GNode gNode = GNode.create("StringConstant", string);
        GNode gNode2 = GNode.create("StringConstant", string2);
        GNode gNode3 = GNode.create("StringConstant", string3);
        Pair<GNode> pair = new Pair<GNode>(gNode);
        pair.add(gNode2);
        pair.add(gNode3);
        GNode gNode4 = GNode.create("RuleIdentifier", new String("concurrent"));
        GNode gNode5 = GNode.create("Tuple", gNode4, pair);
        GNode gNode6 = GNode.create("GenericFact", gNode5);
        node = GNode.ensureVariable(GNode.cast(node));
        node = node.add(gNode6);
        return node;
    }

    private void computeFixpoint(Node node, Node node2, Set<Node> set) {
        if (set.contains(node)) {
            return;
        }
        set.add(node);
        if (!this.closureMap.containsKey(node)) {
            return;
        }
        List<Node> list = this.closureMap.get(node);
        for (Node node3 : list) {
            Iterable<Object> iterable2;
            Pair pair = node3.getList(2);
            for (Iterable<Object> iterable2 : pair) {
                if (!"Tuple".equals(((Node)iterable2).getName()) || iterable2 == node2) continue;
                if (this.readSets.containsKey(node2)) {
                    this.readSets.get(node2).add((Node)iterable2);
                    continue;
                }
                HashSet<Iterable<Object>> hashSet = new HashSet<Iterable<Object>>();
                hashSet.add(iterable2);
                this.readSets.put(node2, hashSet);
            }
            Object object = this.getExternal(node3);
            if (object != null) {
                if (this.writeSets.containsKey(node2)) {
                    this.writeSets.get(node2).add(node3.getNode(1));
                } else {
                    iterable2 = new HashSet();
                    iterable2.add(node3.getNode(1));
                    this.writeSets.put(node2, (Set<Node>)iterable2);
                    return;
                }
            }
            if ((object = this.getMaterialized(node3)) != null) {
                if (this.writeSets.containsKey(node2)) {
                    this.writeSets.get(node2).add(node3.getNode(1));
                } else {
                    iterable2 = new HashSet();
                    iterable2.add((Node)node3.getNode(1));
                    this.writeSets.put(node2, (Set<Node>)iterable2);
                    return;
                }
            }
            this.computeFixpoint(node3.getNode(1), node2, set);
        }
    }

    public void visit(GNode gNode) {
        for (Object object : gNode) {
            if (object instanceof Node) {
                this.dispatch((Node)object);
                continue;
            }
            if (!Node.isList(object)) continue;
            this.iterate(Node.toList(object));
        }
    }

    public void visitMaterialization(GNode gNode) {
        String string = gNode.getNode(0).getString(0);
        this.materialized.add(string);
    }

    public void visitRule(GNode gNode) {
        for (Node node : gNode.getList(3)) {
            this.dispatch(node);
            if (!"Tuple".equals(node.getName())) continue;
            if (this.closureMap.containsKey(node)) {
                this.closureMap.get(node).add(gNode);
                continue;
            }
            ArrayList<GNode> arrayList = new ArrayList<GNode>();
            arrayList.add(gNode);
            this.closureMap.put(node, arrayList);
        }
    }

    public class MaterializationChecker
    extends Visitor {
        public void analyze(Node node) {
            this.dispatch(node);
        }

        public void visit(GNode gNode) {
            for (Object object : gNode) {
                if (object instanceof Node) {
                    this.dispatch((Node)object);
                    continue;
                }
                if (!Node.isList(object)) continue;
                this.iterate(Node.toList(object));
            }
        }

        public void visitRule(GNode gNode) {
            String string = "unknown";
            if ("RuleIdentifier".equals(gNode.getNode(0).getName())) {
                string = gNode.getNode(0).getString(0);
            }
            int n = 0;
            Node node = null;
            for (Node node2 : gNode.getList(3)) {
                if (!"Tuple".equals(node2.getName())) continue;
                String string2 = node2.getNode(0).getString(0);
                if (ConcurrencyAnalyzer.this.materialized.contains(string2) || string2.equals("periodic")) continue;
                node = node2;
                ++n;
            }
            if (n > 1) {
                ConcurrencyAnalyzer.this.runtime.error("Rule " + string + " has " + n + " non-materialized tuples", gNode);
            } else if (n != 0) {
                ConcurrencyAnalyzer.this.fixpointInitiaters.add(node);
            }
        }
    }
}

