/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import xtc.lang.jeannie.PreJeannieParser;
import xtc.parser.Column;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.Node;
import xtc.util.Tool;

public class Preprocessor
extends Tool {
    public static final String[] BUILTINS = new String[]{"_copyFromJava", "_copyToJava", "_newJavaString", "_stringUTFLength"};
    public static final String[] KEYWORDS = new String[]{"_cancel", "_commit", "_with"};

    public static void main(String[] stringArray) {
        new Preprocessor().run(stringArray);
    }

    public final String getCopy() {
        return "(C) 2005-2007 IBM";
    }

    public final String getName() {
        return "Jeannie preprocessor";
    }

    public final void init() {
        super.init();
        this.runtime.bool("underscores", "underscores", false, "Inhibit aliasing Jeannie keywords and builtins to versions without leading underscore. For example, copyToJava will remain unchanged, instead of being macro-expanded to _copyToJava.");
        this.runtime.setConsole(this.runtime.errConsole());
    }

    public final String lineMarker(Column column) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n# " + column.line + " \"" + column.file.replace('\\', '/') + "\"\n");
        for (int i = 0; i < column.column; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public final String jeannieDefs() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n/* start auto-injected Jeannie declarations */\n");
        stringBuilder.append("#include <jni.h>\n");
        stringBuilder.append("\n");
        stringBuilder.append("jint _stringUTFLength(JNIEnv* env, jstring str, jint start, jint len) {\n");
        stringBuilder.append("  jint result = len;\n");
        stringBuilder.append("  const jchar* chars = (*env)->GetStringCritical(env, str, 0x0);\n");
        stringBuilder.append("  jint i;\n");
        stringBuilder.append("  for (i=0; i<len; i++) {\n");
        stringBuilder.append("    const jchar c = chars[start + i];\n");
        stringBuilder.append("    if (c == (jchar)0x0000) result++;\n");
        stringBuilder.append("    else if (c >= (jchar)0x0080) {\n");
        stringBuilder.append("      result++;\n");
        stringBuilder.append("      if (c >= (jchar)0x0800) result++;\n");
        stringBuilder.append("    }\n");
        stringBuilder.append("  }\n");
        stringBuilder.append("  (*env)->ReleaseStringCritical(env, str, chars);\n");
        stringBuilder.append("  return result;\n");
        stringBuilder.append("}\n");
        if (!this.runtime.test("underscores")) {
            stringBuilder.append("\n/* aliased builtins (use -underscores to omit these definitions) */\n");
            for (String string : BUILTINS) {
                stringBuilder.append("#define ").append(string.substring(1)).append(" ").append(string).append('\n');
            }
            stringBuilder.append("\n/* aliased keywords (use -underscores to omit these definitions) */\n");
            for (String string : KEYWORDS) {
                stringBuilder.append("#define ").append(string.substring(1)).append(" ").append(string).append('\n');
            }
        }
        stringBuilder.append("/* end auto-injected Jeannie declarations */\n");
        return stringBuilder.toString();
    }

    public final Node parse(Reader reader, File file) throws IOException, ParseException {
        PreJeannieParser preJeannieParser = new PreJeannieParser(reader, file.getCanonicalPath(), (int)file.length());
        preJeannieParser._tool = this;
        Result result2 = preJeannieParser.pFile(0);
        if (result2.hasValue()) {
            Node node = (Node)((SemanticValue)result2).value;
            return node;
        }
        preJeannieParser.signal(result2.parseError());
        return null;
    }

    public final void process(Node node) {
        if (null != node) {
            System.out.println(node.getString(0));
        }
    }
}

