/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import xtc.lang.CPrinter;
import xtc.lang.JavaEntities;
import xtc.lang.JavaPrinter;
import xtc.lang.jeannie.Analyzer;
import xtc.lang.jeannie.AstSimplifier;
import xtc.lang.jeannie.CodeGenerator;
import xtc.lang.jeannie.JeannieParser;
import xtc.lang.jeannie.JeanniePrinter;
import xtc.lang.jeannie.Utilities;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.LineupPrinter;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public final class Jeannie
extends Tool {
    public static String getStem(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        int n2 = string.indexOf(46, n);
        return -1 == n2 ? string : string.substring(0, n2);
    }

    public static void main(String[] stringArray) {
        new Jeannie().run(stringArray);
    }

    public final String getCopy() {
        return "(C) 2005-2007 IBM, Robert Grimm, and NYU";
    }

    public final String getName() {
        return "Jeannie compiler";
    }

    public final void init() {
        super.init();
        this.runtime.bool("printAST", "printAST", false, "Print the AST in generic form.").bool("printSource", "printSource", false, "Print the AST in Jeannie source form.").bool("analyze", "optionAnalyze", false, "Analyze the program's AST.").bool("printSymbolTable", "printSymbolTable", false, "Print the program's symbol table.").bool("translate", "translate", false, "Generate separate C and Java code.").bool("markAST", "optionMarkAST", true, "Mark AST nodes with types.").bool("strict", "optionStrict", true, "Enforce strict C99 compliance.").bool("pedantic", "optionPedantic", false, "Enforce strict C99 compliance.").bool("pretty", "pretty", false, "Optimize output for human-readability.").word("jniCall", "jniCall", false, "Calling conventions qualifier to C JNI functions. The default is the empty string \"\". On cygwin, use -jniCall \"__attribute__((__stdcall__))\".").bool("showFilePaths", "showFilePaths", false, "Should line markers in the generated Java source code show  file paths (true), or just relative file names (false)?");
        this.runtime.setValue("optionMarkAST", true);
        this.runtime.setValue("optionStrict", true);
        this.runtime.setValue("optionPedantic", true);
    }

    public final Node parse(Reader reader, File file) throws IOException, ParseException {
        JavaEntities.UnicodeUnescaper unicodeUnescaper = new JavaEntities.UnicodeUnescaper(reader);
        JeannieParser jeannieParser = new JeannieParser(unicodeUnescaper, file.toString(), (int)file.length());
        Result result2 = jeannieParser.pFile(0);
        if (!result2.hasValue()) {
            jeannieParser.signal(result2.parseError());
        }
        Node node = (Node)((SemanticValue)result2).value;
        Node node2 = (Node)new AstSimplifier(null).dispatch(node);
        node2.setProperty("originalFileName", file.getCanonicalPath());
        return node2;
    }

    public final void prepare() {
        super.prepare();
        if ((this.runtime.test("printSymbolTable") || this.runtime.test("translate")) && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("need analyze option to obtain symbol table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Node node) {
        if (this.runtime.test("optionAnalyze")) {
            Object object;
            if (!this.runtime.hasValue("inputDirectory")) {
                this.runtime.setValue("inputDirectory", new File(System.getProperty("user.dir")));
            }
            SymbolTable symbolTable = new SymbolTable();
            Analyzer analyzer = new Analyzer(this.runtime, symbolTable, null);
            analyzer.dispatch(node);
            if (0 < this.runtime.errorCount()) {
                System.exit(-1);
            }
            if (this.runtime.test("printSymbolTable")) {
                object = this.runtime.console().visitor();
                try {
                    symbolTable.root().dump(this.runtime.console());
                }
                finally {
                    this.runtime.console().register((Visitor)object);
                }
                this.runtime.console().flush();
            }
            if (this.runtime.test("translate")) {
                Printer printer;
                Writer writer;
                object = Jeannie.getStem((String)node.getProperty("originalFileName"));
                boolean bl = this.runtime.test("showFilePaths");
                CodeGenerator codeGenerator = new CodeGenerator(this.runtime, symbolTable);
                CodeGenerator.Out out = (CodeGenerator.Out)codeGenerator.dispatch(node);
                try {
                    writer = new BufferedWriter(new FileWriter((String)object + ".i"));
                    printer = this.runtime.test("pretty") ? new Printer(writer) : new LineupPrinter(writer, bl);
                    new CPrinter(printer).dispatch(out._cNode);
                    printer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
                try {
                    writer = new BufferedWriter(new FileWriter((String)object + ".java"));
                    printer = this.runtime.test("pretty") ? new Printer(writer) : new LineupPrinter(writer, bl);
                    new JavaPrinter(printer).dispatch(out._javaNode);
                    printer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
                if (!this.runtime.test("pretty")) {
                    try {
                        writer = new PrintWriter(new FileWriter((String)object + ".jni.symbols"));
                        Utilities.printTopLevelDeclarations((PrintWriter)writer, out._javaNode);
                        Utilities.printLocalVariableMap((PrintWriter)writer, node, symbolTable, codeGenerator._cSubstitutions, codeGenerator._javaSubstitutions);
                        Utilities.printMethodMap((PrintWriter)writer, symbolTable, codeGenerator._methodSubstitutions);
                        ((PrintWriter)writer).close();
                    }
                    catch (IOException iOException) {
                        throw new Error(iOException);
                    }
                }
            }
        }
        if (this.runtime.test("printAST")) {
            this.runtime.console().format(node).pln().flush();
        }
        if (this.runtime.test("printSource")) {
            new JeanniePrinter(this.runtime.console(), null).dispatch(node);
            this.runtime.console().flush();
        }
    }
}

