/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import xtc.Constants;
import xtc.lang.CAnalyzer;
import xtc.lang.JavaAnalyzer;
import xtc.lang.JavaEntities;
import xtc.lang.JavaTypeConverter;
import xtc.lang.jeannie.Analyzer;
import xtc.lang.jeannie.JeannieCFactory;
import xtc.lang.jeannie.JeannieJavaFactory;
import xtc.lang.jeannie.Utilities;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Locatable;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.ClassOrInterfaceT;
import xtc.type.FunctionT;
import xtc.type.MethodT;
import xtc.type.PointerT;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator
extends Visitor {
    final Substitutions _cSubstitutions;
    final Substitutions _javaSubstitutions;
    final Map<String, String> _methodSubstitutions;
    final JeannieJavaFactory _astFactoryJava;
    final JeannieCFactory _astFactoryC = new JeannieCFactory();
    final Stack<Context> _contexts;
    final Map<String, Integer> _freshIdCount;
    final Runtime _runtime;
    final SymbolTable _table;
    Set<String> _usedIdentifiers;

    private static String getFileStem(GNode gNode) {
        String string = gNode.getLocation().file;
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        int n2 = string.indexOf(46, n);
        int n3 = -1 == n2 ? string.length() : n2;
        return string.substring(1 + n, n3);
    }

    private static Type getType(GNode gNode) {
        return (Type)gNode.getProperty("xtc.Constants.Type");
    }

    private static GNode idNode(Locatable locatable, String string) {
        return CodeGenerator.setLoc(locatable, GNode.create("PrimaryIdentifier", string));
    }

    public static GNode setLoc(Locatable locatable, GNode gNode) {
        gNode.setLocation(locatable);
        return gNode;
    }

    public CodeGenerator(Runtime runtime, SymbolTable symbolTable) {
        this._astFactoryJava = new JeannieJavaFactory();
        this._contexts = new Stack();
        this._cSubstitutions = new Substitutions();
        this._freshIdCount = new HashMap<String, Integer>();
        this._javaSubstitutions = new Substitutions();
        this._methodSubstitutions = new HashMap<String, String>();
        this._runtime = runtime;
        this._table = symbolTable;
    }

    private GNode abruptFlowCheck(Locatable locatable, List<Node> list, List<Node> list2) {
        GNode gNode;
        GNode gNode2 = this.cStringNode(this.liftIdJava(this.currentMethodScope(), locatable, "returnAbrupt", JavaEntities.nameToBaseType("boolean"), list2));
        GNode gNode3 = this.abruptFlowJump(locatable, list);
        if (this.existsOpenArrayInSameSnippet()) {
            String string = this.context()._openArray;
            String string2 = this.liftIdC(this.declaringScope(string), string + "ReleaseAbrupt", this.typedefType("jint"), list);
            gNode = (GNode)this._astFactoryC.abruptFlowCheckOpenArray(string2, gNode2, gNode3);
        } else {
            gNode = (GNode)this._astFactoryC.abruptFlowCheck(gNode2, gNode3);
        }
        return CodeGenerator.setLoc(locatable, gNode);
    }

    private GNode abruptFlowJump(Locatable locatable, List<Node> list) {
        GNode gNode;
        if (this.existsOpenArrayInSameSnippet()) {
            String string = this.context()._openArray;
            String string2 = this.liftIdCLabel(this.declaringScope(string), "release_" + string);
            gNode = (GNode)this._astFactoryC.abruptFlowJumpOpenArray(string2);
        } else {
            Type type2 = this.context()._snippetType;
            GNode gNode2 = type2.hasTag(Type.Tag.VOID) ? null : GNode.create("CastExpression", Utilities.cTypeToAst(type2, null, "TypeName"), GNode.create("IntegerConstant", "0"));
            gNode = GNode.create("ReturnStatement", gNode2);
        }
        return CodeGenerator.setLoc(locatable, gNode);
    }

    private GNode cEnvJavaTypeAst() {
        String string;
        switch (4) {
            case 4: {
                string = "int";
                break;
            }
            case 8: {
                string = "long";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return JavaEntities.javaTypeToAst(this._table, JavaEntities.nameToBaseType(string));
    }

    private Out cInJavaCode(GNode gNode, boolean bl) {
        assert ("Java".equals(this.context()._activeLanguage));
        GNode gNode2 = gNode.getGeneric(0);
        Type type2 = bl ? CodeGenerator.getType(gNode2) : VoidT.TYPE;
        this._contexts.push(new Context("C", this.context()._cEnvStructName, true, this.context()._javaEnvClassName, this.context()._javaEnvPackageName, this.context()._javaIsStatic, this.context()._openArray, type2));
        Out out = (Out)this.dispatch(gNode2);
        this._contexts.pop();
        Type type3 = bl ? CodeGenerator.getType(gNode) : JavaEntities.nameToBaseType("void");
        String string = this.freshIdentifier("j2c");
        List<Node> list = this.cInJavaCode_javaMembers(string, type3, out);
        Out out2 = new Out(this.cInJavaCode_cExternalDeclarations(string, type2, out), out._cMembers, null, list, this.cInJavaCode_javaNode(gNode, string, list, bl));
        return out2;
    }

    private List<Node> cInJavaCode_cExternalDeclarations(String string, Type type2, Out out) {
        String string2 = this.mangledFunctionName(string);
        this._methodSubstitutions.put(string2, Utilities.currentFunctionOrMethodName(this._table));
        Object object = this._runtime.getString("jniCall");
        Object object2 = null == object ? string2 : (String)object + " " + string2;
        Node node = Utilities.pureCType(this._table, this._runtime, type2);
        String string3 = Utilities.cTypeToString(node, (String)object2) + "(";
        string3 = Utilities.copyDropAuto(string3);
        string3 = string3 + "  JNIEnv *env, jobject jEnv";
        if (this.context()._cHasEnv) {
            switch (4) {
                case 4: {
                    string3 = string3 + ", const jint cEnv";
                    break;
                }
                case 8: {
                    string3 = string3 + ", const jlong cEnv";
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        string3 = string3 + ") { }";
        Set<String> set = Utilities.typedefs(type2);
        set.addAll(Utilities.standardJniTypeDefs());
        GNode gNode = Utilities.cStringToAst("FunctionDefinition", string3, set);
        object = this.context()._cEnvStructName;
        object2 = out._cNode;
        node = this.context()._cHasEnv ? (type2.isVoid() ? this._astFactoryC.cInJavaStatementWithCEnv((String)object, (Node)object2) : this._astFactoryC.cInJavaExpressionWithCEnv((String)object, (Node)object2)) : (type2.isVoid() ? this._astFactoryC.cInJavaStatementWithoutCEnv((String)object, (Node)object2) : this._astFactoryC.cInJavaExpressionWithoutCEnv((String)object, (Node)object2));
        gNode.set(gNode.size() - 1, CodeGenerator.setLoc(out._cNode, (GNode)node));
        object = out._cExternalDeclarations;
        object.add(gNode);
        return object;
    }

    private List<Node> cInJavaCode_javaMembers(String string, Type type2, Out out) {
        GNode gNode = JavaEntities.javaTypeToAst(this._table, type2);
        Node node = this.context()._cHasEnv ? this._astFactoryJava.cInJavaCodeWithCEnv(gNode, string, this.cEnvJavaTypeAst()) : this._astFactoryJava.cInJavaCodeWithoutCEnv(gNode, string);
        List<Node> list = out._javaMembers;
        list.add(CodeGenerator.setLoc(out._cNode, (GNode)node));
        return list;
    }

    private GNode cInJavaCode_javaNode(Locatable locatable, String string, List<Node> list, boolean bl) {
        Node node;
        if (bl) {
            node = this.context()._cHasEnv ? this._astFactoryJava.cInJavaExpressionWithCEnv(string) : this._astFactoryJava.cInJavaExpressionWithoutCEnv(string);
        } else {
            String string2 = this.liftIdJava(this.currentMethodScope(), locatable, "returnAbrupt", JavaEntities.nameToBaseType("boolean"), list);
            node = this.context()._cHasEnv ? this._astFactoryJava.cInJavaStatementWithCEnv(string, string2) : this._astFactoryJava.cInJavaStatementWithoutCEnv(string, string2);
        }
        return CodeGenerator.setLoc(locatable, (GNode)node);
    }

    private final Context context() {
        return this._contexts.peek();
    }

    private GNode cStringNode(String string) {
        return GNode.create("StringConstant", "\"" + string + "\"");
    }

    private SymbolTable.Scope currentMethodScope() {
        SymbolTable.Scope scope = this._table.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (SymbolTable.isInNameSpace(string, "method") || SymbolTable.isFunctionScopeName(string) || SymbolTable.isMacroScopeName(string)) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    private SymbolTable.Scope declaringScope(String string) {
        return this._table.lookupScope(string);
    }

    private boolean existsOpenArrayInSameSnippet() {
        String string = this.context()._openArray;
        if (null == string) {
            return false;
        }
        String string2 = this.context()._activeLanguage;
        for (int i = this._contexts.size() - 2; i >= 0; --i) {
            Context context = (Context)this._contexts.get(i);
            if (!string2.equals(context._activeLanguage)) {
                return false;
            }
            if (string.equals(context._openArray)) continue;
            return true;
        }
        return true;
    }

    private String freshIdentifier(String string) {
        String string2;
        int n = this._freshIdCount.containsKey(string) ? this._freshIdCount.get(string) : -1;
        while (this._usedIdentifiers.contains(string2 = 0 == ++n ? string : string + n)) {
        }
        this._freshIdCount.put(string, new Integer(n));
        this._usedIdentifiers.add(string2);
        return string2;
    }

    private boolean isUtf8(Type type2, Type type3) {
        if (JavaTypeConverter.isIdentical(type3, JavaEntities.tString(this._table))) {
            Type type4 = ((PointerT)Utilities.c().pointerize(type2)).getType();
            return Utilities.hasTypedefName(type4, "jbyte");
        }
        return false;
    }

    private Out javaInCCode(GNode gNode, boolean bl) {
        assert ("C".equals(this.context()._activeLanguage));
        this._contexts.push(new Context(this.context(), "Java"));
        Out out = (Out)this.dispatch(gNode);
        this._contexts.pop();
        Type type2 = bl ? JavaAnalyzer.getRValueNoError(CodeGenerator.getType(gNode)) : JavaEntities.nameToBaseType("void");
        String string = this.freshIdentifier("c2j");
        this.recordMethodSubstitution(string);
        List<Node> list = out._cMembers;
        List<Node> list2 = out._javaMembers;
        boolean bl2 = bl && !CodeGenerator.getType(gNode).isVoid();
        Out out2 = new Out(out._cExternalDeclarations, list, this.javaInCCode_cNode(string, type2, bl2, gNode, list, list2), this.javaInCCode_javaMembers(string, type2, bl, out), null);
        return out2;
    }

    private GNode javaInCCode_cNode(String string, Type type2, boolean bl, GNode gNode, List<Node> list, List<Node> list2) {
        Node node;
        GNode gNode2 = this.cStringNode(string);
        GNode gNode3 = this.cStringNode("(I)" + JavaEntities.typeToDescriptor(this._table, type2));
        String string2 = "CallNonvirtual" + Utilities.javaTypeToApiType(type2, true, false) + "Method";
        GNode gNode4 = this.abruptFlowCheck(gNode, list, list2);
        if (bl) {
            Type type3 = Utilities.javaTypeToCType(this._table, this._runtime, gNode, type2, false);
            GNode gNode5 = Utilities.cTypeToAst(type3, "tmp", "Declaration");
            node = this._astFactoryC.javaInCExpression32(gNode2, gNode3, gNode5, string2, gNode4);
        } else {
            node = this._astFactoryC.javaInCStatement32(gNode2, gNode3, string2, gNode4);
        }
        return CodeGenerator.setLoc(gNode, (GNode)node);
    }

    private List<Node> javaInCCode_javaMembers(String string, Type type2, boolean bl, Out out) {
        GNode gNode = JavaEntities.javaTypeToAst(this._table, type2);
        Node node = bl ? (type2.isVoid() ? this._astFactoryJava.javaInCExpressionVoid(string, this.cEnvJavaTypeAst(), out._javaNode) : this._astFactoryJava.javaInCExpression(gNode, string, this.cEnvJavaTypeAst(), out._javaNode)) : this._astFactoryJava.javaInCStatement(string, this.cEnvJavaTypeAst(), out._javaNode);
        List<Node> list = out._javaMembers;
        list.add(CodeGenerator.setLoc(out._javaNode, (GNode)node));
        return list;
    }

    private Out jeannieCancelOrCommit(Locatable locatable, String string, boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        GNode gNode = this.abruptFlowJump(locatable, arrayList);
        String string2 = this.liftIdC(this.declaringScope(string), string + "ReleaseAbrupt", this.typedefType("jint"), arrayList);
        Node node = bl ? this._astFactoryC.commit(string2, gNode) : this._astFactoryC.cancel(string2, gNode);
        CodeGenerator.setLoc(locatable, (GNode)node);
        Out out = new Out(new ArrayList<Node>(0), arrayList, (GNode)node, new ArrayList<Node>(0), null);
        return out;
    }

    private String jeannieCopyApiFunction(Type type2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? "Get" : "Set");
        if (JavaTypeConverter.isIdentical(type2, JavaEntities.tString(this._table))) {
            stringBuffer.append(bl2 ? "StringUTF" : "String");
        } else {
            stringBuffer.append(Utilities.javaTypeToApiType(type2, true, true));
        }
        stringBuffer.append("Region");
        return stringBuffer.toString();
    }

    private String liftIdC(SymbolTable.Scope scope, String string, Type type2, List<Node> list) {
        if (null == this._cSubstitutions.get(scope, string)) {
            String string2 = this.freshIdentifier("_" + string);
            Type type3 = Utilities.c().pointerize(Utilities.pureCType(this._table, this._runtime, type2));
            GNode gNode = Utilities.cTypeToAst(type3, string2, "StructureDeclaration");
            list.add(gNode);
            this._cSubstitutions.put(scope, string, string2);
        }
        return this._cSubstitutions.get(scope, string);
    }

    private String liftIdCLabel(SymbolTable.Scope scope, String string) {
        if (null == this._cSubstitutions.get(scope, string)) {
            String string2 = this.freshIdentifier(string);
            this._cSubstitutions.put(scope, string, string2);
        }
        return this._cSubstitutions.get(scope, string);
    }

    private String liftIdJava(SymbolTable.Scope scope, Locatable locatable, String string, Type type2, List<Node> list) {
        if (null == this._javaSubstitutions.get(scope, string)) {
            String string2 = this.freshIdentifier("_" + string);
            Type type3 = JavaEntities.isGeneralLValueT(type2) ? JavaEntities.dereference(type2) : type2;
            Node node = this._astFactoryJava.declareField(JavaEntities.javaTypeToAst(this._table, type3), string2);
            list.add(CodeGenerator.setLoc(locatable, (GNode)node));
            this._javaSubstitutions.put(scope, string, string2);
        }
        return this._javaSubstitutions.get(scope, string);
    }

    private String mangledFunctionName(String string) {
        String string2;
        String string3;
        Object object;
        if (null == this.context()._javaEnvPackageName) {
            object = JavaEntities.currentType(this._table).toClass();
            string3 = JavaEntities.qNameWithDollars(this._table, (ClassOrInterfaceT)object);
            string2 = string3 + "$" + this.context()._javaEnvClassName;
        } else {
            object = this.context()._javaEnvPackageName + this.context()._javaEnvClassName;
            string2 = ((String)object).replace('/', '.');
        }
        object = string2 + '.' + string;
        string3 = "Java_" + Utilities.jniMangledName((String)object);
        return string3;
    }

    private Out processBuiltin(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        String string = gNode.getGeneric(0).getString(0);
        Out out = (Out)this.dispatch(gNode.getGeneric(1));
        assert (null == out._javaNode);
        if ("_copyFromJava".equals(string)) {
            Node node;
            boolean bl;
            GNode gNode2 = out._cNode.getGeneric(0);
            GNode gNode3 = out._cNode.getGeneric(1);
            GNode gNode4 = out._cNode.getGeneric(2);
            GNode gNode5 = out._cNode.getGeneric(3);
            GNode gNode6 = out._cNode.getGeneric(4);
            GNode gNode7 = this.abruptFlowCheck(gNode, out._cMembers, out._javaMembers);
            Type type2 = Utilities.cTypeToJavaType(this._table, this._runtime, gNode.getGeneric(1).getGeneric(2), CodeGenerator.getType(gNode.getGeneric(1).getGeneric(2)));
            boolean bl2 = bl = JavaTypeConverter.isIdentical(type2, JavaEntities.tString(this._table)) || type2.isArray() && JavaEntities.isPrimitiveT(JavaEntities.arrayElementType(type2.toArray()));
            if (bl) {
                boolean bl3 = this.isUtf8(CodeGenerator.getType(gNode.getGeneric(1).getGeneric(0)), type2);
                String string2 = this.jeannieCopyApiFunction(type2, true, bl3);
                node = bl3 ? this._astFactoryC.copyBetweenJavaAndCUTF(gNode4, gNode5, gNode6, string2, gNode2, gNode3, gNode7) : this._astFactoryC.copyBetweenJavaAndC(string2, gNode4, gNode5, gNode6, gNode2, gNode3, gNode7);
            } else {
                node = this._astFactoryC.copyFromJavaReference(gNode4, gNode5, gNode6, gNode2, gNode3, gNode7);
            }
            CodeGenerator.setLoc(gNode, (GNode)node);
            Out out2 = new Out(out._cExternalDeclarations, out._cMembers, (GNode)node, out._javaMembers, null);
            return out2;
        }
        if ("_copyToJava".equals(string)) {
            Node node;
            boolean bl;
            GNode gNode8 = out._cNode.getGeneric(0);
            GNode gNode9 = out._cNode.getGeneric(1);
            GNode gNode10 = out._cNode.getGeneric(2);
            GNode gNode11 = out._cNode.getGeneric(3);
            GNode gNode12 = out._cNode.getGeneric(4);
            GNode gNode13 = this.abruptFlowCheck(gNode, out._cMembers, out._javaMembers);
            Type type3 = Utilities.cTypeToJavaType(this._table, this._runtime, gNode.getGeneric(1).getGeneric(0), CodeGenerator.getType(gNode.getGeneric(1).getGeneric(0)));
            boolean bl4 = bl = JavaTypeConverter.isIdentical(type3, JavaEntities.tString(this._table)) || type3.isArray() && JavaEntities.isPrimitiveT(JavaEntities.arrayElementType(type3.toArray()));
            if (bl) {
                boolean bl5 = this.isUtf8(CodeGenerator.getType(gNode.getGeneric(1).getGeneric(2)), type3);
                String string3 = this.jeannieCopyApiFunction(type3, false, bl5);
                node = bl5 ? this._astFactoryC.copyBetweenJavaAndCUTF(gNode8, gNode9, gNode12, string3, gNode10, gNode11, gNode13) : this._astFactoryC.copyBetweenJavaAndC(string3, gNode8, gNode9, gNode12, gNode10, gNode11, gNode13);
            } else {
                node = this._astFactoryC.copyToJavaReference(gNode8, gNode9, gNode12, gNode10, gNode11, gNode13);
            }
            CodeGenerator.setLoc(gNode, (GNode)node);
            Out out3 = new Out(out._cExternalDeclarations, out._cMembers, (GNode)node, out._javaMembers, null);
            return out3;
        }
        if ("_newJavaString".equals(string)) {
            Type type4 = CodeGenerator.getType(gNode.getGeneric(1).getGeneric(0));
            String string4 = "NewString" + (Utilities.isPtrTypedef(type4, "jchar") ? "" : "UTF");
            GNode gNode14 = out._cNode.getGeneric(0);
            GNode gNode15 = this.abruptFlowCheck(gNode, out._cMembers, out._javaMembers);
            GNode gNode16 = (GNode)this._astFactoryC.newJavaString(string4, gNode14, gNode15);
            CodeGenerator.setLoc(gNode, gNode16);
            Out out4 = new Out(out._cExternalDeclarations, out._cMembers, gNode16, out._javaMembers, null);
            return out4;
        }
        if ("_stringUTFLength".equals(string)) {
            Node node = out._cNode;
            Node node2 = node.getNode(0);
            Node node3 = 1 == gNode.getGeneric(1).size() ? this._astFactoryC.stringUTFLength1(node2) : this._astFactoryC.stringUTFLength3(node2, node.getNode(1), node.getNode(2));
            Out out5 = new Out(out._cExternalDeclarations, out._cMembers, CodeGenerator.setLoc(gNode, (GNode)node3), out._javaMembers, null);
            return out5;
        }
        throw new Error("builtin " + string + " not (yet) implemented");
    }

    private List<Node> processDeclarators(GNode gNode, List<Node> list, List<Node> list2, List<Node> list3) {
        assert ("Java".equals(this.context()._activeLanguage) && gNode.hasName("Declarators"));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Object object : gNode) {
            Node node;
            GNode gNode2 = (GNode)object;
            GNode gNode3 = gNode2.getGeneric(2);
            if (null == gNode3) continue;
            Out out = (Out)this.dispatch(gNode3);
            assert (null == out._cNode);
            list.addAll(out._cExternalDeclarations);
            list2.addAll(out._cMembers);
            list3.addAll(out._javaMembers);
            VariableT variableT = CodeGenerator.getType(gNode2).toVariable();
            String string = variableT.getName();
            String string2 = this.liftIdJava(this.declaringScope(string), gNode2, string, variableT, list3);
            if (out._javaNode.hasName("ArrayInitializer")) {
                GNode gNode4 = JavaEntities.javaTypeToAst(this._table, variableT.getType());
                node = CodeGenerator.setLoc(out._javaNode, GNode.create("NewArrayExpression", gNode4.getGeneric(0), null, gNode4.getGeneric(1), out._javaNode));
            } else {
                node = out._javaNode;
            }
            arrayList.add(CodeGenerator.setLoc(node, (GNode)this._astFactoryJava.setThisDotField(string2, node)));
        }
        return arrayList;
    }

    private void recordMethodSubstitution(String string) {
        String string2 = Utilities.currentFunctionOrMethodName(this._table);
        StringBuilder stringBuilder = new StringBuilder();
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        if (null == classOrInterfaceT) {
            String string3 = this.context()._javaEnvPackageName;
            if (0 < string3.length()) {
                stringBuilder.append(string3.substring(0, string3.length() - 1).replace('/', '.') + '$');
            }
        } else {
            stringBuilder.append(JavaEntities.qNameWithDollars(this._table, classOrInterfaceT)).append('$');
        }
        stringBuilder.append(this.context()._javaEnvClassName).append('.').append(string);
        this._methodSubstitutions.put(stringBuilder.toString(), string2);
    }

    private Type typedefType(String string) {
        Type type2 = (Type)this._table.root().lookup(string);
        assert (null != type2);
        return type2;
    }

    public final Out visit(LineMarker lineMarker) {
        boolean bl = "C".equals(this.context()._activeLanguage);
        Node node = lineMarker.getNode();
        if (null == node) {
            return new Out(new ArrayList<Node>(0), new ArrayList<Node>(0), bl ? lineMarker : null, new ArrayList<Node>(0), bl ? null : lineMarker);
        }
        Out out = (Out)this.dispatch(node);
        if (bl) {
            assert (null != out._cNode && null == out._javaNode);
            lineMarker.setNode(out._cNode);
        } else {
            assert (null == out._cNode && null != out._javaNode);
            lineMarker.setNode(out._javaNode);
        }
        Out out2 = new Out(out._cExternalDeclarations, out._cMembers, bl ? lineMarker : null, out._javaMembers, bl ? null : lineMarker);
        return out2;
    }

    public final Out visit(Node node) {
        this._table.enter(node);
        GNode gNode = CodeGenerator.setLoc(node, GNode.create(node.getName(), node.size()));
        boolean bl = "C".equals(this.context()._activeLanguage);
        Out out = new Out(new ArrayList<Node>(), new ArrayList<Node>(), bl ? gNode : null, new ArrayList<Node>(), bl ? null : gNode);
        for (int i = 0; i < node.size(); ++i) {
            if (node.get(i) instanceof Node) {
                Out out2 = (Out)this.dispatch(node.getNode(i));
                gNode.add(i, bl ? out2._cNode : out2._javaNode);
                out.addAll(out2);
                assert (null == (bl ? out2._javaNode : out2._cNode));
                continue;
            }
            gNode.add(i, node.get(i));
        }
        this._table.exit(node);
        return out;
    }

    public final Out visitBasicForControl(GNode gNode) {
        assert ("Java".equals(this.context()._activeLanguage));
        if (null == this.context()._javaEnvClassName || null == gNode.get(0)) {
            return this.visit(gNode);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        List<Node> list = this.processDeclarators(gNode.getGeneric(2), arrayList, arrayList2, arrayList3);
        GNode gNode2 = 0 == list.size() ? null : CodeGenerator.setLoc(gNode.getGeneric(2), (GNode)GNode.create("ExpressionList", list.size()).addAll(list));
        Out out = (Out)this.dispatch(gNode.getGeneric(3));
        Out out2 = (Out)this.dispatch(gNode.getGeneric(4));
        GNode gNode3 = CodeGenerator.setLoc(gNode, GNode.create("BasicForControl", null, null, gNode2, out._javaNode, out2._javaNode));
        Out out3 = new Out(arrayList, arrayList2, null, arrayList3, gNode3);
        out3.addAll(out).addAll(out2);
        return out3;
    }

    public final Out visitCancelStatement(GNode gNode) {
        return this.jeannieCancelOrCommit(gNode, gNode.getGeneric(0).getString(0), false);
    }

    public final Out visitCDeclarations(GNode gNode) {
        Out out = new Out(new ArrayList<Node>(), new ArrayList<Node>(), null, new ArrayList<Node>(), null);
        assert (this._table.current().isRoot());
        assert (1 == this._contexts.size() && "C".equals(this.context()._activeLanguage));
        for (int i = 0; i < gNode.size() - 1; ++i) {
            Out out2 = (Out)this.dispatch(gNode.getNode(i));
            assert (null == out2._javaNode);
            out._javaMembers.addAll(out2._javaMembers);
            out._cExternalDeclarations.addAll(out2._cExternalDeclarations);
            out._cExternalDeclarations.add(out2._cNode);
        }
        assert (this._table.current().isRoot());
        return out;
    }

    public final Out visitCInCBlock(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        Out out = this.visit(gNode);
        assert (out._cNode.hasName("CInCBlock"));
        ArrayList<GNode> arrayList = new ArrayList<GNode>(gNode.size() - 1);
        for (int i = 0; i < gNode.size() - 1; ++i) {
            GNode gNode2 = gNode.getGeneric(i);
            GNode gNode3 = out._cNode.getGeneric(i);
            if (gNode2.hasName("Declaration")) {
                if (gNode3.hasName("CompoundStatement")) {
                    for (Object object : gNode3) {
                        arrayList.add((GNode)object);
                    }
                    continue;
                }
                if (gNode3.hasName("EmptyStatement")) continue;
                arrayList.add(gNode3);
                continue;
            }
            arrayList.add(gNode3);
        }
        Out out2 = new Out(out._cExternalDeclarations, out._cMembers, CodeGenerator.setLoc(gNode, GNode.create("CompoundStatement", arrayList.size() + 1)), out._javaMembers, out._javaNode);
        for (int i = 0; i < arrayList.size(); ++i) {
            out2._cNode.add(i, arrayList.get(i));
        }
        return out2;
    }

    public final Out visitCInJavaBlock(GNode gNode) {
        return this.cInJavaCode(gNode, false);
    }

    public final Out visitCInJavaExpression(GNode gNode) {
        return this.cInJavaCode(gNode, true);
    }

    public final Out visitClassBody(GNode gNode) {
        assert ("Java".equals(this.context()._activeLanguage));
        this._table.enter(gNode);
        Out out = new Out(new ArrayList<Node>(), new ArrayList<Node>(), null, new ArrayList<Node>(), CodeGenerator.setLoc(gNode, GNode.create("ClassBody")));
        if (Utilities.containsJavaToCTransition(gNode) && JavaEntities.isTypeTopLevel(JavaEntities.currentType(this._table))) {
            GNode gNode2 = GNode.create("StringLiteral", "\"" + CodeGenerator.getFileStem(gNode) + "\"");
            Object object = this._astFactoryJava.loadLibrary(gNode2);
            out._javaNode.add(CodeGenerator.setLoc(gNode, GNode.create("BlockDeclaration", "static", object)));
        }
        for (Object object : gNode) {
            Out out2 = (Out)this.dispatch((GNode)object);
            out._cExternalDeclarations.addAll(out2._cExternalDeclarations);
            assert (out2._cMembers.isEmpty() && null == out2._cNode);
            out._javaNode.add(out2._javaNode);
            out._javaNode.addAll(out2._javaMembers);
        }
        this._table.exit(gNode);
        return out;
    }

    public final Out visitCommitStatement(GNode gNode) {
        return this.jeannieCancelOrCommit(gNode, gNode.getGeneric(0).getString(0), true);
    }

    public final Out visitCompilationUnit(GNode gNode) {
        assert (this._contexts.isEmpty());
        this._usedIdentifiers = JavaEntities.allUsedIdentifiers(gNode);
        GNode gNode2 = CodeGenerator.setLoc(gNode, GNode.create("TranslationUnit"));
        Object object = new StringBuffer();
        if (null != gNode.get(0)) {
            for (Object object2 : gNode.getNode(0).getNode(1)) {
                ((StringBuffer)object).append(object2).append('/');
            }
        }
        this._contexts.push(new Context("C", null, false, null, ((StringBuffer)object).toString(), true, null, null));
        Out out = (Out)this.dispatch(gNode.getGeneric(2));
        this._contexts.pop();
        assert (out._cMembers.isEmpty() && null == out._cNode && null == out._javaNode);
        gNode2.addAll(out._cExternalDeclarations);
        object = CodeGenerator.setLoc(gNode, GNode.create("CompilationUnit"));
        ((Node)object).add(gNode.getGeneric(0));
        for (Object object2 : gNode.getGeneric(1)) {
            ((Node)object).add(object2);
        }
        this._contexts.push(new Context("Java", null, false, null, null, true, null, null));
        JavaEntities.enterScopeByQualifiedName(this._table, (String)gNode.getProperty("xtc.Constants.Scope"));
        for (int i = 3; i < gNode.size(); ++i) {
            Object object2;
            object2 = (Out)this.dispatch(gNode.getGeneric(i));
            gNode2.addAll(((Out)object2)._cExternalDeclarations);
            ((Node)object).add(((Out)object2)._javaNode);
            assert (((Out)object2)._cMembers.isEmpty() && null == ((Out)object2)._cNode && ((Out)object2)._javaMembers.isEmpty());
        }
        ((Node)object).addAll(out._javaMembers);
        this._contexts.pop();
        Out out2 = new Out(null, null, gNode2, null, (Node)object);
        return out2;
    }

    public final Out visitDeclaration(GNode gNode) {
        Object object2;
        assert ("C".equals(this.context()._activeLanguage));
        if (null == this.context()._cEnvStructName || null == gNode.get(2)) {
            return this.visit(gNode);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        ArrayList<Node> arrayList4 = new ArrayList<Node>();
        for (Object object2 : gNode.getGeneric(2)) {
            GNode gNode2;
            Object object3;
            Out out;
            GNode gNode3 = (GNode)object2;
            String string = Utilities.getSimpleDeclarator(gNode3);
            Type type2 = Utilities.pureCType(this._table, this._runtime, (Type)this._table.lookup(string));
            String string2 = this.liftIdC(this.declaringScope(string), string, type2, arrayList2);
            if (gNode3.getGeneric(1).hasName("ArrayDeclarator")) {
                out = (Out)this.dispatch(gNode.getGeneric(1));
                assert (null == out._javaNode);
                arrayList.addAll(out._cExternalDeclarations);
                arrayList2.addAll(out._cMembers);
                arrayList3.addAll(out._javaMembers);
                object3 = (Out)this.dispatch(gNode3);
                assert (null == ((Out)object3)._javaNode);
                arrayList.addAll(((Out)object3)._cExternalDeclarations);
                arrayList2.addAll(((Out)object3)._cMembers);
                arrayList3.addAll(((Out)object3)._javaMembers);
                gNode2 = CodeGenerator.setLoc(gNode3, GNode.create("Declaration", gNode.getString(0), out._cNode, GNode.create("InitializedDeclaratorList", ((Out)object3)._cNode)));
                arrayList4.add(gNode2);
                GNode gNode4 = (GNode)this._astFactoryC.setPCEnvField(string2, GNode.create("PrimaryIdentifier", string));
                arrayList4.add(CodeGenerator.setLoc(gNode3, gNode4));
                continue;
            }
            if (null == gNode3.getGeneric(4)) continue;
            out = (Out)this.dispatch(gNode3.getGeneric(4));
            assert (null == out._javaNode);
            arrayList.addAll(out._cExternalDeclarations);
            arrayList2.addAll(out._cMembers);
            arrayList3.addAll(out._javaMembers);
            object3 = Utilities.cTypeToAst(type2, null, "TypeName");
            gNode2 = GNode.create("CastExpression", object3, out._cNode);
            arrayList4.add(CodeGenerator.setLoc(gNode3, (GNode)this._astFactoryC.setPCEnvField(string2, gNode2)));
        }
        Node node = 0 == arrayList4.size() ? GNode.create("EmptyStatement") : (1 == arrayList4.size() ? (Node)arrayList4.get(0) : this._astFactoryC.block(arrayList4));
        object2 = new Out(arrayList, arrayList2, CodeGenerator.setLoc(gNode.getGeneric(2), (GNode)node), arrayList3, null);
        return object2;
    }

    public final Out visitFieldDeclaration(GNode gNode) {
        GNode gNode2;
        assert ("Java".equals(this.context()._activeLanguage));
        if (null == this.context()._javaEnvClassName) {
            return this.visit(gNode);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        List<Node> list = this.processDeclarators(gNode.getGeneric(2), arrayList, arrayList2, arrayList3);
        if (0 == list.size()) {
            gNode2 = GNode.create("EmptyStatement");
        } else if (1 == list.size()) {
            gNode2 = GNode.create("ExpressionStatement", list.get(0));
        } else {
            gNode2 = GNode.create("Block", list.size());
            for (Node node : list) {
                gNode2.add(GNode.create("ExpressionStatement", node));
            }
        }
        Out out = new Out(arrayList, arrayList2, null, arrayList3, CodeGenerator.setLoc(gNode.getGeneric(2), gNode2));
        return out;
    }

    public final Out visitForStatement(GNode gNode) {
        if ("Java".equals(this.context()._activeLanguage) || null == this.context()._cEnvStructName || null == gNode.get(0) || !gNode.getGeneric(0).hasName("Declaration")) {
            return this.visit(gNode);
        }
        this._table.enter(gNode);
        Out out = (Out)this.dispatch(gNode.getGeneric(0));
        Out out2 = (Out)this.dispatch(gNode.getGeneric(1));
        Out out3 = (Out)this.dispatch(gNode.getGeneric(2));
        Out out4 = (Out)this.dispatch(gNode.getGeneric(3));
        GNode gNode2 = GNode.create("ForStatement", null, null == out2 ? null : out2._cNode, null == out3 ? null : out3._cNode, out4._cNode);
        GNode gNode3 = GNode.create("CompoundStatement", out._cNode, gNode2, null);
        Out out5 = new Out(new ArrayList<Node>(), new ArrayList<Node>(), CodeGenerator.setLoc(gNode, gNode3), new ArrayList<Node>(), null);
        out5.addAll(out).addAll(out2).addAll(out3).addAll(out4);
        this._table.exit(gNode);
        return out5;
    }

    public final Out visitFunctionCall(GNode gNode) {
        Object object;
        GNode gNode2;
        Type type2;
        assert ("C".equals(this.context()._activeLanguage));
        if (null == this.context()._javaEnvClassName) {
            return this.visit(gNode);
        }
        if (gNode.getGeneric(0).hasName("PrimaryIdentifier") && Analyzer.BUILTINS.contains(gNode.getGeneric(0).getString(0))) {
            return this.processBuiltin(gNode);
        }
        Out out = this.visit(gNode);
        Type type3 = CodeGenerator.getType(gNode);
        Node node = out._cNode;
        GNode gNode3 = this.abruptFlowCheck(gNode, out._cMembers, out._javaMembers);
        Type type4 = type2 = type3.isAnnotated() ? type3.toAnnotated().getType() : type3;
        if (type2.isVoid()) {
            gNode2 = (GNode)this._astFactoryC.checkedFunctionCallVoid(node, gNode3);
        } else {
            object = Utilities.cTypeToAst(type3, "tmp", "Declaration");
            gNode2 = (GNode)this._astFactoryC.checkedFunctionCallResult((Node)object, node, gNode3);
        }
        CodeGenerator.setLoc(gNode, gNode2);
        object = new Out(out._cExternalDeclarations, out._cMembers, gNode2, out._javaMembers, out._javaNode);
        return object;
    }

    public final Out visitFunctionDeclarator(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        return this.visit(gNode);
    }

    public final Out visitFunctionDefinition(GNode gNode) {
        Node node2;
        assert ("C".equals(this.context()._activeLanguage));
        if (!Utilities.containsCToJavaTransition(gNode)) {
            return this.visit(gNode);
        }
        this._table.enter(gNode);
        String string = SymbolTable.fromNameSpace(this._table.current().getName());
        String string2 = this.freshIdentifier("JavaEnvFor_" + string);
        String string3 = this.freshIdentifier("CEnvFor_" + string);
        FunctionT functionT = ((Type)this._table.current().getParent().lookupLocally(string)).resolve().toFunction();
        this._contexts.push(new Context("C", string3, true, string2, this.context()._javaEnvPackageName, true, null, functionT.getResult()));
        Out out = (Out)this.dispatch(gNode.getNode(4));
        Iterable<Object> iterable = GNode.create("StringConstant", '\"' + this.context()._javaEnvPackageName + string2 + '\"');
        Object object = CodeGenerator.setLoc(gNode.getGeneric(2), GNode.create("CompoundStatement", functionT.getParameters().size() - 1));
        for (Node node2 : functionT.getParameters()) {
            String string4 = node2.toVariable().getName();
            if ("env".equals(string4)) continue;
            String string5 = this.liftIdC(this.declaringScope(string4), string4, node2.toVariable().getType(), out._cMembers);
            Node node3 = this._astFactoryC.setPCEnvField(string5, GNode.create("PrimaryIdentifier", string4));
            ((Node)object).add(node3);
        }
        assert (functionT.getResult().hasTag(Type.Tag.VOID));
        Iterable<Object> iterable2 = this._astFactoryC.closureStatement(string3, (Node)object, (Node)iterable, out._cNode);
        GNode gNode2 = gNode;
        gNode2.set(4, CodeGenerator.setLoc(out._cNode, (GNode)iterable2));
        iterable2 = this.visitMethodDeclaration_cExternalDeclarations(out);
        object = GNode.create("ClassBody", out._javaMembers.size());
        ((Node)object).addAll(out._javaMembers);
        GNode gNode3 = GNode.create("Modifiers", GNode.create("Modifier", "final"));
        node2 = CodeGenerator.setLoc(gNode, GNode.create("ClassDeclaration", gNode3, this.context()._javaEnvClassName, null, null, null, object));
        iterable = new ArrayList(1);
        iterable.add(node2);
        object = new Out((List<Node>)iterable2, (List<Node>)new ArrayList<Node>(), gNode2, (List<Node>)iterable, null);
        this._contexts.pop();
        this._table.exit(gNode);
        return object;
    }

    public final Out visitJavaImports(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        return this.visit(gNode);
    }

    public final Out visitJavaInCBlock(GNode gNode) {
        return this.javaInCCode(gNode.getGeneric(0), false);
    }

    public final Out visitJavaInCExpression(GNode gNode) {
        return this.javaInCCode(gNode.getGeneric(0), true);
    }

    public final Out visitJavaInCStatement(GNode gNode) {
        return this.javaInCCode(gNode.getGeneric(0), false);
    }

    public final Out visitJavaInJavaBlock(GNode gNode) {
        assert ("Java".equals(this.context()._activeLanguage));
        Out out = this.visit(gNode);
        assert (out._javaNode.hasName("JavaInJavaBlock"));
        Out out2 = new Out(out._cExternalDeclarations, out._cMembers, out._cNode, out._javaMembers, CodeGenerator.setLoc(gNode, GNode.create("Block", gNode.size())));
        for (int i = 0; i < gNode.size(); ++i) {
            out2._javaNode.add(i, out._javaNode.get(i));
        }
        return out2;
    }

    public final Out visitJavaThrows(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        return this.visit(gNode);
    }

    public final Out visitJavaType(GNode gNode) {
        assert ("C".equals(this.context()._activeLanguage));
        Type type2 = Utilities.pureCType(this._table, this._runtime, CodeGenerator.getType(gNode));
        GNode gNode2 = Utilities.cTypeToAst(type2, null, "TypeName");
        Out out = new Out(new ArrayList<Node>(), new ArrayList<Node>(), gNode2, new ArrayList<Node>(), null);
        return out;
    }

    public final Out visitMethodDeclaration(GNode gNode) {
        assert ("Java".equals(this.context()._activeLanguage));
        if (!Utilities.containsJavaToCTransition(gNode)) {
            return this.visit(gNode);
        }
        this._table.enter(gNode);
        MethodT methodT = JavaEntities.currentMethod(this._table);
        String string = this.freshIdentifier("JavaEnvFor_" + methodT.getName());
        String string2 = this.freshIdentifier("CEnvFor_" + Utilities.jniMangledName(this._table, methodT));
        this._contexts.push(new Context("Java", string2, false, string, this.context()._javaEnvPackageName, Utilities.javaIsStaticMethod(gNode), null, methodT.getResult()));
        Out out = (Out)this.dispatch(gNode.getGeneric(7));
        Out out2 = new Out(this.visitMethodDeclaration_cExternalDeclarations(out), new ArrayList<Node>(), null, this.visitMethodDeclaration_javaMembers(gNode, out), this.visitMethodDeclaration_javaNode(gNode));
        this._contexts.pop();
        this._table.exit(gNode);
        return out2;
    }

    private List<Node> visitMethodDeclaration_cExternalDeclarations(Out out) {
        ArrayList<Node> arrayList = new ArrayList<Node>(out._cMembers.size());
        arrayList.addAll(out._cMembers);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(1 + out._cExternalDeclarations.size());
        GNode gNode = (GNode)this._astFactoryC.declareStruct(this.context()._cEnvStructName, arrayList);
        arrayList2.add(CodeGenerator.setLoc(null == out._cNode ? out._javaNode : out._cNode, gNode));
        arrayList2.addAll(out._cExternalDeclarations);
        return arrayList2;
    }

    private List<Node> visitMethodDeclaration_javaMembers(GNode gNode, Out out) {
        Object object;
        Object object2;
        GNode gNode2;
        Object object32;
        Object object4;
        Object object52;
        GNode gNode3 = gNode.getGeneric(4);
        if (!Utilities.javaIsVoidMethod(gNode)) {
            this.liftIdJava(this.currentMethodScope(), gNode, "returnResult", CodeGenerator.getType(gNode).toMethod().getResult(), out._javaMembers);
        }
        for (Object object52 : gNode3) {
            object4 = (GNode)object52;
            object32 = ((Node)object4).getString(3);
            this.liftIdJava(this.declaringScope((String)object32), (Locatable)object4, (String)object32, CodeGenerator.getType((GNode)object4), out._javaMembers);
        }
        ArrayList arrayList = new ArrayList();
        object52 = this.liftIdJava(this.currentMethodScope(), gNode, "returnAbrupt", JavaEntities.nameToBaseType("boolean"), out._javaMembers);
        arrayList.add(GNode.create("ExpressionStatement", this._astFactoryJava.setThisDotField((String)object52, GNode.create("BooleanLiteral", "false"))));
        for (Object object32 : gNode3) {
            gNode2 = (GNode)object32;
            object2 = gNode2.getString(3);
            object = this._javaSubstitutions.get(this.declaringScope((String)object2), (String)object2);
            arrayList.add(GNode.create("ExpressionStatement", this._astFactoryJava.setThisDotField((String)object, CodeGenerator.idNode(gNode2, (String)object2))));
        }
        arrayList.add(out._javaNode);
        object4 = GNode.create("ConstructorDeclaration", GNode.create("Modifiers", false), null, this.context()._javaEnvClassName, gNode3, null, this._astFactoryJava.block(arrayList));
        object32 = Utilities.currentFunctionOrMethodName(this._table);
        this._methodSubstitutions.put(((String)object32).substring(0, ((String)object32).indexOf(40)), (String)object32);
        this.recordMethodSubstitution("<init>");
        out._javaMembers.add((Node)object4);
        object32 = GNode.create("ClassBody", out._javaMembers.size());
        ((Node)object32).addAll(out._javaMembers);
        gNode2 = this.context()._javaIsStatic ? GNode.create("Modifiers", GNode.create("Modifier", "private"), GNode.create("Modifier", "static"), GNode.create("Modifier", "final")) : GNode.create("Modifiers", GNode.create("Modifier", "private"), GNode.create("Modifier", "final"));
        object2 = CodeGenerator.setLoc(gNode, GNode.create("ClassDeclaration", gNode2, this.context()._javaEnvClassName, null, null, null, object32));
        object = new ArrayList(1);
        object.add(object2);
        return object;
    }

    private GNode visitMethodDeclaration_javaNode(GNode gNode) {
        Object object;
        Object object22;
        ArrayList<Node> arrayList = new ArrayList<Node>(gNode.getGeneric(4).size());
        for (Object object22 : gNode.getGeneric(4)) {
            arrayList.add(CodeGenerator.idNode((Locatable)object22, ((Node)object22).getString(3)));
        }
        GNode gNode2 = GNode.create("QualifiedIdentifier", this.context()._javaEnvClassName);
        if (Utilities.javaIsVoidMethod(gNode)) {
            object22 = this._astFactoryJava.closureStatement(gNode2, arrayList);
        } else {
            object = this._javaSubstitutions.get(this.currentMethodScope(), "returnResult");
            object22 = this._astFactoryJava.closureExpression(gNode2, arrayList, (String)object);
        }
        object = CodeGenerator.setLoc(gNode, GNode.create("MethodDeclaration", 8));
        ((Node)object).add(0, GNode.create("Modifiers"));
        for (Object object3 : gNode.getGeneric(0)) {
            if ("native".equals(((Node)object3).getString(0))) continue;
            ((Node)object).getGeneric(0).add(object3);
        }
        for (int i = 1; i < 7; ++i) {
            ((Node)object).add(i, gNode.get(i));
        }
        ((Node)object).add(7, object22);
        return object;
    }

    public final Out visitPrimaryIdentifier(GNode gNode) {
        Out out;
        String string = gNode.getString(0);
        Type type2 = CodeGenerator.getType(gNode);
        if ("C".equals(this.context()._activeLanguage)) {
            VariableT variableT;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            GNode gNode2 = null == type2 || null == this.context()._cEnvStructName ? gNode : (!type2.isVariable() ? (type2.hasAttribute(Constants.ATT_STORAGE_AUTO, true) ? (GNode)this._astFactoryC.getPCEnvField(this.liftIdC(this.declaringScope(string), string, type2, arrayList)) : gNode) : (VariableT.Kind.LOCAL == (variableT = type2.toVariable()).getKind() || VariableT.Kind.PARAMETER == variableT.getKind() ? (GNode)this._astFactoryC.getPCEnvField(this.liftIdC(this.declaringScope(string), string, variableT.getType(), arrayList)) : gNode));
            out = new Out(new ArrayList<Node>(0), arrayList, CodeGenerator.setLoc(gNode, gNode2), new ArrayList<Node>(0), null);
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            GNode gNode3 = null == this.context()._javaEnvClassName || !JavaEntities.isParameterT(type2) && !JavaEntities.isLocalT(type2) ? gNode : (GNode)this._astFactoryJava.getThisDotField(this.liftIdJava(this.declaringScope(string), gNode, string, type2, arrayList));
            out = new Out(new ArrayList<Node>(0), new ArrayList<Node>(0), null, arrayList, CodeGenerator.setLoc(gNode, gNode3));
        }
        return out;
    }

    public final Out visitReturnStatement(GNode gNode) {
        Out out;
        if ("C".equals(this.context()._activeLanguage)) {
            if (null == this.context()._cEnvStructName) {
                out = this.visit(gNode);
            } else {
                GNode gNode2;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                ArrayList<Node> arrayList3 = new ArrayList<Node>();
                GNode gNode3 = this.abruptFlowJump(gNode, arrayList2);
                GNode gNode4 = this.cStringNode(this.liftIdJava(this.currentMethodScope(), gNode, "returnAbrupt", JavaEntities.nameToBaseType("boolean"), arrayList3));
                if (null == gNode.get(0)) {
                    gNode2 = (GNode)this._astFactoryC.returnVoid(gNode4, gNode3);
                } else {
                    Out out2 = (Out)this.dispatch(gNode.getGeneric(0));
                    arrayList.addAll(out2._cExternalDeclarations);
                    arrayList2.addAll(out2._cMembers);
                    arrayList3.addAll(out2._javaMembers);
                    Type type2 = Utilities.currentFunctionOrMethod(this._table);
                    assert (type2.isMethod());
                    Type type3 = Utilities.returnType(type2);
                    GNode gNode5 = this.cStringNode(this.liftIdJava(this.currentMethodScope(), gNode, "returnResult", type3, arrayList3));
                    GNode gNode6 = this.cStringNode(JavaEntities.typeToDescriptor(this._table, type3));
                    String string = "Set" + Utilities.javaTypeToApiType(type3, true, false) + "Field";
                    gNode2 = (GNode)this._astFactoryC.returnResult(gNode5, gNode6, string, out2._cNode, gNode4, gNode3);
                }
                out = new Out(arrayList, arrayList2, CodeGenerator.setLoc(gNode, gNode2), arrayList3, null);
            }
        } else if (null == this.context()._javaEnvClassName) {
            out = this.visit(gNode);
        } else {
            Node node;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            ArrayList<Node> arrayList4 = new ArrayList<Node>();
            ArrayList<Node> arrayList5 = new ArrayList<Node>();
            Type type4 = Utilities.currentFunctionOrMethod(this._table);
            assert (type4.isMethod());
            Type type5 = type4.toMethod().getResult();
            String string = this.liftIdJava(this.currentMethodScope(), gNode, "returnAbrupt", JavaEntities.nameToBaseType("boolean"), arrayList5);
            if (null == gNode.get(0)) {
                node = this._astFactoryJava.returnVoid(string);
            } else {
                Out out3 = (Out)this.dispatch(gNode.getGeneric(0));
                arrayList.addAll(out3._cExternalDeclarations);
                arrayList4.addAll(out3._cMembers);
                arrayList5.addAll(out3._javaMembers);
                String string2 = this.liftIdJava(this.currentMethodScope(), gNode, "returnResult", type5, arrayList5);
                node = this._astFactoryJava.returnResult(string2, out3._javaNode, string);
            }
            out = new Out(arrayList, arrayList4, null, arrayList5, CodeGenerator.setLoc(gNode, (GNode)node));
        }
        return out;
    }

    public final Out visitThisExpression(GNode gNode) {
        assert ("Java".equals(this.context()._activeLanguage));
        assert (null == gNode.get(0));
        String string = JavaEntities.currentType(this._table).toClass().getName();
        GNode gNode2 = CodeGenerator.setLoc(gNode, GNode.create("ThisExpression", GNode.create("Type", GNode.create("QualifiedIdentifier", string), GNode.create("Dimensions"))));
        return this.visit(gNode2);
    }

    public final Out visitTranslationUnit(GNode gNode) {
        assert (this._contexts.isEmpty());
        assert (false);
        return null;
    }

    public final Out visitWithStatement(GNode gNode) {
        Node node;
        Type type2;
        Type type3;
        Out out;
        Out out2;
        String string;
        Iterable<Object> iterable;
        Object object;
        assert ("C".equals(this.context()._activeLanguage));
        this._table.enter(gNode);
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode2.hasName("Declaration")) {
            object = gNode2.getGeneric(2).getGeneric(0);
            iterable = ((Node)object).getGeneric(4);
            string = CAnalyzer.getDeclaredId(((Node)object).getGeneric(1)).getString(0);
            out2 = (Out)this.dispatch(CodeGenerator.setLoc(((Node)object).getGeneric(1), GNode.create("PrimaryIdentifier", string)));
            out = (Out)this.dispatch((Node)iterable);
            type3 = (Type)this._table.current().lookupLocally(string);
            type2 = Utilities.cTypeToJavaType(this._table, this._runtime, iterable, CodeGenerator.getType(iterable));
        } else {
            assert (gNode2.hasName("AssignmentExpression"));
            object = gNode2.getGeneric(0);
            iterable = gNode2.getGeneric(2);
            string = ((Node)object).getString(0);
            out2 = (Out)this.dispatch((Node)object);
            out = (Out)this.dispatch((Node)iterable);
            type3 = CodeGenerator.getType((GNode)object);
            type2 = Utilities.cTypeToJavaType(this._table, this._runtime, iterable, CodeGenerator.getType(iterable));
        }
        this._contexts.push(new Context(this.context()._activeLanguage, this.context()._cEnvStructName, this.context()._cHasEnv, this.context()._javaEnvClassName, this.context()._javaEnvPackageName, this.context()._javaIsStatic, string, this.context()._snippetType));
        object = (Out)this.dispatch(gNode.getGeneric(1));
        this._contexts.pop();
        iterable = new ArrayList();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Object object2 = this.abruptFlowCheck(gNode, (List<Node>)iterable, arrayList);
        Node node2 = out._cNode;
        SymbolTable.Scope scope = this.declaringScope(string);
        String string2 = this.liftIdCLabel(scope, "release_" + string);
        Node node3 = ((Out)object)._cNode;
        String string3 = this.liftIdC(scope, string, type3, (List<Node>)iterable);
        String string4 = this.liftIdC(scope, string + "ReleaseAbrupt", this.typedefType("jint"), (List<Node>)iterable);
        if (JavaTypeConverter.isIdentical(type2, JavaEntities.tString(this._table))) {
            Type type4 = this.typedefType("jstring");
            String string5 = this.liftIdC(scope, string + "JavaString", type4, (List<Node>)iterable);
            node = this.isUtf8(type3, type2) ? this._astFactoryC.withStringUTF(string5, node2, string4, string3, node3, string2, (Node)object2) : this._astFactoryC.withString(string5, node2, string4, string3, node3, string2, (Node)object2);
        } else {
            Type type5 = JavaEntities.arrayElementType(type2.toArray());
            boolean bl = JavaEntities.isPrimitiveT(type5);
            Type type6 = this.typedefType(bl ? "j" + Utilities.javaTypeToApiType(type2) : "jobject");
            String string6 = this.liftIdC(scope, string + "JavaArray", type6, (List<Node>)iterable);
            if (bl) {
                String string7 = "j" + Utilities.javaTypeToApiType(type5) + " ca[length];";
                GNode gNode3 = Utilities.cStringToAst("Declaration", string7, Utilities.standardJniTypeDefs());
                String string8 = this.withArrayFunction(type2, true);
                String string9 = this.withArrayFunction(type2, false);
                node = this._astFactoryC.withPrimitiveArray(string6, node2, string4, gNode3, string3, string8, node3, string2, string9, (Node)object2);
            } else {
                node = this._astFactoryC.withReferenceArray(string6, node2, string4, string3, node3, string2, (Node)object2);
            }
        }
        object2 = new Out(new ArrayList<Node>(0), (List<Node>)iterable, CodeGenerator.setLoc(gNode, (GNode)node), arrayList, null);
        ((Out)object2).addAll(out2).addAll(out).addAll((Out)object);
        this._table.exit(gNode);
        return object2;
    }

    private String withArrayFunction(Type type2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? "Get" : "Set");
        stringBuffer.append(Utilities.javaTypeToApiType(type2, true, true));
        stringBuffer.append("Region");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Substitutions
    implements Iterable<StringString> {
        private final Map<String, Map<String, String>> _map = new HashMap<String, Map<String, String>>();

        Substitutions() {
        }

        final String get(SymbolTable.Scope scope, String string) {
            Map<String, String> map = this._map.get(scope.getQualifiedName());
            return null == map ? null : map.get(string);
        }

        @Override
        public Iterator<StringString> iterator() {
            ArrayList<StringString> arrayList = new ArrayList<StringString>();
            for (String string : this._map.keySet()) {
                for (String string2 : this._map.get(string).keySet()) {
                    arrayList.add(new StringString(string, string2));
                }
            }
            return arrayList.iterator();
        }

        final Substitutions put(SymbolTable.Scope scope, String string, String string2) {
            String string3 = scope.getQualifiedName();
            if (!this._map.containsKey(string3)) {
                this._map.put(string3, new HashMap());
            }
            this._map.get(string3).put(string, string2);
            return this;
        }
    }

    static final class StringString {
        final String _s1;
        final String _s2;

        StringString(String string, String string2) {
            this._s1 = string;
            this._s2 = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Out {
        public final List<Node> _cExternalDeclarations;
        public final List<Node> _cMembers;
        public final Node _cNode;
        public final List<Node> _javaMembers;
        public final Node _javaNode;

        public Out(List<Node> list, List<Node> list2, Node node, List<Node> list3, Node node2) {
            this._cExternalDeclarations = list;
            this._cMembers = list2;
            this._cNode = node;
            this._javaMembers = list3;
            this._javaNode = node2;
        }

        public final Out addAll(Out out) {
            if (null != out) {
                this._cExternalDeclarations.addAll(out._cExternalDeclarations);
                this._cMembers.addAll(out._cMembers);
                this._javaMembers.addAll(out._javaMembers);
            }
            return this;
        }
    }

    public static final class Context {
        final String _activeLanguage;
        final String _cEnvStructName;
        final boolean _cHasEnv;
        final String _javaEnvClassName;
        final String _javaEnvPackageName;
        final boolean _javaIsStatic;
        final String _openArray;
        final Type _snippetType;

        public Context(Context context, String string) {
            this(string, context._cEnvStructName, context._cHasEnv, context._javaEnvClassName, context._javaEnvPackageName, context._javaIsStatic, context._openArray, context._snippetType);
        }

        public Context(String string, String string2, boolean bl, String string3, String string4, boolean bl2, String string5, Type type2) {
            this._activeLanguage = string;
            this._cEnvStructName = string2;
            this._cHasEnv = bl;
            this._javaEnvClassName = string3;
            this._javaEnvPackageName = string4;
            this._javaIsStatic = bl2;
            this._openArray = string5;
            this._snippetType = type2;
        }
    }
}

