/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import xtc.Constants;
import xtc.lang.CAnalyzer;
import xtc.lang.JavaAnalyzer;
import xtc.lang.JavaEntities;
import xtc.lang.JavaTypeConverter;
import xtc.lang.jeannie.Utilities;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.C;
import xtc.type.DynamicReference;
import xtc.type.ErrorT;
import xtc.type.FunctionOrMethodT;
import xtc.type.FunctionT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

public final class Analyzer
extends Visitor {
    static final Set<String> BUILTINS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_copyFromJava", "_copyToJava", "_newJavaString", "_stringUTFLength")));
    final JeannieCAnalyzer _cAnalyzer;
    final JeannieJavaAnalyzer _jAnalyzer;
    final Runtime _runtime;
    private final Stack<JeannieContext> _stack = new Stack();
    public final SymbolTable _table;

    public Analyzer(Runtime runtime, SymbolTable symbolTable, String string) {
        this._table = symbolTable;
        this._runtime = runtime;
        this._cAnalyzer = new JeannieCAnalyzer(this);
        this._jAnalyzer = new JeannieJavaAnalyzer(this);
        if ("C".equals(string)) {
            this.enterC();
        }
        if ("Java".equals(string)) {
            this.enterJava();
        }
    }

    private Visitor activeAnalyzer() {
        return this._stack.isEmpty() ? null : this._stack.peek()._analyzer;
    }

    final Type dispatchRValue(GNode gNode) {
        JeannieJavaAnalyzer jeannieJavaAnalyzer = (JeannieJavaAnalyzer)this.activeAnalyzer();
        return jeannieJavaAnalyzer.dispatchRValue(gNode);
    }

    final void enterC() {
        assert (this._cAnalyzer != this.activeAnalyzer());
        this._stack.push(new JeannieContext(this._cAnalyzer, this._cAnalyzer.contextSave()));
        this._cAnalyzer.setHasScope(this._jAnalyzer._context._hasScope);
        this._cAnalyzer.setIsTopLevel(JavaEntities.isScopeTopLevel(this._table.current().getQualifiedName()));
        if (this._jAnalyzer._context._loop) {
            this._cAnalyzer.getLoops().add(Boolean.TRUE);
        }
        if (this._jAnalyzer._context._switch) {
            this._cAnalyzer.getSwitches().add(Boolean.TRUE);
        }
    }

    final void enterJava() {
        assert (this._jAnalyzer != this.activeAnalyzer());
        this._stack.push(new JeannieContext(this._jAnalyzer, this._jAnalyzer._context.save()));
        this._jAnalyzer._context._hasScope = this._cAnalyzer.getHasScope();
        this._jAnalyzer._context._loop = !this._cAnalyzer.getLoops().isEmpty();
        this._jAnalyzer._context._switch = !this._cAnalyzer.getSwitches().isEmpty();
    }

    final void exitC() {
        assert (this._cAnalyzer == this.activeAnalyzer());
        this._cAnalyzer.contextRestore(this.savedContextC());
        this._stack.pop();
    }

    final void exitJava() {
        assert (this._jAnalyzer == this.activeAnalyzer());
        this._jAnalyzer._context.restore(this.savedContextJ());
        this._stack.pop();
    }

    private Type processBuiltin(GNode gNode) {
        Object object;
        String string = gNode.getGeneric(0).getString(0);
        GNode gNode2 = gNode.getGeneric(1);
        List list = (List)this.dispatch(gNode2);
        for (Type type2 : list) {
            if (!type2.isError()) continue;
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if ("_copyFromJava".equals(string)) {
            if (!this._cAnalyzer.assrt(gNode, 5 == gNode2.size(), "invalid call to builtin function: `int _copyFromJava(cArray, cArrayStart, javaArray, javaArrayStart, length)", new Object[0])) {
                return ErrorT.TYPE;
            }
            this._cAnalyzer.ensureInteger(gNode2.getNode(1), (Type)list.get(1));
            this._cAnalyzer.ensureInteger(gNode2.getNode(3), (Type)list.get(3));
            this._cAnalyzer.ensureInteger(gNode2.getNode(4), (Type)list.get(4));
            this.assrtCorrectArrayConversion(gNode2.getGeneric(0), (Type)list.get(0), gNode2.getGeneric(2), (Type)list.get(2));
            return Utilities.javaTypeToCType(this._table, this._runtime, gNode, JavaEntities.nameToBaseType("int"), false);
        }
        if ("_copyToJava".equals(string)) {
            if (!this._cAnalyzer.assrt(gNode, 5 == list.size(), "invalid call to builtin function: `int _copyToJava(javaArray, javaArrayStart, cArray, cArrayStart, length)", new Object[0])) {
                return ErrorT.TYPE;
            }
            this._cAnalyzer.ensureInteger(gNode2.getNode(1), (Type)list.get(1));
            this._cAnalyzer.ensureInteger(gNode2.getNode(3), (Type)list.get(3));
            this._cAnalyzer.ensureInteger(gNode2.getNode(4), (Type)list.get(4));
            if (!this._cAnalyzer.assrt(gNode2.getGeneric(0), !Utilities.hasTypedefName((Type)list.get(0), "jstring"), "_copyToJava target must not be String", new Object[0])) {
                return ErrorT.TYPE;
            }
            this.assrtCorrectArrayConversion(gNode2.getGeneric(2), (Type)list.get(2), gNode2.getGeneric(0), (Type)list.get(0));
            return Utilities.javaTypeToCType(this._table, this._runtime, gNode, JavaEntities.nameToBaseType("int"), false);
        }
        if ("_newJavaString".equals(string)) {
            boolean bl;
            if (!this._cAnalyzer.assrt(gNode2, 1 == gNode2.size(), "invalid call to builtin function: `String _newJavaString(cArray)", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            object = (Type)list.get(0);
            boolean bl2 = bl = Utilities.isPtrChar((Type)object) || Utilities.isPtrTypedef((Type)object, "`char") || Utilities.isPtrTypedef((Type)object, "jbyte");
            if (!this._cAnalyzer.assrt(gNode2.getGeneric(0), bl, "expected pointer to char, `byte, or `char", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            return Utilities.pureCType(this._table, this._runtime, JavaEntities.tString(this._table));
        }
        if ("_stringUTFLength".equals(string)) {
            if (!this._cAnalyzer.assrt(gNode2, 1 == gNode2.size() || 3 == gNode2.size(), "invalid call to builtin function: `int _stringUTFLength(jstring [, jStart, jLen])", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            object = Utilities.pureCType(this._table, this._runtime, (Type)list.get(0));
            if (!this._cAnalyzer.assrt(gNode2.getGeneric(0), Utilities.hasTypedefName((Type)object, "jstring"), "expected `String", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            if (3 == gNode2.size()) {
                this._cAnalyzer.ensureInteger(gNode2.getNode(1), (Type)list.get(1));
                this._cAnalyzer.ensureInteger(gNode2.getNode(2), (Type)list.get(2));
            }
            return Utilities.javaTypeToCType(this._table, this._runtime, gNode, JavaEntities.nameToBaseType("int"), false);
        }
        throw new Error("builtin " + string + " not yet implemented");
    }

    private JeannieCAnalyzer.JeannieCContext savedContextC() {
        return (JeannieCAnalyzer.JeannieCContext)this._stack.peek()._savedContext;
    }

    private JavaAnalyzer.JavaContext savedContextJ() {
        return (JavaAnalyzer.JavaContext)this._stack.peek()._savedContext;
    }

    public final Object visit(Node node) {
        return this.activeAnalyzer().dispatch(node);
    }

    private void assrtCorrectArrayConversion(GNode gNode, Type type2, GNode gNode2, Type type3) {
        if (type2.isError() || type3.isError()) {
            return;
        }
        Type type4 = Utilities.c().pointerize(type2);
        if (!this._cAnalyzer.assrt(gNode, type4.isPointer(), "pointer or array type expected", new Object[0])) {
            return;
        }
        Type type5 = ((PointerT)type4).getType();
        assert (!type5.isError());
        Type type6 = Utilities.cTypeToJavaType(this._table, this._runtime, gNode2, type3);
        assert (!type6.isError() && JavaEntities.isGeneralRValueT(type6));
        if (type6.isArray()) {
            Type type7 = JavaEntities.resolveToRawRValue(JavaEntities.arrayElementType(type6.toArray()));
            if (JavaEntities.isPrimitiveT(type7)) {
                String string = "j" + JavaEntities.baseTypeToName(type7);
                this._cAnalyzer.assrt(gNode, Utilities.hasTypedefName(type5, string), "type '%s*' expected", string);
            } else {
                Type type8 = Utilities.cTypeToJavaType(this._table, this._runtime, gNode, type5);
                boolean bl = JavaTypeConverter.isAssignable(this._table, JavaEntities.classpath(this._runtime), type8, type7);
                this._cAnalyzer.assrt(gNode, bl, "type 'jobject*' expected", new Object[0]);
            }
        } else if (JavaTypeConverter.isIdentical(type6, JavaEntities.tString(this._table))) {
            boolean bl = Utilities.hasTypedefName(type5, "jchar");
            this._cAnalyzer.assrt(gNode, bl || Utilities.hasTypedefName(type5, "jbyte"), "type 'jchar*' or 'jbyte*' expected", new Object[0]);
        } else {
            this._cAnalyzer.assrt(gNode2, false, "string or primitive array expected", new Object[0]);
        }
    }

    public final void visitCompilationUnit(GNode gNode) {
        assert (null == this.activeAnalyzer());
        this.enterJava();
        this.activeAnalyzer().dispatch(gNode);
        this.exitJava();
    }

    public final void visitTranslationUnit(GNode gNode) {
        assert (null == this.activeAnalyzer());
        this.enterC();
        this.activeAnalyzer().dispatch(gNode);
        this.exitC();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JeannieJavaAnalyzer
    extends JavaAnalyzer {
        final Analyzer _jeannieAnalyzer;

        JeannieJavaAnalyzer(Analyzer analyzer) {
            super(analyzer._runtime, analyzer._table);
            this._jeannieAnalyzer = analyzer;
        }

        @Override
        protected void assrtLegalMethodBody(GNode gNode, Type type2) {
            Type type3;
            boolean bl = JavaAnalyzer.hasModifier(type2, "abstract");
            this.assrt(gNode, bl == (null == gNode.get(7)), "methods should be abstract iff they have no body", new Object[0]);
            if (null != gNode.get(7)) {
                boolean bl2 = JavaAnalyzer.hasModifier(type2, "native");
                this.assrt(gNode, bl2 == gNode.getGeneric(7).hasName("CInJavaBlock"), "methods should be native iff their body is in C", new Object[0]);
            }
            if (null == (type3 = (Type)this._table.root().lookup("JNIEnv"))) {
                this._runtime.error("C typedef for 'JNIEnv' missing; did you forget to #include <jni.h>?", gNode);
            } else if (null != this._table.current().lookupLocally("env")) {
                this._runtime.error("formal parameter declaration of 'env' conflicts with implicit JNIEnv pointer");
            } else {
                Type type4 = new PointerT(type3).attribute(Constants.ATT_CONSTANT);
                VariableT variableT = VariableT.newParam(type4, "env");
                DynamicReference dynamicReference = new DynamicReference("env", type4);
                Type type5 = Utilities.c().qualify(type4, variableT).annotate().shape(dynamicReference);
                this._table.current().define("env", type5);
                type5.scope(this._table.current().getQualifiedName());
            }
        }

        public final void visitCDeclarations(GNode gNode) {
            this._jeannieAnalyzer.enterC();
            assert (this._table.current().isRoot());
            for (int i = 0; i < gNode.size(); ++i) {
                this._jeannieAnalyzer.dispatch(gNode.getNode(i));
            }
            this._jeannieAnalyzer.exitC();
        }

        public final void visitCInJavaBlock(GNode gNode) {
            this._jeannieAnalyzer.enterC();
            for (int i = 0; i < gNode.size(); ++i) {
                this._jeannieAnalyzer.dispatch(gNode.getNode(i));
            }
            this._jeannieAnalyzer.exitC();
        }

        public final Type visitCInJavaExpression(GNode gNode) {
            this._jeannieAnalyzer.enterC();
            Type type2 = (Type)this._jeannieAnalyzer.dispatch(gNode.getNode(0));
            this._jeannieAnalyzer.exitC();
            Type type3 = Utilities.cTypeToJavaType(this._table, this._runtime, gNode, type2);
            return JavaAnalyzer.setType(gNode, type3);
        }

        @Override
        public final void visitCompilationUnit(GNode gNode) {
            if (null == gNode.get(0)) {
                this.visitPackageDeclaration(null);
            } else {
                this.dispatch(gNode.getNode(0));
            }
            this._table.enter(JavaEntities.fileNameToScopeName(gNode.getLocation().file));
            this._table.mark(gNode);
            for (Object object : gNode.getGeneric(1)) {
                this._externalAnalyzer.dispatch((Node)object);
            }
            for (int i = 3; i < gNode.size(); ++i) {
                this._externalAnalyzer.dispatch(gNode.getNode(i));
            }
            this.dispatch(gNode.getNode(1));
            String string = JavaEntities.enterScopeByQualifiedName(this._table, "");
            this.dispatch(gNode.getNode(1));
            this.dispatch(gNode.getNode(2));
            JavaEntities.enterScopeByQualifiedName(this._table, string);
            for (int i = 3; i < gNode.size(); ++i) {
                this.dispatch(gNode.getNode(i));
            }
            this._table.setScope(this._table.root());
        }

        public final List<Type> visitJavaImports(GNode gNode) {
            ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
            for (Object object : gNode) {
                arrayList.add((Type)this.dispatch((Node)object));
            }
            return arrayList;
        }

        public final Type visitJavaInJavaBlock(GNode gNode) {
            return super.visitBlock(gNode);
        }

        public final List<Type> visitJavaThrows(GNode gNode) {
            this._context._handledExceptions = null == gNode || null == gNode.get(0) ? new ArrayList<Type>() : JavaEntities.typeList((List)this._externalAnalyzer.dispatch(gNode.getNode(0)));
            this.assrtLegalHandledExceptions(gNode.getGeneric(0));
            return this._context._handledExceptions;
        }

        @Override
        public final Type visitMethodDeclaration(GNode gNode) {
            assert (!this._jeannieAnalyzer._cAnalyzer._localsAreLifted);
            this._jeannieAnalyzer._cAnalyzer._localsAreLifted = Utilities.containsJavaToCTransition(gNode);
            Type type2 = super.visitMethodDeclaration(gNode);
            this._jeannieAnalyzer._cAnalyzer._localsAreLifted = false;
            return type2;
        }

        @Override
        public final Type visitPrimaryIdentifier(GNode gNode) {
            String string = gNode.getString(0);
            Type type2 = (Type)this._table.lookup(string);
            if (null != type2 && !type2.hasError() && !Utilities.isJavaEntity(type2)) {
                this._runtime.error("cannot use C entity '" + string + "' in Java context", gNode);
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            return super.visitPrimaryIdentifier(gNode);
        }

        @Override
        public final void visitReturnStatement(GNode gNode) {
            Type type2;
            Type type3 = Utilities.currentFunctionOrMethod(this._table);
            if (type3.isMethod()) {
                super.visitReturnStatement(gNode);
                return;
            }
            Type type4 = null;
            if (null != gNode.get(0)) {
                type2 = this._jeannieAnalyzer.dispatchRValue(gNode.getGeneric(0));
                type4 = Utilities.javaTypeToCType(this._table, this._runtime, gNode, type2, false);
            }
            if ((type2 = Utilities.returnType(type3)).resolve().isVoid()) {
                if (null != type4) {
                    this._runtime.error("'return' with a value, in function returning void", gNode);
                }
            } else if (null != type4) {
                this._jeannieAnalyzer._cAnalyzer.processAssignment(false, "return", gNode, type2, type4);
            } else {
                this._runtime.error("'return' with no value, in function returning non-void", gNode);
            }
        }
    }

    private static final class JeannieContext {
        final Visitor _analyzer;
        final Object _savedContext;

        JeannieContext(Visitor visitor, Object object) {
            this._analyzer = visitor;
            this._savedContext = object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JeannieCAnalyzer
    extends CAnalyzer {
        final Analyzer _jeannieAnalyzer;
        boolean _localsAreLifted;
        final List<Type> _openArrays;

        protected static GNode getDeclaredExceptions(GNode gNode) {
            Visitor visitor = new Visitor(){

                public final Object visit(GNode gNode) {
                    return null;
                }

                public final Object visitArrayDeclarator(GNode gNode) {
                    return this.dispatch(gNode.getGeneric(0));
                }

                public final Object visitAttributedDeclarator(GNode gNode) {
                    return this.dispatch(gNode.getGeneric(1));
                }

                public final Object visitFunctionDeclarator(GNode gNode) {
                    GNode gNode2 = gNode.getGeneric(2);
                    assert (null == gNode2 || gNode2.hasName("JavaThrows"));
                    return gNode2;
                }

                public final Object visitPointerDeclarator(GNode gNode) {
                    return this.dispatch(gNode.getGeneric(1));
                }
            };
            return GNode.cast(visitor.dispatch(gNode));
        }

        JeannieCAnalyzer(Analyzer analyzer) {
            super(new JeannieC(), null == analyzer ? Utilities.newRuntime() : analyzer._runtime);
            this._jeannieAnalyzer = analyzer;
            this._openArrays = new ArrayList<Type>();
            this.table = null == analyzer ? null : analyzer._table;
            this.isTopLevel = true;
            this._localsAreLifted = false;
            this.loops.clear();
            this.switches.clear();
        }

        protected boolean assrt(GNode gNode, boolean bl, String string, Object ... objectArray) {
            return JavaEntities.runtimeAssrt(this.runtime, gNode, bl, string, objectArray);
        }

        final void assrtOpenArray(GNode gNode, Type type2) {
            if (type2.hasShape()) {
                Reference reference = type2.getShape();
                for (int i = this._openArrays.size() - 1; i >= 0; --i) {
                    Reference reference2;
                    Type type3 = this._openArrays.get(i);
                    if (!type3.hasShape() || reference != (reference2 = type3.getShape())) continue;
                    if (i != this._openArrays.size() - 1) {
                        this.runtime.error("_with statement for '" + gNode.getGeneric(0).getString(0) + "' not immediately enclosing", gNode);
                    }
                    return;
                }
            }
            this.runtime.error("no enclosing _with statement for '" + gNode.getGeneric(0).getString(0) + "'", gNode);
        }

        final void contextRestore(JeannieCContext jeannieCContext) {
            int n;
            this.hasScope = jeannieCContext._hasScope;
            this.isTopLevel = jeannieCContext._isTopLevel;
            this._localsAreLifted = jeannieCContext._localsAreLifted;
            assert (this._openArrays.size() >= jeannieCContext._openArrays.size());
            while (this._openArrays.size() > jeannieCContext._openArrays.size()) {
                this._openArrays.remove(this.loops.size() - 1);
            }
            for (n = 0; n < this._openArrays.size(); ++n) {
                assert (this._openArrays.get(n) == jeannieCContext._openArrays.get(n));
            }
            assert (this.loops.size() >= jeannieCContext._loops);
            while (this.loops.size() > jeannieCContext._loops) {
                this.loops.remove(this.loops.size() - 1);
            }
            for (n = 0; n < jeannieCContext._loops; ++n) {
                assert (((Boolean)this.loops.get(n)).booleanValue());
            }
            assert (this.switches.size() >= jeannieCContext._switches.size());
            while (this.switches.size() > jeannieCContext._switches.size()) {
                this.switches.remove(this.switches.size() - 1);
            }
            for (n = 0; n < this.switches.size(); ++n) {
                assert (((Boolean)this.switches.get(n)).booleanValue() == jeannieCContext._switches.get(n).booleanValue());
            }
        }

        final JeannieCContext contextSave() {
            JeannieCContext jeannieCContext = new JeannieCContext();
            jeannieCContext._hasScope = this.hasScope;
            jeannieCContext._isTopLevel = this.isTopLevel;
            jeannieCContext._localsAreLifted = this._localsAreLifted;
            jeannieCContext._loops = this.loops.size();
            jeannieCContext._openArrays = new ArrayList<Type>(this._openArrays.size());
            for (Type object : this._openArrays) {
                jeannieCContext._openArrays.add(object);
            }
            jeannieCContext._switches = new ArrayList<Boolean>(this.switches.size());
            for (Boolean bl : this.switches) {
                jeannieCContext._switches.add(bl);
            }
            return jeannieCContext;
        }

        final boolean getHasScope() {
            return this.hasScope;
        }

        final List<Boolean> getLoops() {
            return this.loops;
        }

        final Runtime getRuntime() {
            return this.runtime;
        }

        final List<Boolean> getSwitches() {
            return this.switches;
        }

        final SymbolTable getTable() {
            return this.table;
        }

        @Override
        public final CAnalyzer.Specifiers newSpecifiers(GNode gNode, boolean bl) {
            return new JeannieCSpecifiers(gNode, bl);
        }

        @Override
        protected final Type processAssignment(boolean bl, String string, Node node, Type type2, Type type3) {
            Type type4 = Utilities.getJavaClassOrInterfaceT(type2);
            if (JavaEntities.isWrappedClassT(type4) || JavaEntities.isWrappedInterfaceT(type4)) {
                Type type5 = Utilities.cTypeToJavaType(this.table, this.runtime, node, type3);
                if (type5.isError()) {
                    return ErrorT.TYPE;
                }
                List<File> list = JavaEntities.classpath(this.runtime);
                if (JavaTypeConverter.isAssignable(this.table, list, type4, type5)) {
                    return type4;
                }
                this.runtime.error("illegal C assignment to Java type '" + JavaEntities.javaTypeToString(this.table, type4) + "'", node);
                return ErrorT.TYPE;
            }
            Type type6 = Utilities.getJavaClassOrInterfaceT(type3);
            if (JavaEntities.isWrappedClassT(type6) || JavaEntities.isWrappedInterfaceT(type6)) {
                type6 = Utilities.javaTypeToCType(this.table, this.runtime, node, type6, false);
            }
            return super.processAssignment(bl, string, node, type2, type6);
        }

        @Override
        protected final void processParameters(GNode gNode, FunctionT functionT) {
            functionT.setExceptions(this._jeannieAnalyzer._jAnalyzer._context._handledExceptions);
            super.processParameters(gNode, functionT);
        }

        final void setHasScope(boolean bl) {
            this.hasScope = bl;
        }

        final void setIsTopLevel(boolean bl) {
            this.isTopLevel = bl;
        }

        public final void visitCancelStatement(GNode gNode) {
            Type type2 = (Type)this._jeannieAnalyzer.dispatch(gNode.getGeneric(0));
            this.assrtOpenArray(gNode, type2);
        }

        public final Type visitCInCBlock(GNode gNode) {
            return super.visitCompoundStatement(gNode);
        }

        public final void visitCommitStatement(GNode gNode) {
            Type type2 = (Type)this._jeannieAnalyzer.dispatch(gNode.getGeneric(0));
            this.assrtOpenArray(gNode, type2);
        }

        @Override
        public final void visitDeclaration(GNode gNode) {
            super.visitDeclaration(gNode);
            if (this._localsAreLifted) {
                MiniVisitor_liftableDeclaration miniVisitor_liftableDeclaration = new MiniVisitor_liftableDeclaration();
                boolean bl = (Boolean)miniVisitor_liftableDeclaration.dispatch(gNode);
                this.assrt(gNode, bl, "compound initializer with variable-sized array", new Object[0]);
            }
        }

        @Override
        public final Type visitFunctionCall(GNode gNode) {
            Object object;
            Iterable<Object> iterable;
            GNode gNode2 = gNode.getGeneric(0);
            if (gNode2.hasName("PrimaryIdentifier") && BUILTINS.contains(gNode2.getString(0))) {
                return JavaAnalyzer.setType(gNode, this._jeannieAnalyzer.processBuiltin(gNode));
            }
            Type type2 = super.visitFunctionCall(gNode);
            FunctionOrMethodT functionOrMethodT = null;
            Iterable<Object> iterable2 = gNode2.hasName("PrimaryIdentifier") ? (Type)this.table.lookup(gNode2.getString(0)) : (Type)gNode2.getProperty("xtc.Constants.Type");
            if (null != iterable2 && !(iterable = Utilities.c().pointerize((Type)iterable2)).isError() && iterable.isPointer() && ((Type)(object = ((PointerT)iterable).getType().resolve())).isFunction()) {
                functionOrMethodT = (FunctionT)object;
            }
            if (null != functionOrMethodT && null != (iterable2 = functionOrMethodT.getExceptions())) {
                iterable = JavaEntities.classpath(this.runtime);
                for (Type type3 : iterable2) {
                    if (!JavaEntities.isCheckedException(this.table, (List<File>)iterable, type3) || this._jeannieAnalyzer._jAnalyzer.isHandled(type3)) continue;
                    this.runtime.error("uncaught exception", gNode);
                }
            }
            return type2;
        }

        public final void visitFunctionDeclarator(GNode gNode) {
            assert (false);
        }

        @Override
        public final void visitFunctionDefinition(GNode gNode) {
            GNode gNode2 = JeannieCAnalyzer.getDeclaredExceptions(gNode.getGeneric(2));
            this._jeannieAnalyzer.enterJava();
            this._jeannieAnalyzer.dispatch(gNode2);
            this._jeannieAnalyzer.enterC();
            assert (!this._localsAreLifted);
            this._localsAreLifted = Utilities.containsCToJavaTransition(gNode);
            super.visitFunctionDefinition(gNode);
            this._localsAreLifted = false;
            String string = SymbolTable.fromNameSpace(xtc.util.Utilities.unqualify((String)gNode.getProperty("xtc.Constants.Scope")));
            FunctionT functionT = ((Type)this.table.current().lookupLocally(string)).resolve().toFunction();
            this._jeannieAnalyzer.exitC();
            this._jeannieAnalyzer.exitJava();
            if (Utilities.containsCToJavaTransition(gNode)) {
                VariableT variableT = null;
                for (Type type2 : functionT.getParameters()) {
                    if (!"env".equals(type2.toVariable().getName())) continue;
                    variableT = type2.toVariable();
                    break;
                }
                if (this.assrt(gNode, null != variableT, "C function %s contains Java snippet but lacks explicit formal JNIEnv* env", string)) {
                    this.assrt(gNode, variableT.getType().isPointer() && Utilities.hasTypedefName(variableT.getType().toPointer().getType(), "JNIEnv"), "expected formal env to be of type JNIEnv", new Object[0]);
                }
            }
            JavaAnalyzer.setType(gNode, functionT);
        }

        public final void visitJavaImports(GNode gNode) {
            this._jeannieAnalyzer.enterJava();
            this._jeannieAnalyzer.dispatch(gNode.getGeneric(0));
            this._jeannieAnalyzer.exitJava();
        }

        public final void visitJavaInCBlock(GNode gNode) {
            this._jeannieAnalyzer.enterJava();
            this._jeannieAnalyzer.dispatch(gNode.getGeneric(0));
            this._jeannieAnalyzer.exitJava();
        }

        public final Type visitJavaInCExpression(GNode gNode) {
            this._jeannieAnalyzer.enterJava();
            Type type2 = this._jeannieAnalyzer.dispatchRValue(gNode.getGeneric(0));
            this._jeannieAnalyzer.exitJava();
            Type type3 = Utilities.javaTypeToCType(this.table, this.runtime, gNode, type2, true);
            return JavaAnalyzer.setType(gNode, type3);
        }

        public final void visitJavaInCStatement(GNode gNode) {
            this._jeannieAnalyzer.enterJava();
            this._jeannieAnalyzer.dispatch(gNode.getNode(0));
            this._jeannieAnalyzer.exitJava();
        }

        public final void visitJavaThrows(GNode gNode) {
            assert (false);
        }

        @Override
        public final Type visitPrimaryIdentifier(GNode gNode) {
            String string = gNode.getString(0);
            Type type2 = (Type)this.table.lookup(string);
            if (null == type2) {
                this.runtime.error("'" + string + "' undeclared", gNode);
                type2 = ErrorT.TYPE;
            } else if (Utilities.isJavaEntity(type2)) {
                this.runtime.error("cannot use Java entity '" + string + "' in C context", gNode);
                type2 = ErrorT.TYPE;
            }
            this.mark(gNode, type2);
            return type2;
        }

        @Override
        public final Type visitReturnStatement(GNode gNode) {
            Type type2 = Utilities.currentFunctionOrMethod(this.table);
            if (!type2.isMethod()) {
                return super.visitReturnStatement(gNode);
            }
            Type type3 = (Type)this._jeannieAnalyzer.dispatch(gNode.getNode(0));
            Type type4 = type2.toMethod().getResult();
            if (type4.isVoid()) {
                if (null != type3) {
                    this.runtime.error("'return' with a value, in method returning void", gNode);
                }
            } else if (null == type3) {
                this.runtime.error("'return' with no value, in method returning non-void", gNode);
            } else {
                Type type5 = Utilities.cTypeToJavaType(this.table, this.runtime, gNode, type3);
                this.assrt(gNode, JavaTypeConverter.isAssignable(this.table, JavaEntities.classpath(this.runtime), type4, type5), "return type mismatch", new Object[0]);
            }
            return JavaAnalyzer.setType(gNode, type4);
        }

        @Override
        public final void visitTranslationUnit(GNode gNode) {
            super.visitTranslationUnit(gNode);
        }

        public final void visitWithStatement(GNode gNode) {
            Type type2;
            Type type3;
            GNode gNode2;
            GNode gNode3;
            GNode gNode4;
            boolean bl = this.hasScope;
            this.hasScope = false;
            this.table.enter(this.table.freshName("withStatement"));
            this.table.mark(gNode);
            GNode gNode5 = gNode.getGeneric(0);
            if (gNode5.hasName("Declaration")) {
                gNode4 = gNode5.getGeneric(2);
                if (this.assrt(gNode, null != gNode4 && 1 == gNode4.size(), "expected exactly one initializer", new Object[0])) {
                    GNode gNode6 = gNode4.getGeneric(0);
                    gNode3 = gNode6.getGeneric(1);
                    gNode2 = gNode6.getGeneric(4);
                    gNode6.set(4, null);
                    this._jeannieAnalyzer.dispatch(gNode5);
                    gNode6.set(4, gNode2);
                    String string = CAnalyzer.getDeclaredId(gNode3).getString(0);
                    type3 = (Type)this.table.current().lookupLocally(string);
                    type2 = this.assrt(gNode2, null != gNode2, "initializer expected", new Object[0]) ? (Type)this._jeannieAnalyzer.dispatch(gNode2) : ErrorT.TYPE;
                } else {
                    type3 = type2 = ErrorT.TYPE;
                    gNode2 = null;
                    gNode3 = null;
                }
            } else {
                Type type4;
                assert (gNode5.hasName("AssignmentExpression"));
                gNode3 = gNode5.getGeneric(0);
                gNode2 = gNode5.getGeneric(2);
                gNode4 = gNode3;
                type3 = this.assrt(gNode4, gNode4.hasName("PrimaryIdentifier"), "primary identifier expected", new Object[0]) ? (this.ensureLValue(gNode4, type4 = (Type)this._jeannieAnalyzer.dispatch(gNode4)) ? type4 : ErrorT.TYPE) : ErrorT.TYPE;
                this.assrt(gNode, "=".equals(gNode5.getString(1)), "expected operator '=', not %s", gNode5.getString(1));
                type2 = (Type)this._jeannieAnalyzer.dispatch(gNode2);
            }
            this.mark(gNode5, type3);
            this._jeannieAnalyzer.assrtCorrectArrayConversion(gNode3, type3, gNode2, type2);
            int n = this._openArrays.size();
            this._openArrays.add(type3);
            this._jeannieAnalyzer.dispatch(gNode.getNode(1));
            assert (n + 1 == this._openArrays.size());
            this._openArrays.remove(n);
            this.table.exit(gNode);
            this.hasScope = bl;
        }

        static class MiniVisitor_liftableDeclaration
        extends Visitor {
            private boolean _hasCompoundInitializer = false;
            private boolean _hasVariableArray = false;

            MiniVisitor_liftableDeclaration() {
            }

            public final Boolean visit(Node node) {
                for (Object object : node) {
                    if (!(object instanceof Node)) continue;
                    this.dispatch((Node)object);
                    if (!this._hasCompoundInitializer || !this._hasVariableArray) continue;
                    return false;
                }
                return true;
            }

            public final Boolean visitInitializerList(GNode gNode) {
                this._hasCompoundInitializer = true;
                if (this._hasVariableArray) {
                    return false;
                }
                return this.visit(gNode);
            }

            public final Boolean visitArrayDeclarator(GNode gNode) {
                if (gNode.getGeneric(2).hasName("VariableLength")) {
                    this._hasVariableArray = true;
                }
                if (this._hasCompoundInitializer) {
                    return false;
                }
                return this.visit(gNode);
            }
        }

        final class JeannieCSpecifiers
        extends CAnalyzer.Specifiers {
            public JeannieCSpecifiers(GNode gNode, boolean bl) {
                super(gNode, bl);
            }

            public final void visitJavaType(GNode gNode) {
                Type type2;
                if (this.hasType()) {
                    this.multipleTypes();
                    return;
                }
                JeannieCAnalyzer.this._jeannieAnalyzer.enterJava();
                SymbolTable symbolTable = JeannieCAnalyzer.this.getTable();
                if (gNode.getNode(0).hasName("QualifiedIdentifier")) {
                    String string = (String)JeannieCAnalyzer.this._jeannieAnalyzer.dispatch(gNode.getNode(0));
                    List<File> list = JavaEntities.classpath(JeannieCAnalyzer.this.getRuntime());
                    type2 = JavaEntities.qualifiedNameToType(symbolTable, list, symbolTable.current().getQualifiedName(), string);
                } else {
                    assert (gNode.getNode(0).hasName("PrimitiveType"));
                    Type type3 = (Type)JeannieCAnalyzer.this._jeannieAnalyzer.dispatch(gNode.getNode(0));
                    type2 = Utilities.javaTypeToCType(symbolTable, JeannieCAnalyzer.this.runtime, gNode, type3, true);
                }
                JeannieCAnalyzer.this._jeannieAnalyzer.exitJava();
                this.type = JavaAnalyzer.setType(gNode, type2);
            }
        }

        static final class JeannieCContext {
            boolean _hasScope;
            boolean _isTopLevel;
            boolean _localsAreLifted;
            int _loops;
            List<Type> _openArrays;
            List<Boolean> _switches;

            JeannieCContext() {
            }
        }

        private static final class JeannieC
        extends C {
            private JeannieC() {
            }

            public final boolean isConstant(Type type2) {
                if (Utilities.isJavaEntity(type2)) {
                    return JavaEntities.isConstantT(type2);
                }
                if (type2.hasAttribute(Constants.ATT_CONSTANT, false)) {
                    return true;
                }
                switch (type2.tag()) {
                    case ARRAY: {
                        Type type3 = type2.resolve().toArray().getType();
                        return null == type3 ? false : this.isConstant(type3);
                    }
                    case STRUCT: 
                    case UNION: {
                        for (Type type4 : type2.toTagged().getMembers()) {
                            if (!this.isConstant(type4)) continue;
                            return true;
                        }
                        return false;
                    }
                }
                return type2.isWrapped() ? this.isConstant(type2.toWrapped().getType()) : false;
            }
        }
    }
}

