/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4.util;

import java.util.List;
import xtc.lang.c4.C4CFactory;
import xtc.lang.c4.util.C4Binding;
import xtc.lang.c4.util.C4CFactoryWrapper;
import xtc.lang.c4.util.C4LookAheadVisitor;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Token;
import xtc.tree.Visitor;

public class C4NameMangler
extends Visitor {
    private boolean debug = false;
    private C4Binding bindings = null;
    private C4CFactory cFactory = null;
    private C4LookAheadVisitor lookAhead = null;

    public C4NameMangler(boolean bl, C4Binding c4Binding) {
        this.debug = bl;
        this.bindings = c4Binding;
        this.cFactory = C4CFactoryWrapper.getInstance();
        this.lookAhead = new C4LookAheadVisitor();
    }

    public Node visitExpressionStatement(GNode gNode) {
        Node node = (Node)new ExpressionVisitor().dispatch(gNode);
        return node;
    }

    public Node visitDeclaration(GNode gNode) {
        if (this.lookAhead.hasChild(gNode, "StructureTypeReference")) {
            return (Node)new StructureTypeReferenceVisitor().dispatch(gNode);
        }
        return gNode;
    }

    public Node visitPrimaryIdentifier(GNode gNode) {
        String string = Token.cast(gNode.get(0));
        if (this.bindings.isDefined(string)) {
            String string2 = this.bindings.getMangledDeclarator(string);
            if (this.debug) {
                System.err.printf("Replacing %s with %s", string, string2);
            }
            gNode.set(0, string2);
        }
        return gNode;
    }

    public Node visit(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof Node)) continue;
            if (this.debug) {
                System.err.println("C4NameManger - Mangling: " + ((Node)object).getName());
            }
            node.set(i, this.dispatch((Node)object));
        }
        return node;
    }

    class ExpressionVisitor
    extends Visitor {
        ExpressionVisitor() {
        }

        public Node visitPrimaryIdentifier(GNode gNode) {
            String string = Token.cast(gNode.get(0));
            if (C4NameMangler.this.bindings.isDefined(string)) {
                String string2 = C4NameMangler.this.bindings.getMangledDeclarator(string);
                if (C4NameMangler.this.debug) {
                    System.err.printf("Replacing %s with %s", string, string2);
                }
                gNode.set(0, string2);
            }
            return gNode;
        }

        public Node visitDirectComponentSelection(GNode gNode) {
            return (Node)new StructureComponentSelectionVisitor().dispatch(gNode);
        }

        public Node visitIndirectComponentSelection(GNode gNode) {
            return (Node)new StructureComponentSelectionVisitor().dispatch(gNode);
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }
    }

    class StructureComponentSelectionVisitor
    extends Visitor {
        private int componentLevel = 0;
        private String fieldName = "";
        private boolean isDirect = false;

        StructureComponentSelectionVisitor() {
        }

        public Node visitDirectComponentSelection(GNode gNode) {
            ++this.componentLevel;
            this.isDirect = true;
            this.fieldName = Token.cast(gNode.get(1));
            for (int i = 0; i < gNode.size(); ++i) {
                Object object = gNode.get(i);
                if (!(object instanceof Node)) continue;
                gNode.set(i, this.dispatch((Node)object));
            }
            return gNode;
        }

        public Node visitIndirectComponentSelection(GNode gNode) {
            ++this.componentLevel;
            this.isDirect = false;
            this.fieldName = Token.cast(gNode.get(1));
            for (int i = 0; i < gNode.size(); ++i) {
                Object object = gNode.get(i);
                if (!(object instanceof Node)) continue;
                Node node = (Node)object;
                gNode.set(i, this.dispatch(node));
                if (!node.hasName("PrimaryIdentifier")) continue;
                String string = Token.cast(node.get(0));
                String string2 = Token.cast(gNode.get(1));
                List<String> list = C4NameMangler.this.bindings.getStructInstFields(string);
                if (null == list || !list.contains(string2)) continue;
                if (C4NameMangler.this.debug) {
                    System.err.printf("C4NameManger: Trying to access a field, %s, that was introduced by an advice.\n", string2);
                }
                GNode gNode2 = GNode.cast(C4NameMangler.this.cFactory.createIndirectStructFieldAccess(node, C4NameMangler.this.bindings.getAspectName()).get(0));
                GNode gNode3 = GNode.cast(C4NameMangler.this.cFactory.createDirectStructFieldAccess(gNode2, string2).get(0));
                return gNode3;
            }
            return gNode;
        }

        public Node visitPrimaryIdentifier(GNode gNode) {
            String string = Token.cast(gNode.get(0));
            List<String> list = C4NameMangler.this.bindings.getStructInstFields(string);
            if (C4NameMangler.this.bindings.isDefined(string)) {
                gNode.set(0, C4NameMangler.this.bindings.getMangledDeclarator(string));
            } else if (null != list && list.contains(this.fieldName) && this.isDirect) {
                GNode gNode2 = GNode.cast(C4NameMangler.this.cFactory.createDirectStructFieldAccess(gNode, C4NameMangler.this.bindings.getAspectName()).get(0));
                return gNode2;
            }
            return gNode;
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }
    }

    class StructureTypeReferenceVisitor
    extends Visitor {
        List<String> fields = null;

        StructureTypeReferenceVisitor() {
        }

        public Node visitStructureTypeReference(GNode gNode) {
            String string = Token.cast(gNode.get(1));
            if (C4NameMangler.this.bindings.isStructType(string)) {
                this.fields = C4NameMangler.this.bindings.getStructTypeFields(string);
            } else if (C4NameMangler.this.bindings.isDefined(string)) {
                gNode.set(1, C4NameMangler.this.bindings.getMangledDeclarator(string));
            }
            return gNode;
        }

        public Node visitSimpleDeclarator(GNode gNode) {
            if (null != this.fields) {
                String string = Token.cast(gNode.get(0));
                if (C4NameMangler.this.debug) {
                    System.err.printf("C4NameManger - adding new structure instance %s ...", string);
                }
                C4NameMangler.this.bindings.addStructInstBinding(string, this.fields);
            }
            return gNode;
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }
    }
}

