/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4.transformer;

import java.util.ArrayList;
import java.util.List;
import xtc.lang.c4.advice.C4StructureIntroductionAdvice;
import xtc.lang.c4.transformer.IC4Transformer;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Token;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C4AspectStructureTransformer
extends Visitor
implements IC4Transformer {
    private GNode node = null;
    private boolean debug = false;
    private boolean isType = false;
    private String structureTagName = null;
    private List<C4StructureIntroductionAdvice> structIntroAdviceList = null;
    private List<String> declarators = null;

    public C4AspectStructureTransformer(GNode gNode, boolean bl) {
        assert (gNode.hasName("Declaration"));
        this.node = gNode;
        this.debug = bl;
        this.isType = false;
        this.structIntroAdviceList = new ArrayList<C4StructureIntroductionAdvice>();
        this.declarators = new ArrayList<String>();
    }

    public Node visit(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof Node)) continue;
            node.set(i, this.dispatch((Node)object));
        }
        return node;
    }

    public Node visitStructureAdviceDeclaration(GNode gNode) {
        C4StructureIntroductionAdvice c4StructureIntroductionAdvice = new C4StructureIntroductionAdvice(this.debug, gNode, Token.cast(gNode.get(1)));
        this.structIntroAdviceList.add(c4StructureIntroductionAdvice);
        return c4StructureIntroductionAdvice.transform().get(0);
    }

    public Node visitAspectStructureDeclaration(GNode gNode) {
        if (gNode.getGeneric(1).hasName("StructureAdviceDeclaration")) {
            GNode gNode2 = GNode.create("AspectStructureDeclaration", null, this.visitStructureAdviceDeclaration(gNode.getGeneric(1)), null);
            return gNode2;
        }
        return gNode;
    }

    public Node visitSimpleDeclarator(GNode gNode) {
        if (this.debug) {
            System.err.println("C4AspectStructTransformer: Adding declarator " + gNode);
        }
        this.declarators.add(Token.cast(gNode.get(0)));
        return gNode;
    }

    public Node visitTypedefSpecifier(GNode gNode) {
        if (this.debug) {
            System.err.println("Typedef present. Setting flag ...");
        }
        this.isType = true;
        return gNode;
    }

    public Node visitAspectStructureTypeDefinition(GNode gNode) {
        if (gNode.get(1) != null) {
            if (this.debug) {
                System.err.println("C4AspectStructureTransformer: setting tag name to " + Token.cast(gNode.get(1)));
            }
            this.structureTagName = Token.cast(gNode.get(1));
        }
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode.set(i, this.dispatch((Node)object));
        }
        return gNode;
    }

    @Override
    public List<GNode> transform() {
        if (this.debug) {
            System.err.println("Transforming aspect structure ...");
        }
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (int i = 0; i < this.node.size(); ++i) {
            Object object = this.node.get(i);
            if (!(object instanceof Node)) continue;
            this.node.set(i, this.dispatch((Node)object));
        }
        arrayList.add(this.node);
        for (C4StructureIntroductionAdvice c4StructureIntroductionAdvice : this.structIntroAdviceList) {
            List<String> list = c4StructureIntroductionAdvice.getFieldsIntroduced();
            c4StructureIntroductionAdvice.getParentAspect().addStructureIntroFields(list, this.structureTagName, this.declarators, this.isType);
        }
        return arrayList;
    }
}

