/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4.transformer;

import java.util.ArrayList;
import java.util.List;
import xtc.lang.c4.C4CFactory;
import xtc.lang.c4.advice.C4Advice;
import xtc.lang.c4.advice.C4AfterAdvice;
import xtc.lang.c4.advice.C4AroundAdvice;
import xtc.lang.c4.advice.C4BeforeAdvice;
import xtc.lang.c4.transformer.IC4Transformer;
import xtc.lang.c4.util.C4XFormEngine;
import xtc.lang.c4.util.C4XFormQuery;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Token;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C4AspectFunctionTransformer
extends Visitor
implements IC4Transformer {
    private GNode node = null;
    private boolean debug = false;
    private C4XFormEngine xformEngine = null;
    private C4CFactory cFactory = null;
    private String functionName = null;
    private GNode declarator = null;
    private GNode aspectCompoundStatement = null;
    private GNode beginningAdviceStatements = null;
    private GNode endingAdviceStatements = null;
    private GNode aspectFunctionBody = null;
    private GNode declarationSpecifiers = null;
    private List<C4BeforeAdvice> beforeAdvice = null;
    private List<C4AroundAdvice> aroundAdvice = null;
    private boolean isVoidReturnType = false;
    List<String> beforeAdviceAspectNames = null;
    List<String> afterAdviceAspectNames = null;
    List<String> aroundAdviceAspectNames = null;
    private final String returnValVariableName = "__return_val";
    private final String afterAdviceBeginLabel = "__after_advice_begin";

    public C4AspectFunctionTransformer(GNode gNode, boolean bl) {
        assert (gNode.hasName("AspectFunctionDefinition")) : "The incoming node should have the name 'AspectFunctionDefinition'";
        this.node = gNode;
        this.declarationSpecifiers = this.node.getGeneric(1);
        this.declarator = this.node.getGeneric(2);
        this.aspectCompoundStatement = this.node.getGeneric(4);
        this.beginningAdviceStatements = this.aspectCompoundStatement.getGeneric(0);
        this.aspectFunctionBody = this.aspectCompoundStatement.getGeneric(1);
        this.endingAdviceStatements = this.aspectCompoundStatement.getGeneric(2);
        this.cFactory = new C4CFactory();
        this.beforeAdviceAspectNames = new ArrayList<String>();
        this.afterAdviceAspectNames = new ArrayList<String>();
        this.aroundAdviceAspectNames = new ArrayList<String>();
        this.beforeAdvice = new ArrayList<C4BeforeAdvice>();
        this.aroundAdvice = new ArrayList<C4AroundAdvice>();
    }

    private void extractFunctionDetails() {
        List<Object> list = null;
        list = this.xformEngine.run(C4XFormQuery.GetFunctionName, this.declarator);
        assert (list.size() == 1);
        this.functionName = Token.cast(GNode.cast(list.get(0)).get(0));
        System.out.println("Function Name: " + this.functionName);
        assert (null != this.declarationSpecifiers && this.declarationSpecifiers.hasName("DeclarationSpecifiers"));
        GNode gNode = GNode.cast(this.declarationSpecifiers.get(0));
        boolean bl = this.isVoidReturnType = gNode.hasName("VoidTypeSpecifier") && this.declarator.hasName("FunctionDeclarator");
        if (this.debug && this.isVoidReturnType) {
            System.err.println("Function: " + this.functionName + " returns void.");
        }
    }

    private boolean hasAfterAdvice() {
        return !this.endingAdviceStatements.isEmpty();
    }

    private GNode createReturnValueDeclaration() {
        GNode gNode = new ReturnValueVariableCreator().createReturnVariable(this.declarationSpecifiers, this.declarator);
        return gNode;
    }

    private GNode createAfterAdviceLabel() {
        return GNode.cast(this.cFactory.createLabel(this.afterAdviceBeginLabel));
    }

    public Node visitBeforeAdviceStatement(GNode gNode) {
        C4BeforeAdvice c4BeforeAdvice = new C4BeforeAdvice(this.debug, gNode, Token.cast(gNode.get(1)), this.functionName);
        return c4BeforeAdvice.transform().get(0);
    }

    public Node visitAfterAdviceStatement(GNode gNode) {
        C4AfterAdvice c4AfterAdvice = new C4AfterAdvice(this.debug, gNode, Token.cast(gNode.get(1)), this.functionName);
        return c4AfterAdvice.transform().get(0);
    }

    public Node visitBeginningAdviceStatementList(GNode gNode) {
        if (this.debug) {
            System.err.println("Transforming beginning advice statement list ...");
        }
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode.set(i, this.dispatch((Node)object));
        }
        return gNode;
    }

    public Node visitEndingAdviceStatementList(GNode gNode) {
        if (this.debug) {
            System.err.println("Transforming ending advice statement list ...");
        }
        GNode gNode2 = GNode.create("EndingAdviceStatementList");
        if (!gNode.isEmpty()) {
            gNode2.add(this.createAfterAdviceLabel());
        }
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode2.add(this.dispatch((Node)object));
        }
        if (!this.isVoidReturnType) {
            gNode2.add(GNode.cast(this.cFactory.createReturnWithVal(GNode.create("PrimaryIdentifier", "__return_val"))));
        }
        return gNode2;
    }

    public GNode visitAspectFunctionBody(GNode gNode) {
        AspectFunctionBodyTransformer aspectFunctionBodyTransformer = new AspectFunctionBodyTransformer(gNode);
        return aspectFunctionBodyTransformer.transform().get(0);
    }

    public Node visit(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof Node)) continue;
            node.set(i, this.dispatch((Node)object));
        }
        return node;
    }

    public Node visitAspectCompoundStatement(GNode gNode) {
        if (this.hasAfterAdvice() && !this.isVoidReturnType) {
            gNode.add(0, this.createReturnValueDeclaration());
        }
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode.set(i, this.dispatch((Node)object));
        }
        return gNode;
    }

    @Override
    public List<GNode> transform() {
        if (this.debug) {
            System.err.println("Transforming aspect function definition.");
        }
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        DeclaratorVisitor declaratorVisitor = new DeclaratorVisitor();
        declaratorVisitor.dispatch(this.declarator, this.declarationSpecifiers);
        this.functionName = declaratorVisitor.getFunctionName();
        this.isVoidReturnType = declaratorVisitor.isVoid();
        if (this.debug) {
            System.err.println("Function Name: " + this.functionName);
        }
        this.dispatch(this.aspectCompoundStatement);
        arrayList.add(this.node);
        return arrayList;
    }

    public List<GNode> oldTransform() {
        int n;
        String string = null;
        String string2 = null;
        List<GNode> list = null;
        this.extractFunctionDetails();
        if (this.debug) {
            System.err.println("Starting to transform beginning advice statements.");
        }
        for (n = 0; n < this.beginningAdviceStatements.size(); ++n) {
            C4Advice c4Advice;
            GNode gNode = GNode.cast(this.beginningAdviceStatements.get(n));
            string2 = gNode.getName();
            string = gNode.getString(1);
            if (string2.equals("BeforeAdviceStatement")) {
                c4Advice = new C4BeforeAdvice(this.debug, gNode, string, this.functionName);
                this.beforeAdvice.add((C4BeforeAdvice)c4Advice);
                list = ((C4BeforeAdvice)c4Advice).transform();
                this.beginningAdviceStatements.set(n, list.get(0));
                continue;
            }
            if (!string2.equals("AroundAdviceStatement")) continue;
            c4Advice = new C4AroundAdvice(this.debug, gNode, this.aspectFunctionBody, string, this.functionName);
            this.aroundAdvice.add((C4AroundAdvice)c4Advice);
            list = ((C4AroundAdvice)c4Advice).transform();
        }
        for (n = 0; n < this.endingAdviceStatements.size(); ++n) {
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AspectFunctionBodyTransformer
    extends Visitor
    implements IC4Transformer {
        GNode node = null;

        public AspectFunctionBodyTransformer(GNode gNode) {
            assert (gNode.hasName("AspectFunctionBody")) : "The node should have name `AspectFunctionBody'";
            this.node = gNode;
        }

        public Node visitReturnStatement(GNode gNode) {
            if (C4AspectFunctionTransformer.this.hasAfterAdvice()) {
                if (!C4AspectFunctionTransformer.this.isVoidReturnType) {
                    assert (!gNode.isEmpty()) : "Missing return value.";
                    GNode gNode2 = GNode.create("PrimaryIdentifier", "__return_val");
                    GNode gNode3 = GNode.cast(C4AspectFunctionTransformer.this.cFactory.createAfterAdviceReturnReplacement(gNode2, (Node)gNode.get(0), "__after_advice_begin"));
                    return gNode3;
                }
                assert (gNode.isEmpty()) : "There should not be any return value.";
                GNode gNode4 = GNode.cast(C4AspectFunctionTransformer.this.cFactory.createGoto("__after_advice_begin"));
                return gNode4;
            }
            return gNode;
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }

        @Override
        public List<GNode> transform() {
            ArrayList<GNode> arrayList = new ArrayList<GNode>();
            Object object = this.dispatch(this.node);
            assert (GNode.test(object)) : "The return type must be a GNode.";
            arrayList.add(GNode.cast(object));
            return arrayList;
        }
    }

    class ReturnValueVariableCreator
    extends Visitor {
        private GNode declarationSpecifier = null;
        private GNode declarator = null;

        ReturnValueVariableCreator() {
        }

        public GNode visitFunctionDeclarator(GNode gNode) {
            GNode gNode2 = GNode.cast(gNode.get(0));
            assert (gNode2.hasName("SimpleDeclarator")) : "The first child of the function declarator must be a simple declarator. Something has changed! File a bug.";
            return GNode.create("SimpleDeclarator", "__return_val");
        }

        public GNode visitDeclarationSpecifiers(GNode gNode) {
            return this.declarationSpecifier;
        }

        public GNode visitInitializedDeclarator(GNode gNode) {
            gNode.set(1, this.declarator);
            return gNode;
        }

        public GNode createReturnVariable(GNode gNode, GNode gNode2) {
            GNode gNode3 = GNode.cast(C4AspectFunctionTransformer.this.cFactory.createDeclaration("__return_val"));
            this.declarationSpecifier = gNode;
            GNode gNode4 = GNode.create(gNode2);
            this.declarator = GNode.cast(this.dispatch(gNode4));
            gNode3 = GNode.cast(this.dispatch(gNode3));
            return gNode3;
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }
    }

    class DeclaratorVisitor
    extends Visitor {
        private String functionName = null;
        private int pointerCount = 0;
        private boolean isVoid = false;

        DeclaratorVisitor() {
        }

        public Node visitSimpleDeclarator(GNode gNode) {
            this.functionName = Token.cast(gNode.get(0));
            return gNode;
        }

        public Node visitPointer(GNode gNode) {
            ++this.pointerCount;
            this.isVoid = false;
            return gNode;
        }

        public Node visitDeclarationSpecifiers(GNode gNode) {
            for (Object object : gNode) {
                if (!(object instanceof Node) || !((Node)object).hasName("VoidTypeSpecifier")) continue;
                this.isVoid = true;
            }
            return gNode;
        }

        public Node visit(Node node) {
            for (Object object : node) {
                if (!(object instanceof Node)) continue;
                this.dispatch((Node)object);
            }
            return node;
        }

        public Node visitParameterTypeList(GNode gNode) {
            return gNode;
        }

        public void dispatch(Node node, Node node2) {
            this.dispatch(node2);
            this.dispatch(node);
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public int getPointerCount() {
            return this.pointerCount;
        }

        public boolean isVoid() {
            return this.isVoid;
        }
    }
}

