/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4.advice;

import java.util.ArrayList;
import java.util.List;
import xtc.lang.c4.advice.C4Advice;
import xtc.lang.c4.advice.C4AdviceType;
import xtc.lang.c4.util.C4XFormQuery;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Token;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C4GlobalIntroAdvice
extends C4Advice {
    public C4GlobalIntroAdvice(boolean bl, GNode gNode, String string) {
        super(bl);
        this.adviceType = C4AdviceType.GLOBAL;
        this.node = gNode;
        this.debugMessagePrefix = this.getClass().getName();
        this.manglingPrefix = String.format("__global_intro__advice_%s_", string);
        this.parentAspect = this.aspectManager.getAspect(string);
        this.parentAspect.addGlobalIntroAdvice(this);
    }

    private void mangleAndReplaceSimpleDeclarator(GNode gNode) {
        String string = Token.cast(gNode.get(0));
        String string2 = this.manglingPrefix + string;
        if (this.debug) {
            System.err.printf("%s: Replacing %s with %s.\n", this.debugMessagePrefix, string, string2);
        }
        this.parentAspect.addToBindings(string, string2);
        gNode.set(0, string2);
    }

    private String mangleNameAndUpdateBinding(String string) {
        String string2 = this.manglingPrefix + string;
        if (this.debug) {
            System.err.printf("Adding %s and %s to binding ...\n", string, string2);
        }
        this.parentAspect.addToBindings(string, string2);
        return string2;
    }

    public Node visitSimpleDeclarator(GNode gNode) {
        if (this.debug) {
            System.err.println("Simple declarator: " + gNode);
        }
        this.mangleAndReplaceSimpleDeclarator(gNode);
        return gNode;
    }

    public Node visitFunctionDefinition(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode.set(i, this.dispatch((Node)object));
        }
        return gNode;
    }

    public Node visitStructureDeclaration(GNode gNode) {
        return (Node)new StructureDeclarationVisitor().dispatch(gNode);
    }

    public Node visitDeclaration(GNode gNode) {
        List<Object> list = this.xformEngine.run(C4XFormQuery.GetAllStructureTypeDefinition, gNode);
        if (!list.isEmpty()) {
            return this.visitStructureDeclaration(gNode);
        }
        for (int i = 0; i < gNode.size(); ++i) {
            Object object = gNode.get(i);
            if (!(object instanceof Node)) continue;
            gNode.set(i, this.dispatch((Node)object));
        }
        return gNode;
    }

    @Override
    public List<GNode> transform() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<GNode> arrayList2 = new ArrayList<GNode>(1);
        for (int i = 2; i < this.node.size(); ++i) {
            Object object = this.node.get(i);
            if (!(object instanceof Node)) continue;
            Object object2 = this.dispatch((Node)object);
            this.node.set(i, object2);
            arrayList.add((Node)object2);
        }
        GNode gNode = GNode.create(this.node.getName(), GNode.cast(this.cFactory.createBlock(arrayList)));
        arrayList2.add(gNode);
        return arrayList2;
    }

    class StructureDeclarationVisitor
    extends Visitor {
        StructureDeclarationVisitor() {
        }

        public Node visitStructureTypeDefinition(GNode gNode) {
            if (null != gNode.get(1)) {
                String string = Token.cast(gNode.get(1));
                String string2 = C4GlobalIntroAdvice.this.mangleNameAndUpdateBinding(string);
                if (C4GlobalIntroAdvice.this.debug) {
                    System.err.printf("Mangling structure tag %s to %s\n", string, string2);
                }
                gNode.set(1, string2);
            }
            return gNode;
        }

        public Node visitSimpleDeclarator(GNode gNode) {
            C4GlobalIntroAdvice.this.mangleAndReplaceSimpleDeclarator(gNode);
            return gNode;
        }

        public Node visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                Object object = node.get(i);
                if (!(object instanceof Node)) continue;
                node.set(i, this.dispatch((Node)object));
            }
            return node;
        }
    }
}

