/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import xtc.lang.c4.AspectFunctionAnalyzer;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.xform.Engine;
import xtc.xform.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectTransformer {
    private GNode root = null;
    private ArrayList<String> aspectList = null;
    private Engine engine = null;
    private HashMap<String, HashMap<String, String>> bindings = null;
    private String curAspectName = null;
    private static int uniqueLabelCounter = 0;

    public AspectTransformer(GNode gNode) {
        this.root = gNode;
        this.engine = new Engine();
        this.bindings = new HashMap();
        this.aspectList = new ArrayList();
        this.aspectList.add("AspectDefinition");
        this.aspectList.add("AspectStructureDeclaration");
        this.aspectList.add("AspectFunctionDefinition");
    }

    public Object process(String string, Class<Object>[] classArray, Object[] objectArray) {
        try {
            Method method = this.getClass().getMethod(string, classArray);
            return method.invoke((Object)this, objectArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    public void transform() {
        List<Object> list = null;
        Query query = null;
        for (String string : this.aspectList) {
            query = string.equals("AspectStructureDeclaration") ? new Query("//" + string + "/../../../../..") : new Query("//" + string);
            list = this.engine.run(query, this.root);
            if (list.isEmpty()) continue;
            if (string.equals("AspectDefinition")) {
                this.processAspectDefinition(list);
                continue;
            }
            if (string.equals("AspectStructureDeclaration")) {
                this.processAspectStructureDeclaration(list);
                continue;
            }
            if (!string.equals("AspectFunctionDefinition")) continue;
            this.processAspectFunctionDefinition(list);
        }
    }

    private String getSimpleDeclarator(GNode gNode) {
        if (null == gNode) {
            return null;
        }
        Query query = new Query("//SimpleDeclarator");
        List<Object> list = this.engine.run(query, gNode);
        if (list.size() <= 0) {
            return null;
        }
        return GNode.cast(list.get(0)).getString(0);
    }

    private void mangleDeclarator(GNode gNode, String string) {
        boolean bl = false;
        Query query = new Query("//SimpleDeclarator");
        Query query2 = new Query("/DeclarationSpecifiers/StructureTypeDefinition/../..");
        Query query3 = new Query("/DeclarationSpecifiers/UnionTypeDefinition/../..");
        List<Object> list = this.engine.run(query2, gNode);
        if (list.size() > 0) {
            bl = true;
        } else {
            list = this.engine.run(query3, gNode);
            if (list.size() > 0) {
                bl = true;
            }
        }
        if (bl) {
            GNode gNode2;
            GNode gNode3 = (GNode)list.get(0);
            GNode gNode4 = gNode3.getGeneric(1).getGeneric(0);
            String string2 = gNode4.getString(1);
            if (null != string2) {
                gNode4.set(1, string + string2);
                this.bindings.get(this.curAspectName).put("struct " + string2, string + string2);
            }
            if ((gNode2 = gNode3.getGeneric(2)) != null) {
                list = this.engine.run(query, gNode2);
                GNode gNode5 = (GNode)list.get(0);
                this.bindings.get(this.curAspectName).put(gNode5.getString(0), string + gNode5.getString(0));
                gNode5.set(0, string + gNode5.getString(0));
            }
            return;
        }
        list = this.engine.run(query, gNode);
        GNode gNode6 = (GNode)list.get(0);
        this.bindings.get(this.curAspectName).put(gNode6.getString(0), string + gNode6.getString(0));
        gNode6.set(0, string + gNode6.getString(0));
    }

    private boolean isReturnVoid(GNode gNode) {
        if (null != gNode) {
            Query query = new Query("//VoidTypeSpecifier");
            List<Object> list = this.engine.run(query, gNode);
            return !list.isEmpty();
        }
        return false;
    }

    private void replacePriID(GNode gNode) {
        Object object;
        Object object22;
        Object object3;
        HashMap<String, String> hashMap = this.bindings.get(this.curAspectName);
        List<Object> list = null;
        Query query = new Query("//PrimaryIdentifier");
        Query query2 = new Query("/DeclarationSpecifiers/StructureTypeReference/../..");
        Query query3 = new Query("//TypedefName");
        Query query4 = new Query("//DirectComponentSelection");
        Query query5 = new Query("//IndirectComponentSelection");
        list = this.engine.run(query2, gNode);
        if (list.size() > 0) {
            object3 = (GNode)list.get(0);
            object22 = ((Node)object3).getGeneric(1).getGeneric(0);
            object = ((Node)object3).getGeneric(2);
            if (hashMap.containsKey("struct " + ((Node)object22).getString(1))) {
                ((Node)object22).set(1, hashMap.get("struct " + ((Node)object22).getString(1)));
            }
            if (hashMap.containsKey("field_struct_tag " + ((Node)object22).getString(1))) {
                if (null == object) {
                    System.err.println("initDeclList is null!?");
                    System.exit(1);
                }
                String string = this.getSimpleDeclarator((GNode)object);
                String string2 = hashMap.get("field_struct_tag " + ((Node)object22).getString(1));
                hashMap.put("field_struct " + string, string2);
            }
        }
        list = this.engine.run(query, gNode);
        for (Object object22 : list) {
            object = GNode.cast(object22);
            if (null == hashMap || !hashMap.containsKey(((Node)object).getString(0))) continue;
            ((Node)object).set(0, hashMap.get(((Node)object).getString(0)));
        }
        list = this.engine.run(query3, gNode);
        for (Object object22 : list) {
            object = GNode.cast(object22);
            if (!hashMap.containsKey(((Node)object).getString(0))) continue;
            ((Node)object).set(0, hashMap.get(((Node)object).getString(0)));
        }
        list = this.engine.run(query4, gNode);
        if (list.size() > 0) {
            object3 = GNode.cast(list.get(list.size() - 1));
            object22 = ((Node)object3).getGeneric(0).getString(0);
            if (hashMap.containsKey("field_struct " + (String)object22)) {
                object = hashMap.get("field_struct " + (String)object22);
                System.out.println((String)object22 + " fields: " + (String)object);
                System.out.println(hashMap);
                if (((String)object).contains(((Node)object3).getString(1))) {
                    ((Node)object3).set(0, this.makeDirectComponentSel(((Node)object3).getGeneric(0), this.curAspectName));
                }
            }
        }
        if ((list = this.engine.run(query5, gNode)).size() > 0) {
            object3 = (GNode)list.get(list.size() - 1);
            object22 = ((Node)object3).getGeneric(0).getString(0);
            if (hashMap.containsKey("field_struct " + (String)object22) && ((String)(object = hashMap.get("field_struct " + (String)object22))).contains(((Node)object3).getString(1))) {
                ((Node)object3).set(0, this.makeIndirectComponentSel(((Node)object3).getGeneric(0), this.curAspectName));
            }
        }
    }

    public GNode makeDirectComponentSel(GNode gNode, String string) {
        return GNode.create("DirectComponentSelection", gNode, string);
    }

    public GNode makeIndirectComponentSel(GNode gNode, String string) {
        return GNode.create("IndirectComponentSelection", gNode, string);
    }

    public GNode makeAssignment(String string, GNode gNode) {
        return GNode.create("AssignmentExpression", GNode.create("PrimaryIdentifier", string), "=", gNode);
    }

    public GNode makeGoto(String string) {
        GNode gNode = GNode.create("PrimaryIdentifier", string);
        GNode gNode2 = GNode.create("GotoStatement", null, gNode);
        return gNode2;
    }

    public GNode makeGotoWithAddress(String string) {
        return GNode.create("GotoStatement", GNode.create("PrimaryIdentifier", string));
    }

    public GNode makeLabel(String string, GNode gNode) {
        return GNode.create("LabeledStatement", GNode.create("NamedLabel", string, null), gNode);
    }

    public GNode makeDoStmt(GNode gNode, GNode gNode2) {
        if (null == gNode) {
            gNode = GNode.create("CompoundStatement", null);
        }
        return GNode.create("DoStatement", gNode, gNode2);
    }

    public GNode makeReturn(GNode gNode) {
        return GNode.create("ReturnStatement", gNode);
    }

    public GNode makeStructureDeclaration(GNode gNode, String string) {
        GNode gNode2 = GNode.create("StructureDeclaration");
        GNode gNode3 = GNode.create("SpecifierQualifierList");
        GNode gNode4 = GNode.create("StructureDeclarationList");
        GNode gNode5 = GNode.create("AttributedDeclarator");
        gNode5.add(null);
        gNode5.add(GNode.create("SimpleDeclarator").add(string));
        gNode5.add(null);
        gNode4.add(gNode5);
        gNode3.add(gNode);
        gNode2.add(null);
        gNode2.add(gNode3);
        gNode2.add(gNode4);
        return gNode2;
    }

    public GNode makeDeclaration(GNode gNode, String string) {
        GNode gNode2 = GNode.create("InitializedDeclaratorList");
        GNode gNode3 = GNode.create("InitializedDeclarator");
        GNode gNode4 = GNode.create("SimpleDeclarator", string);
        gNode3.add(null);
        gNode3.add(gNode4);
        gNode3.add(null);
        gNode3.add(null);
        gNode3.add(null);
        gNode2.add(gNode3);
        GNode gNode5 = GNode.create("Declaration");
        gNode5.add(null);
        gNode5.add(gNode);
        gNode5.add(gNode2);
        return gNode5;
    }

    public GNode makeDeclaration(GNode gNode, GNode gNode2) {
        GNode gNode3 = GNode.create("Declaration");
        GNode gNode4 = GNode.create("InitializedDeclaratorList");
        gNode4.add(gNode2);
        gNode3.add(null);
        gNode3.add(gNode);
        gNode3.add(gNode4);
        return gNode3;
    }

    public GNode makeStructure(String string, GNode gNode, GNode gNode2, GNode gNode3) {
        GNode gNode4 = GNode.create("StructureTypeDefinition");
        if (null == gNode) {
            gNode4.add(null);
        } else {
            gNode4.add(gNode);
        }
        if (null == string) {
            gNode4.add(null);
        } else {
            gNode4.add(string);
        }
        gNode4.add(gNode2);
        if (null == gNode3) {
            gNode4.add(null);
        } else {
            gNode4.add(gNode3);
        }
        return gNode4;
    }

    public GNode makeLabelAddressExpression(String string) {
        return GNode.create("LabelAddressExpression", string);
    }

    public GNode makePointerDeclarator(int n, String string) {
        GNode gNode;
        GNode gNode2 = GNode.create("PointerDeclarator");
        GNode gNode3 = gNode = (GNode)GNode.create("Pointer").add(GNode.create("TypeQualifierList")).add(null);
        GNode gNode4 = null;
        for (int i = 1; i < n; ++i) {
            gNode4 = (GNode)GNode.create("Pointer").add(GNode.create("TypeQualifierList")).add(null);
            gNode3.set(1, gNode4);
            gNode3 = gNode4;
        }
        gNode2.add(gNode);
        gNode2.add(GNode.create("SimpleDeclarator").add(string));
        return gNode2;
    }

    public void processAspectDefinition(List<Object> list) {
        String string = null;
        int n = 0;
        ArrayList<GNode> arrayList = null;
        for (int i = 0; i < this.root.size(); ++i) {
            GNode gNode = this.root.getGeneric(i);
            arrayList = new ArrayList<GNode>();
            if (null == gNode || !gNode.hasName("AspectDefinition")) continue;
            this.curAspectName = gNode.getString(1);
            if (!this.bindings.containsKey(this.curAspectName)) {
                this.bindings.put(this.curAspectName, new HashMap());
            }
            string = "__aspect__" + this.curAspectName + "__";
            for (int j = 2; j < gNode.size(); ++j) {
                GNode gNode2 = (GNode)gNode.get(j);
                this.mangleDeclarator(gNode2, string);
                arrayList.add(gNode2);
            }
            this.root.remove(i);
            this.root.addAll(i, arrayList);
            ++n;
        }
        if (n != list.size()) {
            System.err.println("cnt != nodes.size()");
            System.exit(1);
        }
    }

    public void processAspectStructureDeclaration(List<Object> list) {
        Query query = new Query("//SimpleDeclarator");
        List<Object> list2 = null;
        String string = new String();
        for (Object object : list) {
            GNode gNode;
            GNode gNode2 = GNode.cast(object);
            GNode gNode3 = gNode2.getGeneric(1).getGeneric(0);
            String string2 = gNode3.getString(1);
            GNode gNode4 = gNode3.getGeneric(2);
            GNode gNode5 = null;
            GNode gNode6 = gNode2.getGeneric(2);
            for (int i = 0; i < gNode4.size(); ++i) {
                Object object2 = GNode.cast(gNode4.get(i));
                if (null == object2 || !(gNode = ((Node)object2).getGeneric(1)).hasName("AspectStructureDeclaration")) continue;
                this.curAspectName = gNode.getString(1);
                if (!this.bindings.containsKey(this.curAspectName)) {
                    this.bindings.put(this.curAspectName, new HashMap());
                }
                GNode gNode7 = gNode.getGeneric(2);
                list2 = this.engine.run(query, gNode7);
                for (Object object3 : list2) {
                    if (!GNode.test(object3)) {
                        System.err.println("Simple Decl is not a generic node.");
                        System.exit(-1);
                    }
                    GNode gNode8 = GNode.cast(object3);
                    string = string.concat(gNode8.getString(0) + ' ');
                }
                gNode5 = this.makeStructureDeclaration(this.makeStructure(null, null, gNode7, null), gNode.getString(1));
                gNode4.set(i, gNode5);
            }
            this.bindings.get(this.curAspectName).put("field_struct_tag " + string2, string);
            if (null == gNode6) continue;
            for (Object object2 : gNode6) {
                gNode = GNode.cast(object2);
                this.bindings.get(this.curAspectName).put("field_struct " + this.getSimpleDeclarator(gNode), string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processAspectFunctionDefinition(List<Object> list) {
        int n;
        AspectFunctionAnalyzer aspectFunctionAnalyzer = new AspectFunctionAnalyzer(GNode.cast(list.get(0)));
        aspectFunctionAnalyzer.analyze();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Query query = new Query("//FunctionCall/PrimaryIdentifier/\"proceed\"");
        Query query2 = new Query("//SimpleDeclarator");
        List<Object> list2 = null;
        bl4 = aspectFunctionAnalyzer.hasAround();
        for (n = 0; n < this.root.size(); ++n) {
            Iterable<Object> iterable;
            GNode gNode;
            GNode gNode2;
            Object object;
            Object object2;
            Object object322;
            GNode gNode3;
            boolean bl6 = false;
            boolean bl7 = false;
            GNode gNode4 = this.root.getGeneric(n);
            if (null == gNode4 || !gNode4.hasName("AspectFunctionDefinition")) continue;
            GNode gNode5 = gNode4.getGeneric(1);
            bl2 = this.isReturnVoid(gNode5);
            GNode gNode6 = gNode4.getGeneric(2).getGeneric(1);
            GNode gNode7 = GNode.create("CompoundStatement");
            GNode gNode8 = null;
            if (!bl2) {
                gNode7.add(this.makeDeclaration(gNode5, "__returned__"));
            }
            if (bl4) {
                gNode3 = GNode.create("InitializedDeclarator");
                for (int i = 0; i < 5; ++i) {
                    gNode3.add(null);
                }
                gNode3.set(1, this.makePointerDeclarator(1, "gotoDest"));
                gNode7.add(this.makeDeclaration(GNode.create("VoidTypeSpecifier", false), gNode3));
            }
            if (aspectFunctionAnalyzer.hasBefore()) {
                gNode3 = aspectFunctionAnalyzer.getBefore();
                for (Object object322 : gNode3) {
                    object2 = GNode.create("CompoundStatement");
                    object = GNode.cast(object322);
                    this.curAspectName = ((Node)object).getString(1);
                    if (aspectFunctionAnalyzer.isAround(this.curAspectName)) {
                        bl = true;
                        arrayList.add(this.curAspectName);
                    }
                    for (int i = 2; i < ((Node)object).size(); ++i) {
                        gNode2 = GNode.cast(((Node)object).get(i));
                        if (bl5) {
                            bl5 = false;
                            ((Node)object2).add(this.makeLabel("__body_begin", null));
                        }
                        list2 = this.engine.run(new Query("//FunctionCall/PrimaryIdentifier/\"proceed\"/../../.."), gNode2);
                        if (bl && list2.size() > 0) {
                            for (Object e : list2) {
                                GNode gNode9;
                                gNode = GNode.cast(e);
                                System.out.println("expStmt: " + gNode.getName());
                                bl7 = true;
                                if (gNode2.hasName("ExpressionStatement")) {
                                    void e2;
                                    iterable = gNode2.getGeneric(0).getGeneric(1);
                                    List<Object> list3 = this.engine.run(query2, gNode6);
                                    boolean j = false;
                                    while (e2 < list3.size()) {
                                        gNode9 = GNode.cast(list3.get((int)e2));
                                        ((Node)object2).add(this.makeAssignment(gNode9.getString(0), ((Node)iterable).getGeneric((int)e2)));
                                        ++e2;
                                    }
                                    ((Node)object2).add(this.makeAssignment("gotoDest", this.makeLabelAddressExpression("__" + this.curAspectName + "__return_point" + uniqueLabelCounter)));
                                    ((Node)object2).add(this.makeGoto("__body_begin"));
                                    ((Node)object2).add(this.makeLabel("__" + this.curAspectName + "__return_point" + uniqueLabelCounter++, null));
                                    continue;
                                }
                                iterable = this.engine.run(new Query("//FunctionCall/PrimaryIdentifier/\"proceed\"/../../../.."), gNode2);
                                for (Object e2 : iterable) {
                                    gNode9 = GNode.cast(e2);
                                    ArrayList<GNode> arrayList2 = new ArrayList<GNode>();
                                    for (int j = 0; j < gNode9.size(); ++j) {
                                        GNode gNode10 = gNode9.getGeneric(j);
                                        if (null == gNode10 || !list2.contains(gNode10)) continue;
                                        GNode gNode11 = gNode10.getGeneric(0).getGeneric(1);
                                        List<Object> list3 = this.engine.run(query2, gNode6);
                                        for (int k = 0; k < list3.size(); ++k) {
                                            GNode gNode12 = GNode.cast(list3.get(k));
                                            arrayList2.add(this.makeAssignment(gNode12.getString(0), gNode11.getGeneric(k)));
                                        }
                                        arrayList2.add(this.makeAssignment("gotoDest", this.makeLabelAddressExpression("__" + this.curAspectName + "__return_point" + uniqueLabelCounter)));
                                        arrayList2.add(this.makeGoto("__body_begin"));
                                        arrayList2.add(this.makeLabel("__" + this.curAspectName + "__return_point" + uniqueLabelCounter++, null));
                                        gNode9.remove(j);
                                        gNode9.addAll(j, arrayList2);
                                    }
                                }
                            }
                            if (gNode2.hasName("ExpressionStatement")) continue;
                            ((Node)object2).add(gNode2);
                            continue;
                        }
                        if (gNode2.hasName("ReturnStatement") && bl) {
                            bl6 = true;
                            if (!bl7) {
                                ((Node)object2).add(this.makeGoto("__after_" + this.curAspectName + "__start_point"));
                                ((Node)object2).add(this.makeLabel("__" + this.curAspectName + "__return_point", null));
                            }
                            this.replacePriID(gNode2);
                            ((Node)object2).add(gNode2);
                            continue;
                        }
                        this.replacePriID(gNode2);
                        ((Node)object2).add(gNode2);
                    }
                    if (bl && !bl2 && !bl6) {
                        System.err.println("Missing return statement in before advice(" + this.curAspectName + ") for non-void function.");
                        System.exit(1);
                    }
                    if (bl && bl2) {
                        if (!bl7) {
                            ((Node)object2).add(this.makeGoto("__after_" + this.curAspectName + "__start_point"));
                            ((Node)object2).add(this.makeLabel("__" + this.curAspectName + "__return_point", null));
                        }
                        ((Node)object2).add(this.makeGoto("__return_point"));
                    }
                    if (bl) {
                        bl5 = true;
                    }
                    bl = false;
                    gNode7.add(object2);
                }
            }
            gNode3 = gNode7;
            if (bl5) {
                gNode3.add(this.makeLabel("__body_begin", null));
            }
            GNode gNode13 = null;
            object322 = aspectFunctionAnalyzer.getBody();
            object2 = ((ArrayList)object322).iterator();
            while (object2.hasNext()) {
                object = (GNode)object2.next();
                GNode gNode14 = GNode.cast(object);
                if (gNode14.hasName("ReturnStatement")) {
                    gNode13 = gNode14.getGeneric(0);
                    if (!bl2) {
                        gNode3.add(this.makeAssignment("__returned__", gNode13));
                    } else {
                        bl3 = true;
                    }
                    gNode3.add(this.makeGoto("__aspects_done"));
                    continue;
                }
                gNode3.add(gNode14);
            }
            gNode3.add(this.makeLabel("__aspects_done", this.makeDoStmt(null, GNode.create("IntegerConstant", "0"))));
            if (aspectFunctionAnalyzer.hasAfter()) {
                object2 = aspectFunctionAnalyzer.getAfter();
                object = ((Node)object2).iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    gNode2 = GNode.cast(e);
                    GNode gNode15 = GNode.create("CompoundStatement");
                    this.curAspectName = gNode2.getString(1);
                    if (arrayList.contains(this.curAspectName)) {
                        arrayList.remove(this.curAspectName);
                        bl = true;
                    }
                    if (bl) {
                        gNode15.add(this.makeLabel("__after_" + this.curAspectName + "__start_point", null));
                    }
                    for (int i = 2; i < gNode2.size(); ++i) {
                        gNode = (GNode)gNode2.get(i);
                        list2 = this.engine.run(query, gNode);
                        if (list2.size() > 0) {
                            System.err.println("Calling proceed in after advice is not allowed.");
                            System.exit(1);
                        }
                        this.replacePriID(gNode);
                        if (gNode.hasName("ReturnStatement")) {
                            iterable = gNode.getGeneric(0);
                            gNode15.add(this.makeAssignment("__returned__", (GNode)iterable));
                            continue;
                        }
                        gNode15.add(gNode);
                    }
                    gNode15.add(this.makeGoto("__" + gNode2.getString(1) + "____out__"));
                    gNode15.add(this.makeLabel("__" + gNode2.getString(1) + "____out__", this.makeDoStmt(null, GNode.create("IntegerConstant", "0"))));
                    if (bl) {
                        gNode15.add(this.makeGotoWithAddress("gotoDest"));
                    }
                    bl = false;
                    gNode3.add(gNode15);
                }
            }
            gNode3.add(this.makeLabel("__return_point", null));
            if (!bl2) {
                if (null != gNode8) {
                    gNode3.add(this.makeReturn(gNode8));
                } else {
                    gNode3.add(this.makeReturn(GNode.create("PrimaryIdentifier", "__returned__")));
                }
            } else if (bl3) {
                gNode3.add(this.makeReturn(null));
            }
            if (!gNode3.equals(gNode7)) {
                gNode7.add(gNode3);
            }
            gNode4.set(4, gNode7);
            object2 = GNode.create("FunctionDefinition");
            for (Object object4 : gNode4) {
                ((Node)object2).add(object4);
            }
            this.root.set(n, object2);
        }
        if (arrayList.size() != 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                System.err.println("Missing after advice for: " + (String)arrayList.get(n));
            }
            System.exit(1);
        }
    }
}

