/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.xform.Engine;
import xtc.xform.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectFunctionAnalyzer {
    private Engine engine = new Engine();
    private boolean hasBefore = false;
    private boolean hasAfter = false;
    private boolean hasAround = false;
    private GNode functionNode = null;
    private ArrayList<String> beforeAdvice = null;
    private GNode beforeAdviceNode = null;
    private ArrayList<String> afterAdvice = null;
    private GNode afterAdviceNode = null;
    private ArrayList<String> aroundAdvice = null;
    private ArrayList<GNode> functionBody = null;

    public AspectFunctionAnalyzer(GNode gNode) {
        this.functionNode = gNode;
        this.beforeAdvice = new ArrayList();
        this.afterAdvice = new ArrayList();
        this.aroundAdvice = new ArrayList();
        this.functionBody = new ArrayList();
    }

    public void analyze() {
        Object object;
        Iterator<Object> iterator2;
        if (null == this.functionNode) {
            throw new AssertionError((Object)"functionNode is NULL.");
        }
        Query query = new Query("//AspectStatementList");
        List<Object> list = this.engine.run(query, this.functionNode);
        this.beforeAdviceNode = GNode.cast(list.get(0));
        if (this.beforeAdviceNode.size() > 0) {
            this.hasBefore = true;
        }
        for (Iterator<Object> iterator2 : this.beforeAdviceNode) {
            object = GNode.cast(iterator2);
            this.beforeAdvice.add(((Node)object).getString(1));
        }
        this.afterAdviceNode = (GNode)list.get(1);
        if (this.afterAdviceNode.size() > 0) {
            this.hasAfter = true;
        }
        for (Iterator<Object> iterator2 : this.afterAdviceNode) {
            object = GNode.cast(iterator2);
            this.afterAdvice.add(((Node)object).getString(1));
            if (!this.beforeAdvice.contains(((Node)object).getString(1))) continue;
            this.hasAround = true;
            this.aroundAdvice.add(((Node)object).getString(1));
        }
        GNode gNode = (GNode)this.functionNode.get(4);
        iterator2 = gNode.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            GNode gNode2 = GNode.cast(object);
            if (null == gNode2 || gNode2.hasName("AspectStatementList")) continue;
            this.functionBody.add(gNode2);
        }
    }

    public boolean hasBefore() {
        return this.hasBefore;
    }

    public GNode getBefore() {
        return this.beforeAdviceNode;
    }

    public ArrayList<GNode> getBody() {
        return this.functionBody;
    }

    public boolean hasAfter() {
        return this.hasAfter;
    }

    public GNode getAfter() {
        return this.afterAdviceNode;
    }

    public boolean hasAround() {
        return this.hasAround;
    }

    public boolean isAround(String string) {
        return this.aroundAdvice.contains(string);
    }
}

