/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.CharArrayWriter;
import java.io.StringReader;
import java.io.StringWriter;
import xtc.lang.JavaEntities;
import xtc.lang.blink.CommandAstAnalyzer;
import xtc.lang.blink.CommandAstPrinter;
import xtc.lang.blink.CommandParser;
import xtc.lang.jeannie.AstSimplifier;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.Runtime;

public final class Utilities {
    public static String debuggerAstToString(GNode gNode) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        CommandAstPrinter commandAstPrinter = new CommandAstPrinter(new Printer(charArrayWriter));
        commandAstPrinter.dispatch(gNode);
        return charArrayWriter.toString();
    }

    public static Object debuggerParseAndAnalyze(String string, String string2) {
        GNode gNode;
        GNode gNode2 = null;
        String string3 = null;
        try {
            gNode2 = Utilities.debuggerStringToAst(string, string2);
            StringWriter stringWriter = new StringWriter();
            CommandAstAnalyzer commandAstAnalyzer = new CommandAstAnalyzer(Utilities.newRuntime());
            commandAstAnalyzer._runtime.setErrConsole(new Printer(stringWriter));
            commandAstAnalyzer.dispatch(gNode2);
            string3 = stringWriter.toString();
        }
        catch (Exception exception) {
            string3 = exception.getMessage();
        }
        GNode gNode3 = gNode = null == string3 || "".equals(string3) ? gNode2 : string3;
        assert (null != gNode);
        if (gNode instanceof Node) {
            CommandAstAnalyzer.assertAllNodesHaveLanguage(gNode);
        }
        return gNode;
    }

    public static GNode debuggerStringToAst(String string, String string2) throws Exception {
        Result result2;
        CommandParser commandParser = new CommandParser(new StringReader(string2), "<input>", string2.length());
        Result result3 = result2 = "C".equals(string) ? commandParser.pCCommand(0) : commandParser.pJavaCommand(0);
        if (result2.hasValue()) {
            SemanticValue semanticValue = (SemanticValue)result2;
            if (semanticValue.index != string2.length()) {
                commandParser.signal(result2.parseError());
            }
            GNode gNode = (GNode)semanticValue.value;
            return (GNode)new AstSimplifier(string).dispatch(gNode);
        }
        commandParser.signal(result2.parseError());
        return null;
    }

    public static Runtime newRuntime() {
        Runtime runtime = new Runtime();
        runtime.dir("in", "inputDirectory", true, "").setValue("inputDirectory", JavaEntities.TEMP_DIR);
        runtime.bool("markAST", "optionMarkAST", true, "Mark AST nodes with types.").setValue("optionMarkAST", true);
        runtime.bool("strict", "optionStrict", true, "Enforce strict C99 compliance.").setValue("optionStrict", true);
        runtime.bool("pedantic", "optionPedantic", false, "Enforce strict C99 compliance.").setValue("optionPedantic", true);
        runtime.word("jniCall", "jniCall", false, "Calling conventions qualifier to C JNI functions.").setValue("jniCall", "");
        runtime.initDefaultValues();
        return runtime;
    }

    private Utilities() {
        assert (false);
    }
}

