/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import xtc.lang.JavaUnitTests;
import xtc.lang.blink.CommandAstAnalyzer;
import xtc.lang.blink.Utilities;
import xtc.tree.GNode;
import xtc.tree.Node;

public final class UnitTests
extends TestCase {
    static void debuggerAnalyzerTestError(String string, String string2, String string3, CommandAstAnalyzer commandAstAnalyzer) throws Exception {
        Object object = Utilities.debuggerParseAndAnalyze(string, string2);
        String string4 = object instanceof Node ? "" : UnitTests.trimAnalyzerOutput((String)object);
        UnitTests.assrtEquals(string3, string4);
    }

    static void debuggerParserTestRoundTrip(String string, String string2, String string3) throws Exception {
        GNode gNode = Utilities.debuggerStringToAst(string, string2);
        String string4 = Utilities.debuggerAstToString(gNode);
        UnitTests.assrtEquals(string3, string4);
    }

    static String trimAnalyzerOutput(String string) {
        int n = (string = JavaUnitTests.stripPrefix(string, "error:")).indexOf("warning:");
        if (-1 != n) {
            string = string.substring(n);
        }
        string = JavaUnitTests.stripSuffix(string, "\n");
        string = string.trim();
        return string;
    }

    private static TestSuite makeSuiteDebugger() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "next", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print $metaVar = f()", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print $metaVariable", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print &x", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print (*x).f", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print cVar = f()", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print known", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print x + `.Java this.f($mv) + &z", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print x + `this.f($mv)", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "C", "print x->f", "the Blink debugger does not support the IndirectComponentSelection feature"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "next", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "print $metaVar = f()", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "print &x", "expected"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "print `&x", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "print javaVar = f()", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "print new Object()", "the Blink debugger does not support the NewClassExpression feature"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, "Java", "watch all a.b.c.d.e.f", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "break file name.jni:123", "symbol characters expected"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "break file/name.jni:123", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "gdb break foo.c:10", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "gdbb break foo.c:10", "break class command expected"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "n", "break class command expected"));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "next", ""));
        testSuite.addTest((Test)new BlinkDebuggerAnalyzerTest(false, null, "stop at my.pack.Clazz:123", ""));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "delete 42"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "print $metaVariable"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "print &x"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "print x + `this.f($mv)"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "print x + `this.f()"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "C", "watch x[0]"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "delete 42"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "print $metaVariable"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "print `&x + y"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "print my.pack.Clazz.staticField"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "watch access y.g"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "watch all a.b.c.d.e.f"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, "Java", "watch my.pack.Clazz.h"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "   stat   "));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, " stop at my . pack . Clazz : 123 "));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "break file/name.jni:123"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "continue"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "delete 42"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "down 3"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "exit"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "gdb break foo.c:10"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "help"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "info break"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "info watch"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "initj"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "jdb stop at foo.c:10"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "list"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "locals"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "next"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "step"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "stop at Clazz:1"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "stop at my.pack.Clazz:123"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "up 0"));
        testSuite.addTest((Test)new BlinkDebuggerParserTest(false, null, "where"));
        return testSuite;
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTestSuite(UnitTests.class);
        testSuite.addTest((Test)UnitTests.makeSuiteDebugger());
        return testSuite;
    }

    static void assrtEquals(String string, String string2) {
        String string3;
        if (null == string) {
            return;
        }
        String string4 = JavaUnitTests.contractSpace(string);
        if (string4.equals(string3 = JavaUnitTests.contractSpace(string2))) {
            return;
        }
        UnitTests.assertEquals((String)string4, (String)string3);
    }

    static final class BlinkDebuggerParserTest
    extends JavaUnitTests.IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _language;

        BlinkDebuggerParserTest(boolean bl, String string, String string2) {
            super(bl);
            this._expected = string2;
            this._input = string2;
            this._language = string;
        }

        public void runTestIgnorable() throws Exception {
            if (null == this._language) {
                UnitTests.debuggerParserTestRoundTrip("C", this._input, this._expected);
                UnitTests.debuggerParserTestRoundTrip("Java", this._input, this._expected);
            } else {
                UnitTests.debuggerParserTestRoundTrip(this._language, this._input, this._expected);
            }
        }
    }

    static final class BlinkDebuggerAnalyzerTest
    extends JavaUnitTests.IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _language;

        BlinkDebuggerAnalyzerTest(boolean bl, String string, String string2, String string3) {
            super(bl);
            this._expected = string3;
            this._input = string2;
            this._language = string;
        }

        public void runTestIgnorable() throws Exception {
            CommandAstAnalyzer commandAstAnalyzer = new CommandAstAnalyzer(Utilities.newRuntime());
            UnitTests.debuggerAnalyzerTestError(this._language, this._input, this._expected, commandAstAnalyzer);
        }
    }
}

