/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolMapper {
    private final HashMap<String, SourceVariableMapper> varibleRemap = new HashMap();

    SymbolMapper() {
    }

    public VariableRemapEntry lookUpVariableRemap(String string, String string2, int n) {
        if (string2 == null || n < 0) {
            return null;
        }
        SourceVariableMapper sourceVariableMapper = this.getRemapInformation(string2);
        if (sourceVariableMapper == null) {
            return null;
        }
        return sourceVariableMapper.lookUp(string, n);
    }

    public MethodRemapEntry lookupMethodRemap(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        SourceVariableMapper sourceVariableMapper = this.getRemapInformation(string2);
        if (sourceVariableMapper == null) {
            return null;
        }
        return sourceVariableMapper.lookupMethod(string);
    }

    private SourceVariableMapper getRemapInformation(String string) {
        SourceVariableMapper sourceVariableMapper = null;
        if (!this.varibleRemap.containsKey(string)) {
            try {
                String string2 = string + ".symbols";
                sourceVariableMapper = new SourceVariableMapper(string2);
            }
            catch (IOException iOException) {}
        } else {
            sourceVariableMapper = this.varibleRemap.get(string);
        }
        return sourceVariableMapper;
    }

    public List<VariableRemapEntry> lookup(String string, int n) {
        LinkedList<VariableRemapEntry> linkedList = new LinkedList<VariableRemapEntry>();
        SourceVariableMapper sourceVariableMapper = this.getRemapInformation(string);
        if (sourceVariableMapper == null) {
            return linkedList;
        }
        for (VariableRemapEntry variableRemapEntry : sourceVariableMapper.ventries) {
            if (variableRemapEntry.startLine > n || n > variableRemapEntry.endLine) continue;
            linkedList.add(variableRemapEntry);
        }
        return linkedList;
    }

    private static class SourceVariableMapper {
        private final String remapFile;
        private final List<VariableRemapEntry> ventries = new LinkedList<VariableRemapEntry>();
        private final HashMap<String, MethodRemapEntry> mentries = new HashMap();

        public SourceVariableMapper(String string) throws IOException {
            this.remapFile = string;
            this.updateRemapEntry();
        }

        private void updateRemapEntry() throws IOException {
            this.ventries.clear();
            Pattern pattern2 = Pattern.compile("\\s*(\\S+) (\\d+) (\\d+) (\\d+) (\\d+) (Java|C) (\\S+) (\\S+)");
            Pattern pattern3 = Pattern.compile("\\s*(\\S+)\\s*(\\S+)");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.remapFile));
            int n = 0;
            String string = bufferedReader.readLine();
            while (string != null) {
                Matcher matcher;
                if (string.equals("LocalVariableMap:")) {
                    n = 1;
                } else if (string.equals("MethodMap:")) {
                    n = 2;
                } else if (n == 1) {
                    matcher = pattern2.matcher(string);
                    if (matcher.matches()) {
                        TargetSourceLanguage targetSourceLanguage;
                        int n2 = Integer.parseInt(matcher.group(2));
                        int n3 = Integer.parseInt(matcher.group(3));
                        int n4 = Integer.parseInt(matcher.group(4));
                        int n5 = Integer.parseInt(matcher.group(5));
                        String string2 = matcher.group(6);
                        if (string2.equals("Java")) {
                            targetSourceLanguage = TargetSourceLanguage.JAVA;
                        } else {
                            assert (string2.equals("C"));
                            targetSourceLanguage = TargetSourceLanguage.C;
                        }
                        String string3 = matcher.group(7);
                        String string4 = matcher.group(8);
                        VariableRemapEntry variableRemapEntry = new VariableRemapEntry(n2, n3, n4, n5, targetSourceLanguage, string3, string4);
                        this.ventries.add(variableRemapEntry);
                    }
                } else if (n == 2 && (matcher = pattern3.matcher(string)).matches()) {
                    String string5 = matcher.group(1);
                    String string6 = matcher.group(2);
                    MethodRemapEntry methodRemapEntry = new MethodRemapEntry(string5, string6);
                    this.mentries.put(string6, methodRemapEntry);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }

        VariableRemapEntry lookUp(String string, int n) {
            for (VariableRemapEntry variableRemapEntry : this.ventries) {
                if (n < variableRemapEntry.startLine || n > variableRemapEntry.endLine || !variableRemapEntry.sourceVariableName.equals(string)) continue;
                return variableRemapEntry;
            }
            return null;
        }

        MethodRemapEntry lookupMethod(String string) {
            return this.mentries.get(string);
        }
    }

    static class MethodRemapEntry {
        final String sourceLanguageName;
        final String targetLanguageName;

        public MethodRemapEntry(String string, String string2) {
            this.sourceLanguageName = string;
            this.targetLanguageName = string2;
        }

        public String getSourceLanguageName() {
            return this.sourceLanguageName;
        }

        public String getTargetLanguageName() {
            return this.targetLanguageName;
        }
    }

    static class VariableRemapEntry {
        final int startLine;
        final int startColumn;
        final int endLine;
        final int endColumn;
        final TargetSourceLanguage targetLanguage;
        final String sourceVariableName;
        final String targetVariableName;

        VariableRemapEntry(int n, int n2, int n3, int n4, TargetSourceLanguage targetSourceLanguage, String string, String string2) {
            this.startLine = n;
            this.startColumn = n2;
            this.endLine = n3;
            this.endColumn = n4;
            this.targetLanguage = targetSourceLanguage;
            this.sourceVariableName = string;
            this.targetVariableName = string2;
        }

        String targetLanguageExpression() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.targetLanguage) {
                case JAVA: {
                    stringBuffer.append("this.").append(this.targetVariableName);
                    break;
                }
                case C: {
                    stringBuffer.append("pcEnv->").append(this.targetVariableName);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return stringBuffer.toString();
        }
    }

    static class SourceFileAndLine {
        private final String sourceFile;
        private final int sourceLine;

        SourceFileAndLine(String string, int n) {
            this.sourceFile = string;
            this.sourceLine = n;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public int getSourceLine() {
            return this.sourceLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TargetSourceLanguage {
        C,
        JAVA;

    }
}

