/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xtc.lang.blink.Blink;
import xtc.lang.blink.CallStack;
import xtc.lang.blink.Event;
import xtc.lang.blink.EventLoop;
import xtc.lang.blink.EventUtil;
import xtc.lang.blink.NativeDebugger;
import xtc.lang.blink.StdIOProcess;
import xtc.lang.blink.SymbolMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeGDB
extends StdIOProcess
implements NativeDebugger {
    private static final Pattern gdbBreakPointHitPattern = Pattern.compile("Breakpoint ([0-9]+), (.+) at ([^:]+):([0-9]+)\\n((.*)\\n)?\\(gdb\\) ");
    private static final Pattern gdbBinaryBreakPointHitPattern = Pattern.compile("Breakpoint ([0-9]+), (0x[0-9a-f]+) in (\\S+).+\\n\\(gdb\\) ");
    private static final Pattern bdaCBPFunctionAndArgumentPattern = Pattern.compile("bda_cbp \\(bptype=(.+), info=0x[0-9a-f]+ \"(.+)\"\\)");
    private static final Pattern gdbStepiCompletionPatternNoSource = Pattern.compile("0x[0-9a-f]+ in (.*Java.+) \\(\\) from (.+)\\n\\(gdb\\) ");
    private static final Pattern gdbStepCOmpletionPattern = Pattern.compile("GDB_STEP_COMPLETED\\n\\(gdb\\) ");
    private static final Pattern gdbStepiCompletionPatternWithSource = Pattern.compile("(Java.+) at (.+):(.+)\\n((?:.*)\\n)?\\(gdb\\) ");
    private static final Pattern gdbProgramNormalExit = Pattern.compile("Program exited normally.\\n\\(gdb\\) ");
    private static final String BDA_C2J_CALL_BREAKPOINT_VARIABLE = "c2j_call_breakpoint";
    private static final String BDA_C2J_RETURN_BREAKPOINT_VARIBLE = "c2j_return_breakpoint";
    private static final String BDA_CBP = "bda_cbp";
    private static final String BDA_BDA_J2C_CALL_VARIABLE = "bda_j2c_call";
    private static final String BDA_BDA_J2C_RETURN_VARIABLE = "bda_j2c_return";
    private final StringBuffer sbStdout = new StringBuffer();
    private GDBSymbolBreakPoint cbpBreakPoint;
    private GDBRawAddressBreakPoint j2cCallBreakPoint;
    private GDBRawAddressBreakPoint j2cReturnBreakPoint;
    private FlagVariableBreakPoint c2jCallBreakPoint;
    private FlagVariableBreakPoint c2jReturnBreakPoint;
    private boolean steppingMode = false;

    public NativeGDB(Blink blink, String string) {
        super(blink, string);
    }

    @Override
    public void attach(int n) throws IOException {
        final String[] stringArray = new String[]{"gdb", "-nw", "-quiet", "--pid", Integer.toString(n), "-ex", "echo blinkgdbready\\n"};
        EventLoop.subLoop(this.dbg, new EventLoop.Action(){

            public void execute() throws IOException {
                NativeGDB.this.begin(stringArray);
            }
        }, new EventUtil.RegExpReplyHandler(this, "blinkgdbready"));
        if (this.dbg.options.getVerboseLevel() >= 1) {
            this.dbg.out("gdb is initialized.");
        }
        this.raeGDB("set language c\n");
        this.raeGDB("set width 0\n");
        this.cbpBreakPoint = new GDBSymbolBreakPoint(BDA_CBP, true);
        this.raeGDB("handle SIGSEGV nostop \n");
        String string = this.raeGDB("p/x bda_j2c_call\n", "\\$\\d+ = (0x[0-9a-f]+)\\n\\(gdb\\) ").group(1);
        String string2 = this.raeGDB("p/x bda_j2c_return\n", "\\$\\d+ = (0x[0-9a-f]+)\\n\\(gdb\\) ").group(1);
        this.j2cCallBreakPoint = new GDBRawAddressBreakPoint(string, false);
        this.j2cReturnBreakPoint = new GDBRawAddressBreakPoint(string2, false);
        this.c2jCallBreakPoint = new FlagVariableBreakPoint(BDA_C2J_CALL_BREAKPOINT_VARIABLE);
        this.c2jReturnBreakPoint = new FlagVariableBreakPoint(BDA_C2J_RETURN_BREAKPOINT_VARIBLE);
        this.raeGDB("continue\n", "Continuing");
    }

    @Override
    public void callC2J() throws IOException {
        this.sendMessage("call bda_c2j()\n");
    }

    @Override
    public void step() throws IOException {
        this.sendMessage("step\necho \\nGDB_STEP_COMPLETED\\n\n");
    }

    @Override
    public void next() throws IOException {
        this.sendMessage("next\n");
    }

    @Override
    public void detach() throws IOException {
        this.sendMessage("detach\nquit\n");
    }

    @Override
    public void quit() throws IOException {
        this.sendMessage("kill\nquit\n");
    }

    @Override
    public void cont() throws IOException {
        this.sendMessage("continue\n");
    }

    @Override
    public String getJNIEnv() throws IOException {
        Matcher matcher = this.raeGDB("print/x bda_ensure_jnienv()\n", "\\$\\d+ = (0x[0-9a-f]+)\\n\\(gdb\\) ");
        return matcher.group(1);
    }

    @Override
    public String eval(CallStack.NativeCallFrame nativeCallFrame, String string) throws IOException {
        assert (this.dbg.jnienvValue != null);
        this.raeGDB("call bda_stitch_stack_frames(" + this.dbg.jnienvValue + "," + "$fp)\n");
        this.raeGDB("frame " + nativeCallFrame.getGdbIdentifier() + "\n");
        Matcher matcher = this.raeGDB("print " + string + "\n", "\\$\\d+ = (.+)\\n\\(gdb\\) ");
        String string2 = matcher.group(1);
        this.raeGDB("call bda_undo_stitch_stack_frames(" + this.dbg.jnienvValue + ")\n");
        return string2;
    }

    @Override
    public String eval(String string) throws IOException {
        Matcher matcher = this.raeGDB("print " + string + "\n", "\\$\\d+ = (.+)\\n\\(gdb\\) ");
        return matcher.group(1);
    }

    @Override
    public void callJavaDummy() throws IOException {
        this.sendMessage("call bda_dummy()\n");
    }

    @Override
    public void setVariable(CallStack.NativeCallFrame nativeCallFrame, String string, String string2) throws IOException {
        assert (this.dbg.jnienvValue != null);
        this.raeGDB("call bda_stitch_stack_frames(" + this.dbg.jnienvValue + "," + "$fp)\n");
        this.raeGDB("frame " + nativeCallFrame.getGdbIdentifier() + "\n");
        this.raeGDB("set " + string + " = " + string2 + "\n", "\\(gdb\\) ");
        this.raeGDB("call bda_undo_stitch_stack_frames(" + this.dbg.jnienvValue + ")\n");
    }

    @Override
    public int createBreakPoint(String string, int n) throws IOException {
        Matcher matcher = this.raeGDB("break " + string + ":" + n + "\n", "Breakpoint ([0-9]+) at");
        int n2 = Integer.valueOf(matcher.group(1));
        return n2;
    }

    @Override
    public int createRawAddressBreakPoint(String string) throws IOException {
        Matcher matcher = this.raeGDB("break *" + string + "\n", "Breakpoint ([0-9]+) at.*\\n\\(gdb\\) ");
        int n = Integer.valueOf(matcher.group(1));
        return n;
    }

    public int createSymbolBreakPoint(String string) throws IOException {
        Matcher matcher = this.raeGDB("break " + string + "\n", "Breakpoint ([0-9]+) at.*\\n\\(gdb\\) ");
        int n = Integer.valueOf(matcher.group(1));
        return n;
    }

    @Override
    public void deleteBreakPoint(int n) throws IOException {
        this.raeGDB("delete " + n + "\n");
    }

    private void enableBreakPoint(int n) throws IOException {
        this.raeGDB("enable " + n + "\n");
    }

    private void disableBreakPoint(int n) throws IOException {
        this.raeGDB("disable " + n + "\n");
    }

    @Override
    public void enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint languageTransitionBreakPoint) throws IOException {
        switch (languageTransitionBreakPoint) {
            case J2C_CALL: {
                this.j2cCallBreakPoint.enable();
                break;
            }
            case J2C_RETURN: {
                this.j2cReturnBreakPoint.enable();
                break;
            }
            case C2J_CALL: {
                this.c2jCallBreakPoint.enable();
                break;
            }
            case C2J_RETURN: {
                this.c2jReturnBreakPoint.enable();
            }
        }
    }

    @Override
    public void disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint languageTransitionBreakPoint) throws IOException {
        switch (languageTransitionBreakPoint) {
            case J2C_CALL: {
                this.j2cCallBreakPoint.disable();
                break;
            }
            case J2C_RETURN: {
                this.j2cReturnBreakPoint.disable();
                break;
            }
            case C2J_CALL: {
                this.c2jCallBreakPoint.disable();
                break;
            }
            case C2J_RETURN: {
                this.c2jReturnBreakPoint.disable();
            }
        }
    }

    @Override
    public String whatis(CallStack.NativeCallFrame nativeCallFrame, String string) throws IOException {
        assert (this.dbg.jnienvValue != null);
        this.raeGDB("call bda_stitch_stack_frames(" + this.dbg.jnienvValue + "," + "$fp)\n");
        this.raeGDB("frame " + nativeCallFrame.getGdbIdentifier() + "\n");
        Matcher matcher = this.raeGDB("whatis " + string + "\n", ".+ = (.+)\\n\\(gdb\\) ");
        this.raeGDB("call bda_undo_stitch_stack_frames(" + this.dbg.jnienvValue + ")\n");
        return matcher.group(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Event event) {
        assert (event.consumer == Event.EventConsumer.NativerDebugger);
        if (event instanceof J2CHitEvent) {
            try {
                NativeGDB nativeGDB = this;
                synchronized (nativeGDB) {
                    this.sendMessage("stepi\n");
                    this.steppingMode = true;
                }
            }
            catch (IOException iOException) {}
        } else if (event instanceof StepICompletionEventNoSource) {
            try {
                this.sendMessage("cont\n");
            }
            catch (IOException iOException) {}
        } else if (event instanceof StepICompletionEventWithSource) {
            StepICompletionEventWithSource stepICompletionEventWithSource = (StepICompletionEventWithSource)event;
            Event.LanguageTransitionEvent languageTransitionEvent = new Event.LanguageTransitionEvent(this, NativeDebugger.LanguageTransitionBreakPoint.J2C_CALL, new SymbolMapper.SourceFileAndLine(stepICompletionEventWithSource.file, stepICompletionEventWithSource.line), stepICompletionEventWithSource.srcLine);
            this.dbg.enqueEvent(languageTransitionEvent);
            NativeGDB nativeGDB = this;
            synchronized (nativeGDB) {
                this.steppingMode = false;
            }
        }
    }

    @Override
    protected void processMessageEvent(Event.RawTextMessageEvent rawTextMessageEvent) {
        this.sbStdout.append(new String(rawTextMessageEvent.getMessage()));
        this.checkBreakPointHitPattern();
        this.checkBinaryBreakPointHitPattern();
        this.checkStepICompletionPattern();
        this.checkStepCompletion();
        Matcher matcher = gdbProgramNormalExit.matcher(this.sbStdout);
        if (matcher.find()) {
            try {
                this.sendMessage("quit\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkBreakPointHitPattern() {
        Event.SubDebuggerEvent subDebuggerEvent;
        Matcher matcher = gdbBreakPointHitPattern.matcher(this.sbStdout);
        if (!matcher.find()) {
            return;
        }
        int n = matcher.end();
        String string = this.sbStdout.substring(n);
        int n2 = Integer.valueOf(matcher.group(1));
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        int n3 = Integer.valueOf(matcher.group(4));
        String string4 = matcher.group(6);
        this.sbStdout.setLength(0);
        this.sbStdout.append(string);
        if (n2 == this.cbpBreakPoint.getID()) {
            Matcher matcher2 = bdaCBPFunctionAndArgumentPattern.matcher(string2);
            if (!matcher2.matches()) assert (false) : "This should not happen";
            String string5 = matcher2.group(1);
            String string6 = matcher2.group(2);
            if (string5.equals("J2C_CALL") && string6.equals("DebuggerContextSwitch")) {
                subDebuggerEvent = new Event.J2CBreakPointHitEvent(this);
            } else if (string5.equals("C2J_CALL")) {
                subDebuggerEvent = new Event.LanguageTransitionEvent(this, NativeDebugger.LanguageTransitionBreakPoint.C2J_CALL, string6);
            } else if (string5.equals("C2J_RETURN")) {
                subDebuggerEvent = new Event.LanguageTransitionEvent(this, NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN, string6);
            } else {
                subDebuggerEvent = new Event.NativeBreakPointHitEvent((NativeDebugger)this, n2, string2, string3, n3, string4);
                this.dbg.err("can not recognize this internal break point event:" + subDebuggerEvent + "\n");
            }
        } else {
            subDebuggerEvent = new Event.NativeBreakPointHitEvent((NativeDebugger)this, n2, string2, string3, n3, string4);
        }
        this.dbg.enqueEvent(subDebuggerEvent);
    }

    private void checkBinaryBreakPointHitPattern() {
        Matcher matcher = gdbBinaryBreakPointHitPattern.matcher(this.sbStdout);
        if (!matcher.find()) {
            return;
        }
        int n = matcher.end();
        String string = this.sbStdout.substring(n);
        int n2 = Integer.valueOf(matcher.group(1));
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        this.sbStdout.setLength(0);
        this.sbStdout.append(string);
        Event event = n2 == this.j2cCallBreakPoint.getID() ? new J2CHitEvent(this) : (n2 == this.j2cReturnBreakPoint.getID() ? new Event.LanguageTransitionEvent(this, NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN, string3) : new Event.NativeBreakPointHitEvent(this, n2, string2, string3));
        this.dbg.enqueEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStepICompletionPattern() {
        String string;
        String string2;
        Object object = this;
        synchronized (object) {
            if (!this.steppingMode) {
                return;
            }
        }
        object = gdbStepiCompletionPatternNoSource.matcher(this.sbStdout);
        if (((Matcher)object).find()) {
            string2 = ((Matcher)object).group(1);
            string = this.sbStdout.substring(((Matcher)object).end());
            this.sbStdout.setLength(0);
            this.sbStdout.append(string);
            this.dbg.enqueEvent(new StepICompletionEventNoSource(this, string2));
        }
        if (((Matcher)(object = gdbStepiCompletionPatternWithSource.matcher(this.sbStdout))).find()) {
            string2 = ((Matcher)object).group(1);
            string = ((Matcher)object).group(2);
            int n = Integer.parseInt(((Matcher)object).group(3));
            String string3 = string2 + " at " + string + ":" + n + "\n" + ((Matcher)object).group(4);
            this.dbg.enqueEvent(new StepICompletionEventWithSource(this, string2, string, n, string3));
        }
    }

    private void checkStepCompletion() {
        Matcher matcher = gdbStepCOmpletionPattern.matcher(this.sbStdout);
        if (matcher.find()) {
            String string = this.sbStdout.substring(matcher.end());
            this.sbStdout.setLength(0);
            this.sbStdout.append(string);
            this.dbg.enqueEvent(new Event.NativeStepCompletionEvent(this));
        }
    }

    public LinkedList<CallStack.NativeCallFrame> getFrames() throws IOException {
        String string = this.j2cReturnBreakPoint.getAddress();
        String string2 = this.dbg.ensureJNIENV();
        this.raeGDB("call bda_stitch_stack_frames(" + string2 + "," + "$fp)\n");
        String string3 = this.raeGDB("where\n");
        this.raeGDB("call bda_undo_stitch_stack_frames(" + string2 + ")\n");
        Pattern pattern2 = Pattern.compile("^#([0-9]+)\\s+(0x[a-f0-9]+)?\\s+(in\\s+(\\S+)|(\\S+))\\s+\\(.*\\)\\s*(at (.+):([0-9]+))?(from \\S+)?$");
        LinkedList<CallStack.NativeCallFrame> linkedList = new LinkedList<CallStack.NativeCallFrame>();
        for (String string4 : string3.split("\n")) {
            CallStack.NativeCallFrame nativeCallFrame;
            boolean bl;
            Matcher matcher = pattern2.matcher(string4);
            if (!matcher.find()) continue;
            int n = Integer.valueOf(matcher.group(1));
            String string5 = matcher.group(2);
            String string6 = matcher.group(4) != null ? matcher.group(4) : matcher.group(5);
            String string7 = matcher.group(7);
            int n2 = matcher.group(8) == null ? -1 : Integer.parseInt(matcher.group(8));
            boolean bl2 = bl = string7 != null && string7.endsWith("Agent.c");
            if (string5 != null && string5.equals(string)) {
                bl = true;
                string6 = "the_jni_bottom";
                nativeCallFrame = new CallStack.NativeCallFrame(n, string7, n2, bl, string5, string6);
                linkedList.addLast(nativeCallFrame);
                break;
            }
            if (string6 != null && (string6.startsWith(BDA_CBP) || string6.startsWith("Java_xtc_lang_blink_Agent_j2c"))) continue;
            nativeCallFrame = new CallStack.NativeCallFrame(n, string7, n2, bl, string5, string6);
            linkedList.addLast(nativeCallFrame);
        }
        return linkedList;
    }

    @Override
    public List<CallStack.LocalVariable> getlocals(CallStack.NativeCallFrame nativeCallFrame) throws IOException {
        LinkedList<CallStack.LocalVariable> linkedList = new LinkedList<CallStack.LocalVariable>();
        this.raeGDB("call bda_stitch_stack_frames(" + this.dbg.jnienvValue + "," + "$fp)\n");
        this.raeGDB("frame " + nativeCallFrame.getGdbIdentifier() + "\n");
        String string = this.raeGDB("info args\n");
        String string2 = this.raeGDB("info locals\n");
        String string3 = string.concat(string2);
        Pattern pattern2 = Pattern.compile("^(.+) = (.+)$");
        for (String string4 : string3.split("\n")) {
            Matcher matcher = pattern2.matcher(string4);
            if (matcher.matches()) {
                String string5 = matcher.group(1);
                String string6 = matcher.group(2);
                linkedList.add(new CallStack.LocalVariable(string5, string6));
                continue;
            }
            if (string4.equals("No locals.")) continue;
            this.dbg.err("can not recognize this GDB output: " + string4 + "\n");
        }
        this.raeGDB("call bda_undo_stitch_stack_frames(" + this.dbg.jnienvValue + ")\n");
        return linkedList;
    }

    @Override
    public String list(CallStack.NativeCallFrame nativeCallFrame, int n) throws IOException {
        this.raeGDB("call bda_stitch_stack_frames(" + this.dbg.jnienvValue + "," + "$fp)\n");
        this.raeGDB("frame " + nativeCallFrame.getGdbIdentifier() + "\n");
        String string = this.raeGDB("list " + n + "\n");
        this.raeGDB("call bda_undo_stitch_stack_frames(" + this.dbg.jnienvValue + ")\n");
        return string;
    }

    @Override
    public String runCommand(String string) throws IOException {
        return this.raeGDB(string + "\n");
    }

    private Matcher raeGDB(final String string, String string2) throws IOException {
        return (Matcher)EventLoop.subLoop(this.dbg, new EventLoop.Action(){

            public void execute() throws IOException {
                NativeGDB.this.sendMessage(string);
            }
        }, new EventUtil.RegExpReplyHandler(this, string2));
    }

    private String raeGDB(String string) throws IOException {
        return this.raeGDB(string, "((.*\\n)*)\\(gdb\\) ").group(1);
    }

    private static class StepICompletionEventWithSource
    extends Event {
        private final String symbol;
        private final String file;
        private final int line;
        private final String srcLine;

        public StepICompletionEventWithSource(Event.BlinkEventSource blinkEventSource, String string, String string2, int n, String string3) {
            super(blinkEventSource, Event.EventConsumer.NativerDebugger);
            this.symbol = string;
            this.file = string2;
            this.line = n;
            this.srcLine = string3;
        }

        public String getName() {
            return "J2CHit";
        }
    }

    private static class StepICompletionEventNoSource
    extends Event {
        private final String symbol;

        StepICompletionEventNoSource(NativeGDB nativeGDB, String string) {
            super(nativeGDB, Event.EventConsumer.NativerDebugger);
            this.symbol = string;
        }

        public String getName() {
            return "J2CHit";
        }
    }

    private static class J2CHitEvent
    extends Event {
        J2CHitEvent(NativeGDB nativeGDB) {
            super(nativeGDB, Event.EventConsumer.NativerDebugger);
        }

        public String getName() {
            return "J2CHit";
        }
    }

    private class FlagVariableBreakPoint
    extends InternalBreakPoint {
        private final String bpVariable;

        FlagVariableBreakPoint(String string) {
            this.bpVariable = string;
        }

        void enable() throws IOException {
            if (this.enabled) {
                return;
            }
            NativeGDB.this.raeGDB("set " + this.bpVariable + " = 1\n", "\\(gdb\\) ");
            this.enabled = true;
        }

        void disable() throws IOException {
            if (!this.enabled) {
                return;
            }
            NativeGDB.this.raeGDB("set " + this.bpVariable + " = 0\n", "\\(gdb\\) ");
            this.enabled = false;
        }
    }

    private class GDBSymbolBreakPoint
    extends GDBBreakPoint {
        GDBSymbolBreakPoint(String string, boolean bl) throws IOException {
            this.id = NativeGDB.this.createSymbolBreakPoint(string);
            this.enabled = true;
            if (!bl) {
                this.disable();
            }
        }

        void enable() throws IOException {
            if (this.enabled) {
                return;
            }
            NativeGDB.this.enableBreakPoint(this.id);
            this.enabled = true;
        }

        void disable() throws IOException {
            if (!this.enabled) {
                return;
            }
            NativeGDB.this.disableBreakPoint(this.id);
            this.enabled = false;
        }
    }

    private class GDBRawAddressBreakPoint
    extends GDBBreakPoint {
        private final String address;

        GDBRawAddressBreakPoint(String string, boolean bl) throws IOException {
            this.id = NativeGDB.this.createRawAddressBreakPoint(string);
            this.enabled = true;
            this.address = string;
            if (!bl) {
                this.disable();
            }
        }

        void enable() throws IOException {
            if (this.enabled) {
                return;
            }
            NativeGDB.this.enableBreakPoint(this.id);
            this.enabled = true;
        }

        void disable() throws IOException {
            if (!this.enabled) {
                return;
            }
            NativeGDB.this.disableBreakPoint(this.id);
            this.enabled = false;
        }

        String getAddress() {
            return this.address;
        }
    }

    private abstract class GDBBreakPoint
    extends InternalBreakPoint {
        protected int id;

        private GDBBreakPoint() {
        }

        public int getID() {
            return this.id;
        }
    }

    private abstract class InternalBreakPoint {
        protected boolean enabled;

        abstract void enable() throws IOException;

        abstract void disable() throws IOException;

        boolean enabled() {
            return this.enabled;
        }
    }
}

