/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import xtc.lang.blink.Blink;
import xtc.lang.blink.CallStack;
import xtc.lang.blink.SymbolMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerContext {
    private final CallStack callStack;
    private int currentFrameNumber;
    private CallStack.ICallFrame currentFrame;
    private SymbolMapper.SourceFileAndLine currentLocation;

    DebuggerContext(CallStack callStack) {
        this.callStack = callStack;
        this.currentFrameNumber = 0;
        this.currentFrame = callStack.getFrame(this.currentFrameNumber);
        this.currentLocation = new SymbolMapper.SourceFileAndLine(this.currentFrame.getSourceFile(), this.currentFrame.getLineNumber());
    }

    public void showWhere(Blink blink) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.callStack.size();
        for (int i = this.currentFrameNumber; i < n; ++i) {
            CallStack.ICallFrame iCallFrame = this.callStack.getMixedFrameAt(i);
            stringBuffer.append("  [" + i + "] " + iCallFrame + "\n");
        }
        blink.out(stringBuffer.toString());
    }

    public void unWindStack(Blink blink, int n) {
        int n2 = this.currentFrameNumber + n;
        int n3 = this.callStack.size() - 1;
        if (n2 > n3) {
            int n4 = n3 - this.currentFrameNumber;
            blink.err("can not unwind the stack more than " + n4 + "\n");
            this.currentFrameNumber = n3;
        } else {
            this.currentFrameNumber = n2;
        }
        assert (this.currentFrameNumber >= 0 && this.currentFrameNumber < this.callStack.size());
        this.currentFrame = this.callStack.getFrame(this.currentFrameNumber);
        this.currentLocation = new SymbolMapper.SourceFileAndLine(this.currentFrame.getSourceFile(), this.currentFrame.getLineNumber());
    }

    public void windStack(Blink blink, int n) {
        int n2 = this.currentFrameNumber - n;
        int n3 = 0;
        if (n2 < n3) {
            int n4 = this.currentFrameNumber;
            blink.err("can not wind stack more than " + n4 + "\n");
            this.currentFrameNumber = n3;
        } else {
            this.currentFrameNumber = n2;
        }
        assert (this.currentFrameNumber >= 0 && this.currentFrameNumber < this.callStack.size());
        this.currentFrame = this.callStack.getFrame(this.currentFrameNumber);
        this.currentLocation = new SymbolMapper.SourceFileAndLine(this.currentFrame.getSourceFile(), this.currentFrame.getLineNumber());
    }

    public CallStack.ICallFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public void showLocals(Blink blink, SymbolMapper symbolMapper) throws IOException {
        Object object;
        List<CallStack.LocalVariable> list = null;
        CallStack.ICallFrame iCallFrame = this.currentFrame;
        if (iCallFrame instanceof CallStack.JavaCallFrame) {
            object = (CallStack.JavaCallFrame)iCallFrame;
            blink.ensureJDBContext();
            list = blink.jdb.getLocals((CallStack.JavaCallFrame)object);
        } else if (iCallFrame instanceof CallStack.NativeCallFrame) {
            object = (CallStack.NativeCallFrame)iCallFrame;
            blink.ensureGDBContext();
            list = blink.gdb.getlocals((CallStack.NativeCallFrame)object);
        } else if (iCallFrame instanceof CallStack.JeannieCallFrame) {
            list = this.getJeannieLocals((CallStack.JeannieCallFrame)iCallFrame, blink, symbolMapper);
        } else assert (false) : "can not deal with this call frame: " + iCallFrame + "\n";
        if (list.size() == 0) {
            blink.out("No Locals\n");
        } else {
            for (CallStack.LocalVariable localVariable : list) {
                blink.out(localVariable.getName() + " = " + localVariable.getValue() + "\n");
            }
        }
    }

    private List<CallStack.LocalVariable> getJeannieLocals(CallStack.JeannieCallFrame jeannieCallFrame, Blink blink, SymbolMapper symbolMapper) throws IOException {
        String string;
        String string2;
        LinkedList<CallStack.LocalVariable> linkedList = new LinkedList<CallStack.LocalVariable>();
        String string3 = jeannieCallFrame.getSourceFile();
        int n = jeannieCallFrame.getLineNumber();
        if (string3 == null || n <= 0) {
            blink.err("no source file and info avaiable.\n");
        }
        assert (string3 != null && n <= 0);
        List<SymbolMapper.VariableRemapEntry> list = symbolMapper.lookup(string3, n);
        blink.ensureJDBContext();
        for (SymbolMapper.VariableRemapEntry variableRemapEntry : list) {
            if (variableRemapEntry.targetLanguage != SymbolMapper.TargetSourceLanguage.JAVA) continue;
            string2 = variableRemapEntry.sourceVariableName;
            string = blink.jdb.eval(this.getCurrentJavaFrame(), variableRemapEntry.targetLanguageExpression());
            linkedList.add(new CallStack.LocalVariable(string2, string));
        }
        blink.ensureGDBContext();
        for (SymbolMapper.VariableRemapEntry variableRemapEntry : list) {
            if (variableRemapEntry.targetLanguage != SymbolMapper.TargetSourceLanguage.C) continue;
            string2 = variableRemapEntry.sourceVariableName;
            string = blink.gdb.eval(this.getCurrentNativeFrame(), variableRemapEntry.targetLanguageExpression());
            linkedList.add(new CallStack.LocalVariable(string2, string));
        }
        return linkedList;
    }

    public void showSourceCode(Blink blink) throws IOException {
        CallStack.MicroCallFrame microCallFrame = this.currentFrame.getTopMicroFrame();
        if (microCallFrame instanceof CallStack.JavaCallFrame) {
            blink.ensureJDBContext();
            String string = blink.jdb.list(this.getCurrentJavaFrame());
            blink.out(string);
        } else {
            assert (microCallFrame instanceof CallStack.NativeCallFrame);
            blink.ensureGDBContext();
            if (microCallFrame.lineNumber > 0) {
                String string = blink.gdb.list(this.getCurrentNativeFrame(), microCallFrame.lineNumber);
                blink.out(string);
            } else {
                blink.err("line number is not availble.\n");
            }
        }
    }

    private CallStack.JavaCallFrame getCurrentJavaFrame() throws IOException {
        CallStack.ICallFrame iCallFrame = this.getCurrentFrame();
        if (iCallFrame instanceof CallStack.JavaCallFrame) {
            return (CallStack.JavaCallFrame)iCallFrame;
        }
        if (iCallFrame instanceof CallStack.JeannieCallFrame) {
            CallStack.JeannieCallFrame jeannieCallFrame = (CallStack.JeannieCallFrame)iCallFrame;
            return jeannieCallFrame.getTopJavaFrame();
        }
        return null;
    }

    private CallStack.NativeCallFrame getCurrentNativeFrame() throws IOException {
        CallStack.ICallFrame iCallFrame = this.getCurrentFrame();
        if (iCallFrame instanceof CallStack.NativeCallFrame) {
            return (CallStack.NativeCallFrame)iCallFrame;
        }
        if (iCallFrame instanceof CallStack.JeannieCallFrame) {
            CallStack.JeannieCallFrame jeannieCallFrame = (CallStack.JeannieCallFrame)iCallFrame;
            return jeannieCallFrame.getTopNativeFrame();
        }
        return null;
    }

    public SymbolMapper.SourceFileAndLine getCurrentLocation() {
        return this.currentLocation;
    }
}

