/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import xtc.lang.blink.Blink;

public final class BreakPointManager {
    private final Blink dbg;
    private final HashMap<Integer, BlinkBreakPoint> userBreakPoints = new HashMap();
    private final HashMap<Integer, BlinkGDBBreakPoint> deferredUserGDBBreakPoints = new HashMap();
    private final HashMap<Integer, BlinkJDBBreakPoint> deferredUserJDBBreakPoints = new HashMap();
    private HashSet<BlinkBreakPoint> tempBreakPoints = new HashSet();
    private int nextUserBreakPointID = 1;
    private HashSet<BlinkBreakPoint> disabledBreakPointsDueToFreeze = new HashSet();

    BreakPointManager(Blink blink) {
        this.dbg = blink;
    }

    private synchronized int getNextUserBreakPointID() {
        return this.nextUserBreakPointID++;
    }

    BlinkSourceLineGDBBreakPoint addUserGDBBreakPoint(String string, int n) {
        int n2 = this.getNextUserBreakPointID();
        BlinkSourceLineGDBBreakPoint blinkSourceLineGDBBreakPoint = new BlinkSourceLineGDBBreakPoint(string, n);
        this.userBreakPoints.put(n2, blinkSourceLineGDBBreakPoint);
        if (!blinkSourceLineGDBBreakPoint.enable(this.dbg)) {
            this.dbg.out("the break point is delayed until the shared library loading\n");
            this.deferredUserGDBBreakPoints.put(n2, blinkSourceLineGDBBreakPoint);
        }
        return blinkSourceLineGDBBreakPoint;
    }

    BlinkSourceLineJDBBreakPoint addUserJavaBreakPoint(String string, int n) {
        int n2 = this.getNextUserBreakPointID();
        BlinkSourceLineJDBBreakPoint blinkSourceLineJDBBreakPoint = new BlinkSourceLineJDBBreakPoint(string, n);
        this.userBreakPoints.put(n2, blinkSourceLineJDBBreakPoint);
        if (!blinkSourceLineJDBBreakPoint.enable(this.dbg)) {
            this.dbg.out("the break point is delayed \n");
            this.deferredUserJDBBreakPoints.put(n2, blinkSourceLineJDBBreakPoint);
        }
        return blinkSourceLineJDBBreakPoint;
    }

    BlinkJDBMethodEntryBreakPoint addUserJavaBreakPoint(String string) {
        int n = this.getNextUserBreakPointID();
        BlinkJDBMethodEntryBreakPoint blinkJDBMethodEntryBreakPoint = new BlinkJDBMethodEntryBreakPoint(string);
        this.userBreakPoints.put(n, blinkJDBMethodEntryBreakPoint);
        if (!blinkJDBMethodEntryBreakPoint.enable(this.dbg)) {
            this.dbg.out("the break point is delayed\n");
            this.deferredUserJDBBreakPoints.put(n, blinkJDBMethodEntryBreakPoint);
        }
        return blinkJDBMethodEntryBreakPoint;
    }

    void showUserBreakPointList() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.addAll(this.userBreakPoints.keySet());
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : treeSet) {
            BlinkBreakPoint blinkBreakPoint = this.userBreakPoints.get(n);
            stringBuilder.append(n).append("  ");
            stringBuilder.append(blinkBreakPoint.toString()).append('\n');
        }
        this.dbg.out(stringBuilder.toString());
    }

    void deleteUserBreakPoint(int n) {
        if (!this.userBreakPoints.containsKey(n)) {
            this.dbg.err("not valid break point id -" + n);
            return;
        }
        if (this.deferredUserGDBBreakPoints.containsKey(n)) {
            this.deferredUserGDBBreakPoints.remove(n);
        }
        if (this.deferredUserJDBBreakPoints.containsKey(n)) {
            this.deferredUserJDBBreakPoints.remove(n);
        }
        if (this.userBreakPoints.containsKey(n)) {
            BlinkBreakPoint blinkBreakPoint = this.userBreakPoints.get(n);
            blinkBreakPoint.disable(this.dbg);
            this.userBreakPoints.remove(n);
        }
    }

    boolean hasDeferredGDBBreakPoint() {
        return this.deferredUserGDBBreakPoints.size() > 0;
    }

    void HandleDeferredBreakPoint() {
        assert (this.dbg.getDebugControlStatus() != Blink.DebugerControlStatus.NONE);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n : this.deferredUserGDBBreakPoints.keySet()) {
            BlinkGDBBreakPoint blinkGDBBreakPoint = this.deferredUserGDBBreakPoints.get(n);
            if (!blinkGDBBreakPoint.enable(this.dbg)) continue;
            treeSet.add(n);
        }
        for (Integer n : treeSet) {
            this.deferredUserGDBBreakPoints.remove(n);
        }
    }

    void setTempJCBBreakPoint(String string, int n) {
        BlinkSourceLineJDBBreakPoint blinkSourceLineJDBBreakPoint = new BlinkSourceLineJDBBreakPoint(string, n);
        if (this.tempBreakPoints.contains(blinkSourceLineJDBBreakPoint)) {
            return;
        }
        ((BlinkBreakPoint)blinkSourceLineJDBBreakPoint).enable(this.dbg);
        this.tempBreakPoints.add(blinkSourceLineJDBBreakPoint);
    }

    void removeTempJDBBreakPoints() {
        for (BlinkBreakPoint blinkBreakPoint : this.tempBreakPoints) {
            blinkBreakPoint.disable(this.dbg);
        }
        this.tempBreakPoints.clear();
    }

    public void freezeActiveBreakPoints() {
        for (BlinkBreakPoint blinkBreakPoint : this.userBreakPoints.values()) {
            BreakPointState breakPointState = blinkBreakPoint.getState();
            if (breakPointState != BreakPointState.ENABLED) continue;
            if (blinkBreakPoint.disable(this.dbg)) {
                this.disabledBreakPointsDueToFreeze.add(blinkBreakPoint);
                continue;
            }
            this.dbg.err("could not freeze :  " + blinkBreakPoint + "\n");
        }
    }

    public void unfreezeAllBreakpoints() {
        HashSet<BlinkGDBBreakPoint> hashSet = new HashSet<BlinkGDBBreakPoint>();
        HashSet<BlinkJDBBreakPoint> hashSet2 = new HashSet<BlinkJDBBreakPoint>();
        for (BlinkBreakPoint blinkBreakPoint : this.disabledBreakPointsDueToFreeze) {
            if (blinkBreakPoint instanceof BlinkGDBBreakPoint) {
                hashSet.add((BlinkGDBBreakPoint)blinkBreakPoint);
                continue;
            }
            if (!(blinkBreakPoint instanceof BlinkJDBBreakPoint)) continue;
            hashSet2.add((BlinkJDBBreakPoint)blinkBreakPoint);
        }
        for (BlinkJDBBreakPoint blinkJDBBreakPoint : hashSet2) {
            blinkJDBBreakPoint.enable(this.dbg);
        }
        for (BlinkGDBBreakPoint blinkGDBBreakPoint : hashSet) {
            blinkGDBBreakPoint.enable(this.dbg);
        }
        this.disabledBreakPointsDueToFreeze.clear();
    }

    static class BlinkJDBMethodEntryBreakPoint
    extends BlinkJDBBreakPoint {
        private final String classAndmethod;

        public BlinkJDBMethodEntryBreakPoint(String string) {
            this.classAndmethod = string;
        }

        public String getClassAndmethod() {
            return this.classAndmethod;
        }

        boolean enable(Blink blink) {
            switch (this.mdbState) {
                case DISABLED: {
                    if (!blink.ensureJDBContext()) {
                        return false;
                    }
                    try {
                        blink.jdb.setBreakPoint(this.classAndmethod);
                    }
                    catch (IOException iOException) {
                        blink.err("could not set the break point.");
                        return false;
                    }
                    this.mdbState = BreakPointState.ENABLED;
                    return true;
                }
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }

        boolean disable(Blink blink) {
            switch (this.mdbState) {
                case DISABLED: {
                    return true;
                }
                case ENABLED: {
                    try {
                        if (!blink.ensureJDBContext()) {
                            return false;
                        }
                        blink.jdb.clearBreakPoint(this.classAndmethod);
                    }
                    catch (IOException iOException) {
                        blink.err("cound not resent the break point");
                        return false;
                    }
                    this.mdbState = BreakPointState.DISABLED;
                    return true;
                }
            }
            return false;
        }
    }

    static class BlinkSourceLineJDBBreakPoint
    extends BlinkJDBBreakPoint {
        final String className;
        final int sourceLineNumber;

        BlinkSourceLineJDBBreakPoint(String string, int n) {
            this.className = string;
            this.sourceLineNumber = n;
        }

        String getClassName() {
            return this.className;
        }

        int getSourceLineNumber() {
            return this.sourceLineNumber;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BlinkSourceLineGDBBreakPoint)) {
                return false;
            }
            BlinkSourceLineJDBBreakPoint blinkSourceLineJDBBreakPoint = (BlinkSourceLineJDBBreakPoint)object;
            return this == blinkSourceLineJDBBreakPoint || this.className.equals(blinkSourceLineJDBBreakPoint.className) && this.sourceLineNumber == blinkSourceLineJDBBreakPoint.sourceLineNumber;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ").append("java").append(" ");
            stringBuilder.append(this.className).append(":").append(this.sourceLineNumber);
            return stringBuilder.toString();
        }

        boolean enable(Blink blink) {
            switch (this.mdbState) {
                case DISABLED: {
                    if (!blink.ensureJDBContext()) {
                        return false;
                    }
                    try {
                        blink.jdb.setBreakPoint(this.className, this.sourceLineNumber);
                    }
                    catch (IOException iOException) {
                        blink.err("could not set the break point.");
                        return false;
                    }
                    this.mdbState = BreakPointState.ENABLED;
                    return true;
                }
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }

        boolean disable(Blink blink) {
            switch (this.mdbState) {
                case DISABLED: {
                    return true;
                }
                case ENABLED: {
                    try {
                        if (!blink.ensureJDBContext()) {
                            return false;
                        }
                        blink.jdb.clearBreakPoint(this.className, this.sourceLineNumber);
                    }
                    catch (IOException iOException) {
                        blink.err("cound not resent the break point");
                        return false;
                    }
                    this.mdbState = BreakPointState.DISABLED;
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class BlinkJDBBreakPoint
    extends BlinkBreakPoint {
        BreakPointState mdbState = BreakPointState.DISABLED;

        BlinkJDBBreakPoint() {
        }

        BreakPointState getState() {
            return this.mdbState;
        }
    }

    static class BlinkAddressGDBBreakPoint
    extends BlinkGDBBreakPoint {
        final String address;

        BlinkAddressGDBBreakPoint(String string) {
            this.address = string;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BlinkAddressGDBBreakPoint)) {
                return false;
            }
            BlinkAddressGDBBreakPoint blinkAddressGDBBreakPoint = (BlinkAddressGDBBreakPoint)object;
            return this == blinkAddressGDBBreakPoint || this.address.equals(blinkAddressGDBBreakPoint.address);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("native").append(" ");
            stringBuilder.append(this.address);
            return stringBuilder.toString();
        }

        boolean enable(Blink blink) {
            switch (this.mdbState) {
                case ENABLED: {
                    return true;
                }
                case DISABLED: {
                    if (!blink.ensureGDBContext()) {
                        return false;
                    }
                    try {
                        int n = blink.gdb.createRawAddressBreakPoint(this.address);
                        this.setGdbBreakPointIdentifier(n);
                    }
                    catch (IOException iOException) {
                        blink.err("could not set the break point.");
                        return false;
                    }
                    this.mdbState = BreakPointState.ENABLED;
                    return true;
                }
            }
            assert (false) : "not reachable here";
            return false;
        }
    }

    static class BlinkSourceLineGDBBreakPoint
    extends BlinkGDBBreakPoint {
        final String sourceFileName;
        final int sourceLineNumber;

        BlinkSourceLineGDBBreakPoint(String string, int n) {
            this.sourceFileName = string;
            this.sourceLineNumber = n;
        }

        String getSourceFileName() {
            return this.sourceFileName;
        }

        int getSourceLineNumber() {
            return this.sourceLineNumber;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BlinkSourceLineGDBBreakPoint)) {
                return false;
            }
            BlinkSourceLineGDBBreakPoint blinkSourceLineGDBBreakPoint = (BlinkSourceLineGDBBreakPoint)object;
            return this == blinkSourceLineGDBBreakPoint || this.sourceFileName.equals(blinkSourceLineGDBBreakPoint.sourceFileName) && this.sourceLineNumber == blinkSourceLineGDBBreakPoint.sourceLineNumber;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("native").append(" ");
            stringBuilder.append(this.sourceFileName).append(":").append(this.sourceLineNumber);
            return stringBuilder.toString();
        }

        boolean enable(Blink blink) {
            switch (this.mdbState) {
                case ENABLED: {
                    return true;
                }
                case DISABLED: {
                    if (!blink.ensureGDBContext()) {
                        return false;
                    }
                    try {
                        int n = blink.gdb.createBreakPoint(this.sourceFileName, this.sourceLineNumber);
                        this.setGdbBreakPointIdentifier(n);
                        this.mdbState = BreakPointState.ENABLED;
                    }
                    catch (IOException iOException) {
                        blink.err("could not set the break point.");
                        return false;
                    }
                    return true;
                }
            }
            assert (false) : "not reachable.";
            return false;
        }
    }

    static abstract class BlinkGDBBreakPoint
    extends BlinkBreakPoint {
        BreakPointState mdbState = BreakPointState.DISABLED;
        private int gdbBPIdentifier;

        BlinkGDBBreakPoint() {
        }

        public int getGdbBreakPointIdentifier() {
            return this.gdbBPIdentifier;
        }

        public void setGdbBreakPointIdentifier(int n) {
            this.gdbBPIdentifier = n;
        }

        public BreakPointState getState() {
            return this.mdbState;
        }

        boolean disable(Blink blink) {
            switch (this.mdbState) {
                case DISABLED: {
                    return true;
                }
                case ENABLED: {
                    if (!blink.ensureGDBContext()) {
                        blink.err("counld not disable break point: " + this + "\n");
                        return false;
                    }
                    try {
                        blink.gdb.deleteBreakPoint(this.getGdbBreakPointIdentifier());
                    }
                    catch (IOException iOException) {
                        blink.err("cound not resent the break point");
                        return false;
                    }
                    this.mdbState = BreakPointState.DISABLED;
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class BlinkBreakPoint {
        BlinkBreakPoint() {
        }

        abstract boolean enable(Blink var1);

        abstract boolean disable(Blink var1);

        abstract BreakPointState getState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakPointState {
        ENABLED,
        DISABLED;

    }
}

