/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xtc.lang.blink.Agent;
import xtc.lang.blink.AgentVariable;
import xtc.lang.blink.BreakPointManager;
import xtc.lang.blink.CallStack;
import xtc.lang.blink.CommandLineInterface;
import xtc.lang.blink.DebugeeJVM;
import xtc.lang.blink.Event;
import xtc.lang.blink.EventLoop;
import xtc.lang.blink.EventUtil;
import xtc.lang.blink.InternalOption;
import xtc.lang.blink.JavaDebugger;
import xtc.lang.blink.NativeDebugger;
import xtc.lang.blink.NativeGDB;
import xtc.lang.blink.SymbolMapper;

public class Blink {
    private final String mainClass;
    private final String jvmArguments;
    private final String jdbArguments;
    private final CommandLineInterface user;
    final DebugeeJVM jvm;
    final JavaDebugger jdb;
    final NativeDebugger gdb;
    private final LinkedBlockingQueue<Event> eventQueue = new LinkedBlockingQueue();
    final EventLoop eventLoop;
    private DebugerControlStatus debugControl = DebugerControlStatus.NONE;
    private SymbolMapper.SourceFileAndLine breakPointLocation;
    private boolean gdbAttached = false;
    final BreakPointManager breakpointManager = new BreakPointManager(this);
    final InternalOption options;
    String jnienvValue;

    private static void usage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string).append("\n\n");
        }
        String string2 = "Usage: xtc.lang.jennie.Blink [options] CLASS [arguments]\nBlink options:\n\t-help\n\noptions forwarded to JDB:\n\t-sourcepath                <directories separated by \":\">\n\t-dbgtrace [flags]\n\noptions forwarded to debuggee JVM:\n\t-v -verbose[:class|gc|jni]\n\t-D<name>=<value>           system property\n\t-classpath                 <directories separated by \":\">\n\t-X<option>\n\nenvironment variables:\n\tJAVA_DEV_ROOT                xtc installation path\n\tCLASSPATH                    class path\n\tJAVA_HOME                    JDK installation path\n";
        stringBuffer.append(string2);
        System.out.println(stringBuffer.toString());
        System.exit(-1);
    }

    final void help() {
        String string = "\nhelp               print help\nexit               exit the Blink debugger\nrun                start the program run\n\nbreak [file:line]             add a break point e.g.) break Main.jni:9\nstop at <classid>:<line>      add a break point  e.g.) stop at Main:15\nstop in <classid>:<method>    add a break point  e.g.) stop in Main:main\ninfo break                    list break points\ndelete [n]                    delete a break/watch point with its id [n].\n\nwhere                     dump stack trace\nup [n]                    select n frames up\ndown [n]                  select n frames down\nlist                      print source code.\nlocals                    print local variables in selected frame\nprint <jexpr>             print Jeannie expression\n\ncontinue                  coninue running.\nstep                      execute until another line reached\nnext                      execute the next line, including function calls\n";
        this.out(string);
    }

    public static void main(String[] stringArray) {
        InternalOption internalOption = new InternalOption();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        String[] stringArray2 = null;
        StringBuffer stringBuffer6 = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringArray2 == null) {
                Object object;
                if (stringArray3.equals("-help")) {
                    Blink.usage("");
                    continue;
                }
                if (stringArray3.equals("-bv") || stringArray3.equals("-bverbose")) {
                    internalOption.moreVerbose();
                    continue;
                }
                if (stringArray3.equals("-bacp")) {
                    if (i + 1 >= stringArray.length) {
                        Blink.usage("Please, spcifify blink agent classpath ");
                    }
                    object = stringArray[++i];
                    internalOption.setAgentClassPath((String)object);
                    continue;
                }
                if (stringArray3.equals("-balp")) {
                    if (i + 1 >= stringArray.length) {
                        Blink.usage("Please, spcifify blink agent library path");
                    }
                    object = stringArray[++i];
                    internalOption.setAgentLibrarypath((String)object);
                    continue;
                }
                if (stringArray3.equals("-ex")) {
                    if (i + 1 >= stringArray.length) {
                        Blink.usage("Please, specify a Blink command after -ex");
                    }
                    object = "";
                    ++i;
                    while (i < stringArray.length && !stringArray[i].equals("-xe")) {
                        object = (String)object + " " + stringArray[i];
                        ++i;
                    }
                    if (i >= stringArray.length) {
                        Blink.usage("Please, specify -xe to end the Blink initial command.");
                    }
                    internalOption.addInitialBlinkCommand((String)object);
                    continue;
                }
                if (Pattern.matches("-l[0-9]+", (CharSequence)stringArray3)) {
                    object = Pattern.compile("-l([0-9]+)").matcher((CharSequence)stringArray3);
                    if (!((Matcher)object).matches()) assert (false) : "this must not be reachable.";
                    int n = Integer.valueOf(((Matcher)object).group(1));
                    internalOption.setLogSizeMicroDebuggerOutput(n);
                    continue;
                }
                if (stringArray3.equals("-sourcepath")) {
                    if (i + 1 >= stringArray.length) {
                        Blink.usage("Please, specify path after -sourcepath.");
                    }
                    object = stringArray[++i];
                    stringBuffer4.append(' ').append((String)stringArray3).append(' ').append((String)object);
                    continue;
                }
                if (stringArray3.equals("-dbgtrace")) {
                    stringBuffer4.append(' ').append((String)stringArray3);
                    continue;
                }
                if (stringArray3.equals("-classpath")) {
                    if (i + 1 >= stringArray.length) {
                        Blink.usage("Please, specify path after -classpath.");
                    }
                    object = stringArray[++i];
                    stringBuffer2.append((String)object);
                    continue;
                }
                if (stringArray3.equals("-v") || Pattern.matches("-verbose(:(class|gc|jni))?", (CharSequence)stringArray3)) {
                    stringBuffer.append(' ').append((String)stringArray3);
                    continue;
                }
                if (stringArray3.matches("-X.+")) {
                    stringBuffer.append(' ').append((String)stringArray3);
                    continue;
                }
                if (stringArray3.matches("-D[^=]+=.*")) {
                    object = Pattern.compile("-D([^=]+)=(.*)").matcher((CharSequence)stringArray3);
                    if (!((Matcher)object).matches()) assert (false) : "not reachable";
                    String string = ((Matcher)object).group(1);
                    String string2 = ((Matcher)object).group(2);
                    if (string.equals("java.library.path")) {
                        if (stringBuffer3.length() > 0) {
                            stringBuffer3.append(File.pathSeparatorChar);
                        }
                        stringBuffer3.append(string2);
                        continue;
                    }
                    stringBuffer.append(' ').append((String)stringArray3);
                    continue;
                }
                stringArray2 = stringArray3;
                continue;
            }
            stringBuffer6.append(' ').append((String)stringArray3);
        }
        if (stringArray2 == null) {
            Blink.usage("Please, specify the main CLASS name.");
        }
        if (internalOption.getAgentClassPath() != null) {
            Blink.ensureAgentClassFiles(internalOption.getAgentClassPath());
        } else {
            internalOption.setAgentClassPath(Blink.ensureAgentClassPathFromEnv());
        }
        if (internalOption.getAgentLibrarypath() != null) {
            Blink.ensureAgentLibrary(internalOption.getAgentLibrarypath());
        } else {
            internalOption.setAgentLibrarypath(Blink.ensureAgentLibraryPathFromEnv());
        }
        stringBuffer.append(" -classpath .");
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append(internalOption.getAgentClassPath());
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append(" -Djava.library.path=");
        stringBuffer.append(internalOption.getAgentLibrarypath());
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append('.');
        if (stringBuffer3.length() > 0) {
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(stringBuffer3);
        }
        stringBuffer.append(' ').append((String)stringArray2);
        stringBuffer.append(' ').append(stringBuffer6);
        if (internalOption.getVerboseLevel() >= 1) {
            StringBuffer stringBuffer7 = new StringBuffer();
            stringBuffer7.append("xtc.lang.blink.Debugger");
            for (String string2 : stringArray) {
                stringBuffer7.append(' ').append(string2);
            }
            System.out.println("running: " + stringBuffer7 + "\n");
        }
        Blink.ensureJDB();
        Blink.esureGDB();
        try {
            Blink blink = new Blink((String)stringArray2, stringBuffer.toString(), stringBuffer4.toString(), stringBuffer5.toString(), internalOption);
            blink.startSession();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static String ensureJavaDevRoot() {
        String string = System.getenv("JAVA_DEV_ROOT");
        if (string == null || string.equals("")) {
            Blink.usage("JAVA_DEV_ROOT environment variable is not set");
            assert (false) : "not reachable";
        }
        if (!new File(string).isDirectory()) {
            Blink.usage("JAVA_DEV_ROOT(=" + string + ") is expected to be directory");
            assert (false) : "not reachable";
        }
        return string;
    }

    private static String ensureAgentClassPathFromEnv() {
        String string = Blink.ensureJavaDevRoot();
        String string2 = string + File.separator + "classes";
        if (!new File(string2).isDirectory()) {
            Blink.usage(string2 + " inside JAVA_DEV_ROOT(=" + string + ") is expected to be directory");
            assert (false) : "not reachable";
        }
        return string2;
    }

    private static void ensureAgentClassFiles(String string) {
        if (new File(string).isDirectory()) {
            String string2 = Agent.class.getName();
            String string3 = string + File.separator + string2.replace('.', File.separatorChar);
            if (new File(string3).isFile()) {
                Blink.usage("can not find agent class file: " + string3);
            }
            String string4 = AgentVariable.class.getName();
            String string5 = string + File.separator + string4.replace('.', File.separatorChar);
            if (new File(string3).isFile()) {
                Blink.usage("can not find agent class file: " + string5);
            }
        } else {
            Blink.usage("The debug agent's class path (=" + string + " is expected to be directory.");
        }
    }

    private static String ensureAgentLibraryPathFromEnv() {
        String string = Blink.ensureJavaDevRoot();
        String string2 = string + File.separator + "bin";
        Blink.ensureAgentLibrary(string2);
        return string2;
    }

    private static void ensureAgentLibrary(String string) {
        assert (string != null);
        String string2 = string + File.separator + "Agent.dll";
        String string3 = string + File.separator + "libAgent.so";
        if (!new File(string2).exists() && !new File(string3).exists()) {
            Blink.usage("can not find Blink agent native library in " + string);
        }
    }

    private static void ensureJDB() {
        try {
            Process process = Runtime.getRuntime().exec("jdb -version");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            if (string.startsWith("This is jdb version")) {
                int n = process.waitFor();
                bufferedReader.close();
                if (n != 0) {
                    Blink.usage("can not correctly access jdb in the current environment.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Blink.usage("can not correctly access jdb in the current environment.");
        }
        catch (IOException iOException) {
            Blink.usage("can not correctly access jdb in the current environment.");
        }
    }

    private static void esureGDB() {
        try {
            Process process = Runtime.getRuntime().exec("gdb -version");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            if (string.startsWith("GNU gdb")) {
                int n = process.waitFor();
                bufferedReader.close();
                if (n != 0) {
                    Blink.usage("can not correctly access gdb in the current environment.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Blink.usage("can not correctly access gdb in the current environment.");
        }
        catch (IOException iOException) {
            Blink.usage("can not correctly access gdb in the current environment.");
        }
    }

    private Blink(String string, String string2, String string3, String string4, InternalOption internalOption) {
        this.mainClass = string;
        this.jvmArguments = string2;
        this.jdbArguments = string3;
        this.options = internalOption;
        this.user = new CommandLineInterface(this);
        this.jvm = new DebugeeJVM(this, "jvm");
        this.jdb = new JavaDebugger(this, "jdb");
        this.gdb = new NativeGDB(this, "gdb");
        this.eventLoop = new EventLoop(this);
    }

    private void startSession() throws IOException {
        final String string = (String)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.jdb.startListening(Blink.this.jdbArguments);
            }
        }, new EventLoop.ReplyHandler(){

            boolean dispatch(Event event) {
                if (event instanceof JavaDebugger.ListenAddressEvent && event.getSource() == Blink.this.jdb) {
                    JavaDebugger.ListenAddressEvent listenAddressEvent = (JavaDebugger.ListenAddressEvent)event;
                    this.setResult(listenAddressEvent.getAddress());
                    return true;
                }
                return false;
            }
        });
        EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.jvm.beginDebugSession(Blink.this.jvmArguments, string);
            }
        }, new EventLoop.ReplyHandler(){

            boolean dispatch(Event event) {
                if (event instanceof JavaDebugger.InitializedEvent && event.getSource() == Blink.this.jdb) {
                    this.setResult(new Boolean(true));
                    return true;
                }
                return false;
            }
        });
        this.jdb.setLoadLibraryEvent();
        this.out("Blink a Java/C mixed language debugger.\n");
        this.changeDebugControlStatus(DebugerControlStatus.JDB);
        for (String string2 : this.options.getInitialBlinkCommandList()) {
            this.eventLoop.executeBlinkCommand(string2);
        }
        this.user.start();
        this.showPrompt();
        this.eventLoop.main();
    }

    void showPrompt() {
        switch (this.debugControl) {
            case JDB: {
                this.out("(bdb-j) ");
                break;
            }
            case GDB: {
                this.out("(bdb-c) ");
                break;
            }
            case JDB_IN_GDB: {
                this.out("(bdb-c2j) ");
                break;
            }
            case GDB_IN_JDB: {
                this.out("(bdb-j2c) ");
            }
        }
    }

    void run() {
        try {
            assert (this.getDebugControlStatus() == DebugerControlStatus.JDB);
            this.jdb.run();
            this.changeDebugControlStatus(DebugerControlStatus.NONE);
        }
        catch (IOException iOException) {
            this.err("could not successfully run the application");
        }
    }

    boolean initj() {
        int n;
        if (this.gdbAttached) {
            this.err("the initj was run before.");
            return true;
        }
        assert (this.debugControl == DebugerControlStatus.JDB);
        try {
            if (!this.jdb.initAgent()) {
                return false;
            }
        }
        catch (IOException iOException) {
            this.err("failed in executing initj for jdb\n");
            return false;
        }
        try {
            n = this.jdb.getJVMProcessID();
        }
        catch (IOException iOException) {
            this.err("failed in getting debugged process id\n");
            return false;
        }
        try {
            this.gdb.attach(n);
            this.gdbAttached = true;
        }
        catch (IOException iOException) {
            this.err("could not attach the native code debugger.\n");
            return false;
        }
        this.ensurePureContext();
        assert (this.getDebugControlStatus() == DebugerControlStatus.JDB);
        return true;
    }

    void j2c() {
        if (!this.IsNativeDebuggerAttached()) {
            this.err("please run initj before j2c\n");
            return;
        }
        if (this.options.getVerboseLevel() >= 1) {
            this.out("switching to gdb mode due to j2c command.\n");
        }
        try {
            EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

                public void execute() throws IOException {
                    Blink.this.jdb.j2c();
                }
            }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.J2CBreakPointHitEventHandler(this.gdb), new EventUtil.LanguageTransitionHandler(this.gdb)));
            if (blinkEventReplyHandler instanceof EventUtil.LanguageTransitionHandler) {
                EventLoop.subLoop(this, new EventLoop.Action(){

                    public void execute() throws IOException {
                        Blink.this.gdb.cont();
                    }
                }, new EventUtil.J2CBreakPointHitEventHandler(this.gdb));
            }
            this.changeDebugControlStatus(DebugerControlStatus.GDB_IN_JDB);
        }
        catch (IOException iOException) {
            this.err("failed in executing j2c\n");
            iOException.printStackTrace();
        }
    }

    void c2j() {
        if (!this.IsNativeDebuggerAttached()) {
            this.err("please run initj before c2j\n");
            return;
        }
        if (this.options.getVerboseLevel() >= 1) {
            this.out("switching to jdb mode due to c2j command,\n");
        }
        try {
            EventLoop.subLoop(this, new EventLoop.Action(){

                public void execute() throws IOException {
                    Blink.this.gdb.callC2J();
                }
            }, new EventUtil.JavaBreakPointHandler(this.jdb));
            this.changeDebugControlStatus(DebugerControlStatus.JDB_IN_GDB);
        }
        catch (IOException iOException) {
            this.err("failed in executing c2j\n");
            iOException.printStackTrace();
        }
    }

    void jret() {
        if (!this.IsNativeDebuggerAttached()) {
            this.err("please run initj before jret\n");
            return;
        }
        switch (this.getDebugControlStatus()) {
            case JDB: 
            case GDB: 
            case NONE: {
                this.err("jret is for jdb and gdb nesting.");
                break;
            }
            case JDB_IN_GDB: {
                if (this.options.getVerboseLevel() >= 1) {
                    this.out("return to gdb\n");
                }
                try {
                    EventLoop.subLoop(this, new EventLoop.Action(){

                        public void execute() throws IOException {
                            Blink.this.jdb.cont();
                        }
                    }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.RegExpReplyHandler(this.gdb, "\\$[0-9]+ = 1\\n(.*\\n)*\\(gdb\\) "), new EventUtil.LanguageTransitionHandler(this.gdb)));
                    this.changeDebugControlStatus(DebugerControlStatus.GDB);
                }
                catch (IOException iOException) {
                    this.err("failed in resuming jdb control nested in the gdb\n");
                }
                break;
            }
            case GDB_IN_JDB: {
                if (this.options.getVerboseLevel() >= 1) {
                    this.out("returning to jdb\n");
                }
                try {
                    EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

                        public void execute() throws IOException {
                            Blink.this.gdb.cont();
                        }
                    }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.J2CCompletionEventHandler(this.jdb), new EventUtil.LanguageTransitionHandler(this.gdb)));
                    if (blinkEventReplyHandler.getSourceFilter() == this.gdb) {
                        EventLoop.subLoop(this, new EventLoop.Action(){

                            public void execute() throws IOException {
                                Blink.this.gdb.cont();
                            }
                        }, new EventUtil.J2CCompletionEventHandler(this.jdb));
                    }
                    this.changeDebugControlStatus(DebugerControlStatus.JDB);
                }
                catch (IOException iOException) {
                    this.err("failed in resuming gdb control nested in the jdb\n");
                }
                break;
            }
        }
    }

    void cont() {
        assert (this.debugControl != DebugerControlStatus.NONE);
        this.jnienvValue = null;
        switch (this.getDebugControlStatus()) {
            case JDB: 
            case GDB: {
                if (!this.breakpointManager.hasDeferredGDBBreakPoint()) break;
                try {
                    this.ensureJDBContext();
                    this.jdb.setLoadLibraryEvent();
                    break;
                }
                catch (IOException iOException) {
                    this.err("could not handle deferred gdb break point");
                }
            }
        }
        switch (this.getDebugControlStatus()) {
            case JDB: {
                try {
                    this.jdb.cont();
                    this.changeDebugControlStatus(DebugerControlStatus.NONE);
                }
                catch (IOException iOException) {
                    this.err("failed in executing the continue\n");
                }
                break;
            }
            case GDB: {
                try {
                    this.gdb.cont();
                    this.changeDebugControlStatus(DebugerControlStatus.NONE);
                }
                catch (IOException iOException) {
                    this.err("failed in executing the continue\n");
                }
                break;
            }
            case JDB_IN_GDB: 
            case GDB_IN_JDB: {
                this.err("\"continue\" is not allowed in this nested mode:" + (Object)((Object)this.getDebugControlStatus()) + "\n" + "use jret to return to the gdb.\n");
                break;
            }
            default: {
                assert (false) : "not allowed";
                break;
            }
        }
    }

    void stepj() throws IOException {
        assert (this.getDebugControlStatus() == DebugerControlStatus.JDB);
        this.ensureGDBContext();
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_CALL);
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
        this.ensureJDBContext();
        EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.changeDebugControlStatus(DebugerControlStatus.NONE);
                Blink.this.jdb.step();
            }
        }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.JavaStepCompletionHandler(this.jdb), new EventUtil.JavaBreakPointHandler(this.jdb), new EventUtil.LanguageTransitionHandler(this.gdb)));
        if (blinkEventReplyHandler.getSourceFilter() == this.jdb) {
            Event.JavaPauseEvent javaPauseEvent;
            this.changeDebugControlStatus(DebugerControlStatus.JDB);
            this.ensureGDBContext();
            this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_CALL);
            this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
            this.ensureJDBContext();
            if (blinkEventReplyHandler instanceof EventUtil.JavaStepCompletionHandler) {
                EventUtil.JavaStepCompletionHandler javaStepCompletionHandler = (EventUtil.JavaStepCompletionHandler)blinkEventReplyHandler;
                javaPauseEvent = javaStepCompletionHandler.getEvent();
            } else {
                assert (blinkEventReplyHandler instanceof EventUtil.JavaBreakPointHandler);
                EventUtil.JavaBreakPointHandler javaBreakPointHandler = (EventUtil.JavaBreakPointHandler)blinkEventReplyHandler;
                javaPauseEvent = javaBreakPointHandler.getEvent();
            }
            this.setBreakPointLocation(javaPauseEvent.classAndmethod, javaPauseEvent.line);
            if (javaPauseEvent.sourceLine != null && javaPauseEvent.sourceLine.length() > 0) {
                this.out(javaPauseEvent.sourceLine);
            }
            return;
        }
        assert (blinkEventReplyHandler.getSourceFilter() == this.gdb && blinkEventReplyHandler instanceof EventUtil.LanguageTransitionHandler);
        EventUtil.LanguageTransitionHandler languageTransitionHandler = (EventUtil.LanguageTransitionHandler)blinkEventReplyHandler;
        Event.LanguageTransitionEvent languageTransitionEvent = languageTransitionHandler.getEvent();
        this.changeDebugControlStatus(DebugerControlStatus.GDB);
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_CALL);
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
        this.setBreakPointLocation(languageTransitionEvent.fileAndLine);
        this.out(languageTransitionEvent.srcLine + "\n");
        EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.gdb.callJavaDummy();
            }
        }, new EventUtil.JavaStepCompletionHandler(this.jdb));
        this.jdb.cont();
    }

    void stepc() throws IOException {
        assert (this.getDebugControlStatus() == DebugerControlStatus.GDB);
        assert (this.breakPointLocation != null);
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_CALL);
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN);
        EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.gdb.step();
            }
        }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.LanguageTransitionHandler(this.gdb), new EventUtil.NativeStepCompletionEventHandler(this.gdb)));
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_CALL);
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN);
        if (blinkEventReplyHandler instanceof EventUtil.NativeStepCompletionEventHandler) {
            this.out("Step Completed\n");
            this.setBreakPointLocation(this.breakPointLocation.getSourceFile(), this.breakPointLocation.getSourceLine() + 1);
        } else {
            assert (blinkEventReplyHandler instanceof EventUtil.LanguageTransitionHandler);
            EventUtil.LanguageTransitionHandler languageTransitionHandler = (EventUtil.LanguageTransitionHandler)blinkEventReplyHandler;
            Event.LanguageTransitionEvent languageTransitionEvent = languageTransitionHandler.getEvent();
            if (languageTransitionEvent.bptype == NativeDebugger.LanguageTransitionBreakPoint.C2J_CALL) {
                assert (languageTransitionEvent.c2jtarget != null);
                this.ensureJDBContext();
                this.jdb.setBreakPoint(languageTransitionEvent.c2jtarget);
                this.ensureGDBContext();
                Event.JavaBreakPointHitEvent javaBreakPointHitEvent = (Event.JavaBreakPointHitEvent)EventLoop.subLoop(this, new EventLoop.Action(){

                    public void execute() throws IOException {
                        Blink.this.changeDebugControlStatus(DebugerControlStatus.NONE);
                        Blink.this.gdb.cont();
                    }
                }, new EventUtil.JavaBreakPointHandler(this.jdb));
                this.changeDebugControlStatus(DebugerControlStatus.JDB);
                this.jdb.clearBreakPoint(languageTransitionEvent.c2jtarget);
                this.out(javaBreakPointHitEvent.sourceLine);
                this.setBreakPointLocation(javaBreakPointHitEvent.classAndmethod, javaBreakPointHitEvent.line);
            } else if (languageTransitionEvent.bptype == NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN) {
                this.ensureJDBContext();
                CallStack.JavaCallFrame javaCallFrame = CallStack.getMostRecentJavaFrame(this);
                assert (javaCallFrame != null) : "at least one java frame in this context";
                String string = javaCallFrame.getClassName();
                int n = javaCallFrame.getLineNumber();
                assert (string != null && n > 0) : "can not put byte code index break point with jdb.";
                this.jdb.setBreakPoint(string, n);
                this.jdb.setBreakPoint(string, n + 1);
                this.ensureGDBContext();
                Event.JavaBreakPointHitEvent javaBreakPointHitEvent = (Event.JavaBreakPointHitEvent)EventLoop.subLoop(this, new EventLoop.Action(){

                    public void execute() throws IOException {
                        Blink.this.changeDebugControlStatus(DebugerControlStatus.NONE);
                        Blink.this.gdb.cont();
                    }
                }, new EventUtil.JavaBreakPointHandler(this.jdb));
                this.changeDebugControlStatus(DebugerControlStatus.JDB);
                this.jdb.clearBreakPoint(string, n);
                this.jdb.clearBreakPoint(string, n + 1);
                this.out(javaBreakPointHitEvent.sourceLine);
            }
        }
    }

    void nextj() throws IOException {
        assert (this.debugControl == DebugerControlStatus.JDB);
        assert (this.breakPointLocation != null);
        this.ensureGDBContext();
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
        this.ensureJDBContext();
        EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.changeDebugControlStatus(DebugerControlStatus.NONE);
                Blink.this.jdb.sendMessage("next\n");
            }
        }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.JavaStepCompletionHandler(this.jdb), new EventUtil.JavaBreakPointHandler(this.jdb), new EventUtil.NativeBreakPointHandler(this.gdb)));
        if (blinkEventReplyHandler.getSourceFilter() == this.jdb) {
            this.changeDebugControlStatus(DebugerControlStatus.JDB);
            this.ensureGDBContext();
            this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
            this.ensureJDBContext();
            if (blinkEventReplyHandler instanceof EventUtil.JavaStepCompletionHandler) {
                this.setBreakPointLocation(this.breakPointLocation.getSourceFile(), this.breakPointLocation.getSourceLine() + 1);
                return;
            }
            assert (blinkEventReplyHandler instanceof EventUtil.JavaBreakPointHandler);
            Event.JavaBreakPointHitEvent javaBreakPointHitEvent = ((EventUtil.JavaBreakPointHandler)blinkEventReplyHandler).getEvent();
            this.setBreakPointLocation(javaBreakPointHitEvent.classAndmethod, javaBreakPointHitEvent.line);
            this.out(javaBreakPointHitEvent.sourceLine);
            return;
        }
        assert (blinkEventReplyHandler.getSourceFilter() == this.gdb);
        assert (blinkEventReplyHandler instanceof EventUtil.NativeBreakPointHandler);
        Event.NativeBreakPointHitEvent nativeBreakPointHitEvent = ((EventUtil.NativeBreakPointHandler)blinkEventReplyHandler).getEvent();
        this.changeDebugControlStatus(DebugerControlStatus.GDB);
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.C2J_RETURN);
        this.setBreakPointLocation(nativeBreakPointHitEvent.sourceFile, nativeBreakPointHitEvent.line);
        this.ensureGDBContext();
        EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.gdb.step();
            }
        }, new EventUtil.NativeStepCompletionEventHandler(this.gdb));
    }

    void nextc() throws IOException {
        assert (this.debugControl == DebugerControlStatus.GDB);
        assert (this.breakPointLocation != null);
        this.ensureGDBContext();
        this.gdb.enableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN);
        this.changeDebugControlStatus(DebugerControlStatus.NONE);
        EventUtil.BlinkEventReplyHandler blinkEventReplyHandler = (EventUtil.BlinkEventReplyHandler)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.gdb.next();
            }
        }, new EventUtil.DisjunctiveReplyHandler(new EventUtil.NativeBreakPointHandler(this.gdb), new EventUtil.LanguageTransitionHandler(this.gdb)));
        this.changeDebugControlStatus(DebugerControlStatus.GDB);
        this.gdb.disableInternalBreakPoint(NativeDebugger.LanguageTransitionBreakPoint.J2C_RETURN);
        if (blinkEventReplyHandler instanceof EventUtil.NativeBreakPointHandler) {
            EventUtil.NativeBreakPointHandler nativeBreakPointHandler = (EventUtil.NativeBreakPointHandler)blinkEventReplyHandler;
            Event.NativeBreakPointHitEvent nativeBreakPointHitEvent = nativeBreakPointHandler.getEvent();
            this.setBreakPointLocation(nativeBreakPointHitEvent.sourceFile, nativeBreakPointHitEvent.line);
            this.out(nativeBreakPointHitEvent.srcLine);
            return;
        }
        this.ensureJDBContext();
        CallStack.JavaCallFrame javaCallFrame = CallStack.getMostRecentJavaFrame(this);
        assert (javaCallFrame != null) : "at least one java frame in this context";
        String string = javaCallFrame.getClassName();
        int n = javaCallFrame.getLineNumber();
        assert (string != null && n > 0) : "can not put byte code index break point with jdb.";
        this.breakpointManager.setTempJCBBreakPoint(string, n);
        this.breakpointManager.setTempJCBBreakPoint(string, n + 1);
        this.ensureGDBContext();
        this.changeDebugControlStatus(DebugerControlStatus.NONE);
        Event.JavaBreakPointHitEvent javaBreakPointHitEvent = (Event.JavaBreakPointHitEvent)EventLoop.subLoop(this, new EventLoop.Action(){

            public void execute() throws IOException {
                Blink.this.gdb.cont();
            }
        }, new EventUtil.JavaBreakPointHandler(this.jdb));
        this.changeDebugControlStatus(DebugerControlStatus.JDB);
        this.breakpointManager.removeTempJDBBreakPoints();
        this.setBreakPointLocation(javaBreakPointHitEvent.classAndmethod, javaBreakPointHitEvent.line);
        this.changeDebugControlStatus(DebugerControlStatus.NONE);
        this.changeDebugControlStatus(DebugerControlStatus.JDB);
    }

    void exit() {
        if (this.getDebugControlStatus() == DebugerControlStatus.NONE) {
            this.out("can not terminate the current debugging session.\n");
            return;
        }
        this.ensurePureContext();
        if (this.getDebugControlStatus() == DebugerControlStatus.JDB) {
            try {
                if (this.gdbAttached) {
                    this.j2c();
                    EventLoop.subLoop(this, new EventLoop.Action(){

                        public void execute() throws IOException {
                            Blink.this.gdb.detach();
                        }
                    }, new EventUtil.ConjunctiveReplyHandler(new EventUtil.J2CCompletionEventHandler(this.jdb), new EventUtil.DeathReplyHandler(this.gdb)));
                    this.debugControl = DebugerControlStatus.JDB;
                    this.gdbAttached = false;
                }
                EventLoop.subLoop(this, new EventLoop.Action(){

                    public void execute() throws IOException {
                        Blink.this.jdb.exit();
                    }
                }, new EventUtil.ConjunctiveReplyHandler(new EventUtil.DeathReplyHandler(this.jvm), new EventUtil.DeathReplyHandler(this.jdb)));
                this.debugControl = DebugerControlStatus.NONE;
            }
            catch (IOException iOException) {
                this.err("could not successfully run the exit sequent from jdb.");
            }
        } else if (this.getDebugControlStatus() == DebugerControlStatus.GDB) {
            try {
                EventLoop.subLoop(this, new EventLoop.Action(){

                    public void execute() throws IOException {
                        Blink.this.gdb.quit();
                    }
                }, new EventUtil.ConjunctiveReplyHandler(new EventUtil.DeathReplyHandler(this.jvm), new EventUtil.DeathReplyHandler(this.jdb), new EventUtil.DeathReplyHandler(this.gdb)));
            }
            catch (IOException iOException) {
                this.err("could not successfully run the exit sequent from gdb.");
            }
        } else {
            assert (false) : "should not reach here";
            return;
        }
    }

    void out(String string) {
        this.user.out(string);
    }

    void out(char[] cArray) {
        this.user.out(new String(cArray));
    }

    void err(String string) {
        this.user.err(string);
    }

    boolean IsNativeDebuggerAttached() {
        return this.gdbAttached;
    }

    boolean ensureDebugAgent() throws IOException {
        assert (this.debugControl == DebugerControlStatus.JDB);
        if (this.IsNativeDebuggerAttached()) {
            return true;
        }
        this.jdb.resetLoadLibraryEvent();
        if (!this.initj()) {
            this.jdb.setLoadLibraryEvent();
        }
        return true;
    }

    public boolean ensureJDBContext() {
        switch (this.debugControl) {
            case JDB: 
            case JDB_IN_GDB: {
                return true;
            }
            case GDB: {
                this.c2j();
                return true;
            }
            case GDB_IN_JDB: {
                this.jret();
                return true;
            }
        }
        assert (false) : "not allowed state";
        return false;
    }

    public boolean ensureGDBContext() {
        if (!this.IsNativeDebuggerAttached()) {
            return false;
        }
        switch (this.debugControl) {
            case JDB: {
                this.j2c();
                break;
            }
            case JDB_IN_GDB: {
                this.jret();
                break;
            }
            case GDB: 
            case GDB_IN_JDB: {
                break;
            }
            default: {
                assert (false) : "not allowed state";
                break;
            }
        }
        return true;
    }

    public final void ensurePureContext() {
        switch (this.getDebugControlStatus()) {
            case JDB: 
            case GDB: {
                break;
            }
            case JDB_IN_GDB: 
            case GDB_IN_JDB: {
                this.jret();
                break;
            }
        }
    }

    public String ensureJNIENV() {
        if (this.jnienvValue != null) {
            return this.jnienvValue;
        }
        if (!this.ensureGDBContext()) assert (false) : "panic";
        try {
            this.jnienvValue = this.gdb.getJNIEnv();
        }
        catch (IOException iOException) {
            this.err("could not get jnienv value.\n");
        }
        return this.jnienvValue;
    }

    void executeDebugCommand(String string) {
        assert (string.startsWith("bdb "));
        if (Pattern.matches("bdb log (jdb|gdb)", string)) {
            Matcher matcher = Pattern.compile("bdb log (jdb|gdb)").matcher(string);
            if (!matcher.matches()) assert (false) : "impossible!";
            String string2 = matcher.group(1);
            if (string2.equals("jdb")) {
                this.out(this.jdb.getLastOutputMessage() + "\n");
            } else {
                assert (string2.equals("gdb")) : "impossible!";
                this.out(this.gdb.getLastOutputMessage() + "\n");
            }
        } else if (string.equals("bdb verbose")) {
            this.options.moreVerbose();
        } else if (string.equals("bdb quiet")) {
            this.options.setVerboseLevel(0);
        } else if (string.equals("bdb where")) {
            Thread.dumpStack();
        } else {
            this.err("can not recognize: " + string + "\n");
        }
    }

    synchronized void changeDebugControlStatus(DebugerControlStatus debugerControlStatus) {
        DebugerControlStatus debugerControlStatus2 = this.debugControl;
        if (debugerControlStatus2 == debugerControlStatus) {
            return;
        }
        boolean bl = false;
        switch (this.debugControl) {
            case NONE: {
                bl = debugerControlStatus == DebugerControlStatus.JDB || debugerControlStatus == DebugerControlStatus.GDB;
                break;
            }
            case JDB: {
                bl = debugerControlStatus == DebugerControlStatus.NONE || debugerControlStatus == DebugerControlStatus.GDB_IN_JDB;
                break;
            }
            case GDB: {
                bl = debugerControlStatus == DebugerControlStatus.NONE || debugerControlStatus == DebugerControlStatus.JDB_IN_GDB;
                break;
            }
            case JDB_IN_GDB: {
                bl = debugerControlStatus == DebugerControlStatus.GDB;
                break;
            }
            case GDB_IN_JDB: {
                bl = debugerControlStatus == DebugerControlStatus.JDB;
            }
        }
        this.debugControl = debugerControlStatus;
        if (!bl) {
            this.err("warning: not an expected transition in the following context\n" + (Object)((Object)debugerControlStatus2) + "->" + (Object)((Object)debugerControlStatus));
            Thread.dumpStack();
        }
    }

    synchronized DebugerControlStatus getDebugControlStatus() {
        return this.debugControl;
    }

    synchronized String getCurrentLanguageContext() {
        switch (this.debugControl) {
            case JDB: 
            case JDB_IN_GDB: {
                return "Java";
            }
            case GDB: 
            case GDB_IN_JDB: {
                return "C";
            }
        }
        return "None";
    }

    void setBreakPointLocation(String string, int n) {
        this.breakPointLocation = new SymbolMapper.SourceFileAndLine(string, n);
    }

    void setBreakPointLocation(SymbolMapper.SourceFileAndLine sourceFileAndLine) {
        this.breakPointLocation = sourceFileAndLine;
    }

    SymbolMapper.SourceFileAndLine getBreakPointLocation() {
        return this.breakPointLocation;
    }

    void enqueEvent(Event event) {
        if (!this.eventQueue.add(event)) {
            this.err("can not successfully insert event: " + event + " from " + Thread.currentThread() + "\n");
            this.err("Now, I'm discarding that event\n");
        }
    }

    Event dequeEvent() {
        Event event;
        block2: {
            event = null;
            try {
                event = this.eventQueue.take();
            }
            catch (InterruptedException interruptedException) {
                if (event != null) break block2;
                this.err("could not get non-null event from queue\n");
                return null;
            }
        }
        return event;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DebugerControlStatus {
        NONE,
        JDB,
        GDB,
        JDB_IN_GDB,
        GDB_IN_JDB;

    }
}

