/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import xtc.lang.TypedLambdaAnalyzer;
import xtc.lang.TypedLambdaParser;
import xtc.lang.TypedLambdaPrinter;
import xtc.parser.ParseException;
import xtc.tree.Node;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public class TypedLambda
extends Tool {
    public String getName() {
        return "xtc Simply Typed Lambda Calculus Driver";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm";
    }

    public void init() {
        super.init();
        this.runtime.bool("printSymbolTable", "printSymbolTable", false, "Print the symbol table.").bool("printAST", "printAST", false, "Print the program's AST in generic form.").bool("printSource", "printSource", false, "Print the program's AST in source form.");
    }

    public File locate(String string) throws IOException {
        File file = super.locate(string);
        if (Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        return file;
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        TypedLambdaParser typedLambdaParser = new TypedLambdaParser(reader, file.toString(), (int)file.length());
        return (Node)typedLambdaParser.value(typedLambdaParser.pExpression(0));
    }

    public void process(Node node) {
        SymbolTable symbolTable = new TypedLambdaAnalyzer(this.runtime).run(node);
        if (this.runtime.test("printSymbolTable")) {
            symbolTable.root().dump(this.runtime.console());
            this.runtime.console().flush();
        }
        if (this.runtime.test("printAST")) {
            this.runtime.console().format(node).pln().flush();
        }
        if (this.runtime.test("printSource")) {
            new TypedLambdaPrinter(this.runtime.console()).dispatch(node);
            this.runtime.console().pln().flush();
        }
    }

    public static void main(String[] stringArray) {
        new TypedLambda().run(stringArray);
    }
}

