/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceMapExtractor {
    private static final Pattern lineDirectivePattern = Pattern.compile("^\\s*//#line\\s+([0-9]+)\\s+\"(\\S+)\"$");
    protected final String sourceFile;
    protected int numSourceLines = 0;
    protected final TreeSet<SMAPLineEntry> smapLineEntries = new TreeSet();
    protected final HashMap<String, Integer> inputSourceFile2id = new HashMap();
    protected int numInputSourceFiles = 0;
    private int[] outputSourceLine2inputSourceLine;

    private static void usage(String string) {
        String string2 = "usage: SourceMapExtractor [source file]";
        System.err.println(string2 + "\n" + string);
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        File file;
        Object object;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (string == null) {
                string = object;
                continue;
            }
            SourceMapExtractor.usage("can not recognize command line option:" + (String)object);
        }
        if (string == null) {
            SourceMapExtractor.usage("please, specify [java source file]");
        }
        if (!(file = new File(string)).isFile()) {
            SourceMapExtractor.usage("can not find " + string);
        }
        if (!file.canRead()) {
            SourceMapExtractor.usage("check permission for reading " + string);
        }
        try {
            object = new SourceMapExtractor(string);
            ((SourceMapExtractor)object).genSMAP();
            System.out.println(((SourceMapExtractor)object).toStringInSMAPFormat());
        }
        catch (IOException iOException) {
            System.err.println("failed in extracting SMAP from the " + string);
        }
    }

    public SourceMapExtractor(String string) {
        this.sourceFile = string;
    }

    public int getNumberOfInputSourceFiles() {
        return this.numInputSourceFiles;
    }

    public void genSMAP() throws IOException {
        FileReader fileReader = new FileReader(this.sourceFile);
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        LineNumberDirective lineNumberDirective = null;
        while (true) {
            String string;
            if ((string = lineNumberReader.readLine()) == null) {
                this.numSourceLines = lineNumberReader.getLineNumber();
                if (lineNumberDirective == null) break;
                this.addJNISourceLine(lineNumberDirective, lineNumberReader.getLineNumber());
                break;
            }
            LineNumberDirective lineNumberDirective2 = this.checkJNILineNumberDirective(string, lineNumberReader.getLineNumber());
            if (lineNumberDirective2 == null) continue;
            if (lineNumberDirective != null) {
                this.addJNISourceLine(lineNumberDirective, lineNumberReader.getLineNumber() - 1);
            }
            lineNumberDirective = lineNumberDirective2;
        }
    }

    private LineNumberDirective checkJNILineNumberDirective(String string, int n) {
        Matcher matcher = lineDirectivePattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        assert (matcher.group(1).length() > 0 && matcher.group(2).length() > 0);
        int n2 = Integer.parseInt(matcher.group(1));
        String string2 = matcher.group(2);
        int n3 = this.ensureSourceFileID(string2);
        LineNumberDirective lineNumberDirective = new LineNumberDirective(n3, n2, n);
        return lineNumberDirective;
    }

    private void addJNISourceLine(LineNumberDirective lineNumberDirective, int n) {
        int n2 = lineNumberDirective.outputSourceLineNumber + 1;
        int n3 = n - n2 + 1;
        assert (n2 > 0 && n > 0 && n3 >= 1);
        int n4 = lineNumberDirective.inputSurceLineNumber;
        int n5 = lineNumberDirective.sourceFileID;
        SMAPLineEntry sMAPLineEntry = new SMAPLineEntry(n4, n5, n2, n3);
        this.smapLineEntries.add(sMAPLineEntry);
    }

    private int ensureSourceFileID(String string) {
        int n;
        if (this.inputSourceFile2id.containsKey(string)) {
            n = this.inputSourceFile2id.get(string);
        } else {
            ++this.numInputSourceFiles;
            n = this.numInputSourceFiles;
            this.inputSourceFile2id.put(string, n);
        }
        assert (this.inputSourceFile2id.containsKey(string));
        return n;
    }

    protected String getSingleSourceFileName() {
        String string;
        block1: {
            String string2;
            assert (this.numInputSourceFiles == 1);
            string = null;
            Iterator<String> iterator = this.inputSourceFile2id.keySet().iterator();
            if (!iterator.hasNext()) break block1;
            string = string2 = iterator.next();
        }
        return string;
    }

    protected int getSingleSourceLine(int n) {
        assert (this.numInputSourceFiles == 1);
        if (this.outputSourceLine2inputSourceLine == null) {
            this.outputSourceLine2inputSourceLine = new int[this.numSourceLines + 1];
            for (SMAPLineEntry sMAPLineEntry : this.smapLineEntries) {
                int n2 = sMAPLineEntry.getOutputLineBegin();
                int n3 = sMAPLineEntry.getOutputLineEnd();
                assert (n2 >= 1 && n3 >= n2);
                for (int i = n2; i <= n3; ++i) {
                    int n4 = sMAPLineEntry.getInputSourceLine(i);
                    int n5 = this.outputSourceLine2inputSourceLine[i];
                    if (n5 >= 1) {
                        if (n5 >= n4) continue;
                        this.outputSourceLine2inputSourceLine[i] = n4;
                        continue;
                    }
                    this.outputSourceLine2inputSourceLine[i] = n4;
                }
            }
        }
        assert (this.outputSourceLine2inputSourceLine != null);
        return this.outputSourceLine2inputSourceLine[n];
    }

    public String toStringInSMAPFormat() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println("SMAP");
        printWriter.println(this.sourceFile);
        printWriter.println("JNI");
        printWriter.println("*S JNI");
        printWriter.println("*F");
        for (String object : this.inputSourceFile2id.keySet()) {
            int n = this.inputSourceFile2id.get(object);
            printWriter.println("" + n + " " + object);
        }
        printWriter.println("*L");
        for (SMAPLineEntry sMAPLineEntry : this.smapLineEntries) {
            printWriter.println(sMAPLineEntry.toStringInSMAPFormat());
        }
        printWriter.println("*E");
        printWriter.close();
        return charArrayWriter.toString();
    }

    private static final class LineNumberDirective {
        private final int outputSourceLineNumber;
        private final int inputSurceLineNumber;
        private final int sourceFileID;

        public LineNumberDirective(int n, int n2, int n3) {
            assert (n > 0 & n2 > 0 & n3 > 0);
            this.sourceFileID = n;
            this.inputSurceLineNumber = n2;
            this.outputSourceLineNumber = n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SMAPLineEntry
    implements Comparable<SMAPLineEntry> {
        private final int inputStartLine;
        private final int inputFileID;
        private final int repeat;
        private final int outputStartline;
        private final int ouputLineIncrement;

        SMAPLineEntry(int n, int n2, int n3, int n4) {
            assert (n >= 1 && n3 >= 1 && n4 > 0);
            this.inputStartLine = n;
            this.inputFileID = n2;
            this.repeat = n4;
            this.outputStartline = n3;
            this.ouputLineIncrement = 1;
        }

        private int getInputLineBegin() {
            return this.inputStartLine;
        }

        private int getInputLineEnd() {
            return this.inputStartLine + this.repeat - 1;
        }

        private int getOutputLineBegin() {
            return this.outputStartline;
        }

        private int getOutputLineEnd() {
            return this.outputStartline + this.repeat * this.ouputLineIncrement - 1;
        }

        private int getInputSourceLine(int n) {
            assert (n >= this.getOutputLineBegin() && n <= this.getOutputLineEnd());
            int n2 = (n - this.outputStartline) / this.ouputLineIncrement + this.inputStartLine;
            assert (n2 >= this.inputStartLine && n2 <= this.getInputLineEnd());
            return n2;
        }

        private String toStringInSMAPFormat() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.inputStartLine);
            stringBuffer.append("#").append(this.inputFileID);
            if (this.repeat != 1) {
                stringBuffer.append(",").append(this.repeat);
            }
            stringBuffer.append(":").append(this.outputStartline);
            if (this.ouputLineIncrement != 1) {
                stringBuffer.append(",").append(this.ouputLineIncrement);
            }
            return stringBuffer.toString();
        }

        @Override
        public int compareTo(SMAPLineEntry sMAPLineEntry) {
            if (this.inputFileID != sMAPLineEntry.inputFileID) {
                return this.inputFileID - sMAPLineEntry.inputFileID;
            }
            if (this.outputStartline != sMAPLineEntry.outputStartline) {
                return this.outputStartline - sMAPLineEntry.outputStartline;
            }
            return this.inputStartLine - sMAPLineEntry.inputStartLine;
        }
    }
}

