/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import xtc.lang.JavaEntities;
import xtc.type.ClassT;
import xtc.type.IntegerT;
import xtc.type.InterfaceT;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.Type;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTypeConverter {
    public static Type convertAssigning(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.convertAssigningInternal(symbolTable, list, type2, type3);
        assert (null == type4 || JavaEntities.isWrappedRValueT(type4));
        return type4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Type convertAssigningInternal(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        Type type4 = JavaTypeConverter.convertIdentity(type2, type3);
        if (null != type4) {
            return type4;
        }
        Type type5 = JavaTypeConverter.widenPrimitive(type2, type3);
        if (null != type5) {
            return type5;
        }
        Type type6 = JavaTypeConverter.widenReference(symbolTable, list, type2, type3);
        if (null != type6) {
            return type6;
        }
        if (!type3.hasConstant()) return null;
        Type type7 = JavaEntities.resolveToRawRValue(type3);
        Type type8 = JavaEntities.resolveToRawRValue(type2);
        if (!type7.isInteger() || !type8.isInteger()) return null;
        IntegerT integerT = (IntegerT)type7;
        IntegerT integerT2 = (IntegerT)type8;
        switch (integerT.getKind()) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                switch (integerT2.getKind()) {
                    case BYTE: 
                    case SHORT: 
                    case CHAR: {
                        long l;
                        Type type9 = JavaTypeConverter.narrowPrimitive(type2, type3);
                        Object object = type3.getConstant().getValue();
                        Object object2 = type9.getConstant().getValue();
                        long l2 = object instanceof Number ? ((Number)object).longValue() : (long)((Character)object).charValue();
                        long l3 = l = object2 instanceof Number ? ((Number)object2).longValue() : (long)((Character)object2).charValue();
                        if (l2 != l) return null;
                        return type9;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static Type convertCasting(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.convertCastingInternal(symbolTable, list, type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4));
        return type4;
    }

    private static Type convertCastingInternal(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        Type type4 = JavaTypeConverter.convertIdentity(type2, type3);
        if (null != type4) {
            return type4;
        }
        Type type5 = JavaTypeConverter.widenPrimitive(type2, type3);
        if (null != type5) {
            return type5;
        }
        Type type6 = JavaTypeConverter.narrowPrimitive(type2, type3);
        if (null != type6) {
            return type6;
        }
        Type type7 = JavaTypeConverter.widenReference(symbolTable, list, type2, type3);
        if (null != type7) {
            return type7;
        }
        Type type8 = JavaTypeConverter.narrowReference(symbolTable, list, type2, type3);
        if (null != type8) {
            return type8;
        }
        return null;
    }

    public static Type convertIdentity(Type type2, Type type3) {
        Type type4;
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type5 = type4 = JavaTypeConverter.isIdentical(type2, type3) ? type3 : null;
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4));
        return type4;
    }

    public static Type convertParameterPassing(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3)) : "tgt == " + type2 + ", src == " + type3;
        Type type4 = JavaTypeConverter.convertParameterPassingInternal(symbolTable, list, type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4));
        return type4;
    }

    private static Type convertParameterPassingInternal(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        if (JavaTypeConverter.isIdentical(type2, type3) || JavaTypeConverter.isWiderPrimitive(type2, type3) || JavaTypeConverter.isWiderReference(symbolTable, list, type2, type3)) {
            return type2;
        }
        return null;
    }

    public static Type convertString(SymbolTable symbolTable, Type type2) {
        assert (JavaEntities.isGeneralRValueT(type2));
        Type type3 = JavaTypeConverter.convertStringInternal(symbolTable, type2);
        assert (null == type3 || JavaEntities.isWrappedRValueT(type3));
        return type3;
    }

    private static Type convertStringInternal(SymbolTable symbolTable, Type type2) {
        ClassT classT = JavaEntities.tString(symbolTable);
        if (type2.hasConstant()) {
            if (JavaEntities.isNullT(type2)) {
                return classT.annotate().constant("null");
            }
            return classT.annotate().constant(type2.getConstant().getValue().toString());
        }
        return classT;
    }

    public static boolean isAssignable(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        return null != JavaTypeConverter.convertAssigning(symbolTable, list, type2, type3);
    }

    public static boolean isCastable(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        return null != JavaTypeConverter.convertCasting(symbolTable, list, type2, type3);
    }

    public static boolean isIdentical(Type type2, Type type3) {
        if (type2.isVoid() || type3.isVoid()) {
            return type2.isVoid() && type3.isVoid();
        }
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaEntities.resolveToRawRValue(type2);
        Type type5 = JavaEntities.resolveToRawRValue(type3);
        if (type4.isArray()) {
            if (!type5.isArray()) {
                return false;
            }
            Type type6 = JavaEntities.arrayElementType(type4.toArray());
            Type type7 = JavaEntities.arrayElementType(type5.toArray());
            return JavaTypeConverter.isIdentical(type6, type7);
        }
        return type4 == type5;
    }

    public static boolean isNarrowerPrimitive(Type type2, Type type3) {
        return null != JavaTypeConverter.narrowPrimitive(type2, type3);
    }

    public static boolean isNarrowerReference(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        return null != JavaTypeConverter.narrowReference(symbolTable, list, type2, type3);
    }

    public static boolean isParameterPassable(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        return null != JavaTypeConverter.convertParameterPassing(symbolTable, list, type2, type3);
    }

    public static boolean isPromotableBinaryNumeric(Type type2, Type type3) {
        Type type4 = JavaTypeConverter.promoteBinaryNumeric(type2, type3);
        Type type5 = JavaTypeConverter.promoteBinaryNumeric(type3, type2);
        return null != type4 && null != type5;
    }

    public static boolean isReturnTypeSubstitutable(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        if (null == type2 || null == type3) {
            return null == type2 && null == type3;
        }
        if (JavaEntities.isPrimitiveT(type3)) {
            return JavaTypeConverter.isIdentical(type3, type2);
        }
        if (JavaEntities.isReferenceT(type3)) {
            return JavaTypeConverter.isIdentical(type3, type2) || JavaTypeConverter.isWiderReference(symbolTable, list, type3, type2);
        }
        if (type3.isVoid()) {
            return type2.isVoid();
        }
        assert (false);
        return false;
    }

    public static boolean isWiderPrimitive(Type type2, Type type3) {
        return null != JavaTypeConverter.widenPrimitive(type2, type3);
    }

    public static boolean isWiderReference(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        return null != JavaTypeConverter.widenReference(symbolTable, list, type2, type3);
    }

    public static strictfp Type narrowPrimitive(Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.narrowPrimitiveInternal(type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4) && JavaEntities.resolveToRawRValue(type4).isNumber());
        return type4;
    }

    private static strictfp Type narrowPrimitiveInternal(Type type2, Type type3) {
        Type type4 = JavaEntities.resolveToRawRValue(type2);
        Type type5 = JavaEntities.resolveToRawRValue(type3);
        if (!type5.isNumber() || !type4.isNumber()) {
            return null;
        }
        NumberT numberT = (NumberT)type5;
        NumberT numberT2 = (NumberT)type4;
        NumberT.Kind kind = numberT.getKind();
        NumberT.Kind kind2 = numberT2.getKind();
        switch (kind) {
            case BYTE: {
                if (NumberT.Kind.CHAR == kind2) break;
                return null;
            }
            case SHORT: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.CHAR == kind2) break;
                return null;
            }
            case CHAR: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.SHORT == kind2) break;
                return null;
            }
            case INT: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.SHORT == kind2 || NumberT.Kind.CHAR == kind2) break;
                return null;
            }
            case LONG: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.SHORT == kind2 || NumberT.Kind.CHAR == kind2 || NumberT.Kind.INT == kind2) break;
                return null;
            }
            case FLOAT: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.SHORT == kind2 || NumberT.Kind.CHAR == kind2 || NumberT.Kind.INT == kind2 || NumberT.Kind.LONG == kind2) break;
                return null;
            }
            case DOUBLE: {
                if (NumberT.Kind.BYTE == kind2 || NumberT.Kind.SHORT == kind2 || NumberT.Kind.CHAR == kind2 || NumberT.Kind.INT == kind2 || NumberT.Kind.LONG == kind2 || NumberT.Kind.FLOAT == kind2) break;
                return null;
            }
        }
        if (type3.hasConstant()) {
            Comparable<Character> comparable;
            block9 : switch (kind) {
                case BYTE: {
                    byte by = (Byte)type3.getConstant().getValue();
                    switch (kind2) {
                        case CHAR: {
                            comparable = new Character((char)by);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case SHORT: {
                    short s = (Short)type3.getConstant().getValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)s);
                            break block9;
                        }
                        case CHAR: {
                            comparable = new Character((char)s);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case CHAR: {
                    char c = ((Character)type3.getConstant().getValue()).charValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)c);
                            break block9;
                        }
                        case SHORT: {
                            comparable = new Short((short)c);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case INT: {
                    int n = (Integer)type3.getConstant().getValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)n);
                            break block9;
                        }
                        case SHORT: {
                            comparable = new Short((short)n);
                            break block9;
                        }
                        case CHAR: {
                            comparable = new Character((char)n);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case LONG: {
                    long l = (Long)type3.getConstant().getValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)l);
                            break block9;
                        }
                        case SHORT: {
                            comparable = new Short((short)l);
                            break block9;
                        }
                        case CHAR: {
                            comparable = new Character((char)l);
                            break block9;
                        }
                        case INT: {
                            comparable = new Integer((int)l);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case FLOAT: {
                    float f = ((Float)type3.getConstant().getValue()).floatValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)f);
                            break block9;
                        }
                        case SHORT: {
                            comparable = new Short((short)f);
                            break block9;
                        }
                        case CHAR: {
                            comparable = new Character((char)f);
                            break block9;
                        }
                        case INT: {
                            comparable = new Integer((int)f);
                            break block9;
                        }
                        case LONG: {
                            comparable = new Long((long)f);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                case DOUBLE: {
                    double d = (Double)type3.getConstant().getValue();
                    switch (kind2) {
                        case BYTE: {
                            comparable = new Byte((byte)d);
                            break block9;
                        }
                        case SHORT: {
                            comparable = new Short((short)d);
                            break block9;
                        }
                        case CHAR: {
                            comparable = new Character((char)d);
                            break block9;
                        }
                        case INT: {
                            comparable = new Integer((int)d);
                            break block9;
                        }
                        case LONG: {
                            comparable = new Long((long)d);
                            break block9;
                        }
                        case FLOAT: {
                            comparable = new Float((float)d);
                            break block9;
                        }
                    }
                    comparable = null;
                    break;
                }
                default: {
                    comparable = null;
                }
            }
            if (null == comparable) {
                throw new Error();
            }
            return type4.annotate().constant(comparable);
        }
        return type2;
    }

    public static Type narrowReference(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.narrowReferenceInternal(symbolTable, list, type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4) && !JavaEntities.isPrimitiveT(JavaEntities.resolveToRawRValue(type4)));
        return type4;
    }

    private static Type narrowReferenceInternal(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        Type type4;
        Type type5;
        Object object;
        if (JavaTypeConverter.isIdentical(type2, type3)) {
            return null;
        }
        Type type6 = JavaEntities.resolveToRawRValue(type2);
        if (JavaTypeConverter.isIdentical(JavaEntities.tObject(symbolTable), type3) && (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2) || type6.isArray())) {
            return type2;
        }
        if (JavaEntities.isWrappedClassT(type3) || JavaEntities.isWrappedInterfaceT(type3)) {
            JavaEntities.SuperTypesIter superTypesIter = new JavaEntities.SuperTypesIter(symbolTable, list, type3);
            while (superTypesIter.hasNext()) {
                if (!JavaTypeConverter.isIdentical(type2, (Type)superTypesIter.next())) continue;
                return null;
            }
        }
        boolean bl = false;
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            object = new JavaEntities.SuperTypesIter(symbolTable, list, type2);
            while (object.hasNext()) {
                if (!JavaTypeConverter.isIdentical((Type)object.next(), type3)) continue;
                bl = true;
                break;
            }
        }
        if (JavaEntities.isWrappedClassT(type3)) {
            if (JavaEntities.isWrappedClassT(type2) && bl) {
                return type2;
            }
            if (JavaEntities.isWrappedInterfaceT(type2) && !type3.hasAttribute(JavaEntities.nameToModifier("final"))) {
                return type2;
            }
        }
        object = JavaEntities.resolveToRawRValue(type3);
        if (JavaEntities.isWrappedInterfaceT(type3)) {
            if (JavaEntities.isWrappedClassT(type2) && (bl || !type2.hasAttribute(JavaEntities.nameToModifier("final")))) {
                return type2;
            }
            if (JavaEntities.isWrappedInterfaceT(type2)) {
                List<Type> list2 = ((InterfaceT)object).getMethods();
                List<Type> list3 = ((InterfaceT)type6).getMethods();
                if (100 < list2.size() * list3.size()) {
                    throw new Error("implement sub-quadratic algorithm here");
                }
                for (Type type7 : list2) {
                    for (Type type8 : list3) {
                        MethodT methodT = type7.toMethod();
                        MethodT methodT2 = type8.toMethod();
                        if (!methodT.getName().equals(methodT2.getName()) || JavaTypeConverter.isIdentical(methodT.getResult(), methodT2.getResult())) continue;
                        List<Type> list4 = methodT.getParameters();
                        List<Type> list5 = methodT2.getParameters();
                        if (list4.size() != list5.size()) continue;
                        Iterator<Type> iterator = list4.iterator();
                        Iterator<Type> iterator2 = list5.iterator();
                        boolean bl2 = true;
                        while (bl2 && iterator.hasNext()) {
                            Type type9 = JavaEntities.dereference(iterator.next());
                            Type type10 = JavaEntities.dereference(iterator2.next());
                            bl2 = JavaTypeConverter.isIdentical(type9, type10);
                        }
                        if (!bl2) continue;
                        return null;
                    }
                }
                return type2;
            }
        }
        if (type6.isArray() && ((Type)object).isArray() && JavaTypeConverter.isNarrowerReference(symbolTable, list, type5 = JavaEntities.arrayElementType(type6.toArray()), type4 = JavaEntities.arrayElementType(((Type)object).toArray()))) {
            return type2;
        }
        return null;
    }

    public static Type promoteBinaryNumeric(Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.promoteBinaryNumericInternal(type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4) && JavaEntities.resolveToRawRValue(type4).isNumber());
        return type4;
    }

    private static Type promoteBinaryNumericInternal(Type type2, Type type3) {
        Type type4 = JavaEntities.resolveToRawRValue(type3);
        Type type5 = JavaEntities.resolveToRawRValue(type2);
        if (!type4.isNumber() || !type5.isNumber()) {
            return null;
        }
        NumberT numberT = (NumberT)type4;
        NumberT numberT2 = (NumberT)type5;
        NumberT.Kind kind = numberT.getKind();
        NumberT.Kind kind2 = numberT2.getKind();
        switch (kind2) {
            case DOUBLE: {
                switch (kind) {
                    case DOUBLE: {
                        return type3;
                    }
                }
                return JavaTypeConverter.widenPrimitive(type2, type3);
            }
            case FLOAT: {
                switch (kind) {
                    case FLOAT: 
                    case DOUBLE: {
                        return type3;
                    }
                }
                return JavaTypeConverter.widenPrimitive(type2, type3);
            }
            case LONG: {
                switch (kind) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return type3;
                    }
                }
                return JavaTypeConverter.widenPrimitive(type2, type3);
            }
        }
        switch (kind) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return type3;
            }
        }
        return JavaTypeConverter.widenPrimitive(JavaEntities.nameToBaseType("int"), type3);
    }

    public static Type promoteUnaryNumeric(Type type2) {
        assert (JavaEntities.isGeneralRValueT(type2));
        Type type3 = JavaTypeConverter.promoteUnaryNumericInternal(type2);
        assert (null == type3 || JavaEntities.isGeneralRValueT(type3) && JavaEntities.resolveToRawRValue(type3).isNumber());
        return type3;
    }

    private static Type promoteUnaryNumericInternal(Type type2) {
        Type type3 = JavaEntities.resolveToRawRValue(type2);
        if (type3.isNumber()) {
            NumberT.Kind kind = ((NumberT)type3).getKind();
            Type type4 = JavaEntities.nameToBaseType("int");
            switch (kind) {
                case BYTE: 
                case SHORT: 
                case CHAR: {
                    return JavaTypeConverter.widenPrimitive(type4, type2);
                }
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return type2;
                }
            }
        }
        return null;
    }

    public static strictfp Type widenPrimitive(Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type2) && JavaEntities.isGeneralRValueT(type3));
        Type type4 = JavaTypeConverter.widenPrimitiveInternal(type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4) && JavaEntities.resolveToRawRValue(type4).isNumber());
        return type4;
    }

    private static strictfp Type widenPrimitiveInternal(Type type2, Type type3) {
        Type type4 = JavaEntities.resolveToRawRValue(type2);
        Type type5 = JavaEntities.resolveToRawRValue(type3);
        if (!JavaEntities.isPrimitiveT(type5) || !JavaEntities.isPrimitiveT(type4)) {
            return null;
        }
        if (type5.isBoolean() || type4.isBoolean()) {
            return null;
        }
        NumberT numberT = (NumberT)type5;
        NumberT numberT2 = (NumberT)type4;
        NumberT.Kind kind = numberT.getKind();
        NumberT.Kind kind2 = numberT2.getKind();
        switch (kind) {
            case BYTE: {
                if (NumberT.Kind.SHORT == kind2 || NumberT.Kind.INT == kind2 || NumberT.Kind.LONG == kind2 || NumberT.Kind.FLOAT == kind2 || NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case SHORT: {
                if (NumberT.Kind.INT == kind2 || NumberT.Kind.LONG == kind2 || NumberT.Kind.FLOAT == kind2 || NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case CHAR: {
                if (NumberT.Kind.INT == kind2 || NumberT.Kind.LONG == kind2 || NumberT.Kind.FLOAT == kind2 || NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case INT: {
                if (NumberT.Kind.LONG == kind2 || NumberT.Kind.FLOAT == kind2 || NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case LONG: {
                if (NumberT.Kind.FLOAT == kind2 || NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case FLOAT: {
                if (NumberT.Kind.DOUBLE == kind2) break;
                return null;
            }
            case DOUBLE: {
                return null;
            }
        }
        if (type3.hasConstant()) {
            Number number;
            block9 : switch (kind) {
                case BYTE: {
                    byte by = (Byte)type3.getConstant().getValue();
                    switch (kind2) {
                        case SHORT: {
                            number = new Short(by);
                            break block9;
                        }
                        case INT: {
                            number = new Integer(by);
                            break block9;
                        }
                        case LONG: {
                            number = new Long(by);
                            break block9;
                        }
                        case FLOAT: {
                            number = new Float(by);
                            break block9;
                        }
                        case DOUBLE: {
                            number = new Double(by);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                case SHORT: {
                    short s = (Short)type3.getConstant().getValue();
                    switch (kind2) {
                        case INT: {
                            number = new Integer(s);
                            break block9;
                        }
                        case LONG: {
                            number = new Long(s);
                            break block9;
                        }
                        case FLOAT: {
                            number = new Float(s);
                            break block9;
                        }
                        case DOUBLE: {
                            number = new Double(s);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                case CHAR: {
                    char c = ((Character)type3.getConstant().getValue()).charValue();
                    switch (kind2) {
                        case INT: {
                            number = new Integer(c);
                            break block9;
                        }
                        case LONG: {
                            number = new Long(c);
                            break block9;
                        }
                        case FLOAT: {
                            number = new Float(c);
                            break block9;
                        }
                        case DOUBLE: {
                            number = new Double(c);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                case INT: {
                    int n = (Integer)type3.getConstant().getValue();
                    switch (kind2) {
                        case LONG: {
                            number = new Long(n);
                            break block9;
                        }
                        case FLOAT: {
                            number = new Float(n);
                            break block9;
                        }
                        case DOUBLE: {
                            number = new Double(n);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                case LONG: {
                    long l = (Long)type3.getConstant().getValue();
                    switch (kind2) {
                        case FLOAT: {
                            number = new Float(l);
                            break block9;
                        }
                        case DOUBLE: {
                            number = new Double(l);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                case FLOAT: {
                    float f = ((Float)type3.getConstant().getValue()).floatValue();
                    switch (kind2) {
                        case DOUBLE: {
                            number = new Double(f);
                            break block9;
                        }
                    }
                    number = null;
                    break;
                }
                default: {
                    number = null;
                }
            }
            if (null == number) {
                throw new Error();
            }
            return type4.annotate().constant(number);
        }
        return type2;
    }

    public static Type widenReference(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        assert (JavaEntities.isGeneralRValueT(type3) && JavaEntities.isGeneralRValueT(type2));
        Type type4 = JavaTypeConverter.widenReferenceInternal(symbolTable, list, type2, type3);
        assert (null == type4 || JavaEntities.isGeneralRValueT(type4) && !JavaEntities.isPrimitiveT(JavaEntities.resolveToRawRValue(type4)));
        return type4;
    }

    private static Type widenReferenceInternal(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        Object object;
        if (JavaTypeConverter.isIdentical(type2, type3)) {
            return null;
        }
        Type type4 = JavaEntities.resolveToRawRValue(type2);
        if (JavaEntities.isNullT(type3) && (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2) || type4.isArray())) {
            return type2;
        }
        Type type5 = JavaEntities.resolveToRawRValue(type3);
        if (type5.isClass() || type5.isInterface()) {
            if (JavaTypeConverter.isIdentical(type2, JavaEntities.tObject(symbolTable))) {
                return type2;
            }
            object = new JavaEntities.SuperTypesIter(symbolTable, list, type3);
            while (object.hasNext()) {
                if (!JavaTypeConverter.isIdentical(type2, (Type)object.next())) continue;
                return type2;
            }
        }
        if (type5.isArray()) {
            Type type6;
            if (JavaTypeConverter.isIdentical(type2, JavaEntities.tObjectAlias(symbolTable)) || JavaTypeConverter.isIdentical(type2, JavaEntities.tCloneable(symbolTable)) || JavaTypeConverter.isIdentical(type2, JavaEntities.tSerializable(symbolTable))) {
                return type2;
            }
            if (type4.isArray() && JavaTypeConverter.isWiderReference(symbolTable, list, (Type)(object = JavaEntities.arrayElementType(type4.toArray())), type6 = JavaEntities.arrayElementType(type5.toArray()))) {
                return type2;
            }
        }
        return null;
    }
}

