/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import xtc.lang.JavaEntities;
import xtc.tree.Attribute;
import xtc.type.AliasT;
import xtc.type.ClassT;
import xtc.type.InterfaceT;
import xtc.type.MethodT;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.util.SymbolTable;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaNoSourceAnalyzer {
    public final SymbolTable _table;

    public JavaNoSourceAnalyzer(SymbolTable symbolTable) {
        this._table = symbolTable;
    }

    private final Type defineMethod(List<Attribute> list, MethodT methodT, String string) {
        for (Attribute attribute : list) {
            methodT.addAttribute(attribute);
        }
        this._table.current().define(string, methodT);
        this._table.enter(string);
        methodT.scope(this._table.current().getQualifiedName());
        this._table.exit();
        JavaEntities.currentType(this._table).getMethods().add(methodT);
        assert (methodT.isMethod());
        return methodT;
    }

    public final void visitClassBody(Class clazz) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i = 0; i < classArray.length; ++i) {
            this.visitClassOrInterface(classArray[i]);
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            this.visitMethodDeclaration(constructorArray[i]);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            this.visitFieldDeclaration(fieldArray[i]);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.visitMethodDeclaration(methodArray[i]);
        }
    }

    private static String getQName(Class clazz) {
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (null == clazz2) {
            return clazz.getName();
        }
        return Utilities.qualify(JavaNoSourceAnalyzer.getQName(clazz2), clazz.getSimpleName());
    }

    public final Type visitClassDeclaration(Class clazz) {
        if (clazz.isInterface()) {
            throw new Error(clazz.getName());
        }
        List<Attribute> list = this.visitModifiers(clazz.getModifiers());
        String string = JavaNoSourceAnalyzer.getQName(clazz);
        Object object = Utilities.getName(string);
        int n = ((String)object).lastIndexOf(36);
        Object object2 = -1 == n ? object : ((String)object).substring(1 + n);
        Class clazz2 = clazz.getSuperclass();
        if (null == clazz2) {
            object = null;
            if (!"java.lang.Object".equals(clazz.getName())) {
                throw new Error();
            }
        } else {
            object = this.visitType(clazz.getSuperclass());
        }
        List<Type> list2 = this.visitTypeList(clazz.getInterfaces());
        ClassT classT = new ClassT(string, (Type)object, list2, new ArrayList<Type>(), new ArrayList<Type>());
        for (Attribute attribute : list) {
            classT.addAttribute(attribute);
        }
        String string2 = SymbolTable.toTagName((String)object2);
        this._table.current().define(string2, classT);
        this._table.enter((String)object2);
        classT.scope(this._table.current().getQualifiedName());
        this.visitClassBody(clazz);
        this._table.exit();
        assert (classT.isClass());
        return classT;
    }

    public final Type visitClassOrInterface(Class clazz) {
        return clazz.isInterface() ? this.visitInterfaceDeclaration(clazz) : this.visitClassDeclaration(clazz);
    }

    public final Type visitFieldDeclaration(Field field) {
        Type type2 = this.visitType(field.getType());
        VariableT variableT = VariableT.newField(type2, field.getName());
        for (Attribute attribute : this.visitModifiers(field.getModifiers())) {
            variableT.addAttribute(attribute);
        }
        this._table.current().define(field.getName(), variableT);
        variableT.scope(this._table.current().getQualifiedName());
        JavaEntities.currentType(this._table).getFields().add(variableT);
        assert (JavaEntities.isFieldT(variableT));
        return variableT;
    }

    public final List<Type> visitFormalParameters(Class[] classArray) {
        ArrayList<Type> arrayList = new ArrayList<Type>(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            VariableT variableT = VariableT.newParam(this.visitType(classArray[i]), "x" + i);
            assert (JavaEntities.isParameterT(variableT));
            arrayList.add(variableT);
        }
        return arrayList;
    }

    public final Type visitInterfaceDeclaration(Class clazz) {
        if (!clazz.isInterface()) {
            throw new Error(clazz.getName());
        }
        List<Attribute> list = this.visitModifiers(clazz.getModifiers());
        String string = clazz.getName();
        Object object = Utilities.getName(string);
        int n = ((String)object).lastIndexOf(36);
        Object object2 = -1 == n ? object : ((String)object).substring(1 + n);
        object = this.visitTypeList(clazz.getInterfaces());
        InterfaceT interfaceT = new InterfaceT(string, (List<Type>)object, new ArrayList<Type>(), new ArrayList<Type>());
        for (Attribute attribute : list) {
            interfaceT.addAttribute(attribute);
        }
        String string2 = SymbolTable.toTagName((String)object2);
        this._table.current().define(string2, interfaceT);
        this._table.enter((String)object2);
        interfaceT.scope(this._table.current().getQualifiedName());
        this.visitClassBody(clazz);
        this._table.exit();
        assert (interfaceT.isInterface());
        return interfaceT;
    }

    public final Type visitMethodDeclaration(Constructor constructor) {
        List<Attribute> list = this.visitModifiers(constructor.getModifiers());
        Type type2 = this.visitType(constructor.getDeclaringClass());
        List<Type> list2 = this.visitTypeList(constructor.getExceptionTypes());
        String string = JavaEntities.methodSymbolFromConstructor(constructor);
        List<Type> list3 = this.visitFormalParameters(constructor.getParameterTypes());
        MethodT methodT = JavaEntities.newRawConstructor(type2, list3, list2);
        Type type3 = this.defineMethod(list, methodT, string);
        return type3;
    }

    public final Type visitMethodDeclaration(Method method) {
        List<Attribute> list = this.visitModifiers(method.getModifiers());
        Type type2 = this.visitType(method.getReturnType());
        String string = method.getName();
        List<Type> list2 = this.visitTypeList(method.getExceptionTypes());
        String string2 = JavaEntities.methodSymbolFromMethod(method);
        List<Type> list3 = this.visitFormalParameters(method.getParameterTypes());
        MethodT methodT = new MethodT(type2, string, list3, false, list2);
        Type type3 = this.defineMethod(list, methodT, string2);
        return type3;
    }

    public final List<Attribute> visitModifiers(int n) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (Modifier.isAbstract(n)) {
            arrayList.add(JavaEntities.nameToModifier("abstract"));
        }
        if (Modifier.isFinal(n)) {
            arrayList.add(JavaEntities.nameToModifier("final"));
        }
        if (Modifier.isNative(n)) {
            arrayList.add(JavaEntities.nameToModifier("native"));
        }
        if (Modifier.isPrivate(n)) {
            arrayList.add(JavaEntities.nameToModifier("private"));
        }
        if (Modifier.isProtected(n)) {
            arrayList.add(JavaEntities.nameToModifier("protected"));
        }
        if (Modifier.isPublic(n)) {
            arrayList.add(JavaEntities.nameToModifier("public"));
        }
        if (Modifier.isStatic(n)) {
            arrayList.add(JavaEntities.nameToModifier("static"));
        }
        if (Modifier.isStrict(n)) {
            arrayList.add(JavaEntities.nameToModifier("strictfp"));
        }
        if (Modifier.isSynchronized(n)) {
            arrayList.add(JavaEntities.nameToModifier("synchronized"));
        }
        if (Modifier.isTransient(n)) {
            arrayList.add(JavaEntities.nameToModifier("transient"));
        }
        if (Modifier.isVolatile(n)) {
            arrayList.add(JavaEntities.nameToModifier("volatile"));
        }
        return arrayList;
    }

    public final Type visitType(Class clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        Type type2 = clazz2.isPrimitive() ? this.visitTypeName(clazz2.getName()) : new AliasT(clazz2.getName());
        Type type3 = JavaEntities.typeWithDimensions(type2, n);
        assert (JavaEntities.isReturnT(type3));
        return type3;
    }

    public final List<Type> visitTypeList(Class[] classArray) {
        ArrayList<Type> arrayList = new ArrayList<Type>(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            arrayList.add(this.visitType(classArray[i]));
        }
        return arrayList;
    }

    public final Type visitTypeName(String string) {
        if (1 == string.length()) {
            switch (string.charAt(0)) {
                case 'Z': {
                    return JavaEntities.nameToBaseType("boolean");
                }
                case 'B': {
                    return JavaEntities.nameToBaseType("byte");
                }
                case 'C': {
                    return JavaEntities.nameToBaseType("char");
                }
                case 'D': {
                    return JavaEntities.nameToBaseType("double");
                }
                case 'F': {
                    return JavaEntities.nameToBaseType("float");
                }
                case 'I': {
                    return JavaEntities.nameToBaseType("int");
                }
                case 'J': {
                    return JavaEntities.nameToBaseType("long");
                }
                case 'S': {
                    return JavaEntities.nameToBaseType("short");
                }
            }
        }
        Type type2 = JavaEntities.nameToBaseType(string);
        assert (type2.isBoolean() || type2.isNumber() || type2 instanceof VoidT);
        return type2;
    }
}

