/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import xtc.Constants;
import xtc.lang.JavaAnalyzer;
import xtc.lang.JavaAstSimplifier;
import xtc.lang.JavaExternalAnalyzer;
import xtc.lang.JavaNoSourceAnalyzer;
import xtc.lang.JavaParser;
import xtc.lang.JavaPrinter;
import xtc.lang.JavaTypeConverter;
import xtc.lang.JavaUnitTests;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.Attribute;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ClassT;
import xtc.type.DynamicReference;
import xtc.type.FunctionOrMethodT;
import xtc.type.IntegerT;
import xtc.type.InterfaceT;
import xtc.type.MethodT;
import xtc.type.NullReference;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Type;
import xtc.type.TypePrinter;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.type.WrappedT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaEntities {
    public static final File TEMP_DIR;
    public static final Set<String> EMPTY_SET;
    private static final Map<Attribute, String> MODIFIER_TO_NAME;
    private static final Map<String, Type> NAME_TO_BASETYPE;
    private static final Map<String, Attribute> NAME_TO_MODIFIER;
    private static boolean recursiveTypeDotType;

    public static void addBaseTypes(SymbolTable symbolTable) {
        if (null == symbolTable.lookup("int")) {
            String string = JavaEntities.enterScopeByQualifiedName(symbolTable, "");
            for (String string2 : NAME_TO_BASETYPE.keySet()) {
                symbolTable.current().define(string2, JavaEntities.nameToBaseType(string2));
            }
            JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        }
    }

    public static List<MethodT> allAbstractMethods(SymbolTable symbolTable, List<File> list, ClassT classT) {
        List<MethodT> list2 = JavaEntities.allMethods(symbolTable, list, classT);
        List<MethodT> list3 = JavaEntities.mostSpecificMethods(symbolTable, list, list2);
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        for (MethodT methodT : list3) {
            if (!JavaEntities.hasModifier(methodT, "abstract")) continue;
            arrayList.add(methodT);
        }
        return arrayList;
    }

    public static List<MethodT> allMethods(SymbolTable symbolTable, List<File> list, ClassT classT) {
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        SuperTypesIter superTypesIter = new SuperTypesIter(symbolTable, list, classT);
        while (superTypesIter.hasNext()) {
            arrayList.addAll(JavaEntities.methodsOwn((Type)superTypesIter.next()));
        }
        return arrayList;
    }

    public static Set<String> allUsedIdentifiers(GNode gNode) {
        MiniVisitor_allUsedIdentifiers miniVisitor_allUsedIdentifiers = new MiniVisitor_allUsedIdentifiers();
        Set<String> set = JavaEntities.stringSet(miniVisitor_allUsedIdentifiers.dispatch(gNode));
        return set;
    }

    public static Type arrayElementType(ArrayT arrayT) {
        AnnotatedT annotatedT = (AnnotatedT)arrayT.getType();
        Type type2 = annotatedT.getType();
        assert (JavaEntities.isRValueT(type2));
        return type2;
    }

    public static VariableT arrayLengthField() {
        VariableT variableT = VariableT.newField(JavaEntities.nameToBaseType("int"), "length");
        variableT.addAttribute(JavaEntities.nameToModifier("final"));
        variableT.addAttribute(JavaEntities.nameToModifier("public"));
        variableT.scope(".package(java.lang).file().Object");
        assert (JavaEntities.isFieldT(variableT));
        return variableT;
    }

    public static String baseTypeToName(Type type2) {
        return JavaEntities.typeToString(null, false, type2);
    }

    public static ClassOrInterfaceT canonicalAliasToType(SymbolTable symbolTable, List<File> list, AliasT aliasT, boolean bl) {
        if (aliasT.getType() == null) {
            aliasT.setType(JavaEntities.canonicalNameToType(symbolTable, list, aliasT.getName(), bl));
        }
        return (ClassOrInterfaceT)aliasT.getType();
    }

    public static String canonicalName(SymbolTable symbolTable, String string) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(symbolTable);
        if (classOrInterfaceT != null) {
            return Utilities.qualify(classOrInterfaceT.getQName(), string);
        }
        PackageT packageT = JavaEntities.currentPackage(symbolTable);
        if (packageT == null) {
            Error error = new Error();
            error.printStackTrace();
            throw error;
        }
        if ("".equals(packageT.getName())) {
            return string;
        }
        return Utilities.qualify(packageT.getName(), string);
    }

    public static PackageT canonicalNameToPackage(SymbolTable symbolTable, String string) {
        if (string.indexOf(46) == -1) {
            return JavaEntities.simpleNameToPackage(symbolTable, string);
        }
        PackageT packageT = JavaEntities.canonicalNameToPackage(symbolTable, Utilities.getQualifier(string));
        return JavaEntities.packageDotPackage(symbolTable, packageT, Utilities.unqualify(string));
    }

    public static Type canonicalNameToPackageOrType(SymbolTable symbolTable, List<File> list, String string, boolean bl) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.canonicalNameToType(symbolTable, list, string, bl);
        return classOrInterfaceT != null ? classOrInterfaceT : JavaEntities.canonicalNameToPackage(symbolTable, string);
    }

    public static ClassOrInterfaceT canonicalNameToType(SymbolTable symbolTable, List<File> list, String string, boolean bl) {
        if (string.indexOf(46) == -1) {
            if (bl) {
                return JavaEntities.packageDotType(symbolTable, list, JavaEntities.simpleNameToPackage(symbolTable, ""), string);
            }
            return null;
        }
        String string2 = Utilities.getQualifier(string);
        String string3 = Utilities.unqualify(string);
        if (string2.indexOf(46) == -1) {
            return JavaEntities.packageDotType(symbolTable, list, JavaEntities.simpleNameToPackage(symbolTable, string2), string3);
        }
        Type type2 = JavaEntities.canonicalNameToPackageOrType(symbolTable, list, string2, bl);
        if (type2.isPackage()) {
            return JavaEntities.packageDotType(symbolTable, list, type2.toPackage(), string3);
        }
        return JavaEntities.typeDotType(symbolTable, list, (ClassOrInterfaceT)type2, false, string3);
    }

    public static List<File> classpath(Runtime runtime) {
        return runtime.getFileList("inputDirectory");
    }

    public static boolean constructorsReturnVoid() {
        return true;
    }

    public static boolean couldCreateConcreteSubclass(SymbolTable symbolTable, List<File> list, ClassT classT) {
        List<MethodT> list2 = JavaEntities.allAbstractMethods(symbolTable, list, classT);
        for (MethodT methodT : list2) {
            JavaEntities.resolveIfAliasMethod(symbolTable, list, methodT);
        }
        for (MethodT methodT : list2) {
            for (MethodT methodT2 : list2) {
                if (!methodT.getName().equals(methodT2.getName()) || !JavaEntities.sameMethodSignature(methodT, methodT2) || JavaTypeConverter.isIdentical(methodT.getResult(), methodT2.getResult())) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Type> currentImports(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (SymbolTable.isInNameSpace(string, "file")) {
                return JavaEntities.imports(symbolTable, JavaEntities.currentPackage(symbolTable), SymbolTable.fromNameSpace(string));
            }
            scope = scope.getParent();
        }
        return JavaEntities.imports(symbolTable, null, null);
    }

    public static MethodT currentMethod(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (SymbolTable.isInNameSpace(string, "method")) {
                ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(symbolTable);
                for (Type type2 : classOrInterfaceT.getMethods()) {
                    assert (type2.isMethod());
                    assert (type2.hasScope(false));
                    String string2 = type2.getScope();
                    if (!scope.getQualifiedName().equals(string2)) continue;
                    return type2.toMethod();
                }
            }
            scope = scope.getParent();
        }
        return null;
    }

    public static PackageT currentPackage(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (string.startsWith("package(")) {
                return JavaEntities.canonicalNameToPackage(symbolTable, SymbolTable.fromNameSpace(string));
            }
            scope = scope.getParent();
        }
        return JavaEntities.canonicalNameToPackage(symbolTable, "");
    }

    public static ClassOrInterfaceT currentType(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = SymbolTable.toTagName(scope.getName());
            ClassOrInterfaceT classOrInterfaceT = (ClassOrInterfaceT)scope.getParent().lookup(string);
            if (classOrInterfaceT != null) {
                return classOrInterfaceT;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public static PackageT declaringPackage(SymbolTable symbolTable, Type type2) {
        if (type2.isPackage()) {
            return (PackageT)type2;
        }
        if (type2 instanceof ClassOrInterfaceT && JavaEntities.isTypeTopLevel((ClassOrInterfaceT)type2)) {
            String string = JavaEntities.enterScopeByQualifiedName(symbolTable, JavaEntities.typeToScopeName(type2));
            PackageT packageT = JavaEntities.currentPackage(symbolTable);
            JavaEntities.enterScopeByQualifiedName(symbolTable, string);
            return packageT;
        }
        if (JavaEntities.isTypeMember(type2)) {
            return JavaEntities.declaringPackage(symbolTable, JavaEntities.declaringType(symbolTable, type2));
        }
        String string = JavaEntities.enterScopeByQualifiedName(symbolTable, JavaEntities.declaringScopeName(type2));
        PackageT packageT = JavaEntities.currentPackage(symbolTable);
        JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        return packageT;
    }

    public static String declaringScopeName(Type type2) {
        Type type3;
        assert (!type2.isAlias());
        Type type4 = type3 = JavaEntities.isConstantT(type2) ? ((AnnotatedT)type2).getType() : type2;
        if (type3.hasScope(false)) {
            String string = type3.getScope();
            if (JavaEntities.isLocalT(type2) || JavaEntities.isParameterT(type2) || JavaEntities.isFieldT(type2)) {
                return string;
            }
            return Utilities.getQualifier(string);
        }
        return null;
    }

    public static ClassOrInterfaceT declaringType(SymbolTable symbolTable, Type type2) {
        assert (type2.isMethod() || JavaEntities.isFieldT(type2) || JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2));
        String string = JavaEntities.declaringScopeName(type2);
        assert (null != string);
        assert (JavaEntities.isScopeForMember(string));
        String string2 = JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(symbolTable);
        assert (null != classOrInterfaceT);
        JavaEntities.enterScopeByQualifiedName(symbolTable, string2);
        return classOrInterfaceT;
    }

    public static Type dereference(Type type2) {
        assert (JavaEntities.isGeneralLValueT(type2));
        WrappedT wrappedT = JavaEntities.isLValueT(type2) ? (AnnotatedT)type2 : JavaEntities.resolveToRawLValue(type2);
        Type type3 = wrappedT.getType();
        assert (JavaEntities.isGeneralRValueT(type3));
        return type3;
    }

    public static List<ClassOrInterfaceT> directSuperTypes(SymbolTable symbolTable, List<File> list, Type type2) {
        Object object;
        if (type2.isArray()) {
            ArrayList<ClassOrInterfaceT> arrayList = new ArrayList<ClassOrInterfaceT>();
            arrayList.add(JavaEntities.tObject(symbolTable));
            arrayList.add(JavaEntities.tCloneable(symbolTable));
            arrayList.add(JavaEntities.tSerializable(symbolTable));
            return arrayList;
        }
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.resolveToRawClassOrInterfaceT(type2);
        ArrayList<AliasT> arrayList = new ArrayList<AliasT>();
        if (JavaEntities.isWrappedClassT(type2) && null != (object = classOrInterfaceT.toClass().getParent())) {
            arrayList.add(((Type)object).toAlias());
        }
        for (Type type3 : classOrInterfaceT.getInterfaces()) {
            arrayList.add(type3.toAlias());
        }
        object = JavaEntities.typeToScopeName(type2);
        return JavaEntities.qualifiedAliasesToTypes(symbolTable, list, (String)object, arrayList);
    }

    public static String enterScopeByQualifiedName(SymbolTable symbolTable, String string) {
        String string2 = symbolTable.current().getQualifiedName();
        assert (null != string);
        symbolTable.setScope(symbolTable.getScope(string));
        return string2;
    }

    public static List<VariableT> fieldsApplicableAndAccessible(SymbolTable symbolTable, List<File> list, Type type2, boolean bl, String string) {
        List<VariableT> list2 = bl ? JavaEntities.fieldsOwnAndInherited(symbolTable, list, type2) : JavaEntities.fieldsOwn(type2);
        ArrayList<VariableT> arrayList = new ArrayList<VariableT>();
        for (VariableT variableT : list2) {
            if (!JavaEntities.isAccessibleIn(symbolTable, list, variableT, type2) || !JavaEntities.isApplicableField(symbolTable, list, variableT, string)) continue;
            arrayList.add(variableT);
        }
        return arrayList;
    }

    public static List<VariableT> fieldsInherited(SymbolTable symbolTable, List<File> list, Type type2) {
        ArrayList<VariableT> arrayList = new ArrayList<VariableT>();
        List<VariableT> list2 = JavaEntities.fieldsOwn(type2);
        String string = JavaEntities.declaringScopeName(type2);
        assert (null != string || type2.isArray());
        List<ClassOrInterfaceT> list3 = JavaEntities.directSuperTypes(symbolTable, list, type2);
        for (ClassOrInterfaceT classOrInterfaceT : list3) {
            List<VariableT> list4 = JavaEntities.fieldsOwnAndInherited(symbolTable, list, classOrInterfaceT);
            block1: for (VariableT variableT : list4) {
                if (JavaEntities.hasModifier(variableT, "private") || null != string && !JavaEntities.isAccessibleFromIn(symbolTable, list, string, variableT, classOrInterfaceT)) continue;
                for (VariableT variableT2 : list2) {
                    if (!variableT.getName().equals(variableT2.getName())) continue;
                    continue block1;
                }
                for (VariableT variableT2 : arrayList) {
                    if (variableT != variableT2) continue;
                    continue block1;
                }
                arrayList.add(variableT);
            }
        }
        return arrayList;
    }

    public static List<VariableT> fieldsOwn(Type type2) {
        ArrayList<VariableT> arrayList = new ArrayList<VariableT>(1);
        if (type2.isArray()) {
            arrayList.add(JavaEntities.arrayLengthField());
        } else {
            for (Type type3 : JavaEntities.resolveToRawClassOrInterfaceT(type2).getFields()) {
                arrayList.add(type3.toVariable());
            }
        }
        return arrayList;
    }

    public static List<VariableT> fieldsOwnAndInherited(SymbolTable symbolTable, List<File> list, Type type2) {
        ArrayList<VariableT> arrayList = new ArrayList<VariableT>();
        arrayList.addAll(JavaEntities.fieldsInherited(symbolTable, list, type2));
        arrayList.addAll(JavaEntities.fieldsOwn(type2));
        return arrayList;
    }

    public static String fileNameToScopeName(String string) {
        return SymbolTable.toNameSpace(string, "file");
    }

    public static boolean hasAbstractMethods(SymbolTable symbolTable, List<File> list, ClassT classT) {
        return !JavaEntities.allAbstractMethods(symbolTable, list, classT).isEmpty();
    }

    public static boolean hasCircularDependency(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT) {
        SuperTypesIter superTypesIter = new SuperTypesIter(symbolTable, list, classOrInterfaceT, false);
        block0: while (superTypesIter.hasNext()) {
            Type type2 = (Type)superTypesIter.next();
            while (!JavaTypeConverter.isIdentical(classOrInterfaceT, type2)) {
                if (!JavaEntities.isTypeMember(type2)) continue block0;
                type2 = JavaEntities.declaringType(symbolTable, type2);
            }
            return true;
        }
        return false;
    }

    public static boolean hasModifier(Type type2, String string) {
        Type type3;
        Type type4 = type3 = type2.isAlias() ? ((AliasT)type2).getType() : type2;
        assert (JavaEntities.isGeneralLValueT(type3) || type3.isMethod() || type3.isClass() || type3.isInterface());
        return type3.hasAttribute(JavaEntities.nameToModifier(string), false);
    }

    static List<Type> imports(SymbolTable symbolTable, PackageT packageT, String string) {
        String string2 = null == packageT ? "" : JavaEntities.scopeName(packageT, string);
        Object object = symbolTable.lookup(Utilities.qualify(string2, "imports(*)"));
        if (null == object) {
            return new ArrayList<Type>();
        }
        if (object instanceof List) {
            return JavaEntities.typeList((List)object);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.add((Type)object);
        return arrayList;
    }

    public static boolean isAccessible(SymbolTable symbolTable, List<File> list, Type type2) {
        return JavaEntities.isAccessibleIn(symbolTable, list, type2, null);
    }

    public static boolean isAccessibleFromIn(SymbolTable symbolTable, List<File> list, String string, Type type2, Type type3) {
        String string2 = JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        boolean bl = JavaEntities.isAccessibleIn(symbolTable, list, type2, type3);
        JavaEntities.enterScopeByQualifiedName(symbolTable, string2);
        return bl;
    }

    public static boolean isAccessibleIn(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        Type type4;
        if (type2.isArray()) {
            return true;
        }
        if (type2.isAlias()) {
            return JavaEntities.isAccessible(symbolTable, list, ((AliasT)type2).getType());
        }
        if (type2.isPackage()) {
            return true;
        }
        boolean bl = JavaEntities.declaringPackage(symbolTable, type2).getName().equals(JavaEntities.currentPackage(symbolTable).getName());
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            if (JavaEntities.hasModifier(type2, "public")) {
                return true;
            }
            if (JavaEntities.isTypeTopLevel((ClassOrInterfaceT)type2)) {
                return bl;
            }
        }
        if (!JavaEntities.isTypeMember(type2)) {
            return true;
        }
        Type type5 = type4 = null == type3 ? JavaEntities.declaringType(symbolTable, type2) : type3;
        assert (null != type4);
        if (!JavaEntities.isAccessible(symbolTable, list, type4)) {
            return false;
        }
        if (JavaEntities.hasModifier(type2, "public")) {
            return true;
        }
        if (JavaEntities.hasModifier(type2, "protected")) {
            if (bl) {
                return true;
            }
            if (type2.isMethod() && JavaEntities.isConstructor(type4, type2.toMethod())) {
                return false;
            }
            ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(symbolTable, type2);
            ClassOrInterfaceT classOrInterfaceT2 = JavaEntities.currentType(symbolTable);
            return (null == classOrInterfaceT2 || JavaEntities.isSuperClass(symbolTable, list, classOrInterfaceT, classOrInterfaceT2)) && JavaEntities.isSuperClass(symbolTable, list, classOrInterfaceT, type4);
        }
        if (JavaEntities.hasModifier(type2, "private")) {
            ClassOrInterfaceT classOrInterfaceT;
            String string = JavaEntities.enterScopeByQualifiedName(symbolTable, JavaEntities.typeToScopeName(type4));
            while (true) {
                classOrInterfaceT = JavaEntities.currentType(symbolTable);
                JavaEntities.enterScopeByQualifiedName(symbolTable, JavaEntities.typeToScopeName(classOrInterfaceT));
                if (JavaEntities.isTypeTopLevel(classOrInterfaceT)) break;
                symbolTable.exit();
            }
            ClassOrInterfaceT classOrInterfaceT3 = classOrInterfaceT;
            JavaEntities.enterScopeByQualifiedName(symbolTable, string);
            return symbolTable.current().getQualifiedName().startsWith(JavaEntities.typeToScopeName(classOrInterfaceT3));
        }
        return bl;
    }

    public static boolean isApplicableField(SymbolTable symbolTable, List<File> list, VariableT variableT, String string) {
        if (string.equals(variableT.getName())) {
            ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(symbolTable, variableT);
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.typeToScopeName(classOrInterfaceT), variableT.getType());
            return true;
        }
        return false;
    }

    public static boolean isApplicableMemberType(Type type2, String string) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.resolveToRawClassOrInterfaceT(type2);
        return string.equals(classOrInterfaceT.getName());
    }

    public static boolean isApplicableMethod(SymbolTable symbolTable, List<File> list, MethodT methodT, String string, List<Type> list2) {
        if (!methodT.getName().equals(string)) {
            return false;
        }
        List<Type> list3 = methodT.getParameters();
        if (list3.size() != list2.size()) {
            return false;
        }
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(symbolTable, methodT);
        String string2 = symbolTable.current().getQualifiedName();
        Iterator<Type> iterator = list3.iterator();
        Iterator<Type> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Type type2 = iterator.next();
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.typeToScopeName(classOrInterfaceT), JavaEntities.dereference(type2));
            Type type3 = iterator2.next();
            Type type4 = JavaEntities.resolveIfAlias(symbolTable, list, string2, type3);
            boolean bl = JavaTypeConverter.isParameterPassable(symbolTable, list, JavaEntities.dereference(type2), type4);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean isCheckedException(SymbolTable symbolTable, List<File> list, Type type2) {
        return JavaEntities.isSuperClass(symbolTable, list, JavaEntities.tThrowable(symbolTable), type2) && !JavaEntities.isSuperClass(symbolTable, list, JavaEntities.tRuntimeException(symbolTable), type2) && !JavaEntities.isSuperClass(symbolTable, list, JavaEntities.tError(symbolTable), type2);
    }

    public static boolean isConstantT(Type type2) {
        return null != type2 && type2.isAnnotated() && type2.hasConstant(false);
    }

    public static boolean isConstructor(Type type2, MethodT methodT) {
        if (!type2.isClass()) {
            return false;
        }
        return type2.toClass().getName().equals(methodT.getName());
    }

    public static boolean isExpressionT(Type type2) {
        return JavaEntities.isGeneralLValueT(type2) || JavaEntities.isGeneralRValueT(type2);
    }

    public static boolean isFieldT(Type type2) {
        return type2.isVariable() && VariableT.Kind.FIELD == type2.toVariable().getKind();
    }

    public static boolean isGeneralLValueT(Type type2) {
        return JavaEntities.isLValueT(type2) || JavaEntities.isLocalT(type2) || JavaEntities.isFieldT(type2) || JavaEntities.isParameterT(type2);
    }

    public static boolean isGeneralRValueT(Type type2) {
        return JavaEntities.isNullT(type2) || JavaEntities.isWrappedRValueT(type2);
    }

    public static boolean isInLocalNameSpace(String string) {
        String string2 = Utilities.unqualify(string);
        return SymbolTable.isInNameSpace(string2, "method") || SymbolTable.isInNameSpace(string2, "block") || SymbolTable.isInNameSpace(string2, "forStatement") || SymbolTable.isInNameSpace(string2, "labeledStatement") || SymbolTable.isInNameSpace(string2, "function") || SymbolTable.isInNameSpace(string2, "withStatement") || SymbolTable.isInNameSpace(string2, "matchClause") || SymbolTable.isInNameSpace(string2, "catchClause");
    }

    public static boolean isInt(Type type2) {
        Type type3 = JavaTypeConverter.promoteUnaryNumeric(type2);
        if (null == type3) {
            return false;
        }
        Type type4 = JavaEntities.resolveToRawRValue(type3);
        return type4.isInteger() && NumberT.Kind.INT == ((IntegerT)type4).getKind();
    }

    public static boolean isLocalT(Type type2) {
        return type2.isVariable() && VariableT.Kind.LOCAL == type2.toVariable().getKind();
    }

    public static boolean isLValueT(Type type2) {
        return null != type2 && type2.isAnnotated() && type2.hasShape(false);
    }

    public static boolean isNotAValueT(Type type2) {
        return type2.isPackage() || type2 instanceof AnnotatedT && type2.hasAttribute(Constants.ATT_NOT_A_VALUE) && JavaEntities.isReturnT(((AnnotatedT)type2).getType());
    }

    public static boolean isNullT(Type type2) {
        return JavaEntities.isConstantT(type2) && ((AnnotatedT)type2).getType().isVoid();
    }

    public static boolean isParameterT(Type type2) {
        return type2.isVariable() && VariableT.Kind.PARAMETER == type2.toVariable().getKind();
    }

    public static boolean isPrimitiveT(Type type2) {
        return type2.isBoolean() || type2.isNumber();
    }

    public static boolean isReferenceT(Type type2) {
        if (JavaEntities.isNullT(type2)) {
            return true;
        }
        Type type3 = JavaEntities.isConstantT(type2) ? ((AnnotatedT)type2).getType() : type2;
        return type3.isArray() || JavaEntities.isWrappedClassT(type3) || JavaEntities.isWrappedInterfaceT(type3);
    }

    public static boolean isReturnT(Type type2) {
        return type2.isVoid() || JavaEntities.isRValueT(type2);
    }

    public static boolean isRValueT(Type type2) {
        return JavaEntities.isPrimitiveT(type2) || type2.isArray() || JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2);
    }

    public static boolean isScopeForMember(String string) {
        return JavaEntities.isScopeNested(string) && !JavaEntities.isInLocalNameSpace(string);
    }

    public static boolean isScopeLocal(String string) {
        return JavaEntities.isInLocalNameSpace(string);
    }

    public static boolean isScopeNested(String string) {
        if (JavaEntities.isScopeTopLevel(string)) {
            return false;
        }
        return 3 < Utilities.toComponents(string).length;
    }

    public static boolean isScopeTopLevel(String string) {
        if (null == string) {
            System.out.println("hohoho");
        }
        assert (null != string);
        if ("".equals(string) || ".".equals(string)) {
            return true;
        }
        String[] stringArray = Utilities.toComponents(string);
        if (0 < stringArray.length) assert ("".equals(stringArray[0]));
        if (2 < stringArray.length && SymbolTable.isInNameSpace(stringArray[1], "package")) {
            assert (SymbolTable.isInNameSpace(stringArray[2], "file"));
            return 3 == stringArray.length;
        }
        return false;
    }

    public static boolean isSuperClass(SymbolTable symbolTable, List<File> list, Type type2, Type type3) {
        if (!JavaEntities.isWrappedClassT(type3) || !JavaEntities.isWrappedClassT(type2)) {
            return false;
        }
        return JavaTypeConverter.isIdentical(type2, type3) || JavaTypeConverter.isWiderReference(symbolTable, list, type2, type3);
    }

    public static boolean isSuperMethod(SymbolTable symbolTable, List<File> list, MethodT methodT, MethodT methodT2) {
        Type type2;
        Type type3;
        if (!methodT2.getName().equals(methodT.getName())) {
            return false;
        }
        if (methodT2.getParameters().size() != methodT.getParameters().size()) {
            return false;
        }
        if (JavaEntities.hasModifier(methodT, "private")) {
            return false;
        }
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(symbolTable, methodT);
        ClassOrInterfaceT classOrInterfaceT2 = JavaEntities.declaringType(symbolTable, methodT2);
        if (!JavaEntities.isAccessibleFromIn(symbolTable, list, JavaEntities.typeToScopeName(classOrInterfaceT2), methodT, classOrInterfaceT)) {
            return false;
        }
        if (!JavaTypeConverter.isParameterPassable(symbolTable, list, classOrInterfaceT, classOrInterfaceT2)) {
            return false;
        }
        Iterator<Type> iterator = methodT2.getParameters().iterator();
        Iterator<Type> iterator2 = methodT.getParameters().iterator();
        while (iterator.hasNext()) {
            type3 = iterator2.next().toVariable();
            type2 = iterator.next().toVariable();
            Type type4 = type3.getType();
            Type type5 = type2.getType();
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.declaringScopeName(methodT), type4);
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.declaringScopeName(methodT2), type5);
            if (JavaTypeConverter.isParameterPassable(symbolTable, list, type4, type5)) continue;
            return false;
        }
        if (JavaTypeConverter.isIdentical(classOrInterfaceT, classOrInterfaceT2) && JavaEntities.sameMethodSignature(methodT, methodT2)) {
            type3 = methodT.getResult();
            type2 = methodT2.getResult();
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.declaringScopeName(methodT), type3);
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.declaringScopeName(methodT2), type2);
            if (!JavaTypeConverter.isReturnTypeSubstitutable(symbolTable, list, type3, type2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isTypeAnonymous(ClassOrInterfaceT classOrInterfaceT) {
        return classOrInterfaceT.isClass() && null == classOrInterfaceT.toClass().getName();
    }

    public static boolean isTypeInner(ClassOrInterfaceT classOrInterfaceT) {
        return !JavaEntities.hasModifier(classOrInterfaceT, "static") && JavaEntities.isTypeNested(classOrInterfaceT);
    }

    public static boolean isTypeLocal(ClassOrInterfaceT classOrInterfaceT) {
        return JavaEntities.isScopeLocal(JavaEntities.declaringScopeName(classOrInterfaceT)) && !JavaEntities.isTypeAnonymous(classOrInterfaceT);
    }

    public static boolean isTypeMember(Type type2) {
        return JavaEntities.isScopeForMember(JavaEntities.declaringScopeName(type2));
    }

    public static boolean isTypeNamed(ClassOrInterfaceT classOrInterfaceT) {
        return !JavaEntities.isTypeAnonymous(classOrInterfaceT);
    }

    public static boolean isTypeNested(ClassOrInterfaceT classOrInterfaceT) {
        String string = JavaEntities.declaringScopeName(classOrInterfaceT);
        assert (null != string);
        return JavaEntities.isScopeNested(string);
    }

    public static boolean isTypeTopLevel(ClassOrInterfaceT classOrInterfaceT) {
        return JavaEntities.isScopeTopLevel(JavaEntities.declaringScopeName(classOrInterfaceT));
    }

    public static boolean isWrappedClassT(Type type2) {
        if (type2.isAlias()) {
            Type type3 = ((AliasT)type2).getType();
            return null == type3 || type3.isClass();
        }
        return type2.isClass();
    }

    public static boolean isWrappedInterfaceT(Type type2) {
        if (type2.isAlias()) {
            Type type3 = ((AliasT)type2).getType();
            return null == type3 || type3.isInterface();
        }
        return type2.isInterface();
    }

    public static boolean isWrappedRValueT(Type type2) {
        return JavaEntities.isConstantT(type2) && JavaEntities.isRValueT(((AnnotatedT)type2).getType()) || JavaEntities.isRValueT(type2);
    }

    public static String javaAstToString(Node node) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        JavaPrinter javaPrinter = new JavaPrinter(new Printer(charArrayWriter));
        javaPrinter.dispatch(node);
        return charArrayWriter.toString();
    }

    private static GNode javaStringToAst(String string, String string2) {
        try {
            return JavaEntities.javaStringToAst(string, string2, true);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public static GNode javaStringToAst(String string, String string2, boolean bl) throws Exception {
        Method method = JavaParser.class.getDeclaredMethod("p" + string, Integer.TYPE);
        method.setAccessible(true);
        String string3 = JavaEntities.unicodeUnescape(string2);
        JavaParser javaParser = new JavaParser(new StringReader(string3), "<input>", string3.length());
        Object[] objectArray = new Object[]{new Integer(0)};
        Result result2 = (Result)method.invoke((Object)javaParser, objectArray);
        if (!result2.hasValue()) {
            javaParser.signal(result2.parseError());
        }
        if (result2.index != string3.length()) {
            throw new ParseException("input not fully consumed");
        }
        GNode gNode = (GNode)result2.semanticValue();
        if (bl) {
            return (GNode)new JavaAstSimplifier().dispatch(gNode);
        }
        return gNode;
    }

    public static Type javaStringToType(String string) {
        SymbolTable symbolTable = new SymbolTable();
        JavaUnitTests.enterPackageFile(symbolTable, "", "<input>");
        return JavaEntities.javaStringToType(string, symbolTable);
    }

    private static Type javaStringToType(String string, SymbolTable symbolTable) {
        GNode gNode = JavaEntities.javaStringToAst("Type", string);
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        Type type2 = (Type)javaAnalyzer.dispatch(gNode);
        return type2;
    }

    public static GNode javaTypeToAst(SymbolTable symbolTable, Type type2) {
        String string = JavaEntities.javaTypeToString(symbolTable, type2);
        GNode gNode = JavaEntities.javaStringToAst("ResultType", string);
        return JavaEntities.scrubLocations(gNode);
    }

    public static String javaTypeToString(SymbolTable symbolTable, Type type2) {
        if (JavaEntities.isGeneralRValueT(type2)) {
            Type type3 = JavaEntities.resolveToRawRValue(type2);
            return JavaEntities.typeToString(symbolTable, false, type3);
        }
        return JavaEntities.typeToString(symbolTable, false, type2);
    }

    static ClassOrInterfaceT lookupImport(SymbolTable symbolTable, List<File> list, AliasT aliasT) {
        return JavaEntities.canonicalAliasToType(symbolTable, list, aliasT, false);
    }

    public static List<Type> memberTypesApplicableAndAccessible(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT, boolean bl, String string) {
        List<Type> list2 = bl ? JavaEntities.memberTypesOwnAndInherited(symbolTable, list, classOrInterfaceT) : JavaEntities.memberTypesOwn(symbolTable, list, classOrInterfaceT);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type type2 : list2) {
            if (!JavaEntities.isAccessibleIn(symbolTable, list, type2, classOrInterfaceT) || !JavaEntities.isApplicableMemberType(type2, string)) continue;
            arrayList.add(type2);
        }
        return arrayList;
    }

    public static List<Type> memberTypesInherited(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        List<Type> list2 = JavaEntities.memberTypesOwn(symbolTable, list, classOrInterfaceT);
        String string = JavaEntities.declaringScopeName(classOrInterfaceT);
        assert (null != string || classOrInterfaceT.isArray());
        List<ClassOrInterfaceT> list3 = JavaEntities.directSuperTypes(symbolTable, list, classOrInterfaceT);
        for (ClassOrInterfaceT classOrInterfaceT2 : list3) {
            List<Type> list4 = JavaEntities.memberTypesOwnAndInherited(symbolTable, list, classOrInterfaceT2);
            block1: for (Type type2 : list4) {
                if (JavaEntities.hasModifier(type2, "private") || null != string && !JavaEntities.isAccessibleFromIn(symbolTable, list, string, type2, classOrInterfaceT2)) continue;
                String string2 = JavaEntities.resolveToRawClassOrInterfaceT(type2).getName();
                for (Type type3 : list2) {
                    if (!string2.equals(JavaEntities.resolveToRawClassOrInterfaceT(type3).getName())) continue;
                    continue block1;
                }
                for (Type type3 : arrayList) {
                    if (type2 != type3) continue;
                    continue block1;
                }
                arrayList.add(type2);
            }
        }
        return arrayList;
    }

    public static List<Type> memberTypesOwn(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT) {
        if (classOrInterfaceT.isArray()) {
            return new ArrayList<Type>(0);
        }
        SymbolTable.Scope scope = symbolTable.getScope(JavaEntities.typeToScopeName(classOrInterfaceT));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator<String> iterator = scope.symbols();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Type type2 = (Type)scope.lookupLocally(string);
            if (!JavaEntities.isWrappedClassT(type2) && !JavaEntities.isWrappedInterfaceT(type2)) continue;
            arrayList.add(type2);
        }
        return arrayList;
    }

    public static List<Type> memberTypesOwnAndInherited(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.addAll(JavaEntities.memberTypesInherited(symbolTable, list, classOrInterfaceT));
        arrayList.addAll(JavaEntities.memberTypesOwn(symbolTable, list, classOrInterfaceT));
        return arrayList;
    }

    public static List<MethodT> methodsApplicableAndAccessible(SymbolTable symbolTable, List<File> list, Type type2, boolean bl, String string, List<Type> list2) {
        List<MethodT> list3 = bl ? JavaEntities.methodsOwnAndInherited(symbolTable, list, type2) : JavaEntities.methodsOwn(type2);
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        for (MethodT methodT : list3) {
            if (!JavaEntities.isAccessibleIn(symbolTable, list, methodT, type2) || !JavaEntities.isApplicableMethod(symbolTable, list, methodT, string, list2)) continue;
            arrayList.add(methodT);
        }
        return arrayList;
    }

    public static List<MethodT> methodsInherited(SymbolTable symbolTable, List<File> list, Type type2, boolean bl) {
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        List<MethodT> list2 = JavaEntities.methodsOwn(type2);
        String string = JavaEntities.typeToScopeName(type2);
        assert (null != string || type2.isArray());
        List<ClassOrInterfaceT> list3 = JavaEntities.directSuperTypes(symbolTable, list, type2);
        for (ClassOrInterfaceT classOrInterfaceT : list3) {
            List<MethodT> list4 = JavaEntities.methodsOwnAndInherited(symbolTable, list, classOrInterfaceT);
            block1: for (MethodT methodT : list4) {
                Object object2;
                JavaEntities.resolveIfAliasMethod(symbolTable, list, methodT);
                if (JavaEntities.hasModifier(methodT, "private") || null != string && !JavaEntities.isAccessibleFromIn(symbolTable, list, string, methodT, classOrInterfaceT)) continue;
                if (!bl) {
                    for (MethodT methodT2 : list2) {
                        JavaEntities.resolveIfAliasMethod(symbolTable, list, methodT2);
                        if (!JavaEntities.sameMethodSignature(methodT2, methodT)) continue;
                        continue block1;
                    }
                }
                boolean bl2 = false;
                for (Object object2 : arrayList) {
                    if (object2 == methodT) continue block1;
                    if (!JavaEntities.sameMethodSignature(methodT, (MethodT)object2)) continue;
                    assert (JavaEntities.hasModifier(methodT, "abstract") || JavaEntities.hasModifier((Type)object2, "abstract"));
                    if (JavaEntities.hasModifier(methodT, "abstract") && JavaEntities.hasModifier((Type)object2, "abstract")) continue;
                    if (!JavaEntities.hasModifier(methodT, "abstract")) {
                        bl2 = true;
                        continue;
                    }
                    if (JavaEntities.hasModifier((Type)object2, "abstract")) continue;
                    continue block1;
                }
                arrayList.add(methodT);
                if (!bl2) continue;
                ArrayList<MethodT> arrayList2 = arrayList;
                arrayList = new ArrayList();
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    MethodT methodT3 = (MethodT)object2.next();
                    if (methodT3 != methodT && JavaEntities.sameMethodSignature(methodT3, methodT)) continue;
                    arrayList.add(methodT3);
                }
            }
        }
        return arrayList;
    }

    public static List<MethodT> methodsOwn(Type type2) {
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        if (!type2.isArray()) {
            for (Type type3 : JavaEntities.resolveToRawClassOrInterfaceT(type2).getMethods()) {
                arrayList.add(type3.toMethod());
            }
        }
        return arrayList;
    }

    public static List<MethodT> methodsOwnAndInherited(SymbolTable symbolTable, List<File> list, Type type2) {
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        arrayList.addAll(JavaEntities.methodsInherited(symbolTable, list, type2, false));
        arrayList.addAll(JavaEntities.methodsOwn(type2));
        return arrayList;
    }

    public static String methodSymbolFromAst(GNode gNode) {
        String string = gNode.getString(3);
        String string2 = JavaEntities.javaAstToString(gNode.getGeneric(4));
        return "method(" + string + ")" + string2;
    }

    public static String methodSymbolFromConstructor(Constructor constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("method(<init>)");
        JavaEntities.methodSymbolHelper(stringBuilder, constructor.getParameterTypes());
        return stringBuilder.toString();
    }

    public static String methodSymbolFromMethod(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("method(").append(method.getName()).append(")");
        JavaEntities.methodSymbolHelper(stringBuilder, method.getParameterTypes());
        return stringBuilder.toString();
    }

    private static void methodSymbolHelper(StringBuilder stringBuilder, Class[] classArray) {
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            if (0 < i) {
                stringBuilder.append(',');
            }
            stringBuilder.append(classArray[i].getName());
        }
        stringBuilder.append(')');
    }

    public static String modifiersToString(Type type2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Attribute attribute : type2.attributes()) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(JavaEntities.modifierToName(attribute));
        }
        return stringBuilder.toString();
    }

    public static String modifierToName(Attribute attribute) {
        return MODIFIER_TO_NAME.get(attribute);
    }

    private static List<MethodT> mostSpecificMethods(SymbolTable symbolTable, List<File> list, List<MethodT> list2) {
        ArrayList<MethodT> arrayList = new ArrayList<MethodT>();
        block0: for (MethodT methodT : list2) {
            for (MethodT methodT2 : list2) {
                if (methodT == methodT2 || !JavaEntities.isSuperMethod(symbolTable, list, methodT, methodT2)) continue;
                continue block0;
            }
            arrayList.add(methodT);
        }
        return arrayList;
    }

    public static Type nameToBaseType(String string) {
        return NAME_TO_BASETYPE.get(string);
    }

    public static Attribute nameToModifier(String string) {
        Attribute attribute = NAME_TO_MODIFIER.get(string);
        assert (null != attribute);
        return attribute;
    }

    public static MethodT newRawConstructor(Type type2, List<Type> list, List<Type> list2) {
        return new MethodT(JavaEntities.constructorsReturnVoid() ? JavaEntities.nameToBaseType("void") : type2, JavaEntities.typeToSimpleName(type2), list, false, list2);
    }

    public static Type notAValueIfClassOrInterface(Type type2) {
        if (null == type2) {
            return type2;
        }
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            AnnotatedT annotatedT = new AnnotatedT(type2);
            return annotatedT.attribute(Constants.ATT_NOT_A_VALUE);
        }
        return type2;
    }

    public static PackageT packageDotPackage(SymbolTable symbolTable, PackageT packageT, String string) {
        String string2 = SymbolTable.toTagName(string);
        String string3 = JavaEntities.packageNameToScopeName(packageT.getName());
        String string4 = "." + Utilities.qualify(string3, string2);
        PackageT packageT2 = (PackageT)symbolTable.lookup(string4);
        if (packageT2 == null) {
            packageT2 = new PackageT(Utilities.qualify(packageT.getName(), string));
            SymbolTable.Scope scope = symbolTable.lookupScope(string4);
            if (scope == null) {
                SymbolTable.Scope scope2 = symbolTable.current();
                symbolTable.setScope(symbolTable.root());
                symbolTable.enter(JavaEntities.packageNameToScopeName(packageT.getName()));
                scope = symbolTable.current();
                symbolTable.setScope(scope2);
            }
            scope.define(string2, packageT2);
        }
        return packageT2;
    }

    public static Type packageDotPackageOrType(SymbolTable symbolTable, List<File> list, PackageT packageT, String string) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.packageDotType(symbolTable, list, packageT, string);
        return classOrInterfaceT != null ? classOrInterfaceT : JavaEntities.packageDotPackage(symbolTable, packageT, string);
    }

    static ClassOrInterfaceT packageDotType(SymbolTable symbolTable, List<File> list, PackageT packageT, String string) {
        assert (null != packageT);
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.packageDotType_existing(symbolTable, packageT, string);
        if (null != classOrInterfaceT) {
            return classOrInterfaceT;
        }
        ClassOrInterfaceT classOrInterfaceT2 = JavaEntities.packageDotType_external(symbolTable, list, packageT, string);
        if (null != classOrInterfaceT2) {
            return classOrInterfaceT2;
        }
        return JavaEntities.packageDotType_noSource(symbolTable, packageT, string);
    }

    private static ClassOrInterfaceT packageDotType_existing(SymbolTable symbolTable, PackageT packageT, String string) {
        String string2 = SymbolTable.toTagName(string);
        String string3 = "." + JavaEntities.packageNameToScopeName(packageT.getName());
        SymbolTable.Scope scope = symbolTable.getScope(string3);
        if (scope != null) {
            Iterator<String> iterator = scope.nested();
            while (iterator.hasNext()) {
                String string4 = string3 + "." + iterator.next() + "." + string2;
                Type type2 = (Type)symbolTable.lookup(string4);
                if (type2 == null || type2.isAlias()) continue;
                return (ClassOrInterfaceT)type2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassOrInterfaceT packageDotType_external(SymbolTable symbolTable, List<File> list, PackageT packageT, String string) {
        String string2 = SymbolTable.toTagName(string);
        String string3 = File.separatorChar + Utilities.toPath(packageT.getName()) + File.separatorChar + string + ".java";
        for (File file : list) {
            try {
                Object object;
                File file2 = new File(file, string3);
                String string4 = file2.getAbsolutePath();
                if (!file2.exists()) continue;
                String string5 = JavaEntities.scopeName(packageT, string4) + "." + string2;
                if (null == symbolTable.lookupScope(string5)) {
                    object = JavaEntities.enterScopeByQualifiedName(symbolTable, "");
                    FileReader fileReader = null;
                    try {
                        fileReader = new FileReader(file2);
                        UnicodeUnescaper unicodeUnescaper = new UnicodeUnescaper(fileReader);
                        JavaParser javaParser = new JavaParser(unicodeUnescaper, string4);
                        Result result2 = javaParser.pCompilationUnit(0);
                        if (result2.hasValue()) {
                            GNode gNode = (GNode)result2.semanticValue();
                            GNode gNode2 = (GNode)new JavaAstSimplifier().dispatch(gNode);
                            new JavaExternalAnalyzer(new Runtime(), symbolTable).dispatch(gNode2);
                        }
                    }
                    finally {
                        if (null != fileReader) {
                            fileReader.close();
                        }
                    }
                    JavaEntities.enterScopeByQualifiedName(symbolTable, (String)object);
                }
                if ((object = (ClassOrInterfaceT)symbolTable.lookup(string5)) == null) continue;
                return object;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    static ClassOrInterfaceT packageDotType_noSource(SymbolTable symbolTable, PackageT packageT, String string) {
        String string2 = "." + JavaEntities.packageNameToScopeName(packageT.getName()) + ".file()." + SymbolTable.toTagName(string);
        if (null == symbolTable.lookup(string2)) {
            Class<?> clazz;
            try {
                clazz = Class.forName(packageT.getName() + "." + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            if (packageT.getName().equals(clazz.getPackage().getName())) {
                String string3 = JavaEntities.enterScopeByQualifiedName(symbolTable, "");
                symbolTable.enter(JavaEntities.packageNameToScopeName(packageT.getName()));
                symbolTable.enter("file()");
                new JavaNoSourceAnalyzer(symbolTable).visitClassOrInterface(clazz);
                JavaEntities.enterScopeByQualifiedName(symbolTable, string3);
            }
        }
        return (ClassOrInterfaceT)symbolTable.lookup(string2);
    }

    public static String packageNameToScopeName(String string) {
        return SymbolTable.toNameSpace(string, "package");
    }

    public static String qNameWithDollars(SymbolTable symbolTable, ClassOrInterfaceT classOrInterfaceT) {
        String string = classOrInterfaceT.getQName();
        if (null == symbolTable) {
            return string;
        }
        String string2 = JavaEntities.declaringPackage(symbolTable, classOrInterfaceT).getName();
        if (0 == string2.length()) {
            return string;
        }
        assert (string.startsWith(string2));
        String string3 = string.substring(string2.length() + 1).replace('.', '$');
        String string4 = string2 + "." + string3;
        return string4;
    }

    public static List<ClassOrInterfaceT> qualifiedAliasesToTypes(SymbolTable symbolTable, List<File> list, String string, List<AliasT> list2) {
        ArrayList<ClassOrInterfaceT> arrayList = new ArrayList<ClassOrInterfaceT>(list2.size());
        for (AliasT aliasT : list2) {
            ClassOrInterfaceT classOrInterfaceT = JavaEntities.qualifiedAliasToType(symbolTable, list, string, aliasT);
            if (null == classOrInterfaceT) continue;
            arrayList.add(classOrInterfaceT);
        }
        return arrayList;
    }

    public static ClassOrInterfaceT qualifiedAliasToType(SymbolTable symbolTable, List<File> list, String string, AliasT aliasT) {
        if (aliasT.getType() == null) {
            aliasT.setType(JavaEntities.qualifiedNameToType(symbolTable, list, string, aliasT.getName()));
        }
        return (ClassOrInterfaceT)aliasT.getType();
    }

    public static Type qualifiedNameToPackageOrType(SymbolTable symbolTable, List<File> list, String string, String string2) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.qualifiedNameToType(symbolTable, list, string, string2);
        return classOrInterfaceT != null ? classOrInterfaceT : JavaEntities.canonicalNameToPackage(symbolTable, string2);
    }

    public static ClassOrInterfaceT qualifiedNameToType(SymbolTable symbolTable, List<File> list, String string, String string2) {
        if (string2.indexOf(46) == -1) {
            return JavaEntities.simpleNameToType(symbolTable, list, string, string2);
        }
        String string3 = Utilities.getQualifier(string2);
        String string4 = Utilities.unqualify(string2);
        Type type2 = JavaEntities.qualifiedNameToPackageOrType(symbolTable, list, string, string3);
        if (type2.isPackage()) {
            return JavaEntities.packageDotType(symbolTable, list, type2.toPackage(), string4);
        }
        return JavaEntities.typeDotType(symbolTable, list, (ClassOrInterfaceT)type2, true, string4);
    }

    public static Type resolveIfAlias(SymbolTable symbolTable, List<File> list, String string, Type type2) {
        assert (null != string);
        if (null == type2) {
            return null;
        }
        if (JavaEntities.isGeneralLValueT(type2)) {
            Type type3 = JavaEntities.dereference(type2);
            JavaEntities.resolveIfAlias(symbolTable, list, string, type3);
            return type2;
        }
        if (type2.isAnnotated()) {
            Type type4 = ((AnnotatedT)type2).getType();
            JavaEntities.resolveIfAlias(symbolTable, list, string, type4);
            return type2;
        }
        if (type2.isArray()) {
            Type type5 = JavaEntities.arrayElementType(type2.toArray());
            JavaEntities.resolveIfAlias(symbolTable, list, string, type5);
            return type2;
        }
        if (type2.isAlias()) {
            return JavaEntities.qualifiedAliasToType(symbolTable, list, string, type2.toAlias());
        }
        return type2;
    }

    public static MethodT resolveIfAliasMethod(SymbolTable symbolTable, List<File> list, MethodT methodT) {
        String string = JavaEntities.declaringScopeName(methodT);
        assert (null != string);
        JavaEntities.resolveIfAlias(symbolTable, list, string, JavaEntities.declaringType(symbolTable, methodT));
        JavaEntities.resolveIfAlias(symbolTable, list, string, methodT.getResult());
        for (Type type2 : methodT.getParameters()) {
            JavaEntities.resolveIfAlias(symbolTable, list, string, type2);
        }
        for (Type type2 : methodT.getExceptions()) {
            JavaEntities.resolveIfAlias(symbolTable, list, string, type2);
        }
        return methodT;
    }

    static ClassOrInterfaceT resolveToRawClassOrInterfaceT(Type type2) {
        return (ClassOrInterfaceT)JavaEntities.resolveToRawRValue(type2);
    }

    public static WrappedT resolveToRawLValue(Type type2) {
        assert (JavaEntities.isGeneralLValueT(type2));
        boolean bl = type2.isAnnotated();
        WrappedT wrappedT = (WrappedT)(bl ? ((AnnotatedT)type2).getType() : type2);
        assert (JavaEntities.isLValueT(wrappedT) || JavaEntities.isLocalT(wrappedT) || JavaEntities.isFieldT(wrappedT) || JavaEntities.isParameterT(wrappedT));
        return wrappedT;
    }

    public static Type resolveToRawRValue(Type type2) {
        assert (JavaEntities.isGeneralRValueT(type2));
        Type type3 = type2;
        if (!JavaEntities.isNullT(type3)) {
            while (true) {
                if (type3.isAlias()) {
                    type3 = ((AliasT)type3).getType();
                    continue;
                }
                if (type3.isAnnotated()) {
                    type3 = ((AnnotatedT)type3).getType();
                    continue;
                }
                if (!JavaEntities.isConstantT(type3)) break;
                type3 = ((AnnotatedT)type3).getType();
            }
        }
        assert (JavaEntities.isNullT(type3) || JavaEntities.isPrimitiveT(type3) || type3.isArray() || type3.isClass() || type3.isInterface());
        return type3;
    }

    public static Type resolveToRValue(Type type2) {
        Type type3;
        assert (JavaEntities.isGeneralRValueT(type2));
        Type type4 = JavaEntities.isConstantT(type2) ? ((AnnotatedT)type2).getType() : type2;
        Type type5 = type3 = type4.isAlias() ? ((AliasT)type4).getType() : type4;
        assert (JavaEntities.isPrimitiveT(type3) || type3.isArray() || type3.isClass() || type3.isInterface());
        return type3;
    }

    public static Type resolveToValue(AnnotatedT annotatedT) {
        assert (JavaEntities.isNotAValueT(annotatedT));
        Type type2 = annotatedT.getType();
        for (Attribute attribute : annotatedT.attributes()) {
            if (attribute.equals(Constants.ATT_NOT_A_VALUE)) continue;
            type2 = type2.attribute(attribute);
        }
        if (annotatedT.hasScope(false)) {
            type2.scope(annotatedT.getScope());
        }
        return type2;
    }

    public static boolean runtimeAssrt(Runtime runtime, Node node, boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            Formatter formatter = new Formatter();
            formatter.format(string, objectArray);
            runtime.error(formatter.toString(), node);
        }
        return bl;
    }

    public static boolean sameMethodReturnType(MethodT methodT, MethodT methodT2) {
        Type type2 = methodT.getResult();
        Type type3 = methodT2.getResult();
        if (type2.isVoid() || type3.isVoid()) {
            return type2.isVoid() && type3.isVoid();
        }
        return JavaTypeConverter.isIdentical(type2, type3);
    }

    public static boolean sameMethodSignature(MethodT methodT, MethodT methodT2) {
        if (!methodT.getName().equals(methodT2.getName())) {
            return false;
        }
        List<Type> list = methodT.getParameters();
        List<Type> list2 = methodT2.getParameters();
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<Type> iterator = list.iterator();
        Iterator<Type> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Type type2;
            Type type3 = iterator.next();
            Type type4 = iterator2.next();
            assert (JavaEntities.isParameterT(type3) && JavaEntities.isParameterT(type4));
            Type type5 = JavaEntities.dereference(type3);
            if (JavaTypeConverter.isIdentical(type5, type2 = JavaEntities.dereference(type4))) continue;
            return false;
        }
        return true;
    }

    static String scopeName(PackageT packageT, String string) {
        return "." + JavaEntities.packageNameToScopeName(packageT.getName()) + "." + JavaEntities.fileNameToScopeName(string);
    }

    public static GNode scrubLocations(GNode gNode) {
        new MiniVisitor_scrubLocations().dispatch(gNode);
        return gNode;
    }

    public static Type simpleNameToExpression(SymbolTable symbolTable, List<File> list, String string, String string2) {
        Type type2;
        boolean bl;
        String string3 = JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        Type type3 = (Type)symbolTable.lookup(string2);
        JavaEntities.resolveIfAlias(symbolTable, list, string, type3);
        boolean bl2 = bl = null != type3 && JavaEntities.isGeneralLValueT(type3);
        if (bl) {
            type2 = JavaEntities.dereference(type3);
            JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.typeToScopeName(JavaEntities.currentType(symbolTable)), type2);
        }
        JavaEntities.enterScopeByQualifiedName(symbolTable, string3);
        if (!bl && JavaEntities.isScopeNested(symbolTable.current().getQualifiedName()) && null != (type2 = JavaEntities.currentType(symbolTable))) {
            return JavaEntities.typeDotField(symbolTable, list, type2, true, string2);
        }
        return type3;
    }

    public static PackageT simpleNameToPackage(SymbolTable symbolTable, String string) {
        String string2 = SymbolTable.toTagName(string);
        String string3 = "." + string2;
        PackageT packageT = (PackageT)symbolTable.lookup(string3);
        if (packageT == null) {
            packageT = new PackageT(string);
            symbolTable.lookupScope(string3).define(string2, packageT);
        }
        return packageT;
    }

    public static Type simpleNameToPackageOrType(SymbolTable symbolTable, List<File> list, String string, String string2) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.simpleNameToType(symbolTable, list, string, string2);
        return classOrInterfaceT != null ? classOrInterfaceT : JavaEntities.simpleNameToPackage(symbolTable, string2);
    }

    public static Type simpleNameToPackageOrTypeOrExpression(SymbolTable symbolTable, List<File> list, String string, String string2) {
        Type type2 = JavaEntities.simpleNameToExpression(symbolTable, list, string, string2);
        return type2 != null ? type2 : JavaEntities.simpleNameToPackageOrType(symbolTable, list, string, string2);
    }

    public static ClassOrInterfaceT simpleNameToType(SymbolTable symbolTable, List<File> list, String string, String string2) {
        String string3 = JavaEntities.enterScopeByQualifiedName(symbolTable, string);
        ClassOrInterfaceT classOrInterfaceT = null;
        Iterable<Object> iterable = (Type)symbolTable.lookup(SymbolTable.toTagName(string2));
        if (null != iterable && !((Type)iterable).isPackage()) {
            ClassOrInterfaceT classOrInterfaceT2 = classOrInterfaceT = ((Type)iterable).isAlias() ? JavaEntities.lookupImport(symbolTable, list, ((Type)iterable).toAlias()) : (ClassOrInterfaceT)iterable;
        }
        if (null == classOrInterfaceT && JavaEntities.isScopeNested(string) && null != (iterable = JavaEntities.currentType(symbolTable))) {
            classOrInterfaceT = JavaEntities.typeDotType(symbolTable, list, iterable, true, string2);
        }
        if (null == classOrInterfaceT) {
            classOrInterfaceT = JavaEntities.packageDotType(symbolTable, list, JavaEntities.currentPackage(symbolTable), string2);
        }
        if (null == classOrInterfaceT && null != (iterable = JavaEntities.currentImports(symbolTable))) {
            Type type2;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext() && null == (classOrInterfaceT = JavaEntities.packageDotType(symbolTable, list, (PackageT)(type2 = (Type)iterator.next()), string2))) {
            }
        }
        if (null == classOrInterfaceT) {
            classOrInterfaceT = JavaEntities.packageDotType(symbolTable, list, JavaEntities.canonicalNameToPackage(symbolTable, "java.lang"), string2);
        }
        JavaEntities.enterScopeByQualifiedName(symbolTable, string3);
        if (null == classOrInterfaceT) {
            return null;
        }
        return classOrInterfaceT;
    }

    public static Set<String> stringSet(Object object) {
        return (Set)object;
    }

    public static ClassT tClass(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.Class").toClass();
    }

    public static InterfaceT tCloneable(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.Cloneable").toInterface();
    }

    public static ClassT tError(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.Error").toClass();
    }

    private static ClassOrInterfaceT tForName(SymbolTable symbolTable, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        return JavaEntities.canonicalNameToType(symbolTable, arrayList, string, false);
    }

    public static ClassT tObject(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.Object").toClass();
    }

    public static AliasT tObjectAlias(SymbolTable symbolTable) {
        return new AliasT("java.lang.Object", (Type)JavaEntities.tObject(symbolTable));
    }

    public static ClassT tRuntimeException(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.RuntimeException").toClass();
    }

    public static InterfaceT tSerializable(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.io.Serializable").toInterface();
    }

    public static ClassT tString(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.String").toClass();
    }

    public static ClassT tThrowable(SymbolTable symbolTable) {
        return JavaEntities.tForName(symbolTable, "java.lang.Throwable").toClass();
    }

    public static String typeDeclString(SymbolTable symbolTable, Object object) {
        assert (object instanceof Type || object instanceof List);
        if (object instanceof Type) {
            return JavaEntities.typeToString(symbolTable, true, (Type)object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type2 : JavaEntities.typeList((List)object)) {
            stringBuilder.append(JavaEntities.typeToString(symbolTable, true, type2)).append(';');
        }
        return stringBuilder.toString();
    }

    public static VariableT typeDotField(SymbolTable symbolTable, List<File> list, Type type2, boolean bl, String string) {
        List<VariableT> list2 = JavaEntities.fieldsApplicableAndAccessible(symbolTable, list, type2, bl, string);
        if (1 == list2.size()) {
            return list2.get(0);
        }
        return null;
    }

    public static MethodT typeDotMethod(SymbolTable symbolTable, List<File> list, Type type2, boolean bl, String string, List<Type> list2) {
        MethodT methodT;
        List<MethodT> list3 = JavaEntities.methodsApplicableAndAccessible(symbolTable, list, type2, bl, string, list2);
        List<MethodT> list4 = JavaEntities.mostSpecificMethods(symbolTable, list, list3);
        if (list4.size() == 1) {
            methodT = list4.get(0);
        } else {
            int n = 0;
            MethodT methodT2 = null;
            for (MethodT methodT3 : list4) {
                if (methodT2 == null) {
                    methodT2 = methodT3;
                }
                assert (JavaEntities.sameMethodSignature(methodT3, methodT2));
                if (JavaEntities.hasModifier(methodT3, "abstract")) continue;
                methodT2 = methodT3;
                ++n;
            }
            assert (n <= 1);
            methodT = methodT2;
        }
        if (null == methodT) {
            return null;
        }
        JavaEntities.resolveIfAlias(symbolTable, list, JavaEntities.typeToScopeName(type2), methodT.getResult());
        return methodT;
    }

    public static ClassOrInterfaceT typeDotType(SymbolTable symbolTable, List<File> list, ClassOrInterfaceT classOrInterfaceT, boolean bl, String string) {
        if (recursiveTypeDotType) {
            return null;
        }
        recursiveTypeDotType = true;
        List<Type> list2 = JavaEntities.memberTypesApplicableAndAccessible(symbolTable, list, classOrInterfaceT, bl, string);
        recursiveTypeDotType = false;
        if (1 == list2.size()) {
            return (ClassOrInterfaceT)list2.get(0);
        }
        return null;
    }

    public static Type typeDotTypeOrField(SymbolTable symbolTable, List<File> list, Type type2, boolean bl, String string) {
        assert (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2) || type2.isArray());
        if (bl) {
            SuperTypesIter superTypesIter = new SuperTypesIter(symbolTable, list, type2);
            while (superTypesIter.hasNext()) {
                Type type3 = JavaEntities.typeDotTypeOrField(symbolTable, list, (Type)superTypesIter.next(), false, string);
                if (null == type3) continue;
                return type3;
            }
            return null;
        }
        VariableT variableT = JavaEntities.typeDotField(symbolTable, list, type2, false, string);
        if (null != variableT) {
            return variableT;
        }
        return JavaEntities.typeDotType(symbolTable, list, (ClassOrInterfaceT)type2, false, string);
    }

    public static List<Type> typeList(List list) {
        return list;
    }

    public static String typeToDescriptor(SymbolTable symbolTable, Type type2) {
        if (JavaEntities.isConstantT(type2)) {
            return JavaEntities.typeToDescriptor(symbolTable, type2.toAnnotated().getType());
        }
        if (type2.isBoolean()) {
            return "Z";
        }
        if (type2.isNumber()) {
            switch (((NumberT)type2).getKind()) {
                case BYTE: {
                    return "B";
                }
                case CHAR: {
                    return "C";
                }
                case DOUBLE: {
                    return "D";
                }
                case FLOAT: {
                    return "F";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case SHORT: {
                    return "S";
                }
            }
        }
        if (type2.isVoid()) {
            return "V";
        }
        if (type2.isArray()) {
            return "[" + JavaEntities.typeToDescriptor(symbolTable, JavaEntities.arrayElementType(type2.toArray()));
        }
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            return "L" + JavaEntities.qNameWithDollars(symbolTable, JavaEntities.resolveToRawClassOrInterfaceT(type2)).replace('.', '/') + ";";
        }
        if (type2.isMethod()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            for (Type type3 : type2.toMethod().getParameters()) {
                stringBuilder.append(JavaEntities.typeToDescriptor(symbolTable, JavaEntities.dereference(type3)));
            }
            stringBuilder.append(')').append(JavaEntities.typeToDescriptor(symbolTable, type2.toMethod().getResult()));
            return stringBuilder.toString();
        }
        throw new Error();
    }

    static String typeToScopeName(Type type2) {
        if (null == type2 || type2.isArray()) {
            return "";
        }
        String string = type2.getScope();
        assert (null != string);
        return string;
    }

    public static String typeToSimpleName(Type type2) {
        if (type2.isAlias()) {
            return Utilities.unqualify(type2.toAlias().getName());
        }
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            return JavaEntities.resolveToRawClassOrInterfaceT(type2).getName();
        }
        assert (type2.isMethod());
        return type2.toMethod().getName();
    }

    public static String typeToString(SymbolTable symbolTable, boolean bl, Type type2) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Printer printer = new Printer(charArrayWriter);
        JavaTypePrinter javaTypePrinter = new JavaTypePrinter(symbolTable, bl, printer);
        javaTypePrinter.dispatch(type2);
        printer.flush();
        return charArrayWriter.toString();
    }

    public static Type typeWithDimensions(Type type2, int n) {
        if (n == 0) {
            return type2;
        }
        Type type3 = JavaEntities.typeWithDimensions(type2, n - 1);
        Type type4 = type3.annotate().shape(new DynamicReference(NumberT.INT));
        return new ArrayT(type4, true);
    }

    public static String unicodeUnescape(String string) {
        if (!string.contains("\\u")) {
            return string;
        }
        UnicodeUnescaper unicodeUnescaper = new UnicodeUnescaper(new StringReader(string));
        StringBuilder stringBuilder = new StringBuilder(string.length());
        try {
            int n;
            while (-1 != (n = unicodeUnescaper.read())) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new Error("internal error", iOException);
        }
        return stringBuilder.toString();
    }

    public static boolean zeroLiteral(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('1' <= c && c <= '9') {
                return false;
            }
            if ('d' != c && 'D' != c && 'e' != c && 'E' != c && 'f' != c && 'F' != c) continue;
            return true;
        }
        return true;
    }

    static {
        EMPTY_SET = Collections.emptySet();
        MODIFIER_TO_NAME = new HashMap<Attribute, String>();
        NAME_TO_BASETYPE = new HashMap<String, Type>();
        NAME_TO_MODIFIER = new HashMap<String, Attribute>();
        recursiveTypeDotType = false;
        String[] stringArray = new String[]{System.getProperty("TMP"), System.getProperty("TEMP"), "/tmp", "/cygwin/tmp", "."};
        File file = null;
        for (String string : stringArray) {
            File file2;
            if (null == string || !(file2 = new File(string)).exists()) continue;
            file = file2;
            break;
        }
        assert (null != file && file.exists());
        TEMP_DIR = file;
        NAME_TO_MODIFIER.put("public", Constants.ATT_PUBLIC);
        NAME_TO_MODIFIER.put("protected", Constants.ATT_PROTECTED);
        NAME_TO_MODIFIER.put("private", Constants.ATT_PRIVATE);
        NAME_TO_MODIFIER.put("static", Constants.ATT_STORAGE_STATIC);
        NAME_TO_MODIFIER.put("abstract", Constants.ATT_ABSTRACT);
        NAME_TO_MODIFIER.put("final", Constants.ATT_CONSTANT);
        NAME_TO_MODIFIER.put("native", Constants.ATT_NATIVE);
        NAME_TO_MODIFIER.put("synchronized", Constants.ATT_SYNCHRONIZED);
        NAME_TO_MODIFIER.put("transient", Constants.ATT_TRANSIENT);
        NAME_TO_MODIFIER.put("volatile", Constants.ATT_VOLATILE);
        NAME_TO_MODIFIER.put("strictfp", Constants.ATT_STRICT_FP);
        for (Map.Entry entry2 : NAME_TO_MODIFIER.entrySet()) {
            MODIFIER_TO_NAME.put((Attribute)entry2.getValue(), (String)entry2.getKey());
        }
        NAME_TO_BASETYPE.put("boolean", BooleanT.TYPE);
        NAME_TO_BASETYPE.put("byte", NumberT.BYTE);
        NAME_TO_BASETYPE.put("char", NumberT.CHAR);
        NAME_TO_BASETYPE.put("double", NumberT.DOUBLE);
        NAME_TO_BASETYPE.put("float", NumberT.FLOAT);
        NAME_TO_BASETYPE.put("int", NumberT.INT);
        NAME_TO_BASETYPE.put("long", NumberT.LONG);
        NAME_TO_BASETYPE.put("null", VoidT.TYPE.annotate().constant(NullReference.NULL));
        NAME_TO_BASETYPE.put("short", NumberT.SHORT);
        NAME_TO_BASETYPE.put("void", VoidT.TYPE);
    }

    public static final class UnicodeUnescaper
    extends Reader {
        private boolean _havePeek = false;
        private int _peek = -1;
        private final Reader _reader;

        public UnicodeUnescaper(Reader reader) {
            this._reader = reader;
        }

        public final void close() throws IOException {
            this._reader.close();
        }

        public final int read() throws IOException {
            int n;
            if (this._havePeek) {
                this._havePeek = false;
                return this._peek;
            }
            int n2 = this._reader.read();
            if (92 != n2) {
                return n2;
            }
            this._peek = this._reader.read();
            if (117 != this._peek) {
                this._havePeek = true;
                return n2;
            }
            int n3 = this._peek;
            while (117 == n3) {
                n3 = this._reader.read();
            }
            byte[] byArray = new byte[4];
            block6: for (n = 0; n < 4; ++n) {
                if (0 != n) {
                    n3 = this._reader.read();
                }
                switch (n3) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        byArray[n] = (byte)(n3 - 48);
                        continue block6;
                    }
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        byArray[n] = (byte)(10 + n3 - 97);
                        continue block6;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        byArray[n] = (byte)(10 + n3 - 65);
                        continue block6;
                    }
                    default: {
                        throw new Error("illegal unicode sequence");
                    }
                }
            }
            n = 0;
            for (int i = 0; i < 4; ++i) {
                n = n << 4 | byArray[i];
            }
            return n;
        }

        public final int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.read();
                if (-1 == n4) {
                    return -1;
                }
                cArray[n + n3] = (char)n4;
            }
            return n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SuperTypesIter
    implements Iterator<Type> {
        private final List<File> _paths;
        private final Set<String> _seen = new HashSet<String>();
        private final SymbolTable _tab;
        private final LinkedList<Type> _todo = new LinkedList();

        private static String key(Type type2) {
            Type type3;
            Type type4 = type3 = type2.isAlias() ? ((AliasT)type2).getType() : type2;
            if (type3.isArray()) {
                return SuperTypesIter.key(JavaEntities.arrayElementType(type3.toArray())) + "[]";
            }
            if (JavaEntities.isPrimitiveT(type2)) {
                return type2.toString();
            }
            return JavaEntities.resolveToRawClassOrInterfaceT(type3).getQName();
        }

        public SuperTypesIter(SymbolTable symbolTable, List<File> list, Type type2) {
            this(symbolTable, list, type2, true);
        }

        public SuperTypesIter(SymbolTable symbolTable, List<File> list, Type type2, boolean bl) {
            this._tab = symbolTable;
            this._paths = list;
            Type type3 = JavaEntities.resolveToRValue(type2);
            if (bl) {
                this.add(type3);
            } else {
                this.addDirectSupertypes(type3);
            }
        }

        private final void add(Type type2) {
            assert (null != type2);
            assert (JavaEntities.isReferenceT(type2));
            if (this._seen.add(SuperTypesIter.key(type2))) {
                this._todo.addLast(type2);
            }
        }

        private void addDirectSupertypes(Type type2) {
            for (ClassOrInterfaceT classOrInterfaceT : JavaEntities.directSuperTypes(this._tab, this._paths, type2)) {
                this.add(classOrInterfaceT);
            }
        }

        @Override
        public final boolean hasNext() {
            return !this._todo.isEmpty();
        }

        @Override
        public final Type next() {
            if (this._todo.isEmpty()) {
                return null;
            }
            Type type2 = this._todo.removeFirst();
            this.addDirectSupertypes(type2);
            return type2;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class MiniVisitor_scrubLocations
    extends Visitor {
        MiniVisitor_scrubLocations() {
        }

        public final void visit(Node node) {
            node.setLocation((Location)null);
            for (Object object : node) {
                if (!(object instanceof Node)) continue;
                this.dispatch((Node)object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MiniVisitor_allUsedIdentifiers
    extends Visitor {
        MiniVisitor_allUsedIdentifiers() {
        }

        public final Set<String> visit(LineMarker lineMarker) {
            Node node = lineMarker.getNode();
            return null == node ? EMPTY_SET : JavaEntities.stringSet(this.dispatch(node));
        }

        public final Set<String> visit(Node node) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < node.size(); ++i) {
                if (node.get(i) instanceof String) {
                    hashSet.add(node.getString(i));
                    continue;
                }
                if (!(node.get(i) instanceof Node)) continue;
                hashSet.addAll(JavaEntities.stringSet(this.dispatch(node.getNode(i))));
            }
            return hashSet;
        }

        public final Set<String> visitBinaryExpression(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(JavaEntities.stringSet(this.dispatch(gNode.getNode(0))));
            hashSet.addAll(JavaEntities.stringSet(this.dispatch(gNode.getNode(2))));
            return hashSet;
        }

        public final Set<String> visitBlockDeclaration(GNode gNode) {
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(1)));
        }

        public final Set<String> visitBooleanLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitCharacterLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitFieldDeclaration(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(JavaEntities.stringSet(this.dispatch(gNode.getNode(1))));
            hashSet.addAll(JavaEntities.stringSet(this.dispatch(gNode.getNode(2))));
            return hashSet;
        }

        public final Set<String> visitFloatingPointLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitForInit(GNode gNode) {
            if (1 == gNode.size()) {
                return JavaEntities.stringSet(this.dispatch(gNode.getNode(0)));
            }
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(1)));
        }

        public final Set<String> visitFormalParameter(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(JavaEntities.stringSet(this.dispatch(gNode.getNode(1))));
            hashSet.add(gNode.getString(3));
            return hashSet;
        }

        public final Set<String> visitImportDeclaration(GNode gNode) {
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(1)));
        }

        public final Set<String> visitIntegerLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitNullLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitPostfixUnaryExpression(GNode gNode) {
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(0)));
        }

        public final Set<String> visitPrefixUnaryExpression(GNode gNode) {
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(1)));
        }

        public final Set<String> visitStringLiteral(GNode gNode) {
            return EMPTY_SET;
        }

        public final Set<String> visitType(GNode gNode) {
            return JavaEntities.stringSet(this.dispatch(gNode.getNode(0)));
        }
    }

    public static final class JavaTypePrinter
    extends TypePrinter {
        private boolean _showDetails;
        private final SymbolTable _table;

        public JavaTypePrinter(SymbolTable symbolTable, boolean bl, Printer printer) {
            super(printer);
            this._showDetails = bl;
            this._table = symbolTable;
        }

        private boolean isJavaLangObject(Type type2) {
            if (null == type2) {
                return false;
            }
            if (type2.isClass()) {
                return type2.toClass().getQName().equals("java.lang.Object");
            }
            assert (type2.isAlias());
            String string = type2.toAlias().getName();
            return string.equals("Object") || string.equals("java.lang.Object");
        }

        public final boolean printAnnotations(Type type2) {
            this.printAttributes(type2);
            return type2.hasAttributes();
        }

        public final void printAttributes(Type type2) {
            if (type2.hasAttributes()) {
                for (Attribute attribute : type2.attributes()) {
                    this.printer.p(JavaEntities.modifierToName(attribute)).p(' ');
                }
            }
        }

        private final void printMethodNoDetails(MethodT methodT) {
            assert (!this._showDetails);
            this.dispatch(JavaEntities.declaringType(this._table, methodT));
            this.printer.p('.').p(methodT.getName());
        }

        public final void printSignature(FunctionOrMethodT functionOrMethodT) {
            if (!this._showDetails) {
                throw new Error();
            }
            this._showDetails = false;
            this.printer.p('(');
            Iterator<Type> iterator = functionOrMethodT.getParameters().iterator();
            while (iterator.hasNext()) {
                this.printer.p(iterator.next());
                if (!iterator.hasNext() && !functionOrMethodT.isVarArgs()) continue;
                this.printer.p(", ");
            }
            if (functionOrMethodT.isVarArgs()) {
                this.printer.p("...");
            }
            this.printer.p(") -> ");
            if (functionOrMethodT.getResult().resolve().isFunction()) {
                this.printer.p('(').p(functionOrMethodT.getResult()).p(')');
            } else {
                this.printer.p(functionOrMethodT.getResult());
            }
            if (null != functionOrMethodT.getExceptions() && !functionOrMethodT.getExceptions().isEmpty()) {
                this.printer.p(" throws ");
                iterator = functionOrMethodT.getExceptions().iterator();
                while (iterator.hasNext()) {
                    this.printer.p(iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.printer.p(", ");
                }
            }
            this._showDetails = true;
        }

        public final void visit(AliasT aliasT) {
            this.printer.p(aliasT.getName());
        }

        public final void visit(AnnotatedT annotatedT) {
            if (JavaEntities.isNullT(annotatedT)) {
                this.printer.p("null");
                return;
            }
            if (this._showDetails) {
                this.printAttributes(annotatedT);
            }
            this.printer.p(annotatedT.getType());
        }

        public final void visit(ArrayT arrayT) {
            this.printer.p(JavaEntities.arrayElementType(arrayT)).p("[]");
        }

        public final void visit(BooleanT booleanT) {
            this.printer.p("boolean");
        }

        public final void visit(ClassT classT) {
            Object object;
            if (!this._showDetails) {
                this.printer.p(classT.getQName());
                return;
            }
            this.printAttributes(classT);
            this.printer.p("class ").p(classT.getQName());
            if (!this.isJavaLangObject(classT.getParent())) {
                this.printer.p(" extends ").p(classT.getParent());
            }
            if (!classT.getInterfaces().isEmpty()) {
                this.printer.p(" implements ");
                object = classT.getInterfaces().iterator();
                while (object.hasNext()) {
                    this.printer.p((Node)object.next());
                    if (!object.hasNext()) continue;
                    this.printer.p(", ");
                }
            }
            this.printer.p("{");
            object = this._table.getScope(JavaEntities.typeToScopeName(classT));
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator<String> iterator = ((SymbolTable.Scope)object).symbols();
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            for (String string : treeSet) {
                Type type2 = (Type)((SymbolTable.Scope)object).lookupLocally(string);
                assert (null != type2);
                this.dispatch(type2);
                this.printer.p("; ");
            }
            this.printer.p("}");
        }

        public final void visit(InterfaceT interfaceT) {
            Object object;
            if (!this._showDetails) {
                this.printer.p(interfaceT.getQName());
                return;
            }
            this.printAttributes(interfaceT);
            this.printer.p("interface ").p(interfaceT.getQName());
            if (!interfaceT.getInterfaces().isEmpty()) {
                this.printer.p(" extends ");
                object = interfaceT.getInterfaces().iterator();
                while (object.hasNext()) {
                    this.printer.p((Node)object.next());
                    if (!object.hasNext()) continue;
                    this.printer.p(", ");
                }
            }
            this.printer.p("{");
            object = this._table.getScope(JavaEntities.typeToScopeName(interfaceT));
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator<String> iterator = ((SymbolTable.Scope)object).symbols();
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            for (String string : treeSet) {
                Type type2 = (Type)((SymbolTable.Scope)object).lookupLocally(string);
                assert (null != type2);
                this.dispatch(type2);
                this.printer.p("; ");
            }
            this.printer.p("}");
        }

        public final void visit(MethodT methodT) {
            if (this._showDetails) {
                super.visit(methodT);
            } else {
                this.printMethodNoDetails(methodT);
            }
        }
    }
}

