/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import xtc.lang.JavaAnalyzer;
import xtc.lang.JavaAstSimplifier;
import xtc.lang.JavaFiveParser;
import xtc.lang.JavaFiveReader;
import xtc.lang.JavaPrinter;
import xtc.lang.JavaReader;
import xtc.lang.JavaRecognizer;
import xtc.lang.antlr.JavaLexer;
import xtc.lang.antlr.JavaTreeLexer;
import xtc.lang.antlr.JavaTreeRecognizer;
import xtc.lang.javacc.JavaParser;
import xtc.lang.javacc.JavaTreeParser;
import xtc.lang.javacc.ParseException;
import xtc.parser.Result;
import xtc.tree.Node;
import xtc.tree.ParseTreePrinter;
import xtc.tree.ParseTreeStripper;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public class Java
extends Tool {
    protected Method profile;
    protected Method dump;

    public String getName() {
        return "xtc Java Tool";
    }

    public String getCopy() {
        return "(C) 2004-2007 IBM, Robert Grimm, and NYU";
    }

    public String getExplanation() {
        return "By default, this tool simply parses Java sources using the Rats!-generated recognizer.  If the ast option is specified, it also generates an AST, which can then be further processed and printed.  If the pt option is specified, it also embeds all formatting in the resulting AST.  For performance comparisons, this tool can optionally use ANTLR- or JavaCC-generated recognizers and parsers.  Any ASTs generated by these parsers cannot be processed.";
    }

    public void init() {
        super.init();
        this.runtime.bool("memoProfile", "printMemoProfile", false, "Print profile of parser's memoization table.").bool("memoTable", "printMemoTable", false, "Print parser's memoization table.").bool("tiger", "optionTiger", false, "Process Java 5 aka Tiger.").bool("ast", "optionAST", false, "Use parser that builds abstract syntax tree.").bool("parsetree", "optionParseTree", false, "Use parser that builds parse tree.").bool("strip", "optionStrip", false, "Strip any annotations from the AST before printing.").bool("simplifyAST", "optionSimplifyAST", false, "Simplify the AST.").bool("printAST", "printAST", false, "Print the AST in generic form.").bool("locateAST", "optionLocateAST", false, "Include location information when printing the AST in generic form.").bool("printSource", "printSource", false, "Print the AST in Java source form.").bool("antlr", "optionANTLR", false, "Use an ANTLR-generated parser.").bool("javacc", "optionJavaCC", false, "Use a JavaCC-generated parser.").bool("analyze", "optionAnalyze", false, "Analyze the program's AST.").bool("printSymbolTable", "printSymbolTable", false, "Print the program's symbol table.").bool("g", "debug", false, "Ignored; provided for compatibility with jacks.").bool("deprecated", "deprecated", false, "Ignored; provided for compatibility with jacks.");
    }

    public void prepare() {
        String string;
        Class clazz;
        super.prepare();
        if (this.runtime.test("printMemoProfile")) {
            if (this.runtime.test("optionANTLR") || this.runtime.test("optionJavaCC")) {
                this.runtime.error("memoization profile only available for Rats!-generated parser");
            } else {
                if (this.runtime.test("optionAST")) {
                    clazz = xtc.lang.JavaParser.class;
                    string = "Java parser";
                } else if (this.runtime.test("optionParseTree")) {
                    clazz = JavaReader.class;
                    string = "Java reader";
                } else {
                    clazz = JavaRecognizer.class;
                    string = "Java recognizer";
                }
                try {
                    this.profile = clazz.getMethod("profile", Printer.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.runtime.error(string + " generated without profile attribute");
                }
                catch (SecurityException securityException) {
                    this.runtime.error("unable to access " + string + "'s profile() method");
                }
            }
        }
        if (this.runtime.test("printMemoTable")) {
            if (this.runtime.test("optionANTLR") || this.runtime.test("optionJavaCC")) {
                this.runtime.error("memoization table only available for Rats!-generated parser");
            } else {
                if (this.runtime.test("optionAST")) {
                    clazz = xtc.lang.JavaParser.class;
                    string = "Java parser";
                } else if (this.runtime.test("optionParseTree")) {
                    clazz = JavaReader.class;
                    string = "Java reader";
                } else {
                    clazz = JavaRecognizer.class;
                    string = "Java recognizer";
                }
                try {
                    this.dump = clazz.getMethod("dump", Printer.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.runtime.error(string + " generated without dump attribute");
                }
                catch (SecurityException securityException) {
                    this.runtime.error("unable to access " + string + "'s dump() method");
                }
            }
        }
        if (this.runtime.test("optionTiger")) {
            if (this.runtime.test("optionANTLR")) {
                this.runtime.error("antlr option incompatible with tiger option");
            } else if (this.runtime.test("optionJavaCC")) {
                this.runtime.error("javacc option incompatible with tiger option");
            }
            if (!this.runtime.test("optionAST") && !this.runtime.test("optionParseTree")) {
                this.runtime.error("tiger option requires ast or parseTree option");
            }
        }
        if (this.runtime.test("optionANTLR") && this.runtime.test("optionJavaCC")) {
            this.runtime.error("antlr option incompatible with javacc option");
        }
        if (this.runtime.test("optionParseTree")) {
            if (this.runtime.test("optionANTLR")) {
                this.runtime.error("antlr option incompatible with pt option");
            }
            if (this.runtime.test("optionJavaCC")) {
                this.runtime.test("javacc option incompatible with pt option");
            }
        }
        if (this.runtime.test("optionStrip") || this.runtime.test("optionSimplifyAST") || this.runtime.test("printAST") || this.runtime.test("printSource")) {
            if (!this.runtime.test("optionAST") && !this.runtime.test("optionParseTree")) {
                this.runtime.error("processing of AST requires ast or pt option");
            } else if (this.runtime.test("optionANTLR")) {
                this.runtime.error("AST built by ANTLR-generated parser cannot be printed");
            } else if (this.runtime.test("optionJavaCC")) {
                this.runtime.error("AST built by JavaCC-generated parser cannot be printed");
            }
        }
        if (this.runtime.test("optionLocateAST") && !this.runtime.test("printAST")) {
            this.runtime.error("locateAST option requires printAST option");
        }
        if (this.runtime.test("optionAnalyze") && !this.runtime.test("optionSimplifyAST")) {
            this.runtime.error("type checker only works on simplified AST;run with -ast -simplifyAST -analyze");
        }
    }

    public File locate(String string) throws IOException {
        File file = super.locate(string);
        if (Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        return file;
    }

    public Node parse(Reader reader, File file) throws IOException, xtc.parser.ParseException {
        if (this.runtime.test("optionJavaCC")) {
            if (this.runtime.test("optionAST")) {
                JavaTreeParser javaTreeParser = new JavaTreeParser(reader);
                try {
                    javaTreeParser.CompilationUnit();
                }
                catch (ParseException parseException) {
                    this.runtime.error();
                    System.err.println(parseException.getMessage());
                }
            } else {
                JavaParser javaParser = new JavaParser(reader);
                try {
                    javaParser.CompilationUnit();
                }
                catch (ParseException parseException) {
                    this.runtime.error();
                    System.err.println(parseException.getMessage());
                }
            }
            return null;
        }
        if (this.runtime.test("optionANTLR")) {
            if (this.runtime.test("optionAST")) {
                JavaTreeLexer javaTreeLexer = new JavaTreeLexer(reader);
                JavaTreeRecognizer javaTreeRecognizer = new JavaTreeRecognizer(javaTreeLexer);
                try {
                    javaTreeRecognizer.compilationUnit();
                }
                catch (Exception exception) {
                    this.runtime.error();
                    System.err.println(exception.getMessage());
                }
                javaTreeRecognizer.getAST();
            } else {
                JavaLexer javaLexer = new JavaLexer(reader);
                xtc.lang.antlr.JavaRecognizer javaRecognizer = new xtc.lang.antlr.JavaRecognizer(javaLexer);
                try {
                    javaRecognizer.compilationUnit();
                }
                catch (Exception exception) {
                    this.runtime.error();
                    System.err.println(exception.getMessage());
                }
            }
            return null;
        }
        if (this.runtime.test("optionTiger") && this.runtime.test("optionParseTree")) {
            JavaFiveReader javaFiveReader = new JavaFiveReader(reader, file.toString(), (int)file.length());
            Result result2 = javaFiveReader.pCompilationUnit(0);
            this.printMemoInfo(javaFiveReader, file);
            return (Node)javaFiveReader.value(result2);
        }
        if (this.runtime.test("optionTiger") && this.runtime.test("optionAST")) {
            JavaFiveParser javaFiveParser = new JavaFiveParser(reader, file.toString(), (int)file.length());
            Result result3 = javaFiveParser.pCompilationUnit(0);
            this.printMemoInfo(javaFiveParser, file);
            return (Node)javaFiveParser.value(result3);
        }
        if (this.runtime.test("optionParseTree")) {
            JavaReader javaReader = new JavaReader(reader, file.toString(), (int)file.length());
            Result result4 = javaReader.pCompilationUnit(0);
            this.printMemoInfo(javaReader, file);
            return (Node)javaReader.value(result4);
        }
        if (this.runtime.test("optionAST")) {
            xtc.lang.JavaParser javaParser = new xtc.lang.JavaParser(reader, file.toString(), (int)file.length());
            Result result5 = javaParser.pCompilationUnit(0);
            this.printMemoInfo(javaParser, file);
            return (Node)javaParser.value(result5);
        }
        JavaRecognizer javaRecognizer = new JavaRecognizer(reader, file.toString(), (int)file.length());
        Result result6 = javaRecognizer.pCompilationUnit(0);
        this.printMemoInfo(javaRecognizer, file);
        return (Node)javaRecognizer.value(result6);
    }

    private void printMemoInfo(Object object, File file) {
        if (this.runtime.test("printMemoProfile")) {
            try {
                this.profile.invoke(object, this.runtime.console());
            }
            catch (Exception exception) {
                this.runtime.error(file + ": " + exception.getMessage());
            }
            this.runtime.console().flush();
        }
        if (this.runtime.test("printMemoTable")) {
            try {
                this.dump.invoke(object, this.runtime.console());
            }
            catch (Exception exception) {
                this.runtime.error(file + ": " + exception.getMessage());
            }
            this.runtime.console().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Node node) {
        if (this.runtime.test("optionSimplifyAST")) {
            node = (Node)new JavaAstSimplifier().dispatch(node);
        }
        if (this.runtime.test("optionAnalyze")) {
            if (!this.runtime.hasValue("inputDirectory")) {
                this.runtime.setValue("inputDirectory", new File(System.getProperty("user.dir")));
            }
            SymbolTable symbolTable = new SymbolTable();
            new JavaAnalyzer(this.runtime, symbolTable).dispatch(node);
            if (this.runtime.test("printSymbolTable")) {
                Visitor visitor = this.runtime.console().visitor();
                try {
                    symbolTable.root().dump(this.runtime.console());
                }
                finally {
                    this.runtime.console().register(visitor);
                }
                this.runtime.console().flush();
            }
        }
        if (this.runtime.test("optionStrip")) {
            node = (Node)new ParseTreeStripper().dispatch(node);
        }
        if (this.runtime.test("printAST")) {
            this.runtime.console().format(node, this.runtime.test("optionLocateAST")).pln().flush();
        }
        if (this.runtime.test("printSource")) {
            if (this.runtime.test("optionParseTree") && !this.runtime.test("optionStrip")) {
                new ParseTreePrinter(this.runtime.console()).dispatch(node);
            } else {
                new JavaPrinter(this.runtime.console()).dispatch(node);
            }
            this.runtime.console().flush();
        }
    }

    public static void main(String[] stringArray) {
        new Java().run(stringArray);
    }
}

