/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.Iterator;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Node;
import xtc.tree.Pragma;
import xtc.tree.Printer;
import xtc.tree.SourceIdentity;
import xtc.tree.Token;
import xtc.tree.Visitor;

public class CPrinter
extends Visitor {
    public static final boolean EXTRA_PARENTHESES = true;
    public static final int PREC_BASE = 0;
    public static final int PREC_LIST = 11;
    public static final int PREC_CONSTANT = 21;
    public static final int STMT_ANY = 0;
    public static final int STMT_IF = 1;
    public static final int STMT_IF_ELSE = 2;
    protected final Printer printer;
    protected final boolean lineUp;
    protected final boolean gnuify;
    protected boolean isDeclaration;
    protected boolean isLongDecl;
    protected boolean isStatement;
    protected boolean isOpenLine;
    protected boolean isNested;
    protected boolean isIfElse;
    protected boolean isStmtAsExpr;
    protected boolean isFunctionDef;
    protected int precedence;

    public CPrinter(Printer printer) {
        this(printer, false, false);
    }

    public CPrinter(Printer printer, boolean bl, boolean bl2) {
        this.printer = printer;
        this.lineUp = bl;
        this.gnuify = bl2;
        printer.register(this);
    }

    protected boolean containsLongType(GNode gNode) {
        for (Object object : gNode) {
            GNode gNode2 = GNode.cast(object);
            if (!gNode2.hasName("EnumerationTypeDefinition") && !gNode2.hasName("StructureTypeDefinition") && !gNode2.hasName("UnionTypeDefinition")) continue;
            return true;
        }
        return false;
    }

    protected boolean isLongDeclaration(GNode gNode) {
        if (!gNode.hasName("Declaration")) {
            return false;
        }
        if (this.containsLongType(gNode.getGeneric(1))) {
            return true;
        }
        GNode gNode2 = gNode.getGeneric(2);
        if (null != gNode2) {
            for (Object object : gNode2) {
                GNode gNode3 = GNode.cast(object).getGeneric(3);
                if (null == gNode3 || !gNode3.hasName("InitializerList")) continue;
                return true;
            }
        }
        return false;
    }

    protected void formatAsTruthValue(Node node) {
        if (GNode.cast(node).hasName("AssignmentExpression")) {
            this.printer.p('(').p(node).p(')');
        } else {
            this.printer.p(node);
        }
    }

    protected boolean startStatement(int n, Node node) {
        if (this.isIfElse && (1 == n || 2 == n)) {
            this.isNested = false;
        } else {
            if (this.lineUp) {
                if (this.isOpenLine) {
                    this.printer.pln();
                }
                this.printer.lineUp(node);
            } else if (this.isDeclaration || this.isOpenLine) {
                this.printer.pln();
            }
            if (this.isNested) {
                this.printer.incr();
            }
        }
        this.isOpenLine = false;
        boolean bl = this.isNested;
        this.isNested = false;
        return bl;
    }

    protected void prepareNested() {
        this.isDeclaration = false;
        this.isStatement = false;
        this.isOpenLine = true;
        this.isNested = true;
    }

    protected void endStatement(boolean bl) {
        if (bl) {
            this.printer.decr();
        }
        this.isDeclaration = false;
        this.isStatement = true;
    }

    protected int enterContext(int n) {
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected int enterContext() {
        int n = this.precedence++;
        return n;
    }

    protected void exitContext(int n) {
        this.precedence = n;
    }

    protected int startExpression(int n) {
        if (n < this.precedence) {
            this.printer.p('(');
        }
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected void endExpression(int n) {
        if (this.precedence < n) {
            this.printer.p(')');
        }
        this.precedence = n;
    }

    public void visitTranslationUnit(GNode gNode) {
        this.isDeclaration = false;
        this.isLongDecl = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.isStmtAsExpr = false;
        this.isFunctionDef = false;
        this.precedence = 0;
        if (this.lineUp) {
            this.printer.line(1L);
        }
        for (Object object : gNode) {
            this.printer.p((Node)object);
        }
    }

    public void visitFunctionDefinition(GNode gNode) {
        if (this.lineUp) {
            if (this.isOpenLine) {
                this.printer.pln();
            }
            this.printer.lineUp(gNode);
        } else if (this.isStatement || this.isDeclaration || this.isLongDecl) {
            if (this.isOpenLine) {
                this.printer.pln();
            }
            this.printer.pln();
        }
        this.isDeclaration = false;
        this.isLongDecl = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.printer.indent();
        if (null != gNode.get(0) || null != gNode.get(1)) {
            if (null != gNode.get(0)) {
                this.printer.p("__extension__ ");
            }
            this.printer.p(gNode.getNode(1));
        }
        Node node = gNode.getNode(2);
        if (this.gnuify) {
            GNode gNode2 = GNode.cast(node);
            if (gNode2.hasName("PointerDeclarator")) {
                this.isFunctionDef = true;
                this.printer.p(' ').p(node);
                node = gNode2.getNode(1);
            }
            this.printer.pln().indent();
        } else if (null != gNode.get(1)) {
            this.printer.p(' ');
        }
        this.printer.p(node);
        if (null != gNode.get(3)) {
            this.printer.pln().incr().p(gNode.getNode(3)).decr();
        } else if (this.gnuify) {
            this.printer.pln();
            this.isOpenLine = false;
        } else {
            this.isOpenLine = true;
        }
        this.isDeclaration = false;
        this.isLongDecl = false;
        this.isStatement = false;
        this.isNested = false;
        this.isIfElse = false;
        this.printer.p(gNode.getNode(4)).pln();
        this.isDeclaration = true;
        this.isLongDecl = true;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitEmptyDefinition(GNode gNode) {
    }

    public void visitDeclarationList(GNode gNode) {
        for (Object object : gNode) {
            this.printer.p((Node)object);
        }
    }

    public void visitDeclaration(GNode gNode) {
        boolean bl = this.isNested;
        if (!bl) {
            if (this.lineUp) {
                if (this.isOpenLine) {
                    this.printer.pln();
                }
                this.printer.lineUp(gNode);
            } else if (this.isStatement || this.isLongDecl) {
                if (this.isOpenLine) {
                    this.printer.pln();
                }
                this.printer.pln();
            } else if (this.isLongDeclaration(gNode)) {
                this.printer.pln();
            }
            this.printer.indent();
        }
        this.isDeclaration = false;
        this.isLongDecl = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        if (null != gNode.get(0)) {
            this.printer.p("__extension__ ");
        }
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
        if (!bl) {
            this.printer.p(';').fitMore().pln();
        }
        this.isDeclaration = true;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitDeclarationSpecifiers(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitAutoSpecifier(GNode gNode) {
        this.printer.p("auto");
    }

    public void visitExternSpecifier(GNode gNode) {
        this.printer.p("extern");
    }

    public void visitRegisterSpecifier(GNode gNode) {
        this.printer.p("register");
    }

    public void visitStaticSpecifier(GNode gNode) {
        this.printer.p("static");
    }

    public void visitThreadSpecifier(GNode gNode) {
        this.printer.p("__thread");
    }

    public void visitTypedefSpecifier(GNode gNode) {
        this.printer.p("typedef");
    }

    public void visitVolatileQualifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitConstantQualifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitRestrictQualifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitFunctionSpecifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitEnumerationTypeDefinition(GNode gNode) {
        this.printer.p("enum ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getString(1)).p(' ');
        }
        this.printer.pln('{').incr().p(gNode.getNode(2)).decr().indent().p('}');
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        this.isLongDecl = true;
    }

    public void visitEnumeratorList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.indent().p((Node)iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(',');
            }
            this.printer.pln();
        }
    }

    public void visitEnumerator(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null != gNode.get(1)) {
            int n = this.enterContext(21);
            this.printer.p(" = ").p(gNode.getNode(1));
            this.exitContext(n);
        }
    }

    public void visitEnumerationTypeReference(GNode gNode) {
        this.printer.p("enum ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getString(1));
    }

    public void visitStructureTypeDefinition(GNode gNode) {
        this.printer.p("struct ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getString(1)).p(' ');
        }
        this.printer.pln('{').incr().p(gNode.getNode(2)).decr().indent().p('}');
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        this.isLongDecl = true;
    }

    public void visitStructureTypeReference(GNode gNode) {
        this.printer.p("struct ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getString(1));
    }

    public void visitUnionTypeDefinition(GNode gNode) {
        this.printer.p("union ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getString(1)).p(' ');
        }
        this.printer.pln('{').incr().p(gNode.getNode(2)).decr().indent().p('}');
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        this.isLongDecl = true;
    }

    public void visitUnionTypeReference(GNode gNode) {
        this.printer.p("union ");
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getString(1));
    }

    public void visitStructureDeclarationList(GNode gNode) {
        boolean bl = false;
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                if (this.containsLongType(GNode.cast(node).getGeneric(1))) {
                    this.printer.pln();
                    bl = true;
                } else if (bl) {
                    this.printer.pln();
                    bl = false;
                }
            }
            this.printer.p(node);
        }
    }

    public void visitStructureDeclaration(GNode gNode) {
        this.printer.indent();
        if (null != gNode.get(0)) {
            this.printer.p("__extension__ ");
        }
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
        this.printer.pln(';');
    }

    public void visitSpecifierQualifierList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitStructureDeclaratorList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitBitField(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1)).p(':');
        int n = this.enterContext(21);
        this.printer.p(gNode.getNode(2));
        this.exitContext(n);
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
    }

    public void visitAttributedDeclarator(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
    }

    public void visitPointerDeclarator(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (this.isFunctionDef) {
            this.isFunctionDef = false;
            return;
        }
        this.printer.p(gNode.getNode(1));
    }

    public void visitPointer(GNode gNode) {
        this.printer.p('*').p(gNode.getNode(0)).p(gNode.getNode(1));
    }

    public void visitTypeQualifierList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p(' ').p((Node)iterator.next());
            if (iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitSimpleDeclarator(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitFunctionDeclarator(GNode gNode) {
        if (gNode.getGeneric(0).hasName("SimpleDeclarator")) {
            this.printer.p(gNode.getNode(0));
        } else {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        }
        this.printer.p('(').p(gNode.getNode(1)).p(')');
    }

    public void visitParameterTypeList(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(", ...");
        }
    }

    public void visitParameterList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitParameterDeclaration(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(' ').p(gNode.getNode(1));
        }
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
    }

    public void visitAttributedAbstractDeclarator(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1));
    }

    public void visitAbstractDeclarator(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(gNode.getNode(1));
    }

    public void visitDirectAbstractDeclarator(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        }
        if ("[".equals(gNode.get(1))) {
            this.printer.p('[');
            if (null != gNode.get(2)) {
                int n = this.enterContext(11);
                this.printer.p(gNode.getNode(2));
                this.exitContext(n);
            }
            this.printer.p(']');
        } else {
            this.printer.p('(').p(gNode.getNode(2)).p(')');
        }
    }

    public void visitIdentifierList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p(Token.cast(iterator.next()));
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitArrayDeclarator(GNode gNode) {
        if (gNode.getGeneric(0).hasName("SimpleDeclarator")) {
            this.printer.p(gNode.getNode(0));
        } else {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        }
        this.printer.p('[');
        int n = this.printer.column();
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            if (this.printer.column() != n) {
                this.printer.p(' ');
            }
            int n2 = this.enterContext(11);
            this.printer.p(gNode.getNode(2));
            this.exitContext(n2);
        }
        this.printer.p(']');
    }

    public void visitVariableLength(GNode gNode) {
        this.printer.p('*');
    }

    public void visitArrayQualifierList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitComplex(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitDouble(GNode gNode) {
        this.printer.p("double");
    }

    public void visitFloat(GNode gNode) {
        this.printer.p("float");
    }

    public void visitLong(GNode gNode) {
        this.printer.p("long");
    }

    public void visitInt(GNode gNode) {
        this.printer.p("int");
    }

    public void visitShort(GNode gNode) {
        this.printer.p("short");
    }

    public void visitChar(GNode gNode) {
        this.printer.p("char");
    }

    public void visitBool(GNode gNode) {
        this.printer.p("_Bool");
    }

    public void visitUnsigned(GNode gNode) {
        this.printer.p("unsigned");
    }

    public void visitSigned(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitTypedefName(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitTypeofSpecifier(GNode gNode) {
        int n = this.enterContext(0);
        this.printer.p("typeof(").p(gNode.getNode(0)).p(')');
        this.exitContext(n);
    }

    public void visitVoidTypeSpecifier(GNode gNode) {
        this.printer.p("void");
    }

    public void visitVarArgListSpecifier(GNode gNode) {
        this.printer.p("__builtin_va_list");
    }

    public void visitInitializedDeclaratorList(GNode gNode) {
        boolean bl = true;
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                this.printer.buffer();
            }
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ").fitMore();
        }
    }

    public void visitInitializedDeclarator(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        if (null != gNode.get(4)) {
            this.printer.p(" = ");
            int n = this.enterContext(11);
            this.printer.p(gNode.getNode(4));
            this.exitContext(n);
        }
    }

    public void visitInitializerList(GNode gNode) {
        if (!gNode.isEmpty()) {
            this.printer.pln('{').incr().indent();
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                this.printer.buffer().p((Node)iterator.next());
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                }
                this.printer.fit();
            }
            this.printer.pln().decr().indent().p('}');
            this.isLongDecl = true;
        } else {
            this.printer.p("{ }");
        }
    }

    public void visitInitializerListEntry(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        int n = this.enterContext(11);
        this.printer.p(gNode.getNode(1));
        this.exitContext(n);
    }

    public void visitDesignation(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
        this.printer.p(" = ");
    }

    public void visitObsoleteArrayDesignation(GNode gNode) {
        int n = this.enterContext(21);
        this.printer.p('[').p(gNode.getNode(1));
        if (3 == gNode.size() && null != gNode.getGeneric(2)) {
            this.printer.p(" ... ").p(gNode.getNode(2));
        }
        this.printer.p(']');
        this.exitContext(n);
        this.printer.p(" = ");
    }

    public void visitObsoleteFieldDesignation(GNode gNode) {
        this.printer.p('.').p(gNode.getString(0)).p(" = ");
    }

    public void visitDesignator(GNode gNode) {
        if ("[".equals(gNode.get(0))) {
            int n = this.enterContext(21);
            this.printer.p('[').p(gNode.getNode(1));
            if (3 == gNode.size()) {
                this.printer.p(" ... ").p(gNode.getNode(2));
            }
            this.printer.p(']');
            this.exitContext(n);
        } else {
            this.printer.p('.').p(gNode.getNode(1));
        }
    }

    public void visitTypeName(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(' ').p(gNode.getNode(1));
        }
    }

    public void visitAttributeSpecifierList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitAttributeSpecifier(GNode gNode) {
        this.printer.p("__attribute__((").p(gNode.getNode(0)).p("))");
    }

    public void visitAttributeList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitAttributeListEntry(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null != gNode.get(1)) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        }
    }

    public void visitLabeledStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indentLess().p(gNode.getNode(0)).pln();
        this.isDeclaration = false;
        this.isStatement = true;
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitNamedLabel(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null == gNode.get(1)) {
            this.printer.p(':');
        } else {
            this.printer.p(": ").p(gNode.getNode(1));
        }
    }

    public void visitCaseLabel(GNode gNode) {
        int n = this.enterContext(21);
        this.printer.p("case ").p(gNode.getNode(0));
        if (2 == gNode.size()) {
            this.printer.p(" ... ").p(gNode.getNode(1));
        }
        this.printer.p(':');
        this.exitContext(n);
    }

    public void visitDefaultLabel(GNode gNode) {
        this.printer.p("default:");
    }

    public void visitCompoundStatement(GNode gNode) {
        boolean bl = this.isStmtAsExpr;
        this.isStmtAsExpr = false;
        boolean bl2 = this.isNested;
        if (bl) {
            this.printer.pln(" ({").incr();
        } else if (bl2 && this.gnuify) {
            this.printer.pln().incr().indent().pln('{').incr();
        } else if (this.isOpenLine) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.indent().pln('{').incr();
        }
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        for (Object object : gNode) {
            this.printer.p((Node)object);
        }
        if (this.isOpenLine) {
            this.printer.pln();
        }
        if (bl) {
            this.printer.decr().indent().p("})");
            this.isOpenLine = true;
        } else if (bl2 && this.gnuify) {
            this.printer.decr().indent().pln('}').decr();
            this.isOpenLine = false;
        } else {
            this.printer.decr().indent().p('}');
            this.isOpenLine = true;
        }
        this.isNested = false;
        this.isIfElse = false;
        this.isStmtAsExpr = bl;
    }

    public void visitLocalLabelDeclaration(GNode gNode) {
        if (!this.isNested) {
            if (this.lineUp) {
                if (this.isOpenLine) {
                    this.printer.pln();
                }
                this.printer.lineUp(gNode);
            } else if (this.isStatement || this.isLongDecl) {
                if (this.isOpenLine) {
                    this.printer.pln();
                }
                this.printer.pln();
            } else if (this.isLongDeclaration(gNode)) {
                this.printer.pln();
            }
            this.printer.indent();
        }
        this.printer.p("__label__ ");
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p(Token.cast(iterator.next()));
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.pln(';');
        this.isDeclaration = true;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitIfElseStatement(GNode gNode) {
        boolean bl = this.startStatement(2, gNode);
        if (this.isIfElse) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("if (");
        this.formatAsTruthValue(gNode.getNode(0));
        this.printer.p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        if (this.isOpenLine) {
            this.printer.p(" else");
        } else {
            this.printer.indent().p("else");
        }
        this.prepareNested();
        boolean bl2 = this.isIfElse;
        this.isIfElse = true;
        this.printer.p(gNode.getNode(2));
        this.isIfElse = bl2;
        this.endStatement(bl);
    }

    public void visitIfStatement(GNode gNode) {
        boolean bl = this.startStatement(1, gNode);
        if (this.isIfElse) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("if (");
        this.formatAsTruthValue(gNode.getNode(0));
        this.printer.p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitWhileStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("while (");
        this.formatAsTruthValue(gNode.getNode(0));
        this.printer.p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitDoStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("do");
        this.prepareNested();
        this.printer.p(gNode.getNode(0));
        if (this.isOpenLine) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("while (");
        this.formatAsTruthValue(gNode.getNode(1));
        this.printer.pln(");");
        this.endStatement(bl);
    }

    public void visitForStatement(GNode gNode) {
        int n;
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("for (");
        if (null != gNode.get(0)) {
            n = this.enterContext(0);
            this.printer.p(gNode.getNode(0));
            this.exitContext(n);
        }
        this.printer.p(';');
        if (null != gNode.get(1)) {
            n = this.enterContext(0);
            this.printer.p(' ');
            this.formatAsTruthValue(gNode.getNode(1));
            this.exitContext(n);
        }
        this.printer.p(';');
        if (null != gNode.get(2)) {
            n = this.enterContext(0);
            this.printer.p(' ').p(gNode.getNode(2));
            this.exitContext(n);
        }
        this.printer.p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(3));
        this.endStatement(bl);
    }

    public void visitSwitchStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("switch (").p(gNode.getNode(0)).p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitBreakStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().pln("break;");
        this.endStatement(bl);
    }

    public void visitContinueStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().pln("continue;");
        this.endStatement(bl);
    }

    public void visitReturnStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("return");
        if (null != gNode.getNode(0)) {
            this.printer.p(' ').p(gNode.getNode(0));
        }
        this.printer.pln(';');
        this.endStatement(bl);
    }

    public void visitGotoStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("goto ");
        if (null == gNode.get(0)) {
            this.printer.p(gNode.getNode(1));
        } else {
            this.printer.p('*');
            int n = this.enterContext(150);
            this.printer.p(gNode.getNode(1));
            this.exitContext(n);
        }
        this.printer.pln(';');
        this.endStatement(bl);
    }

    public void visitExpressionStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p(gNode.getNode(0)).pln(';');
        this.endStatement(bl);
    }

    public void visitEmptyStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().pln(';');
        this.endStatement(bl);
    }

    public void visitCommaExpression(GNode gNode) {
        int n = this.startExpression(10);
        this.printer.p(gNode.getNode(0)).p(", ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitAssignmentExpression(GNode gNode) {
        int n = this.startExpression(20);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0));
        this.exitContext(n2);
        this.printer.p(' ').p(gNode.getString(1)).p(' ').p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitConditionalExpression(GNode gNode) {
        int n = this.startExpression(30);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0)).p(" ? ");
        this.exitContext(n2);
        n2 = this.enterContext();
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(" : ");
        } else {
            this.printer.p(" /* Empty */ : ");
        }
        this.exitContext(n2);
        this.printer.p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitLogicalOrExpression(GNode gNode) {
        int n = this.startExpression(40);
        boolean bl = gNode.getGeneric(0).hasName("LogicalAndExpression");
        boolean bl2 = gNode.getGeneric(1).hasName("LogicalAndExpression");
        if (bl) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(" || ");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(1));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitLogicalAndExpression(GNode gNode) {
        int n = this.startExpression(50);
        this.printer.p(gNode.getNode(0)).p(" && ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitBitwiseOrExpression(GNode gNode) {
        boolean bl;
        int n = this.startExpression(60);
        GNode gNode2 = gNode.getGeneric(0);
        boolean bl2 = gNode2.hasName("AdditiveExpression") || gNode2.hasName("BitwiseAndExpression") || gNode2.hasName("BitwiseXorExpression") || gNode2.hasName("RelationalExpression") || gNode2.hasName("EqualityExpression");
        GNode gNode3 = gNode.getGeneric(1);
        boolean bl3 = bl = gNode3.hasName("AdditiveExpression") || gNode3.hasName("BitwiseAndExpression") || gNode3.hasName("BitwiseXorExpression") || gNode3.hasName("RelationalExpression") || gNode3.hasName("EqualityExpression");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(" | ");
        if (bl) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(1));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitBitwiseXorExpression(GNode gNode) {
        boolean bl;
        int n = this.startExpression(70);
        GNode gNode2 = gNode.getGeneric(0);
        boolean bl2 = gNode2.hasName("AdditiveExpression") || gNode2.hasName("BitwiseAndExpression") || gNode2.hasName("RelationalExpression") || gNode2.hasName("EqualityExpression");
        GNode gNode3 = gNode.getGeneric(1);
        boolean bl3 = bl = gNode3.hasName("AdditiveExpression") || gNode3.hasName("BitwiseAndExpression") || gNode3.hasName("RelationalExpression") || gNode3.hasName("EqualityExpression");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(" ^ ");
        if (bl) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(1));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitBitwiseAndExpression(GNode gNode) {
        boolean bl;
        int n = this.startExpression(80);
        GNode gNode2 = gNode.getGeneric(0);
        boolean bl2 = gNode2.hasName("AdditiveExpression") || gNode2.hasName("RelationalExpression") || gNode2.hasName("EqualityExpression");
        GNode gNode3 = gNode.getGeneric(1);
        boolean bl3 = bl = gNode3.hasName("AdditiveExpression") || gNode3.hasName("RelationalExpression") || gNode3.hasName("EqualityExpression");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(" & ");
        if (bl) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(1));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitEqualityExpression(GNode gNode) {
        boolean bl;
        int n = this.startExpression(90);
        GNode gNode2 = gNode.getGeneric(0);
        boolean bl2 = gNode2.hasName("RelationalExpression") || gNode2.hasName("EqualityExpression");
        GNode gNode3 = gNode.getGeneric(2);
        boolean bl3 = bl = gNode3.hasName("RelationalExpression") || gNode3.hasName("EqualityExpression");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(' ').p(gNode.getString(1)).p(' ');
        if (bl) {
            this.printer.p('(').p(gNode.getNode(2)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(2));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitRelationalExpression(GNode gNode) {
        boolean bl;
        int n = this.startExpression(100);
        GNode gNode2 = gNode.getGeneric(0);
        boolean bl2 = gNode2.hasName("RelationalExpression") || gNode2.hasName("EqualityExpression");
        GNode gNode3 = gNode.getGeneric(2);
        boolean bl3 = bl = gNode3.hasName("RelationalExpression") || gNode3.hasName("EqualityExpression");
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(' ').p(gNode.getString(1)).p(' ');
        if (bl) {
            this.printer.p('(').p(gNode.getNode(2)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(2));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitShiftExpression(GNode gNode) {
        int n = this.startExpression(110);
        boolean bl = gNode.getGeneric(0).hasName("AdditiveExpression");
        boolean bl2 = gNode.getGeneric(2).hasName("AdditiveExpression");
        if (bl) {
            this.printer.p('(').p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(' ').p(gNode.getString(1)).p(' ');
        if (bl2) {
            this.printer.p('(').p(gNode.getNode(2)).p(')');
        } else {
            int n2 = this.enterContext();
            this.printer.p(gNode.getNode(2));
            this.exitContext(n2);
        }
        this.endExpression(n);
    }

    public void visitAdditiveExpression(GNode gNode) {
        int n = this.startExpression(120);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitMultiplicativeExpression(GNode gNode) {
        int n = this.startExpression(130);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitCastExpression(GNode gNode) {
        int n = this.startExpression(140);
        this.printer.p('(').p(gNode.getNode(0)).p(')').p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitSizeofExpression(GNode gNode) {
        int n = this.startExpression(150);
        int n2 = this.enterContext(0);
        this.printer.p("sizeof(").p(gNode.getNode(0)).p(')');
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitAlignofExpression(GNode gNode) {
        int n = this.startExpression(150);
        int n2 = this.enterContext(0);
        this.printer.p("__alignof__(").p(gNode.getNode(0)).p(')');
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitOffsetofExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("__builtin_offsetof(").p(gNode.getNode(0)).p(", ").p(gNode.getNode(1)).p(')');
        this.endExpression(n);
    }

    public void visitTypeCompatibilityExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p("__builtin_types_compatible_p(");
        int n2 = this.enterContext(0);
        this.printer.p(gNode.getNode(0));
        this.exitContext(n2);
        n2 = this.enterContext(0);
        this.printer.p(", ").p(gNode.getNode(1)).p(')');
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitUnaryMinusExpression(GNode gNode) {
        int n = this.startExpression(150);
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode2.hasName("UnaryMinusExpression") || gNode2.hasName("PredecrementExpression")) {
            this.printer.p("-(").p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p('-').p(gNode.getNode(0));
        }
        this.endExpression(n);
    }

    public void visitUnaryPlusExpression(GNode gNode) {
        int n = this.startExpression(150);
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode2.hasName("UnaryPlusExpression") || gNode2.hasName("PreincrementExpression")) {
            this.printer.p("+(").p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p('+').p(gNode.getNode(0));
        }
        this.endExpression(n);
    }

    public void visitLogicalNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('!').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitBitwiseNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('~').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitAddressExpression(GNode gNode) {
        int n = this.startExpression(150);
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode2.hasName("AddressExpression") || gNode2.hasName("LabelAddressExpression")) {
            this.printer.p("&(").p(gNode.getNode(0)).p(')');
        } else {
            this.printer.p('&').p(gNode.getNode(0));
        }
        this.endExpression(n);
    }

    public void visitLabelAddressExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p("&&").p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitIndirectionExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('*').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitPreincrementExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p("++").p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitPredecrementExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p("--").p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitExtensionExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p("__extension__ ").p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitSubscriptExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0));
        int n2 = this.enterContext(0);
        this.printer.p('[').p(gNode.getNode(1)).p(']');
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitDirectComponentSelection(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p('.').p(gNode.getString(1));
        this.endExpression(n);
    }

    public void visitIndirectComponentSelection(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p("->").p(gNode.getString(1));
        this.endExpression(n);
    }

    public void visitFunctionCall(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p('(').p(gNode.getNode(1)).p(')');
        this.endExpression(n);
    }

    public void visitExpressionList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            int n = this.enterContext(11);
            this.printer.p((Node)iterator.next());
            this.exitContext(n);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitPostincrementExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p("++");
        this.endExpression(n);
    }

    public void visitPostdecrementExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p("--");
        this.endExpression(n);
    }

    public void visitCompoundLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p('(').p(gNode.getNode(0)).p(") ").p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitPrimaryIdentifier(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitStatementAsExpression(GNode gNode) {
        int n = this.enterContext(0);
        boolean bl = this.isStmtAsExpr;
        this.isStmtAsExpr = true;
        this.prepareNested();
        this.printer.p(gNode.getNode(0));
        this.isStmtAsExpr = bl;
        this.exitContext(n);
    }

    public void visitVariableArgumentAccess(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("__builtin_va_arg(");
        int n2 = this.enterContext(11);
        this.printer.p(gNode.getNode(0));
        this.exitContext(n2);
        this.printer.p(", ").p(gNode.getNode(1)).p(')');
        this.endExpression(n);
    }

    public void visitAssemblyDefinition(GNode gNode) {
        if (this.lineUp) {
            if (this.isOpenLine) {
                this.printer.pln();
            }
            this.printer.lineUp(gNode);
        } else if (this.isStatement || this.isDeclaration || this.isLongDecl) {
            if (this.isOpenLine) {
                this.printer.pln();
            }
            this.printer.pln();
        }
        this.printer.p(gNode.getNode(0)).pln(';');
        this.isDeclaration = false;
        this.isLongDecl = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitSimpleAssemblyExpression(GNode gNode) {
        int n = this.enterContext(0);
        this.printer.p("asm(").p(gNode.getNode(0)).p(')');
        this.exitContext(n);
    }

    public void visitAssemblyStatement(GNode gNode) {
        boolean bl = this.startStatement(0, gNode);
        this.printer.indent().p("asm ");
        if (null != gNode.getNode(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p('(').p(gNode.getNode(1)).pln(");");
        this.endStatement(bl);
    }

    public void visitAssemblyArgument(GNode gNode) {
        int n = this.enterContext(0);
        int n2 = gNode.size();
        int n3 = this.printer.column();
        this.printer.p(gNode.getNode(0));
        if (n2 >= 2) {
            if (null == gNode.get(1)) {
                this.printer.pln().align(n3).p(": /* No output operands */");
            } else {
                this.printer.pln().align(n3).p(": ").p(gNode.getNode(1));
            }
            if (n2 >= 3) {
                if (null == gNode.get(2)) {
                    this.printer.pln().align(n3).p(": /* No input operands */");
                } else {
                    this.printer.pln().align(n3).p(": ").p(gNode.getNode(2));
                }
                if (n2 == 4) {
                    this.printer.pln().align(n3).p(": ").p(gNode.getNode(3));
                }
            }
        }
        this.exitContext(n);
    }

    public void visitAssemblyOperands(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitAssemblyOperand(GNode gNode) {
        if (null != gNode.get(0)) {
            this.printer.p('[').p(gNode.getString(0)).p("] ");
        }
        this.printer.p(gNode.getNode(1)).p(" (").p(gNode.getNode(2)).p(')');
    }

    public void visitAssemblyClobbers(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitFloatingConstant(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitIntegerConstant(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitCharacterConstant(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitStringConstant(GNode gNode) {
        int n = this.startExpression(160);
        if (1 == gNode.size()) {
            this.printer.p(gNode.getString(0));
        } else {
            int n2 = this.printer.column();
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                this.printer.p(Token.cast(iterator.next()));
                if (!iterator.hasNext()) continue;
                this.printer.pln().align(n2);
            }
        }
        this.endExpression(n);
    }

    public void visit(LineMarker lineMarker) {
        if (this.isOpenLine) {
            this.isOpenLine = false;
            this.printer.pln();
        }
        if (this.lineUp) {
            this.printer.lineUp(lineMarker);
        }
        this.printer.p("# ").p(lineMarker.line).p(" \"").p(lineMarker.file).p('\"');
        if (0 != (lineMarker.flags & 1)) {
            this.printer.p(" 1");
        }
        if (0 != (lineMarker.flags & 2)) {
            this.printer.p(" 2");
        }
        if (0 != (lineMarker.flags & 4)) {
            this.printer.p(" 3");
        }
        if (0 != (lineMarker.flags & 8)) {
            this.printer.p(" 4");
        }
        this.printer.pln().p(lineMarker.getNode());
    }

    public void visit(Pragma pragma) {
        if (this.isOpenLine) {
            this.isOpenLine = false;
            this.printer.pln();
        }
        if (this.lineUp) {
            this.printer.lineUp(pragma);
        }
        this.printer.p("#pragma ").pln(pragma.directive).p(pragma.getNode());
    }

    public void visit(SourceIdentity sourceIdentity) {
        if (this.isOpenLine) {
            this.isOpenLine = false;
            this.printer.pln();
        }
        if (this.lineUp) {
            this.printer.lineUp(sourceIdentity);
        }
        this.printer.p("#ident \"").p(sourceIdentity.ident).pln('\"').p(sourceIdentity.getNode());
    }
}

