/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.HashMap;
import xtc.tree.Annotation;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Pragma;
import xtc.tree.SourceIdentity;
import xtc.util.State;

public class CParserState
implements State {
    protected static final boolean DEBUG = false;
    protected static final int POOL_INIT = 10;
    protected static final int POOL_INCR = 5;
    protected static final int FLAG_TYPEDEF = 1;
    protected static final int FLAG_SCOPE = 2;
    protected static final int FLAG_TYPE_SPEC = 4;
    protected static final int FLAG_PARAMS = 8;
    protected static final int FLAG_MODIFIED = 16;
    protected static final int FLAG_STRUCTURE = 32;
    private Context pool;
    protected Context top;
    protected int nesting;
    protected Annotation annotation;

    public CParserState() {
        this.fillPool(10);
        this.top = new Context();
        this.reset(null);
    }

    protected void fillPool(int n) {
        for (int i = 0; i < n; ++i) {
            this.addToPool(new Context());
        }
    }

    protected Context takeFromPool() {
        if (null == this.pool) {
            this.fillPool(5);
        }
        Context context = this.pool;
        this.pool = context.next;
        context.next = null;
        return context;
    }

    protected void addToPool(Context context) {
        context.next = this.pool;
        context.clear();
        this.pool = context;
    }

    protected void push(Context context) {
        context.next = this.top;
        this.top = context;
    }

    protected Context pop() {
        Context context = this.top;
        this.top = context.next;
        context.next = null;
        return context;
    }

    public void reset(String string) {
        while (null != this.top.next) {
            this.addToPool(this.pop());
        }
        this.top.clear();
        this.top.set(2);
        this.nesting = 0;
        this.annotation = null;
    }

    public void start() {
        this.push(this.takeFromPool());
    }

    public void commit() {
        this.addToPool(this.pop());
    }

    public void abort() {
        this.addToPool(this.pop());
    }

    public void typedef() {
        this.top.set(1);
    }

    public void parameters() {
        this.top.set(8);
    }

    public void functionDeclarator() {
        this.top.clear(8);
    }

    public void typeSpecifier() {
        this.top.set(4);
    }

    public void pushScope() {
        this.top.set(2);
    }

    public void popScope() {
        this.top.clear(2);
    }

    public void enterStructure() {
        this.top.set(32);
    }

    public void exitStructure() {
        this.top.clear(32);
    }

    public void bind(String string) {
        if (this.top.next.isSet(8) || this.top.next.isSet(32)) {
            return;
        }
        Context context = this.top;
        while (!context.isSet(2)) {
            context = context.next;
        }
        if (!context.bindings.containsKey(string)) {
            context.bindings.put(string, this.top.isSet(1) ? Boolean.TRUE : Boolean.FALSE);
            context.set(16);
        }
    }

    public void bind(String string, boolean bl) {
        Context context = this.top;
        while (!context.isSet(2)) {
            context = context.next;
        }
        if (!context.bindings.containsKey(string)) {
            context.bindings.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
            context.set(16);
        }
    }

    public boolean isType(String string) {
        if (this.top.isSet(4)) {
            return false;
        }
        Context context = this.top;
        while (true) {
            if (!context.isSet(2)) {
                context = context.next;
                continue;
            }
            Boolean bl = context.bindings.get(string);
            if (null != bl) {
                boolean bl2 = bl;
                return bl2;
            }
            context = context.next;
            if (null == context) break;
        }
        return false;
    }

    public boolean isValid(Node node) {
        return this.top.isSet(4) || null != node;
    }

    public void lineMarker(String string, int n, String string2, String string3, String string4, String string5, Location location) {
        int n2 = 0;
        if (null != string2) {
            n2 |= 1;
        }
        if (null != string3) {
            n2 |= 2;
        }
        if (null != string4) {
            n2 |= 4;
        }
        if (null != string5) {
            n2 |= 8;
        }
        LineMarker lineMarker = new LineMarker(n, string, n2, null);
        lineMarker.setLocation(location);
        if (null == this.annotation) {
            this.annotation = lineMarker;
        } else {
            this.annotation.innerMost().setNode(lineMarker);
        }
    }

    public void pragma(String string, Location location) {
        Pragma pragma = new Pragma(string, null);
        pragma.setLocation(location);
        if (null == this.annotation) {
            this.annotation = pragma;
        } else {
            this.annotation.innerMost().setNode(pragma);
        }
    }

    public void ident(String string, Location location) {
        SourceIdentity sourceIdentity = new SourceIdentity(string, null);
        sourceIdentity.setLocation(location);
        if (null == this.annotation) {
            this.annotation = sourceIdentity;
        } else {
            this.annotation.innerMost().setNode(sourceIdentity);
        }
    }

    public void mark() {
        this.top.mark = null == this.annotation ? null : this.annotation.innerMost();
    }

    public Node annotate(Node node) {
        if (null != this.top.mark) {
            Annotation annotation = null;
            Context context = this.top.next;
            while (null != context) {
                if (null != context.mark) {
                    annotation = context.mark;
                    break;
                }
                context = context.next;
            }
            Annotation annotation2 = (Annotation)this.top.mark.getNode();
            this.top.mark.setNode(node);
            if (null == annotation) {
                node = this.annotation;
                this.annotation = annotation2;
            } else {
                node = annotation.getNode();
                annotation.setNode(annotation2);
            }
            this.top.mark = null;
        }
        return node;
    }

    protected static class Context {
        public Context next;
        public int flags;
        public final HashMap<String, Boolean> bindings = new HashMap();
        public Annotation mark;

        public void clear() {
            if (this.isSet(16)) {
                this.bindings.clear();
            }
            this.flags = 0;
            this.mark = null;
        }

        public boolean isSet(int n) {
            return 0 != (n & this.flags);
        }

        public void set(int n) {
            this.flags |= n;
        }

        public void clear(int n) {
            this.flags &= ~n;
        }
    }
}

