/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.Iterator;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Node;
import xtc.tree.Pragma;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class CCounter
extends Visitor {
    public int countTopLevelDeclaration;
    public int countTopLevelFunction;
    public int countNestedDeclaration;
    public int countNestedFunction;
    public int countLocalLabelDecl;
    public int countNamedLabel;
    public int countCaseLabel;
    public int countDefaultLabel;
    public int countCompoundStmt;
    public int countIfStmt;
    public int countIfElseStmt;
    public int countWhileStmt;
    public int countDoStmt;
    public int countForStmt;
    public int countSwitchStmt;
    public int countBreakStmt;
    public int countContinueStmt;
    public int countReturnStmt;
    public int countGotoStmt;
    public int countExpressionStmt;
    public int countAssemblyStmt;
    public int countEmptyStmt;
    public int countLineMarker;
    public int countPragma;
    protected boolean isTopLevel;

    public CCounter() {
        this.clearCounters();
    }

    public void clearCounters() {
        this.countTopLevelDeclaration = 0;
        this.countTopLevelFunction = 0;
        this.countNestedDeclaration = 0;
        this.countNestedFunction = 0;
        this.countLocalLabelDecl = 0;
        this.countNamedLabel = 0;
        this.countCaseLabel = 0;
        this.countDefaultLabel = 0;
        this.countCompoundStmt = 0;
        this.countIfStmt = 0;
        this.countIfElseStmt = 0;
        this.countWhileStmt = 0;
        this.countDoStmt = 0;
        this.countForStmt = 0;
        this.countSwitchStmt = 0;
        this.countBreakStmt = 0;
        this.countContinueStmt = 0;
        this.countReturnStmt = 0;
        this.countGotoStmt = 0;
        this.countExpressionStmt = 0;
        this.countAssemblyStmt = 0;
        this.countEmptyStmt = 0;
        this.countLineMarker = 0;
        this.countPragma = 0;
    }

    public void print(Printer printer) {
        printer.pln().sep().pln();
        printer.indent().p("// Top-level declarations         : ").pln(this.countTopLevelDeclaration);
        printer.indent().p("// Top-level function definitions : ").pln(this.countTopLevelFunction);
        printer.indent().p("// Nested declarations            : ").pln(this.countNestedDeclaration);
        printer.indent().p("// Nested function definitions    : ").pln(this.countNestedFunction);
        printer.indent().p("// Local label declarations       : ").pln(this.countLocalLabelDecl);
        printer.indent().p("// Named labels                   : ").pln(this.countNamedLabel);
        printer.indent().p("// Case labels                    : ").pln(this.countCaseLabel);
        printer.indent().p("// Default labels                 : ").pln(this.countDefaultLabel);
        printer.indent().p("// Compound statements            : ").pln(this.countCompoundStmt);
        printer.indent().p("// If statements                  : ").pln(this.countIfStmt);
        printer.indent().p("// If-else statements             : ").pln(this.countIfElseStmt);
        printer.indent().p("// While statements               : ").pln(this.countWhileStmt);
        printer.indent().p("// Do statements                  : ").pln(this.countDoStmt);
        printer.indent().p("// For statements                 : ").pln(this.countForStmt);
        printer.indent().p("// Switch statements              : ").pln(this.countSwitchStmt);
        printer.indent().p("// Break statements               : ").pln(this.countBreakStmt);
        printer.indent().p("// Continue statements            : ").pln(this.countContinueStmt);
        printer.indent().p("// Return statements              : ").pln(this.countReturnStmt);
        printer.indent().p("// Goto statements                : ").pln(this.countGotoStmt);
        printer.indent().p("// Expression statements          : ").pln(this.countExpressionStmt);
        printer.indent().p("// Assembly statements            : ").pln(this.countAssemblyStmt);
        printer.indent().p("// Empty statements               : ").pln(this.countEmptyStmt);
        printer.indent().p("// Line markers                   : ").pln(this.countLineMarker);
        printer.indent().p("// Pragmas                        : ").pln(this.countPragma);
        printer.pln().sep().pln();
    }

    public void visitTranslationUnit(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.isTopLevel = true;
            this.dispatch((Node)iterator.next());
        }
    }

    public void visitFunctionDefinition(GNode gNode) {
        if (this.isTopLevel) {
            ++this.countTopLevelFunction;
        } else {
            ++this.countNestedFunction;
        }
        this.isTopLevel = false;
        this.dispatch(gNode.getNode(3));
        this.dispatch(gNode.getNode(4));
    }

    public void visitDeclarationList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Node)iterator.next());
        }
    }

    public void visitDeclaration(GNode gNode) {
        if (this.isTopLevel) {
            ++this.countTopLevelDeclaration;
        } else {
            ++this.countNestedDeclaration;
        }
        this.isTopLevel = false;
    }

    public void visitLabeledStatement(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.dispatch(gNode.getNode(1));
    }

    public void visitNamedLabel(GNode gNode) {
        ++this.countNamedLabel;
    }

    public void visitCaseLabel(GNode gNode) {
        ++this.countCaseLabel;
    }

    public void visitDefaultLabel(GNode gNode) {
        ++this.countDefaultLabel;
    }

    public void visitCompoundStatement(GNode gNode) {
        ++this.countCompoundStmt;
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Node)iterator.next());
        }
    }

    public void visitLocalLabelDeclaration(GNode gNode) {
        this.countLocalLabelDecl += gNode.size();
    }

    public void visitIfElseStatement(GNode gNode) {
        ++this.countIfElseStmt;
        this.dispatch(gNode.getNode(1));
        this.dispatch(gNode.getNode(2));
    }

    public void visitIfStatement(GNode gNode) {
        ++this.countIfStmt;
        this.dispatch(gNode.getNode(1));
    }

    public void visitWhileStatement(GNode gNode) {
        ++this.countWhileStmt;
        this.dispatch(gNode.getNode(1));
    }

    public void visitDoStatement(GNode gNode) {
        ++this.countDoStmt;
        this.dispatch(gNode.getNode(0));
    }

    public void visitForStatement(GNode gNode) {
        ++this.countForStmt;
        this.dispatch(gNode.getNode(0));
        this.dispatch(gNode.getNode(3));
    }

    public void visitSwitchStatement(GNode gNode) {
        ++this.countSwitchStmt;
        this.dispatch(gNode.getNode(1));
    }

    public void visitBreakStatement(GNode gNode) {
        ++this.countBreakStmt;
    }

    public void visitContinueStatement(GNode gNode) {
        ++this.countContinueStmt;
    }

    public void visitReturnStatement(GNode gNode) {
        ++this.countReturnStmt;
    }

    public void visitGotoStatement(GNode gNode) {
        ++this.countGotoStmt;
    }

    public void visitExpressionStatement(GNode gNode) {
        ++this.countExpressionStmt;
    }

    public void visitAssemblyStatement(GNode gNode) {
        ++this.countAssemblyStmt;
    }

    public void visitEmptyStatement(GNode gNode) {
        ++this.countEmptyStmt;
    }

    public void visitCommaExpression(GNode gNode) {
    }

    public void visitAssignmentExpression(GNode gNode) {
    }

    public void visitConditionalExpression(GNode gNode) {
    }

    public void visitLogicalOrExpression(GNode gNode) {
    }

    public void visitLogicalAndExpression(GNode gNode) {
    }

    public void visitBitwiseOrExpression(GNode gNode) {
    }

    public void visitBitwiseXorExpression(GNode gNode) {
    }

    public void visitBitwiseAndExpression(GNode gNode) {
    }

    public void visitEqualityExpression(GNode gNode) {
    }

    public void visitRelationalExpression(GNode gNode) {
    }

    public void visitShiftExpression(GNode gNode) {
    }

    public void visitAdditiveExpression(GNode gNode) {
    }

    public void visitMultiplicativeExpression(GNode gNode) {
    }

    public void visitCastExpression(GNode gNode) {
    }

    public void visitSizeofExpression(GNode gNode) {
    }

    public void visitUnaryMinusExpression(GNode gNode) {
    }

    public void visitUnaryPlusExpression(GNode gNode) {
    }

    public void visitLogicalNegationExpression(GNode gNode) {
    }

    public void visitBitwiseNegationExpression(GNode gNode) {
    }

    public void visitAddressExpression(GNode gNode) {
    }

    public void visitIndirectionExpression(GNode gNode) {
    }

    public void visitPreincrementExpression(GNode gNode) {
    }

    public void visitPredecrementExpression(GNode gNode) {
    }

    public void visitSubscriptExpression(GNode gNode) {
    }

    public void visitDirectComponentSelection(GNode gNode) {
    }

    public void visitIndirectComponentSelection(GNode gNode) {
    }

    public void visitFunctionCall(GNode gNode) {
    }

    public void visitPostincrementExpression(GNode gNode) {
    }

    public void visitPostdecrementExpresson(GNode gNode) {
    }

    public void visitCompoundLiteral(GNode gNode) {
    }

    public void visitPrimaryIdentifier(GNode gNode) {
    }

    public void visitFloatingConstant(GNode gNode) {
    }

    public void visitIntegerConstant(GNode gNode) {
    }

    public void visitCharacterConstant(GNode gNode) {
    }

    public void visitStringConstant(GNode gNode) {
    }

    public void visit(LineMarker lineMarker) {
        ++this.countLineMarker;
        this.dispatch(lineMarker.getNode());
    }

    public void visit(Pragma pragma) {
        ++this.countPragma;
        this.dispatch(pragma.getNode());
    }
}

