module TupleSpaceRmi{
	role(endemic){
	}

}

slice TupleSpaceRmi {
	decl{
		import java.util.ArrayList;
		import java.rmi.registry.LocateRegistry;
		import java.rmi.registry.Registry;
		import TupleSpaceRmi.TupleEntry;
		import TupleSpaceRmi.TupleSpaceInterface;
		import java.rmi.RemoteException;

			
		TupleSpaceInterface  tS = connect();
	
		TupleSpaceInterface connect(){
			try {
	        	    String name = "TupleSpace";
	        	    Registry registry = LocateRegistry.getRegistry(Args.hostname);
	        	    TupleSpaceInterface ts = (TupleSpaceInterface) registry.lookup(name);
			    return ts;
	        	} catch (Exception e) {
	        		Logger.printErr("It was not possible get the remote Object in the host "+Args.hostname);
				Logger.printErr(e.getMessage());
			}
			return null;
		}
		
		String getNullValue(){
			return TupleEntry.NULLCHAR;
		}


		Hashtable<String,String> getMatches(ArrayList<String> values,ArrayList<String> types,boolean remove){
			TupleEntry te = new TupleEntry(types,values);
			Hashtable<String,String> ret = new Hashtable<String,String>();
			TupleEntry res;
			try{
				if(!remove){
				  res = tS.getMatches(te);
				}else{
				  res = tS.getMatchesAndRemove(te);
				}
				if(res!=null){
					Logger.printDebug("Found Match");
					Logger.printDebug(res.print());
		   			int i = 0;
			  		int j = 0;
			   		for(String value:values){
						if(value.equals(TupleEntry.NULLCHAR)){
						//Logger.printDebug("indici i="+i+"  j=" + j);
						String varName;
						if(destVar.get(VarTable.getScope())==null){
							Logger.printErr("No destination var for process "+VarTable.getScope());	
							break;
						}
						if(!(destVar.get(VarTable.getScope()).size()<=j)){
							varName = destVar.get(VarTable.getScope()).get(j);	
							String newValue;
							if("List".equals(types.get(i))){
								newValue = ListsTable.deserializeList(res.getValues().get(i));
							}else{
								Logger.printDebug("no need to deserialize "+types.get(i));
								newValue = res.getValues().get(i);
							}
							ret.put(varName,newValue);
						}else{
						  Logger.printErr(" Is not possible get variable number "+j+" from destVar");
						}	
	
						j++;
					    }
					    i++;
			   		}
					destVar.get(VarTable.getScope()).clear();
				}else{
				  Logger.printDebug("Match NOT Found");
				}
			}catch(RemoteException re){
				Logger.printErr("It was not possible connect to the remote object");
				Logger.printErr(re.getMessage());
			}
			return ret;
		}

		void addEntry(ArrayList<String> values,ArrayList<String> types){
			//Temporaneo da rimuovere quando tutti oggetti saranno serializzati
			for(int i =0;i<types.size();i++){
		  	   if("List".equals(types.get(i))){
				values.set(i,ListsTable.serializeList(values.get(i)));
			   } 
			}
			try{
				TupleEntry te = new TupleEntry(types,values);
		   		tS.addEntry(te);
			}catch(RemoteException re){
				Logger.printErr("It was not possible connect to the remote object");
				Logger.printErr(re.getMessage());
			}
		}



		void addDestVariable(String var){
			if(!destVar.containsKey(VarTable.getScope())){
				destVar.put(VarTable.getScope(),new ArrayList<String>());		
			}		
			destVar.get(VarTable.getScope()).add(var);
			Logger.printDebug("Aggiungo "+var+" alla DestVar");
		}
		
		//Tabella temporanea per indicizzare i nomi di variabili destinatari dei valori richiesti con In
		Hashtable<String,ArrayList<String>> destVar = new Hashtable<String,ArrayList<String>>();
	
	}

	

	module TupleSpaceRmi with role endemic

}
