module ListsAccess {
	role(syntax){
		SimpleExpression <-- ListsAccess
		ListsAccess <-- Identifier '[' SimpleExpression ']' AccessList 
		ListsAccess <-- Identifier '[' SimpleExpression ']'
		AccessList  <-- '[' SimpleExpression ']' AccessList 
		AccessList  <-- '[' SimpleExpression ']'
	}
	role(evaluation){
		0 {
			$0.value=$1.eval;
		}
		2 {
			Integer index = Integer.valueOf($4.eval);
			String table = VarTable.getValue($3.eval);
			String value="";
			Logger.printDebug("Access list to "+index+" of table "+table);
			if(table == null){
				Logger.printErr("Error the variable "+$3.value+" has not been declared");	
				value="";
			}else{
				 	ArrayList<String> indexes= new ArrayList<String>();

					for(String str:$5.eval.split(",")){
						indexes.add(str);	
					}
					
					value=Local.recGetValue(Local.parseInt(indexes),ListsTable.ListTableValue.get(VarTable.getValue($3.value)).get(index));
					Logger.printDebug("Value of the access to a multi list "+value);
			}
			$2.value=value;
		}
		6 {
			//Evaluation gia effettuata in type checking
			Integer index = Integer.valueOf($8.eval);
			String table = VarTable.getValue($7.eval);
			String value;
			if(table == null){
				Logger.printErr("Error the variable "+$7.value+" has not been declared");	
				Logger.typeErr=true;
				value="";
			}else{
				 value=ListsTable.ListTableValue.get(table).get(index);	
			}
			$6.value=value;
		}
		9{
			Logger.printDebug("Valore di AccessList "+$9.value);
			$9.value=$10.eval+","+$11.eval;
		}

		12 {
			$12.value=$13.eval;
		}
	}

	role(type_checking){
		0 {
			$0.type=$1.type;
		}
		2 {
			//Funziona Solo se effettuata a runtime
			Logger.printDebug("type checking ListAccess "+$3.type);	
			String type = VarTable.getType($3.type);
			if(type==null){
				type="";
			}
			if(!$4.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
				type=null;

			}else{
				if(!type.equals("List")){
					Logger.printErr("Error the variable  "+$3.type+" is not a list");	
					Logger.typeErr=true;
					type="";
				}else{
					Integer index= Integer.valueOf($4.eval);
					Logger.printDebug("Recupero tipo di oggetto numero "+index);
					type=ListsTable.ListTableType.get(VarTable.getValue($3.type)).get(index);
					if(type==null){
					  type="";
					}
					if(!type.equals("List")){
						Logger.printErr("Error the element at index "+index+" is not a list");	
						Logger.typeErr=true;
						type=null;
	
					}
					ArrayList<String> indexes= new ArrayList<String>();
					for(String str:$5.eval.split(",")){
						indexes.add(str);	
					}
					Logger.printDebug("Index List "+$5.value);

					
					type=Local.recGetType(Local.parseInt(indexes),ListsTable.ListTableValue.get(VarTable.getValue($3.type)).get(index));
					Logger.printDebug("Type of multi access "+type);

				}
			}
			Logger.printDebug(" Tipo oggetto lista  "+type);
			$2.type=type;	
		}


		6 {
			//Funziona Solo se effettuata a runtime
			Logger.printDebug("type checking ListAccess");	
			String type = VarTable.getType($7.type);
			if(type==null){
				type="";
			}
			if(!$8.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
				type=null;
			}else{
				if(!type.equals("List")){
					Logger.printErr("Error the variable  "+$7.type+" is not a list");	
					Logger.typeErr=true;
					type="";
				}else{
					Integer index= Integer.valueOf($8.eval);
					Logger.printDebug("Recupero tipo di oggetto numero "+index);
					type=ListsTable.ListTableType.get(VarTable.getValue($7.type)).get(index);
				
				}
			}
			Logger.printDebug(" Tipo oggetto lista  "+type);
			$6.type=type;	
		}
		9 {
			if(!$10.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
			}
		}
		12 {
			if(!$13.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
			}
		}

	}
}

slice ListsAccess {
	
	decl {
		import java.uti.ArrayList;
		
		String recGetType(ArrayList<Integer> listsIndexs,String baseList){
			Logger.printDebug("recGetType Lista indici "+listsIndexs+ " base list  "+baseList);
			if(listsIndexs.size()<1){
				Logger.printErr("recGetType Error lists indexes length < then 1");
				return "";
			}
			
			if(listsIndexs.size()==1){
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));
				if(type==null){
					type="";			
				}
				return type;
			}else{
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));
				if(type==null){
					type="";			
				}
				if(!type.equals("List")){
					Logger.printErr("Error the index "+listsIndexs.get(0)+" of "+baseList+" is not a list");
					return "";
				}
				String listCode = ListsTable.ListTableValue.get(baseList).get(listsIndexs.get(0));
				listsIndexs.remove(0);
				return recGetType(listsIndexs,listCode);
			}

		
		}
		
		String recGetValue(ArrayList<Integer> listsIndexs,String baseList){
			Logger.printDebug("recGetValue Lista indici "+listsIndexs+ " base list  "+baseList);
			if(listsIndexs.size()<1){
				Logger.printErr("recGetValue Error lists indexes length < then 1");
				return "";
			}
			
			if(listsIndexs.size()==1){
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));
				if(type==null){
					type="";			
				}
				String value=ListsTable.ListTableValue.get(baseList).get(listsIndexs.get(0));
				return value;
			}else{
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));
				if(type==null){
					type="";			
				}
				if(!type.equals("List")){
					Logger.printErr("Error the index "+listsIndexs.get(0)+" of "+baseList+" is not a list");
					return "";
				}
				String listCode = ListsTable.ListTableValue.get(baseList).get(listsIndexs.get(0));
				listsIndexs.remove(0);
				return recGetValue(listsIndexs,listCode);
			}

		
		}

		ArrayList<Integer> parseInt(ArrayList<String> listsIndexs){
			ArrayList<Integer> result=new ArrayList<Integer>();
			for(String str:listsIndexs){
				try{
					result.add(Integer.parseInt(str));	
				}catch(Exception e){
					Logger.printErr("Error in parsing index list");
					Logger.printErr(e.toString());	
				}	
			}
			return result;
		}

	
	}

	module ListsAccess with role syntax evaluation type_checking
}


