module Lists {
	role(syntax){
		SimpleExpression <-- Lists
		Lists <-- '[' ExpressionList ']'  
		Lists <-- '[' ']'
	}
	role(evaluation){
		0 {
		
			$0.value=$1.eval;
		}

		2 {
			LinkedList<String> values = new LinkedList<String>();
			for(String value : $3.eval.split(",")){
				values.add(value);	
			}
			ListsTable.ListTableValue.put($2.hashCode()+"",values);
			$2.value=$2.hashCode()+"";
		
		}
		4 {
			LinkedList<String> values = new LinkedList<String>();
			ListsTable.ListTableValue.put($4.hashCode()+"",values);
			$4.value=$4.hashCode()+"";
		
		}

	}

	role(type_checking){
		0 {
			$0.type=$1.type;
		}

		2 {
			LinkedList<String> types = new LinkedList<String>();
			for(String type : $3.type.split(",")){
				types.add(type);	
				Logger.printDebug("Aggiunto a Lista "+type);
			}
			
			ListsTable.ListTableType.put($2.hashCode()+"",types);
			$2.type="List";
		}
		4 {
			LinkedList<String> types = new LinkedList<String>();
			ListsTable.ListTableType.put($4.hashCode()+"",types);
			$4.type="List";
		}
	}
}

slice Lists {
	module Lists with role syntax evaluation type_checking
}


