module Print {
	role(syntax)
	    {		
	    	Print <-- "print" '(' Expression ')'
	    	Statment <-- Print
	    }
    
    	role(type_checking)
    	{
    	    0 {
	    		
    	    }
    	}
    role(evaluation)
    {
       	0 {
		Logger.printDebug("Print-------");
		Logger.print(Local.formatPrint($1.eval,$1.type));	
	}
	2 {
	   $2.value=$3.eval;
	}
    }
}
	
slice Print { 
    	decl {
		String formatPrint(String value,String type){
			String res = "";
				
			Logger.printDebug("print element of value "+value+ "of type "+type);	
			if(type.equals("String")){
				res="'"+value+"'";
			}else if(type.equals("List")) {
				res="[";
				try{
				List<String> types= ListsTable.ListTableType.get(value);
				List<String> values = ListsTable.ListTableValue.get(value);
				for(int i = 0; i<values.size();i++){
					if(i!=0){
						res+=",";
					}
					res+=formatPrint(values.get(i),types.get(i));
					
				}
				}catch(Exception e){
						Logger.printErr("Error in printing a list "+e.toString());
						e.printStackTrace();
						return "";
				}
				res+="]";
			}else if(type.equals("Boolean")){
				if(!value.equals("0")){
					res="false";
				}else{
					res="true";
				}	
			}else {
				res=value;	
			}
			return res;
		}	
		
	}
	
	module Print with role syntax type_checking evaluation
}
