module VarTable{
	role(endemic){
		
	}

}

slice VarTable {
	init{
	}
	decl{
		import java.util.*;
		//Used to set initial values
		String INITSCOPE="{GLOBAL}";
		String SCOPE ="{GLOBAL}";
		String RUNTIMESCOPE = "{RUNTIME}";
		Hashtable<String,Hashtable<String,String>> varValueTable = new Hashtable<String,Hashtable<String,String>>();
		Hashtable<String,Hashtable<String,String>> varTypeTable = new Hashtable<String,Hashtable<String,String>>();
		
		void putValue(String var,String value){
			String process = VarTable.getScope();
			if(!varValueTable.containsKey(process)){
				varValueTable.put(process,new Hashtable<String,String>());
			}
			Logger.printDebug("Added value "+value+ " for var "+var);
			varValueTable.get(process).put(var,value);
		}
		void putType(String var,String type){
			String process = VarTable.getScope();
			if(!varTypeTable.containsKey(process)){
				varTypeTable.put(process,new Hashtable<String,String>());
			}
			Logger.printDebug("Added type "+type+ " for var "+var);
			varTypeTable.get(process).put(var,type);
		}
		void putValueGlobal(String var,String value){
			String process = INITSCOPE;
			if(!varValueTable.containsKey(process)){
				varValueTable.put(process,new Hashtable<String,String>());
			}
			Logger.printDebug("Added vaule "+value+ " for var "+var);
			varValueTable.get(process).put(var,value);
		}
		void putTypeGlobal(String var,String type){
			String process = INITSCOPE;
			if(!varTypeTable.containsKey(process)){
				varTypeTable.put(process,new Hashtable<String,String>());
			}
			Logger.printDebug("Added type "+type+ " for var "+var);
			varTypeTable.get(process).put(var,type);
		}

		String getValue(String var){
			String process = VarTable.getScope();
			if(varValueTable.containsKey(process)){
				if(varValueTable.get(process).containsKey(var)){
					return varValueTable.get(process).get(var);
				}
			}else
				Logger.printDebug("ValueTable not created yet ");
			if(varValueTable.containsKey(INITSCOPE)){
				if(varValueTable.get(INITSCOPE).containsKey(var)){
					Logger.printDebug("value of "+var+" founded in GLOBAL"+varValueTable.get(INITSCOPE).get(var));
					return varValueTable.get(INITSCOPE).get(var);
				}
			}
			Logger.printErr("Couldn't found  value for var "+var);
			return "";
		}
		
		String getType(String var){
			String process = VarTable.getScope();
			if(varTypeTable.containsKey(process)){
				if(varTypeTable.get(process).containsKey(var)){
					return varTypeTable.get(process).get(var);
				}
			}else
				Logger.printDebug("TypeTable not created yet ");
			if(varTypeTable.containsKey(INITSCOPE)){
				if(varTypeTable.get(INITSCOPE).containsKey(var)){
					Logger.printDebug("type of "+var+" founded in GLOBAL"+varTypeTable.get(INITSCOPE).get(var));
					return varTypeTable.get(INITSCOPE).get(var);
				}
			}
			Logger.typeErr=true;
			Logger.printErr("Couldn't found  type  for var "+var);
			return "";
		}

		String getScope(){
			if(SCOPE.equals(RUNTIMESCOPE)){
				return Thread.currentThread().getName();	
			}else{
				return SCOPE;
			}
		}

	}
	module VarTable with role endemic

}
