module ListsSet {
	role(syntax){
		SimpleExpression <-- ListsSet
		ListsSet <-- Identifier '[' SimpleExpression ']' AccessList '=' Expression 
		ListsSet <-- Identifier '[' SimpleExpression ']' '=' Expression
		AccessList  <-- '[' SimpleExpression ']' AccessList 
		AccessList  <-- '[' SimpleExpression ']'
		}
	role(evaluation){
		0 {
			$0.value=$1.eval;
		}
		2 {
			Integer index = Integer.valueOf($4.eval);
			String table = VarTable.getValue($3.eval);
			String value="";
			Logger.printDebug("Set list to "+index+" of table "+table);
			if(table.equals("") ){
				value="";
				Logger.printErr("Error the variable "+$3.value+" has not been declared");	
			}else{
			    ArrayList<String> indexes= new ArrayList<String>();

			    for(String str:$5.eval.split(",")){
				indexes.add(str);	
			    }
			    Logger.printDebug("Set value of var "+$3.value+" index "+index);
			    Local.recSetValue(Local.parseInt(indexes),
				ListsTable.ListTableValue.get(VarTable.getValue($3.value)).get(index),$6.eval);
			}
		}
		7 {
			Integer index = Integer.valueOf($9.eval);
			String table = VarTable.getValue($8.eval);
			String value;
			Logger.printDebug("Set list to "+index+" of table "+table);
			if(table.equals("") ){
				value="";
				Logger.printErr("Error the variable "+$8.value+" has not been declared");	
			}else{
			    Logger.printDebug("Set value of var "+$8.value+" index "+index);
				 ListsTable.ListTableValue.get(table).set(index,$10.eval);	
			}

		}
		11{
			Logger.printDebug("Valore di AccessList "+$12.value);
			$11.value=$12.eval+","+$13.eval;
		}

		14 {
			$14.value=$15.eval;
		}

	}

	role(type_checking){
		0 {
			$0.type="";
		}
		2 {
			//Funziona Solo se effettuata a runtime
			Logger.printDebug("type checking ListSet "+$3.type);	
			String type = VarTable.getType($3.eval);
			if(!$4.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
				type="";
			}else{
				if(!type.equals("List")){
					Logger.printErr("Error the variable  "+$3.eval+" is not a list");	
					Logger.typeErr=true;
					type="";
				}else{
					Integer index= Integer.valueOf($4.eval);
					Logger.printDebug("Recupero tipo di oggetto numero "+index);
					type=ListsTable.ListTableType.get(VarTable.getValue($3.type)).get(index);
					if(type==null){
					  type="";
					}
					if(!type.equals("List")){
						Logger.printErr("Error the element at index "+index+" is not a list");	
						Logger.typeErr=true;
	
					}
					ArrayList<String> indexes= new ArrayList<String>();
					for(String str:$5.eval.split(",")){
						indexes.add(str);	
					}
					Logger.printDebug("Index List "+$5.value);

					
					Local.recSetType(Local.parseInt(indexes),
						ListsTable.ListTableValue.get(VarTable.getValue($3.type)).get(index),$6.type);

				}
			}
		}


		7 {
			//Funziona Solo se effettuata a runtime
			Logger.printDebug("type checking ListSet");	
			String type = VarTable.getType($8.eval);
			if(type==null){
				type="";
			}
			if(!$9.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
			}else{
				if(!type.equals("List")){
					Logger.printErr("Error the variable  "+$8.eval+" is not a list");	
					Logger.typeErr=true;
				}else{
					Integer index= Integer.valueOf($9.eval);
					ListsTable.ListTableType.get(VarTable.getValue($8.type)).set(index,$10.type);
				
				}
			}
		}
		11 {
			if(!$12.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
			}
		}
		14 {
			if(!$15.type.equals("Integer")){
				Logger.printErr("Error the index is not an Integer");	
				Logger.typeErr=true;
			}
		}

	}
}
	

slice ListsSet {
	
	decl {
		import java.uti.ArrayList;
		
		void recSetType(ArrayList<Integer> listsIndexs,String baseList,String value){
			Logger.printDebug("recGetType Lista indici "+listsIndexs+ " base list  "+baseList);
			if(listsIndexs.size()<1){
				Logger.printErr("recGetType Error lists indexes length < then 1");
				return;
			}
			
			if(listsIndexs.size()==1){
				ListsTable.ListTableType.get(baseList).set(listsIndexs.get(0),value);
				Logger.printDebug("Set type "+value+" to index "+listsIndexs.get(0)+" of baseList "+ baseList);
				return;
			}else{
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));

				if(type==null){
					type="";			
				}
				if(!type.equals("List")){
					Logger.printErr("Error the index "+listsIndexs.get(0)+" of "+baseList+" is not a list");
					return ;
				}
				String listCode = ListsTable.ListTableValue.get(baseList).get(listsIndexs.get(0));
				listsIndexs.remove(0);
				recSetType(listsIndexs,listCode,value);
				return ;
			}

		
		}
		
		void  recSetValue(ArrayList<Integer> listsIndexs,String baseList,String value){
			Logger.printDebug("recGetValue Lista indici "+listsIndexs+ " base list  "+baseList);
			if(listsIndexs.size()<1){
				Logger.printErr("recGetValue Error lists indexes length < then 1");
				return;
			}
			
			if(listsIndexs.size()==1){
				ListsTable.ListTableValue.get(baseList).set(listsIndexs.get(0),value);
				Logger.printDebug("Set value "+value+" to index "+listsIndexs.get(0)+" of baseList "+ baseList);
				return ;
			}else{
				String type=ListsTable.ListTableType.get(baseList).get(listsIndexs.get(0));
				if(type==null){
					type="";			
				}
				if(!type.equals("List")){
					Logger.printErr("Error the index "+listsIndexs.get(0)+" of "+baseList+" is not a list");
					return;
				}
				String listCode = ListsTable.ListTableValue.get(baseList).get(listsIndexs.get(0));
				listsIndexs.remove(0);
				 recSetValue(listsIndexs,listCode, value);
				 return ;
			}

		
		}

		ArrayList<Integer> parseInt(ArrayList<String> listsIndexs){
			ArrayList<Integer> result=new ArrayList<Integer>();
			for(String str:listsIndexs){
				try{
					result.add(Integer.parseInt(str));	
				}catch(Exception e){
					Logger.printErr("Error in parsing index list");
					Logger.printErr(e.toString());	
				}	
			}
			return result;
		}

	
	}

	module ListsSet with role syntax evaluation type_checking
}


