module BoolOperator {
	role(syntax){
		BoolExpr <-- SimpleExpression '>=' SimpleExpression	
		BoolExpr <-- SimpleExpression '<=' SimpleExpression	
		BoolExpr <-- SimpleExpression '>' SimpleExpression	
		BoolExpr <-- SimpleExpression '<' SimpleExpression	
		BoolExpr <-- SimpleExpression '==' SimpleExpression	
		BoolExpr <-- SimpleExpression '!=' SimpleExpression	
		BoolExpr <-- Bool
	}
	role(evaluation){
		0 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($1.type);
			types.add($2.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($1.eval);
			value.add($2.eval);
			String res = OpTable.otTable.get("GreaterEq").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$1.value+" "+$2.value+" of type "+$1.type+" and "+$2.type);
			}
			$0.value=res;
		}
		
		3 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($4.type);
			types.add($5.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($4.eval);
			value.add($5.eval);
			String res = OpTable.otTable.get("LessEq").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$4.value+" "+$5.value+" of type "+$4.type+" and "+$5.type);
			}
			$3.value=res;
		}
		6 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($7.type);
			types.add($8.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($7.eval);
			value.add($8.eval);
			String res = OpTable.otTable.get("Greater").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$7.value+" "+$8.value+" of type "+$7.type+" and "+$8.type);
			}
			$6.value=res;
		}
		9 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($10.type);
			types.add($11.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($10.eval);
			value.add($11.eval);
			String res = OpTable.otTable.get("Less").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$10.value+" "+$11.value+" of type "+$10.type+" and "+$11.type);
			}
			$9.value=res;
		}
		
		12 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($13.type);
			types.add($14.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($13.eval);
			value.add($14.eval);
			String res = OpTable.otTable.get("Equal").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$13.value+" "+$14.value+" of type "+$13.type+" and "+$14.type);
			}
			$12.value=res;
		}
		
		15 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($16.type);
			types.add($17.type);
			ArrayList<String> value= new ArrayList<String>();	
			value.add($16.eval);
			value.add($17.eval);
			String res = OpTable.otTable.get("NotEqual").getEvalResult(value,types);
			if(res.equals("")){
				Logger.printErr("Error something goes wrong in the Comparison of "+$16.value+" "+$17.value+" of type "+$16.type+" and "+$17.type);
			}
			$15.value=res;
		}
		18 {
			$18.value = $19.eval;
		}
	}

	role(type_checking){
		0 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($1.type);
			types.add($2.type);
			String res = OpTable.otTable.get("GreaterEq").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$1.type+" "+$2.type+" are not compatible for Compare operation");
			}
			$0.type=res;
		}
		
		3 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($4.type);
			types.add($5.type);
			String res = OpTable.otTable.get("LessEq").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$4.type+" "+$5.type+" are not compatible for Compare operation");
			}
			$3.type=res;
		}
		6 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($7.type);
			types.add($8.type);
			String res = OpTable.otTable.get("Greater").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$7.type+" "+$8.type+" are not compatible for Compare operation");
			}
			$6.type=res;
		}
		9 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($10.type);
			types.add($11.type);
			String res = OpTable.otTable.get("Less").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$10.type+" "+$11.type+" are not compatible for Compare operation");
			}
			$9.type=res;
		}
		
		12 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($13.type);
			types.add($14.type);
			String res = OpTable.otTable.get("Equal").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$13.type+" "+$14.type+" are not compatible for Compare operation");
			}
			$12.type=res;
		}
		
		15 {
			ArrayList<String> types= new ArrayList<String>();	
			types.add($16.type);
			types.add($17.type);
			String res = OpTable.otTable.get("NotEqual").getTypeResult(types);
			if(res.equals("")){
				Logger.printErr("Error type "+$16.type+" "+$17.type+" are not compatible for Compare operation");
			}
			$15.type=res;
		}
		18{
			$18.type=$19.type;
		}
	}
}

slice BoolOperator {
	init{
		compareTable.add("Integer$Integer");
	}
	decl{
		import java.util.HashSet;

		HashSet<String> compareTable = new HashSet<String>();
		
		boolean isComparable(String s1,String s2){
			return compareTable.contains(s1+"$"+s2);
		}
	
	}
	module BoolOperator with role syntax evaluation type_checking
}


