/*
 * Decompiled with CFR 0.152.
 */
package TupleSpace;

import TupleSpace.TupleEntry;
import TupleSpace.TupleTable;
import java.util.ArrayList;
import java.util.Hashtable;

public class TupleSpace {
    private static TupleSpace ts;
    private Hashtable<String, TupleTable> htt = new Hashtable();

    private TupleSpace() {
    }

    public static TupleSpace getInstance() {
        if (ts != null) {
            return ts;
        }
        ts = new TupleSpace();
        return ts;
    }

    public synchronized void addEntry(TupleEntry tupleEntry) {
        if (this.htt.containsKey(tupleEntry.getSignature())) {
            this.htt.get(tupleEntry.getSignature()).addEntry(tupleEntry);
        } else {
            this.htt.put(tupleEntry.getSignature(), new TupleTable());
            this.htt.get(tupleEntry.getSignature()).addEntry(tupleEntry);
        }
    }

    public synchronized TupleEntry getMatches(TupleEntry tupleEntry) {
        ArrayList<TupleEntry> arrayList = new ArrayList<TupleEntry>();
        for (TupleTable tupleTable : this.htt.values()) {
            if (!tupleTable.checkSignature(tupleEntry.getSignature())) continue;
            arrayList.addAll(tupleTable.getMatches(tupleEntry));
        }
        if (arrayList.size() > 0) {
            return (TupleEntry)arrayList.get(0);
        }
        return null;
    }

    public synchronized TupleEntry getMatchesAndRemove(TupleEntry tupleEntry) {
        for (TupleTable tupleTable : this.htt.values()) {
            if (!tupleTable.checkSignature(tupleEntry.getSignature())) continue;
            TupleEntry tupleEntry2 = tupleTable.getMatchesAndRemove(tupleEntry);
            return tupleEntry2;
        }
        return null;
    }
}

