/*
 * Decompiled with CFR 0.152.
 */
package TupleSpaceServer;

import TupleSpaceRmi.TupleEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TupleTable {
    private String sign;
    private HashSet<TupleEntry> table = new HashSet();

    public String getSign() {
        return this.sign;
    }

    void setSign(String string) {
        this.sign = string;
    }

    public boolean addEntry(TupleEntry tupleEntry) {
        if (this.table.size() == 0) {
            this.sign = tupleEntry.getSignature();
            this.table.add(tupleEntry);
            return true;
        }
        if (this.checkSignature(tupleEntry.getSignature())) {
            this.table.add(tupleEntry);
            return true;
        }
        System.err.println("Is not possible insert entry with signature");
        System.err.println(tupleEntry.getSignature());
        System.err.println("Incompatible with");
        System.err.println(this.sign);
        return false;
    }

    boolean checkSignature(String string) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(this.sign);
        return matcher.matches();
    }

    public ArrayList<TupleEntry> getMatches(TupleEntry tupleEntry) {
        ArrayList<TupleEntry> arrayList = new ArrayList<TupleEntry>();
        if (this.checkSignature(tupleEntry.getSignature())) {
            for (TupleEntry tupleEntry2 : this.table) {
                if (!tupleEntry2.equals(tupleEntry)) continue;
                arrayList.add(tupleEntry2);
            }
            return arrayList;
        }
        System.err.println("Is not possible search for matching entry with signature");
        System.err.println(tupleEntry.getSignature());
        System.err.println("Incompatible with");
        System.err.println(this.sign);
        return arrayList;
    }

    public synchronized TupleEntry getMatchesAndRemove(TupleEntry tupleEntry) {
        if (this.checkSignature(tupleEntry.getSignature())) {
            for (TupleEntry tupleEntry2 : this.table) {
                if (!tupleEntry2.equals(tupleEntry)) continue;
                TupleEntry tupleEntry3 = tupleEntry2;
                this.table.remove(tupleEntry2);
                return tupleEntry3;
            }
            return null;
        }
        System.err.println("Is not possible search for matching entry with signature");
        System.err.println(tupleEntry.getSignature());
        System.err.println("Incompatible with");
        System.err.println(this.sign);
        return null;
    }
}

