/*
 * Decompiled with CFR 0.152.
 */
package TupleSpaceServer;

import TupleSpaceRmi.TupleEntry;
import TupleSpaceRmi.TupleSpaceInterface;
import TupleSpaceServer.TupleTable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;

public class TupleSpace
implements TupleSpaceInterface {
    private static TupleSpace ts;
    private Hashtable<String, TupleTable> htt = new Hashtable();

    private TupleSpace() {
    }

    private static TupleSpace getInstance() {
        if (ts != null) {
            return ts;
        }
        ts = new TupleSpace();
        return ts;
    }

    public synchronized void addEntry(TupleEntry tupleEntry) throws RemoteException {
        if (this.htt.containsKey(tupleEntry.getSignature())) {
            this.htt.get(tupleEntry.getSignature()).addEntry(tupleEntry);
        } else {
            this.htt.put(tupleEntry.getSignature(), new TupleTable());
            this.htt.get(tupleEntry.getSignature()).addEntry(tupleEntry);
        }
    }

    public TupleEntry getMatches(TupleEntry tupleEntry) throws RemoteException {
        ArrayList<TupleEntry> arrayList = new ArrayList<TupleEntry>();
        for (TupleTable tupleTable : this.htt.values()) {
            if (!tupleTable.checkSignature(tupleEntry.getSignature())) continue;
            arrayList.addAll(tupleTable.getMatches(tupleEntry));
        }
        if (arrayList.size() > 0) {
            return (TupleEntry)arrayList.get(0);
        }
        return null;
    }

    public synchronized TupleEntry getMatchesAndRemove(TupleEntry tupleEntry) throws RemoteException {
        for (TupleTable tupleTable : this.htt.values()) {
            if (!tupleTable.checkSignature(tupleEntry.getSignature())) continue;
            TupleEntry tupleEntry2 = tupleTable.getMatchesAndRemove(tupleEntry);
            return tupleEntry2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "TupleSpace";
            TupleSpace tupleSpace = TupleSpace.getInstance();
            TupleSpaceInterface tupleSpaceInterface = (TupleSpaceInterface)UnicastRemoteObject.exportObject((Remote)((Object)tupleSpace), 0);
            Registry registry = LocateRegistry.getRegistry();
            registry.rebind(string, (Remote)tupleSpaceInterface);
            System.out.println("TupleSpace bound");
        }
        catch (Exception exception) {
            System.err.println("TupleSpace exception:");
            exception.printStackTrace();
        }
    }
}

