package time_constraint.time;

import java.net.*;
import uka.karmi.rmi.*;
import uka.karmi.rmi.server.*;
import java.lang.Class;
import java.lang.reflect.*;
import java.util.Hashtable;

/**
 * The <code>Time</code> class rapresents the time. Each istance represents the global time
 * and is used to simulate how the time runs away.
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class Time extends UnicastRemoteObject implements interface_time {

  /**
   * @serial
   **/
  private int t;
  
  /**
   * Creates and initializes a new Time object.
   * @throws RemoteException
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public Time() throws RemoteException {  t = 0; }
  
  /**
   * Increases the time adding 1. Returns the new time. 
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public int updatetime()  {this.t = this.t + 1; 
                            return this.t;}

  /**
   * Establishes which is its security server and which security policy it has
   * to respect; rebinds the name to the new time object.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public static void main(String[] args) {
    String ref;
    try {
      ref = "tm";
      Time t = new Time();
      if(System.getSecurityManager() == null) {
         System.setSecurityManager( new java.rmi.RMISecurityManager() );
      }

      Naming.rebind(ref, t);
      System.out.println("The actual time is :"+ t.t);
       
    } catch (Exception e) {System.out.println("Error in Time");
			   e.printStackTrace();   }
	
  } // main
}//class    
