package time_constraint.constr_eval;

import java.io.*;

/**
 * The <code>request</code> class represents the request of a service.<br> 
 * A request is [client, server, method, parameter].<br><br>
 * An example of request:<br><br>
   [A; T; x; 5].
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class request implements Serializable {
  /**
   * represents the client of the request.
   * @since Version 1.0
   * @serial
   **/
  public char o1;
  /**
   * represents the intended server to satisfy the request.
   * @since Version 1.0
   * @serial
   **/
  public char o2;
  /**
   * represents the service requested.
   * @since Version 1.0
   * @serial
   **/
  public char m;
  /**
   * represents the parameter of the method <code>m</code>.
   * @since Version 1.0
   * @serial
   **/
  public int  p;

/**
 * Initializes a new <code>request</code>. <code>o1</code> represents the client
 * of the request, <code>o2</code> represents the intended server to satisfy the request, 
 * <code>m</code> represents the service requested, <code>p</code> represents
 * the parameter of the method <code>m</code>.
 * @author  Lorella Ristaino (<A HREF="mailto:1994s015@educ.disi.unige.it">1994s015@educ.disi.unige.it</A>)
   * @since Version 1.0
 **/
public request(char o1, char o2, char m, int p) {
  this.o1 = o1;
  this.o2 = o2;
  this.m = m;
  this.p = p;
  }

}
