package time_constraint.constr_eval;

import java.io.*;

/**
 * The <code>elhistory</code> class implements an element of the history.
 * The history consists of elhistory. An elhistory consists of a
 * request thet has been satisfied and the time at which it was made. 
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class elhistory extends request implements Serializable {

 /**
  * Represents the time at which the request was made.
  * @author  Daniela Olivieri
  * @since Version 1.0
  * @serial
  **/
 public int time;
  
 /**
  * Write an elhistory on a stream.
  * @param out is the stream to write on.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 private void writeObject(java.io.ObjectOutputStream out) throws IOException
 {  out.writeChar(o1);
    out.writeChar(o2);
    out.writeChar(m);
    out.writeInt(p);
    out.writeInt(time);
 }
 
 /**
  * Read an elhistory from a stream.
  * @param is the stream to read from.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 private void readObject(java.io.ObjectInputStream in) throws IOException,
 ClassNotFoundException
  { this.o1 = in.readChar();
    this.o2 = in.readChar();
    this.m = in.readChar();
    this.p = in.readInt(); 
    this.time = in.readInt();
 }
  
 /**
  * Creates a new <code>elhistory</code> and initializes request and time.
  * @param r is an accepted request.
  * @param time the time at which the request was made
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public elhistory(request r, int time) {
   super(r.o1, r.o2, r.m, r.p); 
   this.time = time;
 }
 
 /**
  * Checks if the elhistory is equal to <code>el</code>.
  * Returns <B>TRUE</B> if it is, <B>FALSE</B> otherwise.
  * @param el is an elhistory.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public boolean equal(elhistory el) {
    boolean okeq = false;
    if ((this.o1 == el.o1) & (this.o2 == el.o2) & (this.m == el.m) & 
        (this.p == el.p) & (this.time == el.time))
	   { //System.out.println("la richiesta e' nella storia " + okret); 
	       okeq = true;
             }
    return okeq;
  } 

 /**
  * Write an elhistory to standard output.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public void print_el() { 
  System.out.println("cliente " + this.o1);
  System.out.println("server " + this.o2);
  System.out.println("metodo " + this.m);
  System.out.println("tempo " + this.time); 
 }
       
} 
