package time_constraint.constr_eval;

import java.io.*;

/**
 * The <code>binnode</code> class rapresents a node of the tree representing the
 * constraint.
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class binnode extends request {

 /**
  * Represents the operator identifier.
  * @author  Daniela Olivieri
  * @since Version 1.0
  * @serial
  **/
 public int op;

 /**
  * Initializes the <code>binnode</code>. <code>r</code> is a {@link request request} and
  * <code>op</code> is the operator identifier represented by the node.
  * @author  Daniela Olivieri
  * @param r is a request.
  * @param op is the operator identifier: AND(1), BEFORE(2), EXIST(3), FORALL(4),
  *        NOT(5), EQUAL(6), OR(7), ONCE(8), SINCE(9), SOFAR(10), MAJOR(11), 
  *        MINOR(12), TRUE(20).
  * @since Version 1.0
  **/
 public binnode(request r, int op) {
   super(r.o1, r.o2, r.m, r.p); 
   this.op = op;
 }     
} 
