package mChaRM.multichannel;

import java.io.*;
import uka.karmi.rmi.*;
import uka.karmi.rmi.server.*;
import java.lang.reflect.*;
import mChaRM.RMI.*;

  /** 
   * This class represents the common root for both sender and receiver stub classes.
   * Both sender and receiver stubs have common features and behaviors. Both of them 
   * have to be connected to the core of the multi-channel, and offer it some services.
   * Besides both of them allow the multi-channel to access the state of its referents.
   *
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.2
   * @since Version 1.0
   **/

class stub extends UnicastRemoteObject implements stubInterface { 
    /** @serial */
  private channelInterface channelCore;    // the hook towards channel's core 

    /**
     * It supplies a pointer to the core of the multi-channel. 
     * 
     * @return an instance of the interface of the multi-channel. 
     **/
  final public channelInterface WhoIsMyCore() {return channelCore;}
    /**
     * links the stub to the core of the multi-channel which it is part of.
     * @param kind the kind of the core of the multi-channel which it is part of.
     * @exception CoreNotFoundException thrown when the core doesn't exist or isn't registered as a server.
     **/
  final public void setWhoIsMyCore(String kind) throws CoreNotFoundException {
    try {
      channelCore = (channelInterface)lookupEveryWhere.lookup(kind);
    } catch(NotBoundException e) {
        throw new CoreNotFoundException("*** It is impossible to connect the stub to the multi-channel core ["+kind+"], because it isn't registered as server!"); 
    }
  }
  
    /** @serial */
  private Object referent;                 // the hook towards the stub's referent

    /**
     * sets the referent of this stub.
     * @param referent the referent.
     **/
  final public void setReferent(Object r) {referent = r;}
    /**
     * accessor to the referent of the stub.
     * @return a pointer to the referent of this stub.
     **/
  final public Object referent() {return referent;}

  public stub() throws RemoteException {}

    /**
     * queries for the contents of a specified field of the referent.
     * @exception FieldDoesNotExistException thrown when the specified field isn't declared in the class of the referent.
     * @param fieldName the name of the field whose content is retrieved.
     * @return an object representing the contents of the specified field.
     **/
  public Object retrieveField(String fieldName) throws FieldDoesNotExistException {
    try {
      Field f = (referent().getClass()).getDeclaredField(fieldName);
      return f.get(referent());
    } catch(NoSuchFieldException e) { throw new FieldDoesNotExistException("*** The requested field ["+fieldName+"] is not declared in the class of the referent ["+referent().getClass().getName()+"]");
    } catch(IllegalAccessException e){ throw new FieldDoesNotExistException("*** The requested field ["+fieldName+"] cannot be accessed"); }
  }
}
