package mChaRM.mChaRMCollection;

import mChaRM.multichannel.*;
import uka.karmi.rmi.*;

  /**
   * realizes the receiver stubs of a multi-channel of kind <I>verbose</I>. 
   * Its meta-behavior consists in tracing the trapped calls printing the information related them, when they arrive on the receiver side.
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.0
   **/
public class verboseReceiverStub extends receiverStub {
    /**
     * constructor for the stubs. Its ancestor constructor is entrusted of all the work.
     * <HR>
     * @param myReferent a representant of the stub referent.
     * @param myKind the multi-channel's name.
     * @param myReferentName the referent's name.
     * @exception ReceiverStubCannotBeRegisteredAsAServerException thrown when the stub cannot be registered as a server.
     * @exception CoreNotFoundException thrown when the core of the multi-channel, which the stub is part of,
     *            doesn't exist or isn't correctly registered as a server. 
     **/
  public verboseReceiverStub(Object myReferent, String myKind, String myReferentName) 
         throws RemoteException, ReceiverStubCannotBeRegisteredAsAServerException, CoreNotFoundException {
    super(myReferent, myKind, myReferentName);
  }

    /** it is called before the true invocation of the trapped method and permits to prints a message regarding the trapped message.
     * <HR>
     * @param msg the trapped message.
     **/
  public void beforeReceiverSideMetaBehavior(mChaRMMethodCall msg) {
    try {    
      System.out.print("*** I'm in the target locus of ["+retrieveField("whoAmI")+"],\n*** the trapped call is: "+msg.getMethodName()+"( ");
    } catch(Exception e) {System.err.println( "*** There is some troubles in retrieving the name of the receiver");}
    if (msg.hasArgs()) 
      for(int i=0;i<(msg.actualArguments()).length;i++) System.out.print((msg.actualArguments())[i]+" ");
    System.out.println(").");
  }
    /** it is called after the true invocation of the trapped method and prints a message regarding the return value.
     * <HR>
     * @param msg the trapped message.
     **/
  public void afterReceiverSideMetaBehavior(mChaRMMethodCall msg) {
    try {    
      System.out.print("*** I'm again in the target locus of ["+retrieveField("whoAmI")+"],\n*** I've just computed the call: "+msg.getMethodName()+"( ");
    } catch(Exception e) {System.err.println( "*** There is some troubles in retrieving the name of the receiver");}
    if (msg.hasArgs()) 
      for(int i=0;i<(msg.actualArguments()).length;i++) System.out.print((msg.actualArguments())[i]+" ");
    System.out.println(") which gives the result: "+(msg.getReturnValue())+". ");
  }
}
