package mChaRM.mChaRMCollection;

import mChaRM.multichannel.*;
import mChaRM.RMI.*;
import time_constraint.time.*;
import time_constraint.constr_eval.*;
import java.util.Vector;
import java.util.StringTokenizer;
import uka.karmi.rmi.*;

  /**
   * The <code>validationChannel</code> realizes a multi-channel of kind <I>validation</I>.<br><br>
   * The channel meta-behavior is based on the knolwledge of the receivers. The <I>validation</I> 
   * channel needs also to
   * know the sender: it is specified in the sender code by indicating the <code>kind validation_X_</code>,
   * where X is the sender name. See the {@link sender1A sender1A} for more details. <br><br>
   * The channel meta-behavior consists in trapping the method calls and checking if the temporal constraints are
   * respected.<br><br>
   * It uses instances of {@link validationSenderStub validationSenderStub} class as senderStubs, 
   * and instances of {@link validationReceiverStub validationReceiverStub} as receiverStubs.
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>) and 
   *          Lorella Ristaino (<A HREF="mailto:1994s015@educ.disi.unige.it">1994s015@educ.disi.unige.it</A>)
   * @version 1.0
   * @since Version 1.2
   **/
public class validationChannel extends channelCore implements validationChannelInterface {

  /** 
   * Creates a multi-channels of kind validation.
   * <HR>
   * It calls the {@link validationChannel validationChannel} constructor with 
   * <code>kind</code> validation, <code>SSClassName</code> and <code>SRClassName</code> the validation
   * version of the sender and receiver stubs.
   * @param RsName an Array of Strings representing the name of the receivers, which it is connected to.
   * @param client is the sender's name.
   * @exception ReceiverStubNotFoundException thrown when one of the specified receiver wasn't started 
   * before the core.
   * @since Version 1.0
   **/
  public validationChannel(String[] RsName, String client) throws RemoteException, ReceiverStubNotFoundException {
    this("validation", RsName, "mChaRM.multichannel.senderStub", "mChaRM.multichannel.receiverStub", client);
  }
   
  /** 
   * Creates a multi-channels of kind validation.
   * <HR>
   * It calls the {@link mChaRM.multichannel.channelCore#channelCore channelCore} constructor with 
   * kind validation 
   * and as classes for sender and receiver stubs their verbose version.
   * @param kind is the channel kind: <code>validation</code>.
   * @param RsName an Array of Strings representing the name of the receivers, which it is connected to.
   * @param SSClassName is the validation version of the sender stub class.
   * @param SRClassName is the validation version of the receiver stub class.
   * @param client is the sender's name.
   * @exception ReceiverStubNotFoundException thrown when one of the specified receiver wasn't started before the core.
   * @since Version 1.0
   **/
  public validationChannel(String kind, String[] RsName, String SSClassName, String RSClassName, String client) throws RemoteException, ReceiverStubNotFoundException {
    super(kind+"_"+client+"_", RsName, SSClassName, RSClassName);
  }  

  /**
   * @version 1.0
   * @since Version 1.2
   * @serial
   **/
  private partialhistory ph = new partialhistory();  
  
  /**
   * Supply to another channel the history of the current channel. 
   * @version 1.0
   * @since Version 1.2
   **/
  public partialhistory retrievehistory() throws RemoteException {
    return ph;
  }  

  /**
   * Adds the just satisfied request <code>el</code>, timestamped with the current time, to the history.
   * @params el is an element of the history.
   * @since Version 1.0
   **/
  public void updatehistory(elhistory el) {
   (ph.history).addElement(el); 
  }


  private boolean RequestInHistory(elhistory elh) {      	
    validationChannelInterface remch;
    try {
      remch = (validationChannelInterface)lookupEveryWhere.lookup("__validation_"+elh.o1+"_{ "+elh.o2+" }");
      partialhistory h = remch.retrievehistory();
      System.out.println("The history of " + elh.o1 + "+" + elh.o2 + " is: ");
      h.printhistory();  
      
      System.out.println("h.Contains result: " + h.Contains(elh));
      if ((h.Contains(elh)) & 
          ((elh.o1 != senderName(0).charAt(0)) || (elh.o2 != receiverName(0).charAt(0)))) {
             ph.mergehistory(h);
             return true;
      }
    } catch (Exception e2) {e2.printStackTrace();}
    return false;
  } 
   

 private int PosOfVariable(char x, Vector table)  {
   int i = 0;
     
   while (i<table.size()) {
     vardom v = (vardom) table.elementAt(i);
     if (v.var == x) return i; 
     else i++;
   } 
   return -1;
 }
  
  /**
   * Looks in the constraint file for the constraint associated to the request and retrieve it.
   * @return the tree representation of the constraint.
   * @param msg contains the informations of the request: sender, receiver, method, and parameter.
   * @param table represents the evaluation environment (a vector of {@link vardom vardom}) of the 
   *              existential and universal quantifier.
   * @since Version 1.0
   **/
  public bintree retrieveconstraint(mChaRMMethodCall msg, Vector table) { 
    String namefile = "constraint.txt";  
    String s = (new RFile()).readfile(namefile);
    StringTokenizer st = new StringTokenizer(s, "\n", false);
    String cons = " ";
    bintree tree = new bintree();
      
    while (st.hasMoreTokens()) { 
      StringTokenizer st1 = new StringTokenizer(st.nextToken(), " -", false);
      char tkc[] = new char[9];
      tkc = (st1.nextToken()).toCharArray();
      if (tkc[1] == msg.sender().charAt(0) & tkc[3] == (msg.receivers()[0]).charAt(0) & tkc[5] == msg.getMethodName().charAt(0)) 
        cons = st1.nextToken();
    } //while 
    if (cons != " ") { 
      System.out.println("Constraint of the request: " + cons);
      StringTokenizer st2 = new StringTokenizer(cons ,"()[],", true);
      tree.buildtree(st2, table);
    } else System.out.println("There isn't constraints of the request");
    return tree; 
  } //fine retreiveconstraint  


 private boolean Exists(char[] e, elhistory elh, int who)  {
   boolean oke = false;
   request r;
   int i=0;
   while ((i<5) & (oke == false) & (e[i] != '\u0000')) {
     if (who == 1)  // the variable is the client
       r = new request(e[i],elh.o2,elh.m,elh.p);
     else // the variable is the server 
       r = new request(elh.o1,e[i],elh.m,elh.p);
     elhistory elh1 = new elhistory(r, elh.time);
     oke = RequestInHistory(elh1);
     i=i+1; 
   }
   return oke;
 } 
 

 private boolean Forall(char[] e, elhistory elh, int who)  {
   boolean okf = true;
   request r;
   int i=0; 
   while ((i<5) & (okf == true) & (e[i] != '\u0000')) {
     if (who == 1) // the variable is the client
       r = new request(e[i],elh.o2,elh.m,elh.p);
     else // the variable is the server
       r = new request(elh.o1,e[i],elh.m,elh.p);
     elhistory elh1 = new elhistory(r, elh.time);
     if (RequestInHistory(elh1)) okf = false;
     i=i+1; 
   }
   return okf; 
 } 
 
  /**
   * Evaluate the tree representation of the constraint to decide whether the method called by the client
   * can be executed or not. Returns <B>TRUE</B> if the constraint is satisfied, <B>FALSE</B> otherwise.
   * @param tree is the tree representing the constraint to be evaluated.
   * @param t is the time at which the constraint has to be evaluated.
   * @param table represents the evaluation environment (a vector of {@link vardom vardom}) of the 
   *              existential and universal quantifier.
   * @param par is the parameter of the method called from the client whose execution depends on the 
   *            constraint evaluation result.
   * @since Version 1.0
   **/
  public boolean eval(bintree tree, int t, Vector table, int par) {
     final int VarIsServer = 2;
     final int VarIsClient = 1; 
     boolean result = false;
     if ((tree.n != null) & (result == false)) {
       switch (tree.n.op) {
         case (0):  //request
	   char c = tree.n.o1, s = tree.n.o2, m = tree.n.m;
	   int p = tree.n.p;
	   request req = new request(c, s, m, 0);
	   elhistory elh = new elhistory(req, t); 
	 
	   int d= 0;
	   int posc = PosOfVariable(elh.o1,table);
	   int poss = PosOfVariable(elh.o2,table);
	 
	   if ((posc != -1) & (poss == -1)) { // elh.o1 is a variable and elh.o2 isn't a variable
             
	     vardom vc = (vardom) table.elementAt(posc);
	     if (vc.funz == 'e') {
	       if (Exists(vc.dom, elh, VarIsClient)) result = true;
	     } else {
	       if (vc.funz == 'f') 
	         if (Forall(vc.dom, elh, VarIsClient) == false) result = true;
             }             
	   } else if ((posc == -1) & (poss != -1)) { // elh.o1 isn't a variable elh.o2 is a variable
             vardom vs = (vardom) table.elementAt(poss);  
	     if (vs.funz == 'e'){
	       if (Exists(vs.dom, elh, VarIsServer)) result = true;
	     } else { 
               if (vs.funz == 'f') 
	         if (Forall(vs.dom, elh, VarIsServer) == false) result = true;
             }             
	   } else if ((posc != -1) & (poss!= -1)) { // elh.o1 is a variable and elh.o2 is a variable	 
             boolean oke =false, okf = true;
	     vardom vc = (vardom) table.elementAt(posc);  
             vardom vs = (vardom) table.elementAt(poss);  
             if ((vc.funz == 'e') & (vs.funz == 'e')){  
               while ((d<5) & (vs.dom[d] != '\u0000') & (oke==false)) {
	         elh.o2 = vs.dom[d];
		 if (Exists(vc.dom,elh,VarIsClient)) oke = true;
		 d=d+1;
               }
               result = oke;    
             }
             if ((vc.funz == 'e') & (vs.funz == 'f')) { 
               while ((d<5) & (vc.dom[d] != '\u0000') & (oke==false)) { 
                 elh.o1 = vc.dom[d];
		 if (Forall(vs.dom,elh,VarIsServer)==false) oke=true;
		 d=d+1;
               }
               result = oke;    
             }     
             if ((vc.funz == 'f') & (vs.funz == 'e'))
	       {  while ((d<5) & (vc.dom[d] != '\u0000') & (oke==false))
	           {  elh.o1 = vc.dom[d];
		      if (Exists(vs.dom,elh,VarIsServer)) oke=true;
		      d=d+1;
		    }
		   result = oke;    
               }   
	     if ((vc.funz == 'f') & (vs.funz == 'f')) {
	       while ((d<5) & (vc.dom[d] != '\u0000') & (oke==false)) {
                 elh.o1 = vc.dom[d];
	         if (Forall(vs.dom,elh,VarIsServer)==false) oke=true;
                 try {
                        ph.printhistory(); 
                      } catch(Exception e){System.out.println("Eccezione in Eval");}              
		      d=d+1;
		    }
		   result = okf;
               }            
           } else // elh.o1 is not a variable and elh.o2 is not a  variable
	       result = RequestInHistory(elh);
	   break;
         
         case (1):  //and
	   if ((tree.left != null) & (tree.right != null)) 
             result = (eval(tree.left, t, table,par)) & (eval(tree.right, t,table,par));
           else System.out.println("error in tree");
	   break;
	  
         case (2):  //before
	   if (tree.left != null) result = eval(tree.left, t-1, table,par);
	   else System.out.println("error In tree "); 
	   break;
	  
         case (3):  //exist
	   result = eval(tree.left, t, table,par);
	   break;

         case (4):  //forall
	   result = eval(tree.left, t, table,par);
	   break;
	   
         case (5):  //not
	   result = !eval(tree.left, t,table,par);
	   break;
	   
         case (6):  //equal
	   result = (par == tree.n.p);
	   break;
	    
	 case (11):  //major
	   result = (par > tree.n.p);
	   break;
	    
	 case (12):  //minor
	   result = (par < tree.n.p);
	   break;
	    
	 case (7):   // or
	   if ((tree.left != null) & (tree.right != null))
	      result = (eval(tree.left, t,table,par)) || (eval(tree.right, t,table,par));
           else System.out.println("error in tree");
	   break;
	   
         case (8):   // once
	   result = false;
	   bintree bt = tree.left;
	   
	   while ((t > 0) & (result == false)) result = eval(bt, --t, table, par);
	   break;
	   
         case (9):    // since
	   int t1 = t;
	   boolean oksince1 = false, oksince2 = true;
	   while ((oksince1 == false) & (t1 > 0))  
	     if (oksince1 = eval(tree.right, --t1, table, par))
               while ((t1<t) & (oksince2 == true)) 
                 oksince2 = eval(tree.left, ++t1,table,par);
           result = ((oksince1 == true) & (oksince2 == true));
	   break;     
    	   
	 case (10):  // sofar
	   result = true;
	   bintree bts = tree.left;
	   while ((t > 0) & (result == true) ) 
             result = eval(tree.left, --t, table, par);
	   break;

         case (20):  // vincolo = true
	   result = true;
	   break;
	       
	 default:
	   System.out.println("Error in reading methods. ");
	   
	 } //fine switch
	
	
       }  //fine if
       return result; 
	             
   } // fine eval  	      	
  
  
   /** 
    * This method embodies the reflective behaviour realized by the multi-channel.
    * <HR>
    * Its behavior consists in trapping the method calls (also termed as service requests) of a sender
    * and checking the security constraints related to such requests; if the contraints are satisfied the 
    * request is forwarded to the intended receiver (the server) to be carried out. 
    * Otherwise the request will not be satisfied.
    * @param RsName the name of the receivers who the message have to be delivered to.
    * @param methodName the name of the method whose execution is requested.
    * @param args the actual arguments of the call.
    * @return the result of the method call.
    * @exception MethodDoesNotExistException thrown when the method reified doesn't exist in the referent class.
    * @since Version 1.0
    **/
  public Object coreMetaBehavior(mChaRMMethodCall msg) throws MethodDoesNotExistException, RemoteException {
    int actime = 0;
    Vector table = new Vector();
   
    bintree constraint = this.retrieveconstraint(msg, table);
    interface_time  remtime;
    msg.printmChaRMMethodCall();
    try {
      System.out.println("lookup di mataBehavior");
      remtime = (interface_time) lookupEveryWhere.lookup("tm");
      actime = remtime.updatetime();
      System.out.println("*******The actual time is = " + actime + "************");
    } catch (Exception e1) {e1.printStackTrace();}
    try {
      if (eval(constraint, actime, table, ((Integer)msg.inspectArgument(0)).intValue())|| (constraint.emptyTree())) {
        System.out.println("It is possible to satisfy the request ");
        request r = new request(msg.sender().charAt(0), (msg.receivers()[0]).charAt(0), msg.getMethodName().charAt(0), 0);
        elhistory el = new elhistory(r,actime);
        this.updatehistory(el);
        System.out.println("The final history is: ");
        this.ph.printhistory();
        return super.coreMetaBehavior(msg);
      } else { 
        System.out.println("It isn't  possible to satisfy the request! The security constraints are not respected!!");
        return null;
      }	
    } catch(ReferenceToNonExistentArgumentException e) {System.out.println("ERRORE: nella coreMetaBehavior");
                                                        e.printStackTrace();return null;}    
  }

}

