package time_constraint.constr_eval;

import java.io.*;
import java.util.StringTokenizer;
import java.lang.String.*;
import java.util.Vector;
import java.lang.Object;

/**
 * The <code>vardom</code> class represents variables and domains of existential and universal
 * quantifier.
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class vardom {


  /**
   * Represents the variable name.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
   public char var;

  /**
   * Represents the identifier of the existential or universal operator. "f" represents the existential operator
   * and "e" the universal one.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
   public char funz;

  /**
   * Represents the variable domain. It can contains at most 5 elements.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
   public char dom[] = new char[5];

  /**
   * Creates a <code>vardom</code> object.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
   public vardom() {}

  /**
   * Initializes a <code>vardom</code> using the informations contained in <code>st_var</code>.
   * @param st_var is a String containing variables and domain information.
   * <p>An example of <code>st_var</code>: <br><br><B>"X{A/B/C}"</B> <br><br> where X is the variable and A, B, C are possible
   * values of X, names of client or server.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
   public void createdom(String st_var) {
  
   // sara' una funzione che preso un token restituisce la tabella
	  // in cui c'e' (variabile e dominio)		
			
	// String t is like  X{A/B/C}
	
	StringTokenizer t1 = new StringTokenizer(st_var,"{}/",false);
	String tt1 = t1.nextToken(); // X
	char tkc[] = new char[1];
	tkc = (tt1).toCharArray();
	this.var = tkc[0];
	int i=0;
	while (t1.hasMoreTokens())
		 { String tdom = t1.nextToken(); // A B C ..
		   char tdom1[] = new char[1];
	           tdom1 = (tdom).toCharArray();
		   this.dom[i] = tdom1[0];
		   i= i+1;
		  }	  
        if (i<5) dom[i+1]='\0';
   }
}
  
