package time_constraint.constr_eval;

import java.io.*;
import java.util.*;
import uka.karmi.rmi.*;

/**
 * The <code>partialhistory</code> class implements the set of accepted service requests between
 * the sender and the receiver.
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class partialhistory implements Serializable {

  /**
   * Represents a Vector of <code>elhistory</code>.
   * @author  Daniela Olivieri
   * @since Version 1.0
   * @serial
   **/
 public Vector history = new Vector();
 
 /**
 * Creates a new <code>partialhistory</code> object.
 * @author  Daniela Olivieri
 * @since Version 1.0
 **/
 public partialhistory () {}


 /**
  * Checks if <code>el</code> is contained in the partialhistory. Returns <B>TRUE</B> if it is, 
  * <B>FALSE</B> otherwise.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public boolean Contains(elhistory el) {
    boolean okret = false; 
    Enumeration e = (this.history).elements();
    
    while ((e.hasMoreElements()) & (okret == false))
         {   elhistory el3 = (elhistory) (e.nextElement());
	     if (el3.equal(el)) okret = true;
          }
    return okret;
  }
  
   
 /**
  * Prints the partialhistory to standard output.
  * @throws RemoteException
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public void printhistory() throws RemoteException {
   int s = this.history.size();
   for (int i = 0; i<s; i++)
       { elhistory e = (elhistory) this.history.elementAt(i);
         System.out.println(e.o1 + "-" + e.o2 + "-" + e.m + "-" + e.p + "-" +e.time);
       }
 }	 
     
      
  
 /**
  * Merges the parthialhistory with <code>ph1</code>.
  * @author  Daniela Olivieri
  * @since Version 1.0
  **/
 public void mergehistory(partialhistory ph1)  {
   int sizeph1 = ph1.history.size();
   this.history.ensureCapacity(this.history.size() + sizeph1);
   for (int i = 0; i<sizeph1; i++)
      if (!(this.Contains((elhistory) ph1.history.elementAt(i)))) 
         this.history.addElement(ph1.history.elementAt(i)); 
     
 }       	 
}//end class
