package time_constraint.constr_eval;

import java.io.*;
import java.util.StringTokenizer;
import java.lang.String.*;
import java.util.Vector;

/**
 * The <code>bintree</code> class implements the tree that represents the
 * constraint. A constraint is written in the polish infix form. An example is:<br><br> 
 * (B,S,x,p) - and(Once([A;S;y;0],before([A;T;x;0])))<br><br>
 * The related tree is:<br><br><img SRC = "../../tree.gif" align = CENTER>
 * @author  Daniela Olivieri
 * @version 1.0
 * @since Version 1.2
 **/
public class bintree {  

  /**
   * Represents a node of the binary tree.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public binnode n;

  /**
   * Represents the left tree of the binary tree.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public bintree left; 

  /**
   * Represents the right tree of the binary tree.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public bintree right; 

  /**
   * Represents the binary tree whose son is <code>n</code>.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public bintree parent; 

  /**
   * Initializes the binary tree.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public bintree() {}

  /**
   * Adds the node <code>n1</code> to the binary tree.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public void add(binnode n1) {
     this.n = n1;
  }

  /**
   * Constructs the binary tree from the string <code>st</code>.
   * @param st is the string containing the constraint.
   * @param table represents the evaluation environment (a vector of {@link vardom vardom}) of the 
   *              existential and universal quantifier.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public void buildtree(StringTokenizer st, Vector table) {
    
    request r0 = new request('-','-','-',0);
			
    if (st.hasMoreTokens())
          {String tk = st.nextToken();
	   char tkc[] = new char[10];
	   tkc = (tk).toCharArray();
 	   switch (tkc[0]) {
	      
	      case ('t'):  // true
	           if (tkc[1] == 'r' & tkc[2] == 'u' & tkc[3] == 'e')
                       {binnode n = new binnode(r0, 20);
                        this.add(n);
	                (this).parent = this;
	                this.left = null;
	                this.right =null;
		        }
	           break;
		     
	      case ('b'):   //before
		   if (tkc[1] == 'e' & tkc[2] == 'f' & tkc[3] == 'o' & tkc[4] == 'r' & tkc[5] == 'e') 
		      {binnode n = new binnode(r0, 2);
		       this.add(n);
		       if (this.left == null) this.left = new bintree();
		       (this.left).parent = this;
		       this.left.buildtree(st,table);
		       }
		   break; 
	 
	      case ('O'):     
		   if (tkc[1] == 'n' & tkc[2] == 'c' & tkc[3] == 'e')  
		      {binnode n = new binnode(r0, 8); 
		       this.add(n);
		       if (this.left == null) this.left = new bintree();
		       (this.left).parent = this;
	               this.left.buildtree(st,table);
		       }
		   break;
		 
		 
	      case ('o'):     
		   if (tkc[1] == 'r')   //or
		      {binnode n = new binnode(r0, 7); 
		       this.add(n);
		       if (this.left == null ) 
			  {this.left = new bintree(); 
			   (this.left).parent = this;   
			   this.left.buildtree(st,table);
			   }
			this.right = new bintree();
			(this.right).parent = this;          
			this.right.buildtree(st,table);
		        }
		    break; 
		  	  
	      case ('s'):  //sofar
	           if (tkc[1] == 'o' & tkc[2] == 'f' & tkc[3] == 'a' & tkc[4] == 'r') 
		      {binnode n = new binnode(r0, 10); 
		       this.add(n);
		       if (this.left == null) this.left = new bintree();
		       (this.left).parent = this;
		       // devo dire chi e' il padre
		       this.left.buildtree(st,table);
		       }
		    break;
		 
	     case ('S'):  // since
		  if (tkc[1] == 'i' & tkc[2] == 'n' & tkc[3] == 'c' & tkc[4] == 'e')
                     {binnode n = new binnode(r0, 9); 
                      this.add(n);
                      if (this.left == null ) 
			 {this.left = new bintree(); 
			  (this.left).parent = this;   
			  this.left.buildtree(st,table);
			  } 
                       this.right = new bintree();
                       (this.right).parent = this;          
                       this.right.buildtree(st,table);
	               }		   
		   break;
		 
	       case ('n'):    //not	         
		    if (tkc[1] == 'o' & tkc[2] == 't') 
		       {binnode n = new binnode(r0, 5); 
		        this.add(n);
		        if (this.left == null) this.left = new bintree();
		        (this.left).parent = this;
		        this.left.buildtree(st,table);
		        }  
		     break; 
		 
	       case ('e'):    //exist	         
	            if (tkc[1] == 'x' & tkc[2] == 'i' & tkc[3] == 's' & 
		        tkc[4] == 't' & tkc[5] == 's')
		       {binnode n = new binnode(r0, 3); 
		        this.add(n);
		        if (this.left == null) this.left = new bintree();
		        (this.left).parent = this;
	                vardom v = new vardom();
                        v.funz = 'e';
                        String g = st.nextToken();
                        String g1 = st.nextToken();
                        v.createdom(g1);
		        table.addElement(v);
                        String a = st.nextToken(); // serve solo a passare dopo la virgola
		        this.left.buildtree(st,table);
		        }
		    break; 
		 
	       case ('f'):    //forall	         
	            if (tkc[1] == 'o' & tkc[2] == 'r' & tkc[3] == 'a' &
		        tkc[4] == 'l' & tkc[5] == 'l')
		       {binnode n = new binnode(r0, 4); 
		        this.add(n);
		        if (this.left == null) this.left = new bintree();
		        (this.left).parent = this;
			 vardom vf = new vardom();
			 vf.funz = 'f';
			 String g = st.nextToken();
			 String g1 = st.nextToken();
			 vf.createdom(g1);
		         table.addElement(vf);
			 String af = st.nextToken(); // serve solo a passare dopo la virgola
		        this.left.buildtree(st,table);
		        }
		    break; 
		     
	       case ('a'):  //and
		    if (tkc[1]=='n' & tkc[2]== 'd')
		       {binnode n = new binnode(r0, 1); 
		        this.add(n);
		        if (this.left == null ) 
			   {this.left = new bintree(); 
			    (this.left).parent = this;   
			    this.left.buildtree(st,table);
			    }
			this.right = new bintree();
			(this.right).parent = this;          
			this.right.buildtree(st,table);
			}
		    break;
		
               case ('E'): //equal
		    if (tkc[1] == 'q' & tkc[2] == 'u' & tkc[3] == 'a' & 
		         tkc[4] == 'l')
		        {String g1 = st.nextToken(); // (
			 String g2 = st.nextToken(); // intero
			 String g3 = st.nextToken(); // ,
			 String g4 = st.nextToken(); // p
		         request r1 = new request('-','-','-',Integer.parseInt(g4));
		         binnode n = new binnode(r1, 6);         
		         this.add(n);
			 String g5 = st.nextToken(); // )
			 this.buildtree(st,table);
			 }
		    break;
		 
               case ('M'): //major
		    if (tkc[1] == 'a' & tkc[2] == 'j' & tkc[3] == 'o' & 
		        tkc[4] == 'r')
		       {String g1 = st.nextToken(); // (
			String g2 = st.nextToken(); // intero
			String g3 = st.nextToken(); // ,
			String g4 = st.nextToken(); // p
		        request r1 = new request('-','-','-',Integer.parseInt(g4));
		        binnode n = new binnode(r1, 11);         
		        this.add(n);
			String g5 = st.nextToken(); // )
			this.buildtree(st,table);
			}
		    break;
		
               case ('m'): //minor
		    if (tkc[1] == 'i' & tkc[2] == 'n' & tkc[3] == 'o' & 
		        tkc[4] == 'r')
		        {String g1 = st.nextToken(); //  (
			 String g2 = st.nextToken(); // p
			 String g3 = st.nextToken(); // , 
			 String g4 = st.nextToken(); // intero
			 request r1 = new request('-','-','-',Integer.parseInt(g4));
		         binnode n = new binnode(r1, 12);   
			 this.add(n);
		         String g5 = st.nextToken(); // )
			 this.buildtree(st,table);
			 }
		    break;
		       
	       case ('('):
	            this.buildtree(st,table);
		    break;
		   
	       case ('['): 
		    String req = st.nextToken();
		    char reqc[] = new char[11];
		    reqc = (req).toCharArray();
		    request r = new request(reqc[0], reqc[2],reqc[4],reqc[6]-48);
		    binnode n = new binnode(r, 0);
		    this.add(n);
		    this.buildtree(st,table);
		    break;
		  
               case (']'):
		    if (this.parent == null) this.buildtree(st,table);
		       else (this.parent).buildtree(st,table);	    
		    break;
		   
               case (')'):
                    if (this.parent != null) (this.parent).buildtree(st,table);
		    break;
		      
               case (','):
		    // passa oltre la virgola per gli operatori binari
                    return;
		       
               case ('\n'):
		    break;
		      
               case (' '):
		    break;
		        	       			    		      
	       default: 
		    System.out.println("Error in reading file");   
               
          }//switch
      }// if
} //fine buildtree

  /**
   * Writes the tree to standard output.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public void writetree()  {
     System.out.println("op " + this.n.op + " o1 " + this.n.o1 + " o2 " +
     this.n.o2 + " m " + this.n.m + " p " + this.n.p);
     if (this.left != null & this.right != null) 
	{  System.out.println("figlio sinistro di: "+this.n.op);
	   this.left.writetree();
	   System.out.println("figlio destro di: "+this.n.op);
	   this.right.writetree();
	 }  
     if (this.left != null & this.right == null ) 
     	{System.out.println("figlio sinistro di: "+this.n.op);
     	 this.left.writetree();}
	
  } //fine writetree

  /**
   * Checks if the binary tree is empty.
   * Returns <B>TRUE</B> if the tree is empty, <B>FALSE</B> otherwise.
   * @author  Daniela Olivieri
   * @since Version 1.0
   **/
  public boolean emptyTree(){
	if (this.n == null) return true;
		else return false;
  }

} // fine bintree
 
 
 
 
 
 
 
 
