package mChaRM.multichannel;

import java.util.Vector;
import java.lang.Throwable;
import uka.transport.Transportable;

public class mChaRMMethodCall implements Transportable {

  /** 
   * This class reifies the method call filtered by the multi-channel. This class also supplies some methods for manipulate the method call. 
   * <HR>
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.1
   * @since Version 1.2
   **/

  private String sender;
  private String[] receivers;
  private String methodName;
  private Object returnValue;
  private mChaRMArgs actualArguments;

  public mChaRMMethodCall(String s, String[] rs, String m, Object[] args) {
    sender = s;
    receivers = rs;
    methodName = m;
    actualArguments = new mChaRMArgs(args);
    returnValue = null;
  }
  
  public mChaRMMethodCall(String s, String[] rs, String m, Object rv) {
    sender = s;
    receivers = rs;
    methodName = m;
    actualArguments = null;
    returnValue = rv;
  }

    /**
     * returns the name of the sender of the message. 
     * <HR>
     * It only supplies a String representative of the sender but it is simple to retrieve a reference of the sender, using 
     * the methods supplied by the multi-channel. 
     * <HR>
     * @return the name of the sender. 
     **/
  public String sender() {return sender;}
    /**
     * returns an array containing the name of the reecivers involved in the call. 
     * <HR>
     * It only supplies a String representative of each receiver but it is simple to retrieve a reference of the real receiver, using 
     * the methods supplied by the multi-channel. 
     * <HR>
     * @return an array of receiver's names. 
     **/
  public String[] receivers() {return receivers;}
    /**
     * returns the name of the method called. 
     * @return the name of the method called.
     **/
  public String getMethodName() {return methodName;}
    /**
     * changes the name of the method called. 
     * @param m the name of the method to be used.
     * @return the name of the method originally called. 
     **/
  public String setMethodName(String m) {String oldMethod = methodName; methodName=m; return oldMethod;}
    /**
     * returns the actual arguments used in the trapped call. 
     * @return an array of Object representing the arguments of the call.
     **/
  public Object[] actualArguments() {return actualArguments.args();} 
    /**
     * returns the actual value of a specified argument.
     * @param position the position in the call of the argument we want to inspect.  
     * @return an Object containing the value of the inspected argument.
     * @exception ReferenceToNonExistentArgumentException thrown when position exceeds (both the lower and the upper bound)
     * the number of arguments of the call.
     **/
  public Object inspectArgument(int position) throws ReferenceToNonExistentArgumentException { 
    if (position <0 | position > actualArguments.numberOfArgs()) 
      throw new ReferenceToNonExistentArgumentException("the call doesn't have "+position+" arguments");
    else return actualArguments.getArg(position);
  }
    /**
     * changes the value of a specified argument and returns the original value of such an argument.
     * @param position the position in the call of the argument we want to modify.  
     * @param newValue the new value for the specified argument. 
     * @return an Object containing the original value of the modified argument.
     * @exception ReferenceToNonExistentArgumentException thrown when position exceeds (both the lower and the upper bound)
     * the number of arguments of the call.
     **/
  public Object modifyArgument(int position, Object newValue) throws ReferenceToNonExistentArgumentException { 
    if (position <0 | position > actualArguments.numberOfArgs()) 
       throw new ReferenceToNonExistentArgumentException("the call doesn't have "+position+" arguments");
    else return actualArguments.setArg(position, newValue);
  }
    /**
     * inserts a new argument at the specified position in the call.
     * @param position the position in the call that will have the argument we want to insert.  
     * @param value the value of the new argument. 
     **/   
  public void insertArgument(int position, Object value) {actualArguments.addArg(position, value);}
    /**
     * removes the specified argument from the embodied call.
     * @param position the position in the call of the argument we want to remove.  
     * @return an Object containing the value of the removed argument.
     * @exception ReferenceToNonExistentArgumentException thrown when position exceeds (both the lower and the upper bound)
     * the number of arguments of the call.
     **/
  public Object removeArgument(int position) throws ReferenceToNonExistentArgumentException {
    if (position <0 | position > actualArguments.numberOfArgs()) 
       throw new ReferenceToNonExistentArgumentException("the call doesn't have "+position+" arguments");
    else return actualArguments.killArg(position);
  
  }
    /**
     * prints the embodied method call.
     **/
  public void printmChaRMMethodCall() {
    System.out.print(sender+" --- "+methodName);
    actualArguments.printmChaRMArgs();
    System.out.print(" --->"+" ["+receivers[0]);
    for(int i=1;i<receivers.length;i++) System.out.print(","+receivers[i]);
    System.out.println("]");
  }
    /**
     * wonders about wheather the embodied call has or not arguments.
     * @return true if has arguments false otherwise.
     **/
  public boolean hasArgs() {return (actualArguments.numberOfArgs() != 0);}
    /**
     * substitutes the return value of a method call.
     * @param val is the new value.
     * @return returns the current value.
     **/
  public Object setReturnValue(Object val) {
    Object tmp = returnValue;
    returnValue = val;
    return tmp;
  }
    /**
     * gets the return value of the related method call.
     * @return returns the current return value.
     */
  public Object getReturnValue() {return returnValue;}


protected static final int _SIZE = 0;

/** Used by uka.transport.UnmarshalStream to unmarshal the object */
public  mChaRMMethodCall(uka.transport.UnmarshalStream _stream)
  throws java.io.IOException, ClassNotFoundException
{
  this(_stream, _SIZE);
  _stream.accept(_SIZE);
}

protected mChaRMMethodCall(uka.transport.UnmarshalStream  _stream, int _size)
  throws java.io.IOException, ClassNotFoundException
{
  _stream.request(_size); 
}

/** Method of interface Transportable, it must be declared public.
    It is called from within UnmarshalStream after creating the 
    object and assigning a stream reference to it. */
public void unmarshalReferences(uka.transport.UnmarshalStream _stream)
  throws java.io.IOException, ClassNotFoundException
{
  actualArguments = (mChaRM.multichannel.mChaRMArgs) _stream.readObject();
  returnValue = (java.lang.Object) _stream.readObject();
  methodName = (java.lang.String) _stream.readObject();
  receivers = (java.lang.String[]) _stream.readObject();
  sender = (java.lang.String) _stream.readObject();
}

/** Called directly by uka.transport.MarshalStream */
public void marshal(uka.transport.MarshalStream _stream)
  throws java.io.IOException
{
  _stream.reserve(_SIZE);
  byte[] _buffer = _stream.getBuffer();
  int    _pos    = _stream.getPosition();
  marshalPrimitives(_buffer, _pos);
  _stream.deliver(_SIZE);
  marshalReferences(_stream);
}

protected void marshalPrimitives(byte[] _buffer, int _pos)
  throws java.io.IOException
{
}

protected void marshalReferences(uka.transport.MarshalStream _stream)
  throws java.io.IOException
{
  _stream.writeObject(actualArguments);
  _stream.writeObject(returnValue);
  _stream.writeObject(methodName);
  _stream.writeObject(receivers);
  _stream.writeObject(sender);
}

public final Object deepClone(uka.transport.DeepClone _helper)
  throws CloneNotSupportedException
{
  Object _copy = clone();
  _helper.add(this, _copy);
  ((mChaRMMethodCall) _copy).deepCloneReferences(_helper);
  return _copy;
}

/** Clone all references to other objects. Use the 
    DeepClone to resolve cycles */
protected void deepCloneReferences(uka.transport.DeepClone _helper)
  throws CloneNotSupportedException
{
  this.actualArguments = (mChaRM.multichannel.mChaRMArgs) _helper.doDeepClone(this.actualArguments);
  this.returnValue = (java.lang.Object) _helper.doDeepClone(this.returnValue);
  this.methodName = (java.lang.String) _helper.doDeepClone(this.methodName);
  this.receivers = (java.lang.String[]) _helper.doDeepClone(this.receivers);
  this.sender = (java.lang.String) _helper.doDeepClone(this.sender);
}

}
