package mChaRM.multichannel;

import java.util.Vector;
import java.lang.Throwable;
import uka.transport.Transportable;

 public class mChaRMArgs implements Transportable {
  /** 
   * This class reifies the arguments of the method call filtered by the multi-channel. This class also supplies some methods for manipulate such arguments. 
   * <HR>
   * @author  Walter Cazzola (<A HREF="mailto:cazzola@disi.unige.it">cazzola@disi.unige.it</A>)
   * @version 1.0
   * @since Version 1.4
   **/

    private Vector args;
    public mChaRMArgs(Object[] a) { 
      args = new Vector(10, 2); 
      if (a != null) for(int i=0;i<a.length;i++) args.add(i, a[i]); 
    }
    public Object[] args() { return args.toArray(); }
    public void printmChaRMArgs() {
      if (args.size() == 0) System.out.print("()");
      else {
        System.out.print("("+args.get(0));
        for(int i=1;i<args.size();i++) System.out.print(", "+args.get(i));
        System.out.print(")");
      }
    }
    public int numberOfArgs() {return args.size();}
    public Object killArg(int pos) {return args.remove(pos);}
    public void addArg(int pos, Object val) {args.add(pos, val);}
    public Object getArg(int pos) {return args.get(pos);}
    public Object setArg(int pos, Object o) {
      Object old = args.get(pos);
      args.set(pos, o);
      return old;
    } 

protected static final int _SIZE = 0;

/** Used by uka.transport.UnmarshalStream to unmarshal the object */
public  mChaRMArgs(uka.transport.UnmarshalStream _stream)
  throws java.io.IOException, ClassNotFoundException
{
  this(_stream, _SIZE);
  _stream.accept(_SIZE);
}

protected mChaRMArgs(uka.transport.UnmarshalStream  _stream, int _size)
  throws java.io.IOException, ClassNotFoundException
{
  _stream.request(_size); 
}

/** Method of interface Transportable, it must be declared public.
    It is called from within UnmarshalStream after creating the 
    object and assigning a stream reference to it. */
public void unmarshalReferences(uka.transport.UnmarshalStream _stream)
  throws java.io.IOException, ClassNotFoundException
{
  args = (java.util.Vector) _stream.readObject();
}

/** Called directly by uka.transport.MarshalStream */
public void marshal(uka.transport.MarshalStream _stream)
  throws java.io.IOException
{
  _stream.reserve(_SIZE);
  byte[] _buffer = _stream.getBuffer();
  int    _pos    = _stream.getPosition();
  marshalPrimitives(_buffer, _pos);
  _stream.deliver(_SIZE);
  marshalReferences(_stream);
}

protected void marshalPrimitives(byte[] _buffer, int _pos)
  throws java.io.IOException
{
}

protected void marshalReferences(uka.transport.MarshalStream _stream)
  throws java.io.IOException
{
  _stream.writeObject(args);
}

public final Object deepClone(uka.transport.DeepClone _helper)
  throws CloneNotSupportedException
{
  Object _copy = clone();
  _helper.add(this, _copy);
  ((mChaRMArgs) _copy).deepCloneReferences(_helper);
  return _copy;
}

/** Clone all references to other objects. Use the 
    DeepClone to resolve cycles */
protected void deepCloneReferences(uka.transport.DeepClone _helper)
  throws CloneNotSupportedException
{
  this.args = (java.util.Vector) _helper.doDeepClone(this.args);
}

 }
